/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;

public class AIBEAST {
    public static AISTATE[] beastIdle = new AISTATE[2];
    public static AISTATE[] beastSearch = new AISTATE[2];
    public static AISTATE[] beastGoto = new AISTATE[2];
    public static AISTATE[] beastDodge = new AISTATE[2];
    public static AISTATE[] beastChase = new AISTATE[2];
    public static AISTATE[] beastRecoil = new AISTATE[2];
    public static AISTATE[] beastHack = new AISTATE[2];
    public static AISTATE beastRTesla;
    public static AISTATE beastStomps;
    public static AISTATE beastTransforming;
    public static AISTATE beastTransform;
    public static AISTATE beastUp;

    public static void Init() {
        AIBEAST.beastIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIBEAST.beastIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 9, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIBEAST.beastChase[0] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkChase(sprite, xsprite);
            }
        };
        AIBEAST.beastChase[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForwardWater(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
        AIBEAST.beastDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 60, false, true, false, beastChase[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIBEAST.beastDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, beastChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIBEAST.beastGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, beastIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkGoto(sprite, xsprite);
            }
        };
        AIBEAST.beastGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 9, null, 600, false, true, true, beastIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkGotoWater(sprite, xsprite);
            }
        };
        AIBEAST.beastHack[0] = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIBEAST.HackCallback(nXSprite), 120, false, false, false, beastChase[0]);
        AIBEAST.beastHack[1] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 120, false, false, true, beastChase[1]){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
        beastStomps = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIBEAST.StompsCallback(nXSprite), 120, false, false, false, beastChase[0]);
        AIBEAST.beastSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 8, null, 120, false, true, true, beastIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIBEAST.beastSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 120, false, true, true, beastIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIBEAST.beastRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, beastDodge[0]);
        AIBEAST.beastRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, beastDodge[1]);
        beastRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, beastDodge[0]);
        beastTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, beastIdle[0]){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkTransform(sprite, xsprite);
            }
        };
        beastTransforming = new AISTATE(AISTATEFUNC.Type.other, 2576, null, 0, false, false, false, beastTransform);
        beastUp = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, beastChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBEAST.thinkChaseWater(sprite, xsprite);
            }
        };
    }

    private static void myMoveTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pSprite.setAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long vel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            vel = (vel >> 1) + (long)Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            int z1 = 0;
            if (pXSprite.getTarget() != -1) {
                BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
                z1 = pTarget.getZ();
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight;
                }
            }
            int z2 = pSprite.getZ() + pDudeInfo.eyeHeight;
            pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 8L * (long)(z1 - z2));
        }
    }

    private static void myMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        int dy;
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        if (EngineUtils.qdist(dx, dy = pXSprite.getTargetY() - pSprite.getY()) > 1024 || Gameutils.Random(64) >= 32) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            pSprite.addVelocity(Pragmas.mulscale(cos, pDudeInfo.frontSpeed, 30), Pragmas.mulscale(sin, pDudeInfo.frontSpeed, 30), 0L);
        }
    }

    private static void myMoveForwardWater(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (Gameutils.Random(64) >= 32 || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 2));
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void HackCallback(int nXSprite) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXSprite);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pXSprite.getTarget() == -1) {
            return;
        }
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = pSprite.getZ() - Main.boardService.getSprite(pXSprite.getTarget()).getZ();
        Actor.actFireVector(pSprite, 0, 0, dx += Gameutils.BiRandom2(4000 - 700 * Globals.pGameInfo.nDifficulty), dy += Gameutils.BiRandom2(4000 - 700 * Globals.pGameInfo.nDifficulty), dz, 13);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 13);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 13);
        SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 9012, -1, 0);
    }

    private static void StompsCallback(int nXSprite) {
        int damage;
        int dist;
        ListNode<Sprite> node;
        int nSprite = Main.boardService.getXSprite(nXSprite).getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int radius = 6400;
        int minDamage = 2 * Globals.pGameInfo.nDifficulty + 5;
        int maxDamage = 30 * Globals.pGameInfo.nDifficulty + 25;
        Actor.gSectorExp[0] = -1;
        Actor.gWallExp[0] = -1;
        Gameutils.NearSectors(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), 400, Actor.gSectorExp, Actor.gSpriteExp, Actor.gWallExp);
        for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            BloodSprite pTarget;
            int nTarget = node.getIndex();
            if (nTarget == nSprite || Main.boardService.getXSprite((pTarget = (BloodSprite)node.get()).getExtra()) == null || pTarget.getLotag() == 251 || (pTarget.getHitag() & 0x20) != 0 || (Actor.gSpriteExp[pTarget.getSectnum() >> 3] & 1 << (pTarget.getSectnum() & 7)) == 0 || !Gameutils.CheckProximity(pTarget, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), radius)) continue;
            Gameutils.GetSpriteExtents(pSprite);
            if (Gameutils.extents_zBot - Main.boardService.getSector(pSprite.getSectnum()).getFloorz() != 0 || (dist = EngineUtils.sqrt((pSprite.getX() - pTarget.getX()) * (pSprite.getX() - pTarget.getX()) + (pSprite.getY() - pTarget.getY()) * (pSprite.getY() - pTarget.getY()))) > radius) continue;
            damage = minDamage + maxDamage;
            if (dist != 0) {
                damage = minDamage + maxDamage * (radius - dist) / radius;
            }
            if (Gameutils.IsPlayerSprite(pTarget)) {
                PLAYER pPlayer = Globals.gPlayer[pTarget.getLotag() - 231];
                pPlayer.quakeTime += damage << 2;
            }
            Actor.actDamageSprite(nSprite, pTarget, 0, damage << 4);
        }
        for (node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            BloodSprite pTarget = (BloodSprite)node.get();
            XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
            if (pXTarget == null || (pTarget.getHitag() & 0x20) != 0 || (Actor.gSpriteExp[pTarget.getSectnum() >> 3] & 1 << (pTarget.getSectnum() & 7)) == 0 || pXTarget.getLocked() != 0 || !Gameutils.CheckProximity(pTarget, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), radius) || (dist = EngineUtils.sqrt((pSprite.getX() - pTarget.getX()) * (pSprite.getX() - pTarget.getX()) + (pSprite.getY() - pTarget.getY()) * (pSprite.getY() - pTarget.getY()))) > radius) continue;
            damage = minDamage + maxDamage;
            if (dist != 0) {
                damage = minDamage + maxDamage * (radius - dist) / radius;
            }
            Actor.actDamageSprite(nSprite, pTarget, 0, damage << 4);
        }
        SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 9015, -1, 0);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        short nXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra();
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGotoWater(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkTransform(BloodSprite pSprite, XSPRITE pXSPrite) {
        Actor.actHealDude(pXSPrite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
        pSprite.setLotag(251);
    }

    private static void thinkChaseWater(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, beastHack[1]);
                        short nXSprite = pSprite.getExtra();
                        if (!DemoUtils.IsOriginalDemo() && SeqHandling.seqFrame(3, nXSprite) == 1) {
                            AIBEAST.HackCallback(nXSprite);
                        }
                        return;
                    }
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 9009, 1, -1);
                    Ai.aiNewState(pSprite, pXSprite, beastUp);
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastUp);
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[1]);
            pXSprite.setTarget(-1);
        }
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        short nXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra();
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        if (pXSprite.getTarget() == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, beastSearch[0]);
            }
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    if (dist > 0) {
                        pXSprite.getDudeExtra().setDudeSlope(Pragmas.divscale(pTarget.getZ() - pSprite.getZ(), dist, 10));
                    }
                    int hitType = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                    if (dist < 5120 && dist > 2560 && Pragmas.klabs(losAngle) < 85 && (pTarget.getHitag() & 2) != 0 && Gameutils.IsPlayerSprite(pTarget) && Gameutils.Chance(16384) && pXTarget.getHealth() > DudeInfo.gPlayerTemplate[0].startHealth / 2) {
                        if (hitType == 3 && Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == pSprite.getLotag()) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector == null || !pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, beastStomps);
                        }
                    }
                    if (dist < 921 && Pragmas.klabs(losAngle) < 28) {
                        if (hitType == 3 && Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == pSprite.getLotag()) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, beastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, beastHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, beastHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, beastGoto[0]);
        }
        pXSprite.setTarget(-1);
    }
}

