/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.net.Mmulti;

public class AIBONEEL {
    public static AISTATE boneelIdle;
    public static AISTATE boneelChase;
    public static AISTATE boneelGoto;
    public static AISTATE boneelBite;
    public static AISTATE boneelRecoil;
    public static AISTATE boneelSearch;
    public static AISTATE boneelDown;
    public static AISTATE boneelUp;
    public static AISTATE boneelTurn;

    public static void Init() {
        boneelIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.myThinkTarget(sprite, xsprite);
            }
        };
        boneelChase = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, boneelIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 0, null, 600, false, false, true, boneelIdle){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.thinkGoto(sprite, xsprite);
            }
        };
        boneelBite = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIBONEEL.BiteCallback(nXSprite), 60, false, false, false, boneelChase);
        boneelRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 1, false, false, false, boneelChase){

            @Override
            public void callback(int nXSprite) {
                if (DemoUtils.IsOriginalDemo()) {
                    AIBONEEL.BiteCallback(nXSprite);
                }
            }
        };
        boneelSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 120, false, true, true, boneelIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.thinkSearch(sprite, xsprite);
            }
        };
        boneelDown = new AISTATE(AISTATEFUNC.Type.other, 0, null, 60, false, true, true, boneelChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelUp = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, boneelChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBONEEL.thinkChase(sprite, xsprite);
            }
        };
        boneelTurn = new AISTATE(AISTATEFUNC.Type.other, 0, null, 60, false, true, false, boneelChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
    }

    private static void BiteCallback(int nXIndex) {
        int dz;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        if (DemoUtils.IsOriginalDemo()) {
            if (!Actor.IsDudeSprite(pTarget)) {
                return;
            }
            dz = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat() << 2;
            dz -= DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat() << 2;
        } else {
            dz = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat();
            if (pXSprite.getTarget() != -1) {
                dz = pTarget.getZ() - pSprite.getZ();
            }
        }
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 7);
    }

    private static void myMoveDown(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(16384) || EngineUtils.qdist(dx, dy) > 921) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)(pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            pSprite.setVelocity(Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 139810L);
        }
    }

    private static void myMoveUp(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 921) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)(pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            pSprite.setVelocity(Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), -32768L);
        }
    }

    private static void myMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        int dy;
        int dx;
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        if (EngineUtils.qdist(dx = pXSprite.getTargetX() - pSprite.getX(), dy = pXSprite.getTargetY() - pSprite.getY()) > 921) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)(pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 26) / 120);
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += fvel) : (vel += fvel >> 1);
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        AIBONEEL.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
        }
        AIBONEEL.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, boneelGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            Gameutils.GetSpriteExtents(pSprite);
            int zTop1 = Gameutils.extents_zTop;
            Gameutils.GetSpriteExtents(pTarget);
            int zTop2 = Gameutils.extents_zTop;
            int zBot2 = Gameutils.extents_zBot;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist <= 921 && Pragmas.klabs(losAngle) < 85) {
                    if (zTop2 > zTop1) {
                        Ai.aiNewState(pSprite, pXSprite, boneelDown);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, boneelBite);
                    }
                    return;
                }
                if (zBot2 > zTop1 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, boneelDown);
                } else if (zTop2 < zTop1 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, boneelUp);
                }
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, boneelSearch);
            pXSprite.setTarget(-1);
        }
    }

    private static void myThinkTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        if (dudeExtra.isActive()) {
            if (dudeExtra.getThinkTime() >= 10) {
                dudeExtra.setThinkTime(0);
                pXSprite.setGoalAng(pXSprite.getGoalAng() + 256);
                Vector3 kSprite = pSprite.getKSprite();
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, boneelTurn);
                return;
            }
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                int dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < pDudeInfo.hearDist) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }
}

