/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;

public class AICALEB {
    public static AISTATE[] calebIdle = new AISTATE[2];
    public static AISTATE[] calebSearch = new AISTATE[2];
    public static AISTATE[] calebGoto = new AISTATE[2];
    public static AISTATE[] calebDodge = new AISTATE[2];
    public static AISTATE[] calebChase = new AISTATE[2];
    public static AISTATE[] calebRecoil = new AISTATE[2];
    public static AISTATE[] calebHack = new AISTATE[2];
    public static AISTATE calebRTesla;
    public static AISTATE calebMoveTarget;

    public static void Init() {
        AICALEB.calebIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AICALEB.calebIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AICALEB.calebChase[0] = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkChase(sprite, xsprite);
            }
        };
        AICALEB.calebChase[1] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
        AICALEB.calebDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 6, null, 90, false, true, false, calebChase[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AICALEB.calebDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 8, null, 90, false, true, false, calebChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AICALEB.calebGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 6, null, 600, false, true, true, calebIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkGoto(sprite, xsprite);
            }
        };
        AICALEB.calebGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, calebIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkGotoWater(sprite, xsprite);
            }
        };
        CALLPROC hackCallback = nXSprite -> AICALEB.HackCallback(nXSprite);
        AICALEB.calebHack[0] = new AISTATE(AISTATEFUNC.Type.other, 0, hackCallback, 120, false, false, false, calebChase[0]);
        AICALEB.calebHack[1] = new AISTATE(AISTATEFUNC.Type.other, 10, hackCallback, 0, false, false, true, calebChase[1]){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
        AICALEB.calebSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 6, null, 120, false, true, true, calebIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkSearch(sprite, xsprite);
            }
        };
        AICALEB.calebSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 8, null, 120, false, true, true, calebIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkSearch(sprite, xsprite);
            }
        };
        AICALEB.calebRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, calebDodge[0]);
        AICALEB.calebRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, calebDodge[1]);
        calebRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, calebDodge[0]);
        calebMoveTarget = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, calebChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AICALEB.thinkChaseWater(sprite, xsprite);
            }
        };
    }

    private static void HackCallback(int nXSprite) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXSprite);
        BloodSprite pSprite = Main.boardService.getSprite(pXSprite.getReference());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = pXSprite.getDudeExtra().getDudeSlope();
        dx += Gameutils.BiRandom(1500);
        dy += Gameutils.BiRandom(1500);
        dz += Gameutils.BiRandom(1500);
        for (int i = 0; i < 2; ++i) {
            int vz = dz + Gameutils.BiRandom2(500);
            int vy = dy + Gameutils.BiRandom2(1000);
            int vx = dx + Gameutils.BiRandom2(1000);
            Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 1);
        }
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(5) + 10000, -1, 0);
        }
        if (Gameutils.Chance(16384)) {
            SOUND.sfxStart3DSound(pSprite, 1001, -1, 0);
        } else {
            SOUND.sfxStart3DSound(pSprite, 1002, -1, 0);
        }
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        short nXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra();
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGotoWater(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        short nXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra();
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
        }
        if (pXSprite.getTarget() == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            } else {
                Ai.aiPlaySound(pSprite, Gameutils.Random(4) + 11000, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, calebSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    if (dist > 0) {
                        pXSprite.getDudeExtra().setDudeSlope(Pragmas.divscale(pTarget.getZ() - pSprite.getZ(), dist, 10));
                    }
                    if (dist < 1433 && Pragmas.klabs(losAngle) < 28) {
                        int hitType = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                        if (hitType == 3 && Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == pSprite.getLotag()) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, calebDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, calebDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, calebHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, calebHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[0]);
        }
        if (Gameutils.Chance(4096)) {
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(5) + 10000, -1, 0);
        }
        pXSprite.setTarget(-1);
    }

    private static void thinkChaseWater(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, calebSearch[1]);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, calebHack[1]);
                        return;
                    }
                    Ai.aiNewState(pSprite, pXSprite, calebMoveTarget);
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, calebMoveTarget);
            }
        } else {
            Ai.aiNewState(pSprite, pXSprite, calebGoto[1]);
            pXSprite.setTarget(-1);
        }
    }

    private static void myMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (Gameutils.Random(64) >= 32 || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 2));
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void myMoveTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pSprite.setAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long vel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            vel = (vel >> 1) + (long)Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            int z1 = 0;
            if (pXSprite.getTarget() != -1) {
                BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
                z1 = pTarget.getZ();
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight;
                }
            }
            int z2 = pSprite.getZ() + pDudeInfo.eyeHeight;
            pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 8L * (long)(z1 - z2));
        }
    }
}

