/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.net.Mmulti;

public class AICERBERUS {
    public static final int C1 = 0;
    public static final int C2 = 1;
    private static final WeaponAim gFireData = new WeaponAim(65536, 65536, 256, 85, 0x1AAAAA);
    public static AISTATE[] cerberusIdle = new AISTATE[2];
    public static AISTATE[] cerberusSearch = new AISTATE[2];
    public static AISTATE[] cerberusTurn = new AISTATE[2];
    public static AISTATE[] cerberusGoto = new AISTATE[2];
    public static AISTATE[] cerberusChase = new AISTATE[2];
    public static AISTATE[] cerberusBurn = new AISTATE[2];
    public static AISTATE[] cerberusFire = new AISTATE[2];
    public static AISTATE[] cerberusHack = new AISTATE[2];
    public static AISTATE[] cerberusRecoil = new AISTATE[2];
    public static AISTATE cerberusRTesla;

    public static void Init() {
        int i;
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusIdle[i] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

                @Override
                public void think(BloodSprite sprite, XSPRITE xsprite) {
                    AICERBERUS.myThinkTarget(sprite, xsprite);
                }
            };
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusSearch[i] = new AISTATE(AISTATEFUNC.Type.search, 7, null, 1800, false, true, true, cerberusIdle[i]){

                @Override
                public void move(BloodSprite sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(BloodSprite sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkSearch(sprite, xsprite);
                }
            };
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusChase[i] = new AISTATE(AISTATEFUNC.Type.other, 7, null, 0, false, true, true, null){

                @Override
                public void move(BloodSprite sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(BloodSprite sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkChase(sprite, xsprite);
                }
            };
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusRecoil[i] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, true, true, cerberusSearch[i]);
        }
        cerberusRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, true, true, cerberusSearch[0]);
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusGoto[i] = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 600, false, true, true, cerberusIdle[i]){

                @Override
                public void move(BloodSprite sprite, XSPRITE xsprite) {
                    Ai.aiMoveForward(sprite, xsprite);
                }

                @Override
                public void think(BloodSprite sprite, XSPRITE xsprite) {
                    AICERBERUS.thinkGoto(sprite, xsprite);
                }
            };
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusHack[i] = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AICERBERUS.BiteCallback(nXSprite), 60, false, false, false, cerberusChase[i]);
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusFire[i] = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AICERBERUS.FireCallback(nXSprite), 60, false, false, false, cerberusChase[i]);
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusBurn[i] = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AICERBERUS.BurnCallback(nXSprite), 60, false, false, false, cerberusChase[i]);
        }
        for (i = 0; i <= 1; ++i) {
            AICERBERUS.cerberusTurn[i] = new AISTATE(AISTATEFUNC.Type.other, 7, null, 120, false, true, false, cerberusChase[i]){

                @Override
                public void move(BloodSprite sprite, XSPRITE xsprite) {
                    Ai.aiMoveTurn(sprite, xsprite);
                }
            };
        }
    }

    private static void BurnCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra pDudeExtra = pXSprite.getDudeExtra();
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat();
        int x = pSprite.getX();
        int y = pSprite.getY();
        int ax = Trig.Cos(pSprite.getAng()) >> 16;
        int ay = Trig.Sin(pSprite.getAng()) >> 16;
        int az = pDudeExtra.getDudeSlope();
        int aox = ax;
        int aoy = ay;
        int closest = Integer.MAX_VALUE;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int ang;
            int dy;
            int dx;
            int dist2;
            BloodSprite pDude = (BloodSprite)node.get();
            if (pDude == pSprite || (pDude.getHitag() & 8) == 0) continue;
            int tx = pDude.getX();
            int ty = pDude.getY();
            int tz = pDude.getZ();
            int dist = EngineUtils.qdist(tx - x, ty - y);
            if (dist == 0 || dist > 10240) continue;
            if (AICERBERUS.gFireData.kSeeker != 0) {
                int k = (dist << 12) / AICERBERUS.gFireData.kSeeker;
                tx += (int)((long)k * pDude.getVelocityX() >> 12);
                ty += (int)((long)k * pDude.getVelocityY() >> 12);
                tz += (int)((long)k * pDude.getVelocityZ() >> 8);
            }
            int z1 = Pragmas.mulscale(dist, pDudeExtra.getDudeSlope(), 10) + eyeAboveZ;
            int z2 = Pragmas.mulscale(9460L, dist, 10);
            Gameutils.GetSpriteExtents(pDude);
            if (z1 - z2 > Gameutils.extents_zBot || z1 + z2 < Gameutils.extents_zTop || (dist2 = EngineUtils.sqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.getAng()), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.getAng()), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) >= closest || Pragmas.klabs(((ang = EngineUtils.getAngle(tx - x, ty - y)) - pSprite.getAng() + 1024 & 0x7FF) - 1024) > AICERBERUS.gFireData.kDudeAngle) continue;
            int dz = tz - (DudeInfo.dudeInfo[pDude.getLotag() - 200].aimHeight * pDude.getYrepeat() << 2) - eyeAboveZ;
            if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.getSectnum(), tx, ty, tz, pDude.getSectnum())) {
                closest = dist2;
                ax = Trig.Cos(ang) >> 16;
                ay = Trig.Sin(ang) >> 16;
                az = Pragmas.divscale(dz, dist, 10);
                continue;
            }
            az = dz;
        }
        if (pSprite.getLotag() == 227) {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, -az, 308);
            Actor.actFireMissile(pSprite, -350, 0, aox, aoy, 0, 308);
        } else {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, -az, 308);
        }
    }

    private static void FireCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra pDudeExtra = pXSprite.getDudeExtra();
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat();
        int x = pSprite.getX();
        int y = pSprite.getY();
        int ax = Trig.Cos(pSprite.getAng()) >> 16;
        int ay = Trig.Sin(pSprite.getAng()) >> 16;
        int az = pDudeExtra.getDudeSlope();
        int closest = Integer.MAX_VALUE;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int ang;
            int dy;
            int dx;
            int dist2;
            BloodSprite pDude = (BloodSprite)node.get();
            if (pDude == pSprite || (pDude.getHitag() & 8) == 0) continue;
            int tx = pDude.getX();
            int ty = pDude.getY();
            int tz = pDude.getZ();
            int dist = EngineUtils.qdist(tx - x, ty - y);
            if (dist == 0 || dist > 10240) continue;
            if (AICERBERUS.gFireData.kSeeker != 0) {
                int k = (dist << 12) / AICERBERUS.gFireData.kSeeker;
                tx += (int)((long)k * pDude.getVelocityX() >> 12);
                ty += (int)((long)k * pDude.getVelocityY() >> 12);
                tz += (int)((long)k * pDude.getVelocityZ() >> 8);
            }
            int z1 = Pragmas.mulscale(dist, pDudeExtra.getDudeSlope(), 10) + eyeAboveZ;
            int z2 = Pragmas.mulscale(9460L, dist, 10);
            Gameutils.GetSpriteExtents(pDude);
            if (z1 - z2 > Gameutils.extents_zBot || z1 + z2 < Gameutils.extents_zTop || (dist2 = EngineUtils.sqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.getAng()), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.getAng()), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) >= closest || Pragmas.klabs(((ang = EngineUtils.getAngle(tx - x, ty - y)) - pSprite.getAng() + 1024 & 0x7FF) - 1024) > AICERBERUS.gFireData.kDudeAngle) continue;
            int dz = pDude.getZ() - pSprite.getZ();
            if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.getSectnum(), tx, ty, tz, pDude.getSectnum())) {
                closest = dist2;
                ax = Trig.Cos(ang) >> 16;
                ay = Trig.Sin(ang) >> 16;
                az = Pragmas.divscale(dz, dist, 10);
                continue;
            }
            az = dz;
        }
        if (pSprite.getLotag() == 227) {
            Actor.actFireMissile(pSprite, -350, 0, ax, ay, az, 313);
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, az, 313);
        } else {
            Actor.actFireMissile(pSprite, 350, -100, ax, ay, az, 313);
        }
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = pTarget.getZ() - pSprite.getZ();
        Actor.actFireVector(pSprite, 350, -100, dx, dy, dz, 14);
        Actor.actFireVector(pSprite, -350, 0, dx, dy, dz, 14);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 14);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void myThinkTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        if (dudeExtra.isActive()) {
            if (dudeExtra.getThinkTime() >= 10) {
                pXSprite.setGoalAng(pXSprite.getGoalAng() + 256);
                Vector3 kSprite = pSprite.getKSprite();
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                if (pSprite.getLotag() == 227) {
                    Ai.aiNewState(pSprite, pXSprite, cerberusTurn[0]);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, cerberusTurn[1]);
                }
                return;
            }
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                int dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < pDudeInfo.hearDist) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            if (pSprite.getLotag() == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            if (pSprite.getLotag() == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusGoto[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusGoto[1]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            if (pSprite.getLotag() == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            if (pSprite.getLotag() == 227) {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[0]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, cerberusSearch[1]);
            }
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist < 2816 && dist > 1280 && Pragmas.klabs(losAngle) < 85) {
                    if (pSprite.getLotag() == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusBurn[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusBurn[1]);
                    }
                    return;
                }
                if (dist < 6912 && dist > 3328 && Pragmas.klabs(losAngle) < 85) {
                    if (pSprite.getLotag() == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusFire[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusFire[1]);
                    }
                    return;
                }
                if (dist < 512 && Pragmas.klabs(losAngle) < 85) {
                    int hitType = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                    if (hitType == 0 || hitType == 4 || hitType == 3 && (Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == pSprite.getLotag() || Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == 211)) {
                        return;
                    }
                    if (pSprite.getLotag() == 227) {
                        Ai.aiNewState(pSprite, pXSprite, cerberusHack[0]);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, cerberusHack[1]);
                    }
                }
                return;
            }
        }
        if (pSprite.getLotag() == 227) {
            Ai.aiNewState(pSprite, pXSprite, cerberusGoto[0]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, cerberusGoto[1]);
        }
        pXSprite.setTarget(-1);
    }
}

