/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;

public class AIHOUND {
    public static AISTATE houndIdle;
    public static AISTATE houndSearch;
    public static AISTATE houndChase;
    public static AISTATE houndRecoil;
    public static AISTATE houndRTesla;
    public static AISTATE houndGoto;
    public static AISTATE houndBite;
    public static AISTATE houndBurn;

    public static void Init() {
        houndIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        houndSearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, houndIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIHOUND.thinkSearch(sprite, xsprite);
            }
        };
        houndChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIHOUND.thinkChase(sprite, xsprite);
            }
        };
        houndRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, houndSearch);
        houndRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, houndSearch);
        houndGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, houndIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIHOUND.thinkGoto(sprite, xsprite);
            }
        };
        houndBite = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIHOUND.BiteCallback(nXSprite), 60, false, false, false, houndChase);
        houndBurn = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIHOUND.BurnCallback(nXSprite), 60, false, false, false, houndChase);
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = pTarget.getZ() - pSprite.getZ();
        if (Gameutils.IsPlayerSprite(pTarget) || !DemoUtils.IsOriginalDemo()) {
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 15);
        }
    }

    private static void BurnCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = 0;
        Actor.actFireMissile(pSprite, 0, 0, dx, dy, dz, 308);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, houndSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, houndGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, houndSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, houndSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist < 2816 && dist > 1280 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, houndBurn);
                } else if (dist < 614 && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, houndBite);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, houndGoto);
        pXSprite.setTarget(-1);
    }
}

