/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;

public class AIPOD {
    public static final int kSlopeThrow = -14500;
    public static AISTATE podIdle;
    public static AISTATE podSearch;
    public static AISTATE podChase;
    public static AISTATE podRecoil;
    public static AISTATE podGoto;
    public static AISTATE podHack;
    public static AISTATE tentacleIdle;
    public static AISTATE tentacleSearch;
    public static AISTATE tentacleChase;
    public static AISTATE tentacleRecoil;
    public static AISTATE tentacleDown;
    public static AISTATE tentacleHack;

    public static void Init() {
        podIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIPOD.podSearch.next = podSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 3600, false, true, true, podSearch){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkSearch(sprite, xsprite);
            }
        };
        podGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 3600, false, true, true, podSearch){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkGoto(sprite, xsprite);
            }
        };
        podChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkChase(sprite, xsprite);
            }
        };
        podHack = new AISTATE(AISTATEFUNC.Type.other, 8, nXSprite -> AIPOD.pHackCallback(nXSprite), 600, false, false, false, podChase);
        podRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, podChase);
        tentacleIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        tentacleSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 3600, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkSearch(sprite, xsprite);
            }
        };
        tentacleDown = new AISTATE(AISTATEFUNC.Type.other, 8, null, 3600, false, true, true, tentacleSearch){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkGoto(sprite, xsprite);
            }
        };
        tentacleChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIPOD.thinkChase(sprite, xsprite);
            }
        };
        tentacleHack = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIPOD.tHackCallback(nXSprite), 120, false, false, false, tentacleChase);
        tentacleRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, tentacleChase);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            switch (pSprite.getLotag()) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podSearch);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleSearch);
                }
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pXSprite.getTarget() == -1) {
            switch (pSprite.getLotag()) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podGoto);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleDown);
                }
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            switch (pSprite.getLotag()) {
                case 221: 
                case 223: {
                    Ai.aiNewState(pSprite, pXSprite, podSearch);
                    break;
                }
                case 222: 
                case 224: {
                    Ai.aiNewState(pSprite, pXSprite, tentacleSearch);
                }
            }
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (Pragmas.klabs(losAngle) < 85 && pTarget.getLotag() != 221 && pTarget.getLotag() != 223) {
                    switch (pSprite.getLotag()) {
                        case 221: 
                        case 223: {
                            Ai.aiNewState(pSprite, pXSprite, podHack);
                            break;
                        }
                        case 222: 
                        case 224: {
                            Ai.aiNewState(pSprite, pXSprite, tentacleHack);
                        }
                    }
                }
                return;
            }
        }
        switch (pSprite.getLotag()) {
            case 221: 
            case 223: {
                Ai.aiNewState(pSprite, pXSprite, podGoto);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pSprite, pXSprite, tentacleDown);
            }
        }
        pXSprite.setTarget(-1);
    }

    private static void tHackCallback(int nXSprite) {
        int nBurnTime;
        int nDistance;
        int nDamageType;
        int nSprite = Main.boardService.getXSprite(nXSprite).getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        SOUND.sfxStart3DSound(pSprite, 2502, -1, 0);
        int nDamageHit = 5 * Globals.pGameInfo.nDifficulty + 5;
        if (pSprite.getLotag() == 222) {
            nDamageType = 2;
            nDistance = 50;
            nBurnTime = 0;
        } else {
            nDamageType = 3;
            nDistance = 75;
            nBurnTime = 120 * Globals.pGameInfo.nDifficulty;
        }
        Actor.actDistanceDamage(nSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), nDistance, 1, nDamageType, nDamageHit, 2, nBurnTime);
    }

    private static void pHackCallback(int nXSprite) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXSprite);
        BloodSprite pSprite = Main.boardService.getSprite(pXSprite.getReference());
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        int nTarget = pXSprite.getTarget();
        BloodSprite pTarget = Main.boardService.getSprite(nTarget);
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        int dz = pTarget.getZ() - pSprite.getZ();
        dz += 8000;
        int dist = EngineUtils.qdist(dx += Gameutils.BiRandom(1000), dy += Gameutils.BiRandom(1000));
        if (dist > pDudeInfo.seeDist / 10) {
            int nSlope = dz / 128 + -14500;
            Sprite pThing = null;
            int velocity = Pragmas.divscale(dist / 540, 120L, 23);
            switch (pSprite.getLotag()) {
                case 221: {
                    if (Gameutils.Chance(16384)) {
                        SOUND.sfxStart3DSound(pSprite, 2474, -1, 0);
                    } else {
                        SOUND.sfxStart3DSound(pSprite, 2475, -1, 0);
                    }
                    pThing = Actor.actFireThing(pSprite.getXvel(), 0, -8000, nSlope, 430, velocity);
                    if (pThing == null) break;
                    SeqHandling.seqSpawn(68, 3, pThing.getExtra(), null);
                    break;
                }
                case 223: {
                    SOUND.sfxStart3DSound(pSprite, 2454, -1, 0);
                    pThing = Actor.actFireThing(pSprite.getXvel(), 0, -8000, nSlope, 429, velocity);
                    if (pThing == null) break;
                    SeqHandling.seqSpawn(22, 3, pThing.getExtra(), null);
                }
            }
        }
        for (int i = 0; i < 4; ++i) {
            Actor.actSpawnTentacleBlood(pSprite);
        }
    }
}

