/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.exceptions.AssertException;

public class AISPID {
    public static AISTATE spidIdle;
    public static AISTATE spidSearch;
    public static AISTATE spidChase;
    public static AISTATE spidDodge;
    public static AISTATE spidRecoil;
    public static AISTATE spidGoto;
    public static AISTATE spidBite;
    public static AISTATE spidJump;
    public static AISTATE spidSpawn;

    public static void Init() {
        spidIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        spidChase = new AISTATE(AISTATEFUNC.Type.other, 7, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AISPID.thinkChase(sprite, xsprite);
            }
        };
        spidDodge = new AISTATE(AISTATEFUNC.Type.other, 7, null, 90, false, true, false, spidChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        spidGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 7, null, 600, false, true, true, spidIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AISPID.thinkGoto(sprite, xsprite);
            }
        };
        spidSearch = new AISTATE(AISTATEFUNC.Type.search, 7, null, 1800, false, true, true, spidIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AISPID.thinkSearch(sprite, xsprite);
            }
        };
        spidBite = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AISPID.BiteCallback(nXSprite), 60, false, false, false, spidChase);
        spidJump = new AISTATE(AISTATEFUNC.Type.other, 8, nXSprite -> AISPID.JumpCallback(nXSprite), 60, false, true, false, spidChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }
        };
        spidSpawn = new AISTATE(AISTATEFUNC.Type.other, 0, nXSprite -> AISPID.SpawnCallback(nXSprite), 60, false, false, false, spidIdle);
    }

    private static void SpawnCallback(int nXIndex) {
        int losAngle;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Sprite pSpawned = null;
        if (Gameutils.IsPlayerSprite(pTarget) && dudeExtra.getThinkTime() < 10 && Pragmas.klabs(losAngle = pSprite.getAng() - nAngle) <= pDudeInfo.periphery) {
            if (dist < 6656 && dist > 5120) {
                pSpawned = Actor.actSpawnDude(pSprite, 214, pSprite.getClipdist());
            } else if (dist < 3072 || dist < 5120 && dist > 3072) {
                pSpawned = Actor.actSpawnDude(pSprite, 213, pSprite.getClipdist());
            }
        }
        if (pSpawned != null) {
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
            pSpawned.setOwner((short)nSprite);
            ++LEVELS.totalKills;
        }
    }

    private static void JumpCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null || !Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = 0;
        dx += Gameutils.BiRandom(200);
        dy += Gameutils.BiRandom(200);
        dz += Gameutils.BiRandom(200);
        if (Gameutils.IsPlayerSprite(pTarget) && (pSprite.getLotag() == 213 || pSprite.getLotag() == 215)) {
            pSprite.setVelocity((long)dx << 16, (long)dy << 16, (long)(dz += pTarget.getZ() - pSprite.getZ()) << 16);
        }
    }

    private static void spidAttack(XSPRITE pXDude, int add, int max) {
        if (pXDude == null) {
            throw new AssertException("pXDude != null");
        }
        BloodSprite pDude = Main.boardService.getSprite(pXDude.getReference());
        if (Gameutils.IsPlayerSprite(pDude)) {
            PLAYER pPlayer = Globals.gPlayer[pDude.getLotag() - 231];
            pPlayer.blindEffect = Gameutils.ClipHigh(pPlayer.blindEffect + (add << 4), max << 4);
        }
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = 0;
        dz += Gameutils.BiRandom(2000);
        if (Gameutils.IsPlayerSprite(pTarget) && Gameutils.HitScan(pSprite, pSprite.getZ(), dx += Gameutils.BiRandom(2000), dy += Gameutils.BiRandom(2000), 0, Engine.pHitInfo, 0x1000040, 0) == 3 && Gameutils.IsPlayerSprite(Main.boardService.getSprite(Engine.pHitInfo.hitsprite))) {
            PLAYER pPlayer = Globals.gPlayer[Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() - 231];
            XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
            switch (pSprite.getLotag()) {
                case 213: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.getZ() - pSprite.getZ() + dz, 17);
                    if (pPlayer.godMode || PLAYER.powerupCheck(pPlayer, 14) > 0 || !Gameutils.Chance(8192)) break;
                    PLAYER.powerupActivate(pPlayer, 28);
                    break;
                }
                case 214: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.getZ() - pSprite.getZ() + dz, 17);
                    if (!Gameutils.Chance(10240)) break;
                    AISPID.spidAttack(pXTarget, 4, 16);
                    break;
                }
                case 215: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.getZ() - pSprite.getZ() + dz, 17);
                    AISPID.spidAttack(pXTarget, 8, 16);
                    break;
                }
                case 216: {
                    Actor.actFireVector(pSprite, 0, 0, dx, dy, pTarget.getZ() - pSprite.getZ() + dz, 17);
                    Actor.actFireVector(pSprite, 0, 0, Gameutils.BiRandom(8192) + dx, Gameutils.BiRandom(8192) + dy, Gameutils.BiRandom(8192) + (pTarget.getZ() - pSprite.getZ() + dz), 17);
                    AISPID.spidAttack(pXTarget, 8, 16);
                }
            }
        }
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, spidGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, spidSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                switch (pSprite.getLotag()) {
                    case 214: {
                        if (dist >= 921 || Pragmas.klabs(losAngle) >= 85) break;
                        Ai.aiNewState(pSprite, pXSprite, spidBite);
                        break;
                    }
                    case 213: 
                    case 215: {
                        if (dist > 921 && dist < 1843) {
                            if (Pragmas.klabs(losAngle) >= 85) break;
                            Ai.aiNewState(pSprite, pXSprite, spidJump);
                            break;
                        }
                        if (dist >= 921 || Pragmas.klabs(losAngle) >= 85) break;
                        Ai.aiNewState(pSprite, pXSprite, spidBite);
                        break;
                    }
                    case 216: {
                        if (dist > 921 && dist < 1843 && Pragmas.klabs(losAngle) < 85) {
                            Ai.aiNewState(pSprite, pXSprite, spidJump);
                            break;
                        }
                        if (!Gameutils.Chance(16384)) break;
                        Ai.aiNewState(pSprite, pXSprite, spidSpawn);
                    }
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, spidGoto);
        pXSprite.setTarget(-1);
    }
}

