/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.EXPLODE;
import ru.m210projects.Blood.Types.GENDUDESND;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.THINGINFO;
import ru.m210projects.Blood.Types.VECTORDATA;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class AIUNICULT {
    public static final int kSlopeThrow = -8192;
    public static final int kMaxGenDudeSndMode = 11;
    public static final GENDUDESND[] gCustomDudeSnd = new GENDUDESND[]{new GENDUDESND(1003, 2, 0, true), new GENDUDESND(1013, 2, 2, true), new GENDUDESND(1018, 2, 4, false), new GENDUDESND(1031, 2, 6, true), new GENDUDESND(1018, 2, 8, false), new GENDUDESND(4021, 2, 10, true), new GENDUDESND(1005, 2, 12, true), new GENDUDESND(-1, 0, 14, false), new GENDUDESND(-1, 0, 15, false), new GENDUDESND(-1, 0, 16, false), new GENDUDESND(9008, 0, 17, false)};
    public static AISTATE[] GDXGenDudeIdle = new AISTATE[3];
    public static AISTATE[] GDXGenDudeSearch = new AISTATE[3];
    public static AISTATE[] GDXGenDudeGoto = new AISTATE[3];
    public static AISTATE[] GDXGenDudeDodge = new AISTATE[3];
    public static AISTATE[] GDXGenDudeDodgeDmg = new AISTATE[3];
    public static AISTATE[] GDXGenDudeChase = new AISTATE[3];
    public static AISTATE[] GDXGenDudeFire = new AISTATE[3];
    public static AISTATE[] GDXGenDudeRecoil = new AISTATE[3];
    public static AISTATE GDGenDudeThrow;
    public static AISTATE GDGenDudeThrow2;
    public static AISTATE GDXGenDudePunch;
    public static AISTATE GDXGenDudeRTesla;

    public static void Init() {
        AIUNICULT.GDXGenDudeIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 13, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 600, false, true, true, GDXGenDudeIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkSearch(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 13, null, 600, false, true, true, GDXGenDudeIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkSearch(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeGoto[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 600, false, true, true, GDXGenDudeIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkGoto(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 13, null, 600, false, true, true, GDXGenDudeIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkGoto(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeChase[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.aiGenDudeMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, GDXGenDudeChase[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 90, false, true, false, GDXGenDudeChase[2]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 90, false, true, false, GDXGenDudeChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 60, false, true, false, GDXGenDudeChase[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[2] = new AISTATE(AISTATEFUNC.Type.other, 14, null, 60, false, true, false, GDXGenDudeChase[2]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeDodgeDmg[1] = new AISTATE(AISTATEFUNC.Type.other, 13, null, 60, false, true, false, GDXGenDudeChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        CALLPROC attack = nXSprite -> AIUNICULT.GDXCultistAttack1(nXSprite);
        AIUNICULT.GDXGenDudeFire[0] = new AISTATE(AISTATEFUNC.Type.other, 6, attack, 0, false, true, true, GDXGenDudeFire[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeFire[1] = new AISTATE(AISTATEFUNC.Type.other, 8, attack, 0, false, true, true, GDXGenDudeFire[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        AIUNICULT.GDXGenDudeFire[2] = new AISTATE(AISTATEFUNC.Type.other, 8, attack, 0, false, true, true, GDXGenDudeFire[2]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIUNICULT.thinkChase(sprite, xsprite);
            }
        };
        GDGenDudeThrow = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIUNICULT.ThrowCallback(nXSprite, true), 0, false, false, false, GDXGenDudeChase[0]);
        GDGenDudeThrow2 = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIUNICULT.ThrowCallback(nXSprite, false), 0, false, false, false, GDXGenDudeChase[0]);
        GDXGenDudeRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, GDXGenDudeDodge[0]);
        AIUNICULT.GDXGenDudeRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[0]);
        AIUNICULT.GDXGenDudeRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[1]);
        AIUNICULT.GDXGenDudeRecoil[2] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, GDXGenDudeChase[2]);
        GDXGenDudePunch = new AISTATE(AISTATEFUNC.Type.other, 10, nXSprite -> AIUNICULT.punchCallback(nXSprite), 0, false, false, true, GDXGenDudeChase[0]){
            final boolean punch = false;

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                if (SeqHandling.seqFrame(3, sprite.getExtra()) == -1) {
                    short nXSprite = sprite.getExtra();
                    AIUNICULT.punchCallback(nXSprite);
                }
            }
        };
    }

    private static void punchCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int nAngle = EngineUtils.getAngle(pXSprite.getTargetX() - pSprite.getX(), pXSprite.getTargetY() - pSprite.getY());
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight;
        int nZOffset2 = 0;
        if (pXSprite.getTarget() != -1) {
            BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
            if (Actor.IsDudeSprite(pTarget)) {
                nZOffset2 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight;
            }
            int dx = Trig.Cos(nAngle) >> 16;
            int dy = Trig.Sin(nAngle) >> 16;
            int dz = nZOffset1 - nZOffset2;
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 9)) {
                SOUND.sfxStart3DSound(pSprite, 530, 1, 0);
            }
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 22);
        }
    }

    private static void GDXCultistAttack1(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        DudeExtra pXDude = pXSprite.getDudeExtra();
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        short weapon = pXSprite.getData1();
        if (weapon >= 0 && weapon < 23) {
            int dx = Trig.Cos(pSprite.getAng()) >> 16;
            int dy = Trig.Sin(pSprite.getAng()) >> 16;
            int dz = pXDude.getDudeSlope();
            VECTORDATA pVectorData = Actor.gVectorData[weapon];
            int vdist = pVectorData.maxDist;
            if (vdist <= 0 || vdist > 1280) {
                dx += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty);
                dy += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty);
                dz += Gameutils.BiRandom2(1000 - 500 * Globals.pGameInfo.nDifficulty);
            }
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, weapon);
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                Actor.sfxPlayVectorSound(pSprite, weapon);
            }
        } else if (weapon >= 200 && weapon < 256) {
            BloodSprite pSpawned = null;
            int dist = pSprite.getClipdist() * 6;
            pSpawned = Actor.actSpawnDude(pSprite, weapon, dist);
            if (pSpawned == null) {
                return;
            }
            DudeExtra dudeExtra = pXSprite.getDudeExtra();
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
            pSpawned.setOwner((short)nSprite);
            pSpawned.setX(pSpawned.getX() + dist + Gameutils.BiRandom(dist));
            if (pSpawned.getExtra() > -1) {
                Main.boardService.getXSprite(pSpawned.getExtra()).setTarget(pXSprite.getTarget());
                if (pXSprite.getTarget() > -1) {
                    Ai.aiActivateDude(pSpawned, Main.boardService.getXSprite(pSpawned.getExtra()));
                }
            }
            ++LEVELS.totalKills;
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                SOUND.sfxStart3DSoundCP(pSprite, 379, 1, 0, 65536 - Gameutils.BiRandom(12288), 0);
            }
            if (Gameutils.Chance(13568)) {
                int state = AIUNICULT.checkAttackState(pSprite, pXSprite);
                switch (state) {
                    case 1: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                        break;
                    }
                    case 2: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                        break;
                    }
                    default: {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                    }
                }
            }
        } else if (weapon >= 300 && weapon < 318) {
            int dx = Trig.Cos(pSprite.getAng()) >> 16;
            int dy = Trig.Sin(pSprite.getAng()) >> 16;
            int dz = pXDude.getDudeSlope();
            Actor.actFireMissile(pSprite, 0, 0, dx += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty), dy += Gameutils.BiRandom2(3000 - 1000 * Globals.pGameInfo.nDifficulty), dz += Gameutils.BiRandom2(1000 - 500 * Globals.pGameInfo.nDifficulty), weapon);
            if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 7)) {
                Actor.sfxPlayMissileSound(pSprite, weapon);
            }
        }
    }

    private static void ThrowCallback(int nXIndex, boolean impact) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            return;
        }
        short thingType = pXSprite.getData1();
        if (thingType >= 400 && thingType < 436) {
            THINGINFO pThinkInfo = Actor.thingInfo[thingType - 400];
            if (pThinkInfo.allowThrow == 1) {
                if (!AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 8)) {
                    SOUND.sfxStart3DSound(pSprite, 455, -1, 0);
                }
                int dx = pTarget.getX() - pSprite.getX();
                int dy = pTarget.getY() - pSprite.getY();
                int dz = pTarget.getZ() - pSprite.getZ();
                int dist = EngineUtils.qdist(dx, dy);
                int zThrow = 14500;
                Sprite pThing = null;
                Sprite pLeech = null;
                XSPRITE pXLeech = null;
                if (thingType == 435) {
                    pLeech = AIUNICULT.leechIsDropped(pSprite);
                    if (pLeech != null) {
                        pXLeech = Main.boardService.getXSprite(pLeech.getExtra());
                        AIUNICULT.removeLeech(pLeech);
                    }
                    zThrow = 5000;
                }
                if ((pThing = Actor.actFireThing(nSprite, 0, 0, dz / 128 - zThrow, thingType, Pragmas.divscale(dist / 540, 120L, 23))) == null) {
                    return;
                }
                if (pThing.getLotag() != 434) {
                    if (pThinkInfo.picnum < 0) {
                        pThing.setPicnum(0);
                    } else {
                        Tile.tileLoadVoxel(pThinkInfo.picnum);
                    }
                }
                pThing.setOwner(pSprite.getXvel());
                switch (thingType) {
                    case 428: {
                        impact = true;
                        pThing.setXrepeat(24);
                        pThing.setYrepeat(24);
                        Main.boardService.getXSprite(pThing.getExtra()).setData4(3 + Globals.pGameInfo.nDifficulty);
                        break;
                    }
                    case 434: {
                        int[] sPics = new int[]{2406, 2280, 2185, 2155, 2620, 3135};
                        pThing.setPicnum((short)sPics[Gameutils.Random(5)]);
                        pThing.setPal(5);
                        pThing.setCstat(pThing.getCstat() | 1);
                        pThing.setXrepeat((short)(24 + Gameutils.Random(42)));
                        pThing.setYrepeat((short)(24 + Gameutils.Random(42)));
                        if (Gameutils.Chance(12288)) {
                            pThing.setCstat(pThing.getCstat() | 4);
                        }
                        if (Gameutils.Chance(12288)) {
                            pThing.setCstat(pThing.getCstat() | 8);
                        }
                        if (pThing.getXrepeat() > 60) {
                            Main.boardService.getXSprite(pThing.getExtra()).setData1(43);
                        } else if (pThing.getXrepeat() > 40) {
                            Main.boardService.getXSprite(pThing.getExtra()).setData1(33);
                        } else if (pThing.getXrepeat() > 30) {
                            Main.boardService.getXSprite(pThing.getExtra()).setData1(23);
                        } else {
                            Main.boardService.getXSprite(pThing.getExtra()).setData1(12);
                        }
                        impact = false;
                        return;
                    }
                    case 400: 
                    case 401: 
                    case 420: {
                        impact = false;
                        break;
                    }
                    case 433: {
                        Main.boardService.getXSprite(pThing.getExtra()).setState(0);
                        Main.boardService.getXSprite(pThing.getExtra()).setProximity(true);
                        return;
                    }
                    case 431: 
                    case 435: {
                        XSPRITE pXThing = Main.boardService.getXSprite(pThing.getExtra());
                        if (pLeech != null) {
                            pXThing.setHealth(pXLeech.getHealth());
                        } else {
                            pXThing.setHealth(300 * Globals.pGameInfo.nDifficulty);
                        }
                        SOUND.sfxStart3DSound(pSprite, 490, -1, 0);
                        if (Globals.pGameInfo.nDifficulty <= 2) {
                            pXThing.setData3(32700);
                        } else {
                            pXThing.setData3((short)Gameutils.Random(10));
                        }
                        pThing.setPal(6);
                        pXThing.setTarget(pTarget.getXvel());
                        pXThing.setProximity(true);
                        pXThing.setStateTimer(1);
                        EVENT.evPostCallback(pThing.getXvel(), 3, 80L, 20);
                        return;
                    }
                }
                if (impact && dist <= 7680) {
                    Main.boardService.getXSprite(pThing.getExtra()).setImpact(true);
                } else {
                    Main.boardService.getXSprite(pThing.getExtra()).setImpact(false);
                    EVENT.evPost(pThing.getXvel(), 3, Integer.toUnsignedLong(120 * Gameutils.Random(2) + 120), 1);
                }
            }
        }
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(10.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        int vdist;
        int losAngle;
        int dist;
        block79: {
            block80: {
                int state;
                block83: {
                    block84: {
                        VECTORDATA meleeVector;
                        BloodSprite pTarget;
                        block82: {
                            Sprite pLeech;
                            block81: {
                                int defDist;
                                PLAYER pPlayer;
                                if (pSprite.getLotag() < 200) throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
                                if (pSprite.getLotag() >= 256) {
                                    throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
                                }
                                if (pXSprite.getTarget() <= -1) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[1]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[0]);
                                    return;
                                }
                                if (!Main.boardService.isValidSprite(pXSprite.getTarget())) {
                                    throw new AssertException("isValidSprite(pXSprite.getTarget())");
                                }
                                DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
                                pTarget = Main.boardService.getSprite(pXSprite.getTarget());
                                XSPRITE pXTarget = !Actor.IsDudeSprite(pTarget) || pTarget.getExtra() < 0 ? null : Main.boardService.getXSprite(pTarget.getExtra());
                                int dx = pTarget.getX() - pSprite.getX();
                                int dy = pTarget.getY() - pSprite.getY();
                                Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
                                if (pXTarget == null || pXTarget.getHealth() == 0) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 5);
                                    return;
                                }
                                if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                                    return;
                                }
                                dist = EngineUtils.qdist(dx, dy);
                                if (dist == 0) {
                                    dist = 1;
                                }
                                int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                                if (dist > pDudeInfo.seeDist || !Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[1]);
                                    } else {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeGoto[0]);
                                    }
                                    pXSprite.setTarget(-1);
                                    return;
                                }
                                int nAngle = EngineUtils.getAngle(dx, dy);
                                losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                                if (dist >= pDudeInfo.seeDist) return;
                                if (Pragmas.klabs(losAngle) > pDudeInfo.periphery) return;
                                if (pXSprite.getTarget() < 0) {
                                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                                }
                                if ((Globals.gFrameClock & 0x40) == 0 && Gameutils.Chance(4096) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 6);
                                }
                                pXSprite.getDudeExtra().setDudeSlope(Pragmas.divscale(pTarget.getZ() - pSprite.getZ(), dist, 10));
                                pLeech = null;
                                meleeVector = Actor.gVectorData[22];
                                if (pXSprite.getData1() >= 400 && pXSprite.getData1() < 436) {
                                    if (pXSprite.getData1() == 431) {
                                        pXSprite.setData1(435);
                                    }
                                    if ((pLeech = AIUNICULT.leechIsDropped(pSprite)) != null && Main.boardService.getXSprite(pLeech.getExtra()).getTarget() != pXSprite.getTarget()) {
                                        Main.boardService.getXSprite(pLeech.getExtra()).setTarget(pXSprite.getTarget());
                                    }
                                    if (Pragmas.klabs(losAngle) >= 85) return;
                                    if (dist < 12264 && dist > 7680 && !AIUNICULT.spriteIsUnderwater(pSprite, false) && pXSprite.getData1() != 435) {
                                        int pHit = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                                        switch (pHit) {
                                            case 0: 
                                            case 4: {
                                                return;
                                            }
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow);
                                        return;
                                    }
                                    if (dist > 4072 && dist <= 9072 && !AIUNICULT.spriteIsUnderwater(pSprite, false) && pSprite.getOwner() != 32666) {
                                        switch (pXSprite.getData1()) {
                                            case 435: {
                                                if (pLeech == null) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeDodge[0];
                                                    return;
                                                }
                                                XSPRITE pXLeech = Main.boardService.getXSprite(pLeech.getExtra());
                                                int ldist = Trigger.getTargetDist(pTarget, pDudeInfo, pLeech);
                                                if (ldist > 3 || !Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pLeech.getX(), pLeech.getY(), pLeech.getZ(), pLeech.getSectnum()) || pXLeech.getTarget() == -1) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeDodge[0];
                                                    return;
                                                }
                                                AIUNICULT.GDGenDudeThrow2.next = GDXGenDudeChase[0];
                                                if (pXLeech.getTarget() != pXSprite.getTarget()) {
                                                    pXLeech.setTarget(pXSprite.getTarget());
                                                }
                                                if (dist > 5072 && Gameutils.Chance(12288)) {
                                                    if (AIUNICULT.canDuck(pSprite) && !Gameutils.Chance(8192)) {
                                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                                                        return;
                                                    }
                                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                                                    return;
                                                }
                                                Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                                return;
                                            }
                                            case 434: {
                                                if (Gameutils.Chance(8192)) {
                                                    Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                                    return;
                                                }
                                                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                                                return;
                                            }
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDGenDudeThrow2);
                                        return;
                                    }
                                    if (dist <= meleeVector.maxDist) {
                                        if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                            if (Gameutils.Chance(28672)) {
                                                Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                                return;
                                            }
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                                            return;
                                        }
                                        if (Gameutils.Chance(28672)) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                            return;
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                                        return;
                                    }
                                    int state2 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                                    if (state2 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state2 != 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                        return;
                                    }
                                    if (Gameutils.Chance(12288)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                                vdist = defDist = 17920;
                                if (pXSprite.getData1() <= 0 || pXSprite.getData1() >= 23) break block81;
                                if (pXSprite.getData1() == 19) {
                                    pXSprite.setData1(2);
                                }
                                VECTORDATA pVectorData = Actor.gVectorData[pXSprite.getData1()];
                                vdist = pVectorData.maxDist;
                                if (vdist <= 0 || vdist > defDist) {
                                    vdist = defDist;
                                }
                                break block79;
                            }
                            if (pXSprite.getData1() >= 200 && pXSprite.getData1() < 256) {
                                DudeExtra dudeExtra = pXSprite.getDudeExtra();
                                if (dudeExtra.getThinkTime() > 0) {
                                    AIUNICULT.updateTargetOfSlaves(pSprite);
                                    if (pXSprite.getTarget() >= 0 && Main.boardService.getSprite(pXSprite.getTarget()).getOwner() == pSprite.getXvel()) {
                                        Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
                                        return;
                                    }
                                }
                                int state3 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                                if (dudeExtra.getThinkTime() <= Globals.pGameInfo.nDifficulty && dist > meleeVector.maxDist) {
                                    vdist = vdist / 2 + Gameutils.Random(vdist / 2);
                                    break block79;
                                } else {
                                    if (dist <= meleeVector.maxDist) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                        return;
                                    }
                                    if (state3 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state3 == 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                            }
                            if (pXSprite.getData1() < 300 || pXSprite.getData1() >= 318) break block82;
                            int state4 = AIUNICULT.checkAttackState(pSprite, pXSprite);
                            int mdist = pXSprite.getData1() != 303 ? 3000 : 2500;
                            switch (pXSprite.getData1()) {
                                case 315: {
                                    pLeech = AIUNICULT.leechIsDropped(pSprite);
                                    if (pLeech == null) break;
                                    AIUNICULT.removeLeech(pLeech);
                                    break;
                                }
                                case 303: 
                                case 305: 
                                case 312: 
                                case 313: 
                                case 314: {
                                    if (dist > mdist || pXSprite.getLocked() == 1) break;
                                    if (dist <= meleeVector.maxDist && Gameutils.Chance(28672)) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                        return;
                                    }
                                    if (state4 == 1) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                        return;
                                    }
                                    if (state4 == 2) {
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
                                        return;
                                    }
                                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
                                    return;
                                }
                                case 304: 
                                case 308: {
                                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                        if (dist > meleeVector.maxDist) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
                                            return;
                                        }
                                        if (Gameutils.Chance(16384)) {
                                            Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                                            return;
                                        }
                                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                                        return;
                                    }
                                    vdist = 4200;
                                    if ((Globals.gFrameClock & 0x10) != 0) break;
                                    vdist += Gameutils.Random(800);
                                }
                            }
                            break block79;
                        }
                        if (pXSprite.getData1() >= 459 && pXSprite.getData1() < 467) {
                            int nType = pXSprite.getData1() - 459;
                            EXPLODE pExpl = Actor.gExplodeData[nType];
                            boolean inRange = Gameutils.CheckProximity(pSprite, pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pExpl.radius / 2);
                            if (pExpl == null) return;
                            if (!inRange) return;
                            if (!AIUNICULT.doExplosion(pSprite, nType)) return;
                            Actor.actKillSprite(pSprite.getXvel(), pSprite, 3, 65535);
                            return;
                        }
                        state = AIUNICULT.checkAttackState(pSprite, pXSprite);
                        if (Gameutils.Chance(1280) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                            AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 6);
                        }
                        if (!Gameutils.Chance(512)) break block83;
                        if (dist > meleeVector.maxDist) break block84;
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudePunch);
                        break block80;
                    }
                    if (state == 1) {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[1]);
                        break block80;
                    } else if (state == 2) {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[2]);
                        break block80;
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeDodge[0]);
                    }
                    break block80;
                }
                if (state == 1) {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[1]);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeSearch[0]);
                }
            }
            Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
            return;
        }
        if (dist <= vdist && pXSprite.getAIState() == GDXGenDudeChase[2]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
        }
        int state = AIUNICULT.checkAttackState(pSprite, pXSprite);
        if (dist < vdist && Pragmas.klabs(losAngle) < 28) {
            switch (state) {
                case 1: {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[1]);
                    pXSprite.getAIState().next = GDXGenDudeFire[1];
                    return;
                }
                case 2: {
                    Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[2]);
                    pXSprite.getAIState().next = GDXGenDudeFire[2];
                    return;
                }
            }
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeFire[0]);
            pXSprite.getAIState().next = GDXGenDudeFire[0];
            return;
        }
        int nSeq = state < 3 ? 8 : 6;
        SeqInst pInst = SeqHandling.GetInstance(3, pSprite.getExtra());
        if (pInst.getSeqIndex() == Main.boardService.getXSprite(pSprite.getExtra()).getData2() + nSeq) {
            if (state == 1) {
                pXSprite.getAIState().next = GDXGenDudeChase[1];
                return;
            }
            if (state == 2) {
                pXSprite.getAIState().next = GDXGenDudeChase[2];
                return;
            }
            pXSprite.getAIState().next = GDXGenDudeChase[0];
            return;
        }
        if (state == 1 && pXSprite.getAIState() != GDXGenDudeChase[1] && pXSprite.getAIState() != GDXGenDudeFire[1]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[1]);
            pXSprite.getAIState().next = GDXGenDudeFire[1];
            return;
        }
        if (state == 2 && pXSprite.getAIState() != GDXGenDudeChase[2] && pXSprite.getAIState() != GDXGenDudeFire[2]) {
            Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[2]);
            pXSprite.getAIState().next = GDXGenDudeFire[2];
            return;
        }
        if (pXSprite.getAIState() == GDXGenDudeChase[0]) return;
        if (pXSprite.getAIState() == GDXGenDudeFire[0]) return;
        Ai.aiNewState(pSprite, pXSprite, GDXGenDudeChase[0]);
        pXSprite.getAIState().next = GDXGenDudeFire[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkAttackState(Sprite pSprite, XSPRITE pXSprite) {
        if (!AIUNICULT.checkUniCultistSeq(pSprite, 14) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) return 3;
        if (AIUNICULT.checkUniCultistSeq(pSprite, 14) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) return 2;
        if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) return 0;
        return 1;
    }

    public static boolean checkUniCultistSeq(Sprite pSprite, int nSeqID) {
        if (pSprite.getStatnum() == 6 && Actor.IsDudeSprite(pSprite)) {
            SeqInst pInst = SeqHandling.GetInstance(3, pSprite.getExtra());
            return pInst.getSeqIndex() == Main.boardService.getXSprite(pSprite.getExtra()).getData2() + nSeqID && SeqHandling.seqFrame(3, pSprite.getExtra()) >= 0;
        }
        return false;
    }

    public static boolean TargetNearThing(Sprite pSprite, int thingType) {
        for (ListNode<Sprite> node = Main.boardService.getSectNode(pSprite.getSectnum()); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            if (Main.boardService.getSprite(nSprite).getLotag() != thingType && Main.boardService.getSprite(nSprite).getStatnum() != 2) continue;
            return true;
        }
        return false;
    }

    public static long getGenDudeMoveSpeed(Sprite pSprite, int which, boolean mul, boolean shift) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        int speed = -1;
        int step = 2500;
        int maxSpeed = 146603;
        switch (which) {
            case 0: {
                speed = pDudeInfo.frontSpeed;
                break;
            }
            case 1: {
                speed = pDudeInfo.sideSpeed;
                break;
            }
            case 2: {
                speed = pDudeInfo.backSpeed;
                break;
            }
            case 3: {
                speed = pDudeInfo.angSpeed;
                break;
            }
            default: {
                return -1L;
            }
        }
        if (pXSprite.getBusyTime() > 0) {
            speed /= 3;
        }
        if (speed > 0 && mul && pXSprite.getBusyTime() > 0) {
            speed += step * pXSprite.getBusyTime();
        }
        if (shift) {
            speed *= Globals.kFrameTicks >> 4;
        }
        if (speed > maxSpeed) {
            speed = maxSpeed;
        }
        return speed;
    }

    public static void aiGenDudeMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(pSprite.getAng());
        int cos = Trig.Cos(pSprite.getAng());
        long frontSpeed = AIUNICULT.getGenDudeMoveSpeed(pSprite, 0, true, false);
        pSprite.addVelocity(Pragmas.mulscale(cos, frontSpeed, 30), Pragmas.mulscale(sin, frontSpeed, 30), 0L);
    }

    public static boolean sfxPlayGDXGenDudeSound(Sprite pSprite, int mode) {
        int sndId;
        if (mode < 0 || mode >= 11) {
            return false;
        }
        GENDUDESND sndInfo = gCustomDudeSnd[mode];
        boolean gotSnd = false;
        short sndStartId = Main.boardService.getXSprite(pSprite.getExtra()).getData3();
        int rand = sndInfo.randomRange;
        int n = sndId = sndStartId <= 0 ? sndInfo.defaultSndId : sndStartId + sndInfo.sndIdOffset;
        if (sndId < 0) {
            return false;
        }
        if (sndStartId <= 0) {
            sndId += Gameutils.Random(rand);
            gotSnd = true;
        } else {
            int maxRetries = 5;
            while (maxRetries-- > 0) {
                int random = Gameutils.Random(rand);
                if (!Main.game.getCache().contains(sndId + random, "sfx")) continue;
                sndId += random;
                gotSnd = true;
                break;
            }
            if (!gotSnd) {
                while (sndId++ <= sndId + rand) {
                    if (!Main.game.getCache().contains(sndId, "sfx")) continue;
                    gotSnd = true;
                    break;
                }
            }
        }
        if (!gotSnd) {
            return false;
        }
        if (sndInfo.aiPlaySound) {
            Ai.aiPlaySound((BloodSprite)pSprite, sndId, 2, -1);
        } else {
            SOUND.sfxStart3DSound(pSprite, sndId, -1, 0);
        }
        return true;
    }

    public static boolean spriteIsUnderwater(Sprite pSprite, boolean oldWay) {
        if (oldWay) {
            return Main.boardService.getXSprite(pSprite.getExtra()).getPalette() == 1 || Main.boardService.getXSprite(pSprite.getExtra()).getPalette() == 2;
        }
        if (Main.boardService.getSector(pSprite.getSectnum()).getExtra() < 0) {
            return false;
        }
        return DB.xsector[Main.boardService.getSector((int)pSprite.getSectnum()).getExtra()].Underwater;
    }

    public static Sprite leechIsDropped(Sprite pSprite) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            if (Main.boardService.getSprite(nSprite).getLotag() != 435 || Main.boardService.getSprite(nSprite).getOwner() != pSprite.getXvel()) continue;
            return Main.boardService.getSprite(nSprite);
        }
        return null;
    }

    public static void removeDudeStuff(Sprite pSprite) {
        int nSprite;
        ListNode<Sprite> node;
        block4: for (node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            nSprite = node.getIndex();
            if (Main.boardService.getSprite(nSprite).getOwner() != pSprite.getXvel()) continue;
            switch (Main.boardService.getSprite(nSprite).getLotag()) {
                case 401: 
                case 402: 
                case 433: {
                    Main.engine.deletesprite(nSprite);
                    continue block4;
                }
                case 435: {
                    AIUNICULT.killDudeLeech(Main.boardService.getSprite(nSprite));
                }
            }
        }
        for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            nSprite = node.getIndex();
            if (Main.boardService.getSprite(nSprite).getOwner() != pSprite.getXvel()) continue;
            Actor.actDamageSprite(Main.boardService.getSprite(nSprite).getOwner(), Main.boardService.getSprite(nSprite), 0, 65535);
        }
    }

    public static void removeLeech(Sprite pLeech) {
        if (pLeech != null) {
            BloodSprite pEffect = Actor.actSpawnEffect(52, pLeech.getSectnum(), pLeech.getX(), pLeech.getY(), pLeech.getZ(), pLeech.getAng());
            if (pEffect != null) {
                pEffect.setCstat(0);
                pEffect.setPal(6);
                int repeat = 64 + Gameutils.Random(50);
                pEffect.setXrepeat((short)repeat);
                pEffect.setYrepeat((short)repeat);
            }
            SOUND.sfxStart3DSoundCP(pLeech, 490, -1, 0, 60000L, 0);
            Main.engine.deletesprite(pLeech.getXvel());
        }
    }

    public static void killDudeLeech(BloodSprite pLeech) {
        Actor.actDamageSprite(pLeech.getOwner(), pLeech, 3, 65535);
        AIUNICULT.removeLeech(pLeech);
        SOUND.sfxStart3DSoundCP(pLeech, 522, -1, 0, 60000L, 0);
    }

    public static void updateTargetOfSlaves(Sprite pSprite) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            if (Main.boardService.getSprite(nSprite).getOwner() != pSprite.getXvel() || Main.boardService.getSprite(nSprite).getExtra() < 0) continue;
            XSPRITE pXSprite = Main.boardService.getXSprite(node.get().getExtra());
            if (Main.boardService.getXSprite(pSprite.getExtra()).getTarget() != pXSprite.getTarget() && Actor.IsDudeSprite(Main.boardService.getSprite(Main.boardService.getXSprite(pSprite.getExtra()).getTarget()))) {
                Ai.aiSetTarget(pXSprite, Main.boardService.getXSprite(pSprite.getExtra()).getTarget());
            }
            if (pXSprite.getTarget() >= 0 && Main.boardService.getSprite(pXSprite.getTarget()).getOwner() == Main.boardService.getSprite(nSprite).getOwner()) {
                Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), pSprite.getZ());
            }
            if (Trigger.isActive(pXSprite) || pXSprite.getTarget() < 0) continue;
            Ai.aiActivateDude(Main.boardService.getSprite(nSprite), pXSprite);
        }
    }

    public static boolean dudeIsMelee(XSPRITE pXSprite) {
        int meleeDist;
        int vdist = meleeDist = 2048;
        if (pXSprite.getData1() >= 0 && pXSprite.getData1() < 23) {
            int vector = pXSprite.getData1();
            if (vector <= 0) {
                vector = 2;
            }
            VECTORDATA pVectorData = Actor.gVectorData[vector];
            vdist = pVectorData.maxDist;
            return vdist > 0 && vdist <= meleeDist;
        }
        return pXSprite.getData1() >= 459 && pXSprite.getData1() < 467;
    }

    public static int getBaseChanceModifier(int baseChance) {
        return Globals.pGameInfo.nDifficulty > 0 ? baseChance - 768 * Globals.pGameInfo.nDifficulty : baseChance;
    }

    public static int getRecoilChance(Sprite pSprite) {
        int mass = Actor.getDudeMassBySpriteSize(pSprite);
        int cumulDmg = 0;
        int baseChance = AIUNICULT.getBaseChanceModifier(24576);
        if (pSprite.getExtra() >= 0) {
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            baseChance += pXSprite.getBurnTime() / 2;
            cumulDmg = pXSprite.getDudeExtra().getCumulDamage();
            if (AIUNICULT.dudeIsMelee(pXSprite)) {
                baseChance = 1280;
            }
        }
        int chance = (baseChance += cumulDmg) / mass << 7;
        return chance;
    }

    public static int getDodgeChance(Sprite pSprite) {
        int mass = Actor.getDudeMassBySpriteSize(pSprite);
        int baseChance = AIUNICULT.getBaseChanceModifier(8192);
        if (pSprite.getExtra() >= 0) {
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            baseChance += pXSprite.getBurnTime();
            if (AIUNICULT.dudeIsMelee(pXSprite)) {
                baseChance = 512;
            }
        }
        int chance = baseChance / mass << 7;
        return chance;
    }

    public static void dudeLeechOperate(BloodSprite pSprite, XSPRITE pXSprite, int evCommand) {
        BloodSprite pTarget;
        if (evCommand == 0) {
            Actor.actPostSprite(pSprite.getXvel(), 1024);
            return;
        }
        if (Main.boardService.isValidSprite(pXSprite.getTarget()) && pXSprite.getStateTimer() == 0 && (pTarget = Main.boardService.getSprite(pXSprite.getTarget())) != null && Actor.IsDudeSprite(pTarget) && (pTarget.getHitag() & 0x20) == 0 && Main.boardService.getXSprite(pTarget.getExtra()) != null) {
            Gameutils.GetSpriteExtents(pSprite);
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pTarget.getLotag() - 200];
            int dz = Gameutils.extents_zTop - pSprite.getZ() - 256;
            long dist = EngineUtils.qdist(pTarget.getX() - pSprite.getX(), pTarget.getY() - pSprite.getY());
            if (dist != 0L && Main.engine.cansee(pSprite.getX(), pSprite.getY(), Gameutils.extents_zTop, pSprite.getSectnum(), pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum())) {
                BloodSprite pMissile;
                short oldang = pSprite.getAng();
                long vel = Pragmas.divscale(dist, 0x1AAAAAL, 12);
                pSprite.setAng(EngineUtils.getAngle(Pragmas.mulscale(vel, pTarget.getVelocityX(), 12) + pTarget.getX() - pSprite.getX(), Pragmas.mulscale(vel, pTarget.getVelocityY(), 12) + pTarget.getY() - pSprite.getY()));
                int eyeAboveZ = pTarget.getZ() - (pDudeInfo.aimHeight * pTarget.getYrepeat() << 2) - Gameutils.extents_zTop - 256;
                int ax = Trig.Cos(pSprite.getAng()) >> 16;
                int ay = Trig.Sin(pSprite.getAng()) >> 16;
                int az = Pragmas.divscale(eyeAboveZ, dist, 10);
                int time = 12;
                int missileType = 316;
                if (pXSprite.getData3() != 0) {
                    time = 36;
                    ++missileType;
                }
                if ((pMissile = Actor.actFireMissile(pSprite, 0, dz, ax, ay, az, missileType)) != null) {
                    pMissile.setOwner(pSprite.getOwner());
                    pXSprite.setStateTimer(1);
                    pXSprite.setData3((short)Gameutils.ClipLow(pXSprite.getData3() - 1, 0));
                    EVENT.evPostCallback(pSprite.getXvel(), 3, time, 20);
                }
                pSprite.setAng(oldang);
            }
        }
    }

    public static boolean ceilIsTooLow(Sprite pSprite) {
        if (pSprite != null) {
            Sector pSector = Main.boardService.getSector(pSprite.getSectnum());
            int a = pSector.getCeilingz() - pSector.getFloorz();
            Gameutils.GetSpriteExtents(pSprite);
            int b = Gameutils.extents_zTop - Gameutils.extents_zBot;
            return a > b;
        }
        return false;
    }

    public static boolean doExplosion(Sprite pSprite, int nType) {
        int nExplosion = Actor.actSpawnSprite(pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 2, true);
        int nSeq = 4;
        int nSnd = 304;
        EXPLODE pExpl = Actor.gExplodeData[nType];
        if (nExplosion >= 0) {
            BloodSprite pExplosion = Main.boardService.getSprite(nExplosion);
            pExplosion.setYrepeat(pExpl.size);
            pExplosion.setXrepeat(pExpl.size);
            pExplosion.setLotag((short)nType);
            pExplosion.setCstat(pExplosion.getCstat() | 0xFFFF8080);
            pExplosion.setOwner(pSprite.getXvel());
            if (pExplosion.getExtra() >= 0) {
                Main.boardService.getXSprite(pExplosion.getExtra()).setTarget(0);
                Main.boardService.getXSprite(pExplosion.getExtra()).setData1((short)pExpl.liveCount);
                Main.boardService.getXSprite(pExplosion.getExtra()).setData2((short)pExpl.quake);
                Main.boardService.getXSprite(pExplosion.getExtra()).setData3((short)pExpl.used3);
                if (nType == 0) {
                    nSeq = 3;
                    nSnd = 303;
                    pExplosion.setZ(pSprite.getZ());
                } else if (nType == 2) {
                    nSeq = 4;
                    nSnd = 305;
                } else if (nType == 3) {
                    nSeq = 9;
                    nSnd = 307;
                } else if (nType == 4) {
                    nSeq = 5;
                    nSnd = 307;
                } else if (nType <= 6) {
                    nSeq = 4;
                    nSnd = 303;
                } else if (nType == 7) {
                    nSeq = 4;
                    nSnd = 303;
                }
                if (Main.game.getCache().contains(nSeq, "SEQ")) {
                    SeqHandling.seqSpawn(nSeq, 3, pExplosion.getExtra(), null);
                }
                SOUND.sfxStart3DSound(pExplosion, nSnd, -1, 0);
                return true;
            }
        }
        return false;
    }

    public static boolean canSwim(Sprite pSprite) {
        return Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 8, "SEQ") && Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 13, "SEQ") && Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 17, "SEQ");
    }

    public static boolean canDuck(Sprite pSprite) {
        return Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 8, "SEQ") && Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 14, "SEQ");
    }

    public static boolean CDCanMove(Sprite pSprite) {
        return Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 9, "SEQ") && Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 13, "SEQ") && Main.game.getCache().contains(Main.boardService.getXSprite(pSprite.getExtra()).getData2() + 14, "SEQ");
    }

    public static boolean inDodge(AISTATE aiState) {
        return aiState == GDXGenDudeDodgeDmg[1] || aiState == GDXGenDudeDodgeDmg[2] || aiState == GDXGenDudeDodgeDmg[0];
    }

    public static boolean inIdle(AISTATE aiState) {
        return aiState == GDXGenDudeIdle[1] || aiState == GDXGenDudeIdle[2] || aiState == GDXGenDudeIdle[0];
    }

    public static int getSeqStartId(XSPRITE pXSprite) {
        int seqStartId = DudeInfo.dudeInfo[Main.boardService.getSprite((int)pXSprite.getReference()).getLotag() - 200].seqStartID;
        if (pXSprite.getData2() > 0) {
            block3: for (int i = seqStartId = (int)pXSprite.getData2(); i <= seqStartId + 19; ++i) {
                switch (i - seqStartId) {
                    case 3: 
                    case 4: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        continue block3;
                    }
                    default: {
                        if (Main.game.getCache().contains(i, "SEQ")) continue block3;
                        Console.out.println("No SEQ file with ID " + i + " found for custom dude #" + pXSprite.getReference() + "!\nData2 (SEQ Base): " + pXSprite.getData2() + "\nSwitching to default animation!", OsdColor.YELLOW);
                        pXSprite.setData2((short)DudeInfo.dudeInfo[Main.boardService.getSprite((int)pXSprite.getReference()).getLotag() - 200].seqStartID);
                        return pXSprite.getData2();
                    }
                }
            }
        } else {
            pXSprite.setData2((short)seqStartId);
        }
        return seqStartId;
    }
}

