/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;

public class AIZOMBA {
    public static final int kAxeZombieMeleeDist = Gameutils.M2X(2.0);
    public static AISTATE zombieAIdle;
    public static AISTATE zombieAChase;
    public static AISTATE zombieAPonder;
    public static AISTATE zombieAGoto;
    public static AISTATE zombieAHack;
    public static AISTATE zombieASearch;
    public static AISTATE zombieARecoil;
    public static AISTATE zombieARTesla;
    public static AISTATE zombieAFall;
    public static AISTATE zombieAUp;
    public static AISTATE zombieEIdle;
    public static AISTATE zombieEUp;
    public static AISTATE zombieEUp2;
    public static AISTATE zombieSLIdle;
    public static AISTATE zombieSLUP;

    public static void Init() {
        zombieAIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, true, false, true, null){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                xsprite.setTarget(-1);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieEIdle = new AISTATE(AISTATEFUNC.Type.idle, 12, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieAPonder = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.thinkPonder(sprite, xsprite);
            }
        };
        zombieARecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, zombieAPonder);
        zombieARTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, zombieAPonder);
        zombieAUp = new AISTATE(AISTATEFUNC.Type.other, 11, null, 0, false, false, false, zombieAPonder);
        zombieAFall = new AISTATE(AISTATEFUNC.Type.other, 1, null, 360, false, false, false, zombieAUp);
        zombieAHack = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIZOMBA.HackCallback(nXSprite), 80, false, false, false, zombieAPonder);
        zombieAChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.thinkChase(sprite, xsprite);
            }
        };
        zombieAGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 1800, false, true, true, zombieAIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.thinkGoto(sprite, xsprite);
            }
        };
        zombieASearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, zombieAIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.thinkSearch(sprite, xsprite);
            }
        };
        zombieEUp2 = new AISTATE(AISTATEFUNC.Type.other, 0, null, 1, true, false, false, zombieASearch){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombie(sprite, xsprite);
            }
        };
        zombieEUp = new AISTATE(AISTATEFUNC.Type.other, 9, null, 180, true, false, false, zombieEUp2){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombieUp(sprite, xsprite);
            }
        };
        zombieSLIdle = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieSLUP = new AISTATE(AISTATEFUNC.Type.other, 11, null, 0, true, false, false, zombieAPonder){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBA.entryEZombie(sprite, xsprite);
            }
        };
    }

    private static void entryEZombie(BloodSprite pSprite, XSPRITE pXSprite) {
        pSprite.setHitag(pSprite.getHitag() | 1);
        pSprite.setLotag(203);
    }

    private static void entryEZombieUp(BloodSprite pSprite, XSPRITE pXSprite) {
        SOUND.sfxStart3DSound(pSprite, 1100, -1, 0);
        pSprite.setAng(EngineUtils.getAngle(pXSprite.getTargetX() - pSprite.getX(), pXSprite.getTargetY() - pSprite.getY()));
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        long dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < (long)Gameutils.M2X(1.8) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
            return;
        }
        long dist = EngineUtils.qdist(dx, dy);
        if (dist <= (long)pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist < (long)kAxeZombieMeleeDist && Pragmas.klabs(losAngle) < 85) {
                    Ai.aiNewState(pSprite, pXSprite, zombieAHack);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
        pXSprite.setTarget(-1);
    }

    private static void thinkPonder(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieAGoto);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist < kAxeZombieMeleeDist) {
                    if (Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, zombieAHack);
                    }
                    return;
                }
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieAChase);
    }

    private static void HackCallback(int nXIndex) {
        BloodSprite pTarget;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        int nAngle = EngineUtils.getAngle(pXSprite.getTargetX() - pSprite.getX(), pXSprite.getTargetY() - pSprite.getY());
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat() << 2;
        int nZOffset2 = 0;
        if (pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget = Main.boardService.getSprite(pXSprite.getTarget()))) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat() << 2;
        }
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = nZOffset1 - nZOffset2;
        SOUND.sfxStart3DSound(pSprite, 1101, 1, 0);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 10);
    }
}

