/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;

public class AIZOMBF {
    public static AISTATE zombieFIdle;
    public static AISTATE zombieFChase;
    public static AISTATE zombieFGoto;
    public static AISTATE zombieFDodge;
    public static AISTATE zombieFSearch;
    public static AISTATE zombieFRecoil;
    public static AISTATE zombieFRTesla;
    public static AISTATE zombieFThrow;
    public static AISTATE zombieFPuke;
    public static AISTATE zombieFHack;

    public static void Init() {
        zombieFIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        zombieFGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 8, null, 600, false, true, true, zombieFIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBF.thinkGoto(sprite, xsprite);
            }
        };
        zombieFChase = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBF.thinkChase(sprite, xsprite);
            }
        };
        zombieFDodge = new AISTATE(AISTATEFUNC.Type.other, 8, null, 0, false, true, true, zombieFChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBF.thinkChase(sprite, xsprite);
            }
        };
        zombieFHack = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIZOMBF.HackCallback(nXSprite), 120, false, false, false, zombieFChase);
        zombieFPuke = new AISTATE(AISTATEFUNC.Type.other, 9, nXSprite -> AIZOMBF.PukeCallback(nXSprite), 120, false, false, false, zombieFChase);
        zombieFThrow = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIZOMBF.ThrowCallback(nXSprite), 120, false, false, false, zombieFChase);
        zombieFSearch = new AISTATE(AISTATEFUNC.Type.search, 8, null, 1800, false, true, true, zombieFIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIZOMBF.thinkSearch(sprite, xsprite);
            }
        };
        zombieFRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, zombieFChase);
        zombieFRTesla = new AISTATE(AISTATEFUNC.Type.other, 4, null, 0, false, false, false, zombieFChase);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, zombieFGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum()) && dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (dist < 5120 && dist > 3584 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFThrow);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                } else if (dist < 5120 && dist > 1536 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFPuke);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                } else if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                    if (AIZOMBF.checkTarget(pSprite, dx, dy)) {
                        Ai.aiNewState(pSprite, pXSprite, zombieFHack);
                    } else {
                        Ai.aiNewState(pSprite, pXSprite, zombieFDodge);
                    }
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
        pXSprite.setTarget(-1);
    }

    private static boolean checkTarget(BloodSprite pSprite, int dx, int dy) {
        int pInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
        return pInfo <= -1 || pInfo != 3 || pSprite.getLotag() != Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag();
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, zombieFSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void PukeCallback(int nXIndex) {
        BloodSprite pTarget;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        int nAngle = EngineUtils.getAngle(pXSprite.getTargetX() - pSprite.getX(), pXSprite.getTargetY() - pSprite.getY());
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = 0;
        int nZOffset1 = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat();
        int nZOffset2 = 0;
        if (pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget = Main.boardService.getSprite(pXSprite.getTarget()))) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat();
        }
        SOUND.sfxStart3DSound(pSprite, 1203, 1, 0);
        Actor.actFireMissile(pSprite, 0, nZOffset2 - nZOffset1, dx, dy, dz, 309);
    }

    private static void ThrowCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = 0;
        int nZOffset = 0;
        if (Actor.IsDudeSprite(pSprite)) {
            nZOffset = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight;
        }
        Actor.actFireMissile(pSprite, 0, -nZOffset, dx, dy, dz, 300);
    }

    private static void HackCallback(int nXIndex) {
        BloodSprite pSprite;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        if (pXSprite != null && (pSprite = Main.boardService.getSprite(pXSprite.getReference())) != null && pSprite.getLotag() == 204) {
            BloodSprite pTarget;
            int dx = Trig.Cos(pSprite.getAng()) >> 16;
            int dy = Trig.Sin(pSprite.getAng()) >> 16;
            int dz = DudeInfo.dudeInfo[4].eyeHeight * pSprite.getYrepeat();
            if (pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget = Main.boardService.getSprite(pXSprite.getTarget()))) {
                dz -= DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat();
            }
            Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 11);
        }
    }
}

