/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;

public abstract class GeneticDude {
    private static final int kAIThinkMask = 3;
    protected BloodSprite pSprite;
    protected XSPRITE pXSprite;
    protected DudeInfo pDudeInfo;
    protected AiState aiState;
    protected int aiClock;
    protected int aiSoundOnce;
    protected int aiTeslaHit;
    protected int cumulDamage;

    public GeneticDude(BloodSprite pSprite) {
        this.pSprite = pSprite;
        if (!Actor.IsDudeSprite(pSprite)) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        this.pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        this.pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        this.aiClock = 0;
        this.aiSoundOnce = 0;
        this.cumulDamage = 0;
    }

    public abstract void activate();

    public abstract int damage(int var1, int var2, int var3);

    public abstract void kill(int var1, int var2, int var3);

    public abstract void warp(int var1);

    public abstract void touch();

    protected abstract void recoil(boolean var1);

    protected boolean aiCanMove(int nTarget, int ang, int dist) {
        int dx = Pragmas.mulscale(dist, Trig.Cos(ang), 30);
        int dy = Pragmas.mulscale(dist, Trig.Sin(ang), 30);
        int x = this.pSprite.getX();
        int y = this.pSprite.getY();
        int z = this.pSprite.getZ();
        Gameutils.HitScan(this.pSprite, z, Trig.Cos(ang) >> 16, Trig.Sin(ang) >> 16, 0, Engine.pHitInfo, 65537, dist);
        int hitDist = EngineUtils.qdist(x - Engine.pHitInfo.hitx, y - Engine.pHitInfo.hity);
        if (hitDist - (this.pSprite.getClipdist() << 2) < dist) {
            return Engine.pHitInfo.hitsprite != -1 && Engine.pHitInfo.hitsprite == nTarget;
        }
        return Gameutils.FindSector(x += dx, y += dy, z, this.pSprite.getSectnum());
    }

    protected void aiChooseDirection(int ang) {
        int dang = (1024 + ang - this.pSprite.getAng() & 0x7FF) - 1024;
        int sin = Trig.Sin(this.pSprite.getAng());
        int cos = Trig.Cos(this.pSprite.getAng());
        long vel = Pragmas.dmulscale(this.pSprite.getVelocityX(), cos, this.pSprite.getVelocityY(), sin, 30);
        int avoidDist = (int)((15L * vel >> 12) - (15L * vel >> 43) >> 1);
        int turnTo = 341;
        if (dang < 0) {
            turnTo = -turnTo;
        }
        if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() + dang, avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng() + dang & 0x7FF);
        } else if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() + dang / 2, avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng() + dang / 2 & 0x7FF);
        } else if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() - dang / 2, avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng() - dang / 2 & 0x7FF);
        } else if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() + turnTo, avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng() + turnTo & 0x7FF);
        } else if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng(), avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng());
        } else if (this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() - turnTo, avoidDist)) {
            this.pXSprite.setGoalAng(this.pSprite.getAng() - turnTo & 0x7FF);
        } else {
            this.pXSprite.setGoalAng(this.pSprite.getAng() + 341 & 0x7FF);
        }
        this.pXSprite.setDodgeDir(Gameutils.Chance(16384) ? 1 : -1);
        if (!this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() + 512 * this.pXSprite.getDodgeDir(), 512)) {
            this.pXSprite.setDodgeDir(-this.pXSprite.getDodgeDir());
            if (!this.aiCanMove(this.pXSprite.getTarget(), this.pSprite.getAng() + 512 * this.pXSprite.getDodgeDir(), 512)) {
                this.pXSprite.setDodgeDir(0);
            }
        }
    }

    protected void aiMoveForward() {
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + this.pXSprite.getGoalAng() - this.pSprite.getAng() & 0x7FF) - 1024;
        this.pSprite.setAng((short)(this.pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(this.pSprite.getAng());
        int cos = Trig.Cos(this.pSprite.getAng());
        this.pSprite.addVelocity(Pragmas.mulscale(cos, this.pDudeInfo.frontSpeed, 30), Pragmas.mulscale(sin, this.pDudeInfo.frontSpeed, 30), 0L);
    }

    protected void aiMoveTurn() {
        int dang = (1024 + this.pXSprite.getGoalAng() - this.pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        this.pSprite.setAng((short)(this.pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
    }

    protected void aiMoveDodge() {
        int dang = (1024 + this.pXSprite.getGoalAng() - this.pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = this.pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        this.pSprite.setAng((short)(this.pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (this.pXSprite.getDodgeDir() == 0) {
            return;
        }
        long sin = Trig.Sin(this.pSprite.getAng());
        long cos = Trig.Cos(this.pSprite.getAng());
        long vel = Pragmas.dmulscale(this.pSprite.getVelocityX(), cos, this.pSprite.getVelocityY(), sin, 30);
        long svel = Pragmas.dmulscale(this.pSprite.getVelocityX(), sin, -this.pSprite.getVelocityY(), cos, 30);
        svel = this.pXSprite.getDodgeDir() > 0 ? (svel += (long)this.pDudeInfo.sideSpeed) : (svel -= (long)this.pDudeInfo.sideSpeed);
        this.pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
        this.pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
    }

    protected boolean aiThinkTarget() {
        if (!Gameutils.Chance(this.pDudeInfo.alertChance / 2)) {
            return true;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (this.pSprite.getOwner() != pPlayer.nSprite && pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - this.pSprite.getX();
                long dist = EngineUtils.qdist(dx, dy = y - this.pSprite.getY());
                if (dist <= (long)this.pDudeInfo.seeDist || dist <= (long)this.pDudeInfo.hearDist) {
                    int eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, this.pSprite.getX(), this.pSprite.getY(), this.pSprite.getZ() - eyeAboveZ, this.pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - this.pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < (long)this.pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                            this.setTarget(pPlayer.nSprite);
                            this.activate();
                            return true;
                        }
                        if (dist < (long)this.pDudeInfo.hearDist) {
                            this.setTarget(x, y, z);
                            this.activate();
                            return true;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        return false;
    }

    protected void aiPlaySound(int nSound, int soundonce, int nChannel) {
        if (soundonce != 0) {
            if (soundonce > this.aiSoundOnce || Globals.gFrameClock >= this.aiClock) {
                SOUND.sfxKill3DSound(this.pSprite, -1, -1);
                SOUND.sfxStart3DSound(this.pSprite, nSound, nChannel, 0);
                this.aiSoundOnce = soundonce;
                this.aiClock = Globals.gFrameClock + 120;
            }
        } else {
            SOUND.sfxStart3DSound(this.pSprite, nSound, nChannel, 2);
        }
    }

    protected void aiNewState(AiState pState) {
        this.pXSprite.setStateTimer(pState.ticks);
        this.aiState = pState;
        int seqStartId = this.pDudeInfo.seqStartID;
        if (pState.seqId >= 0) {
            if (!Main.game.getCache().contains(seqStartId + pState.seqId, "SEQ")) {
                return;
            }
            SeqHandling.seqSpawn(seqStartId + pState.seqId, 3, this.pSprite.getExtra(), pState.callback);
        }
        if (pState.enter != null) {
            pState.enter.run();
        }
    }

    public void setTarget(int x, int y, int z) {
        this.pXSprite.setTarget(-1);
        this.pXSprite.setTargetX(x);
        this.pXSprite.setTargetY(y);
        this.pXSprite.setTargetZ(z);
    }

    public void setTarget(int nTarget) {
        if (!Main.boardService.isValidSprite(nTarget)) {
            throw new AssertException("isValidSprite(nTarget)");
        }
        if (nTarget == this.pSprite.getOwner()) {
            return;
        }
        BloodSprite pTarget = Main.boardService.getSprite(nTarget);
        if (!Actor.IsDudeSprite(pTarget)) {
            return;
        }
        DudeInfo pTargetInfo = DudeInfo.dudeInfo[pTarget.getLotag() - 200];
        this.pXSprite.setTarget(nTarget);
        this.pXSprite.setTargetX(pTarget.getX());
        this.pXSprite.setTargetY(pTarget.getY());
        this.pXSprite.setTargetZ(pTarget.getZ() - (pTargetInfo.eyeHeight * pTarget.getYrepeat() << 2));
    }

    public void process() {
        if ((this.pSprite.getHitag() & 0x20) != 0) {
            return;
        }
        short nXSprite = this.pSprite.getExtra();
        if (this.pXSprite.getHealth() == 0) {
            return;
        }
        this.pXSprite.setStateTimer(Gameutils.ClipLow(this.pXSprite.getStateTimer() - Globals.kFrameTicks, 0));
        if (this.aiState != null && this.aiState.move != null) {
            this.aiState.move.run();
        }
        if (this.aiState != null && this.aiState.think != null && (Globals.gFrame & 3) == (this.pSprite.getXvel() & 3)) {
            this.aiState.think.run();
        }
        if (this.aiState != null && this.pXSprite.getStateTimer() == 0 && this.aiState.next != null) {
            if (this.aiState != null && this.aiState.ticks > 0) {
                this.aiNewState(this.aiState.next);
            } else if (SeqHandling.seqFrame(3, nXSprite) < 0) {
                this.aiNewState(this.aiState.next);
            }
        }
        if (this.pXSprite.getHealth() != 0 && this.cumulDamage >= this.pDudeInfo.hinderDamage << 4) {
            this.pXSprite.setData3((short)this.cumulDamage);
            boolean chance = Gameutils.Chance(16384);
            if (this.pSprite.getStatnum() != 6 || !Actor.IsDudeSprite(this.pSprite)) {
                return;
            }
            this.recoil(chance);
        }
        this.cumulDamage = 0;
    }

    public boolean heal(int value, int max) {
        value <<= 4;
        if (this.pXSprite.getHealth() < (max <<= 4)) {
            this.pXSprite.setHealth(Gameutils.ClipHigh(this.pXSprite.getHealth() + value, max));
            return true;
        }
        return false;
    }

    public int mass() {
        return this.pDudeInfo.mass;
    }

    protected static class AiState {
        final int seqId;
        final int ticks;
        final AiState next;
        final Runnable enter;
        final Runnable move;
        final Runnable think;
        final CALLPROC callback;

        public AiState(int seqId, CALLPROC callback, int ticks, Runnable enter, Runnable move, Runnable think, AiState next) {
            this.seqId = seqId;
            this.callback = callback;
            this.ticks = ticks;
            this.enter = enter;
            this.move = move;
            this.think = think;
            this.next = next;
        }
    }
}

