/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.ScreenAdapter;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodBoard;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class DB {
    public static final int kMaxXWalls = 512;
    public static final int kMaxXSectors = 512;
    public static final int kMaxBusyValue = 65536;
    public static final int kFluxMask = 65535;
    public static final int kPathMarker = 15;
    public static final int kDudeSpawn = 18;
    public static final int kEarthQuake = 19;
    public static final int kSwitchBase = 20;
    public static final int kSwitchToggle = 20;
    public static final int kSwitchMomentary = 21;
    public static final int kSwitchCombination = 22;
    public static final int kSwitchPadlock = 23;
    public static final int kSwitchMax = 24;
    public static final int kGDXTypeBase = 24;
    public static final int kGDXCustomDudeSpawn = 24;
    public static final int kGDXRandomTX = 25;
    public static final int kGDXSequentialTX = 26;
    public static final int kGDXSeqSpawner = 27;
    public static final int kGDXObjPropertiesChanger = 28;
    public static final int kGDXObjPicnumChanger = 29;
    public static final int kGDXObjSizeChanger = 31;
    public static final int kGDXDudeTargetChanger = 33;
    public static final int kGDXSectorFXChanger = 34;
    public static final int kGDXObjDataChanger = 35;
    public static final int kGDXSpriteDamager = 36;
    public static final int kGDXObjDataAccumulator = 37;
    public static final int kGDXEffectSpawner = 38;
    public static final int kGDXWindGenerator = 39;
    public static final int kDudeBase = 200;
    public static final int kDudeTommyCultist = 201;
    public static final int kDudeShotgunCultist = 202;
    public static final int kDudeAxeZombie = 203;
    public static final int kDudeButcher = 204;
    public static final int kDudeEarthZombie = 205;
    public static final int kDudeFleshGargoyle = 206;
    public static final int kDudeStoneGargoyle = 207;
    public static final int kDudeFleshStatue = 208;
    public static final int kDudeStoneStatue = 209;
    public static final int kDudePhantasm = 210;
    public static final int kDudeHound = 211;
    public static final int kDudeHand = 212;
    public static final int kDudeBrownSpider = 213;
    public static final int kDudeRedSpider = 214;
    public static final int kDudeBlackSpider = 215;
    public static final int kDudeMotherSpider = 216;
    public static final int kDudeGillBeast = 217;
    public static final int kDudeEel = 218;
    public static final int kDudeBat = 219;
    public static final int kDudeRat = 220;
    public static final int kDudeGreenPod = 221;
    public static final int kDudeGreenTentacle = 222;
    public static final int kDudeFirePod = 223;
    public static final int kDudeFireTentacle = 224;
    public static final int kDudeMotherPod = 225;
    public static final int kDudeMotherTentacle = 226;
    public static final int kDudeCerberus = 227;
    public static final int kDudeCerberus2 = 228;
    public static final int kDudeTchernobog = 229;
    public static final int kDudeFanaticProne = 230;
    public static final int kDudePlayer1 = 231;
    public static final int kDudePlayer8 = 238;
    public static final int kDudeBurning = 239;
    public static final int kDudeCultistBurning = 240;
    public static final int kDudeAxeZombieBurning = 241;
    public static final int kDudeBloatedButcherBurning = 242;
    public static final int kDudeSleepZombie = 244;
    public static final int kDudeInnocent = 245;
    public static final int kDudeCultistProne = 246;
    public static final int kDudeTeslaCultist = 247;
    public static final int kDudeDynamiteCultist = 248;
    public static final int kDudeBeastCultist = 249;
    public static final int kDudeTinyCaleb = 250;
    public static final int kDudeTheBeast = 251;
    public static final int kDudeTinyCalebburning = 252;
    public static final int kDudeTheBeastburning = 253;
    public static final int kGDXDudeUniversalCultist = 254;
    public static final int kGDXGenDudeBurning = 255;
    public static final int kDudeMax = 256;
    public static final String[] kDudeName = new String[]{"kDudeBase", "Tommy Cultist", "Shotgun Cultist", "Axe Zombie", "Butcher", "Earth Zombie", "Flesh Gargoyle", "Stone Gargoyle", "Flesh Statue", "Stone Statue", "Phantasm", "Hound", "Hand", "Brown Spider", "Red Spider", "Black Spider", "Mother Spider", "Gill Beast", "Eel", "Bat", "Rat", "Green Pod", "Green Tentacle", "Fire Pod", "Fire Tentacle", "Mother Pod", "Mother Tentacle", "Cerberus", "Cerberus", "Tchernobo", "Fanatic Prone", "Player1", "Player2", "Player3", "Player4", "Player5", "Player6", "Player7", "Player8", "Burning", "Cultist Burning", "Axe Zombie Burning", "Bloated Butcher Burning", "<Reserved>", "Sleep Zombie", "Innocent", "CultistProne", "Tesla Cultist", "Dynamite Cultist", "Beast Cultist", "Tiny Caleb", "The Beast", "Tiny Calebburning", "The Beastburning", "GDX Custom dude", "GDX Custom burning dude", "kDudeMax"};
    public static final int kMissileBase = 300;
    public static final int kMissileButcherKnife = 300;
    public static final int kMissileFlare = 301;
    public static final int kMissileAltTesla = 302;
    public static final int kMissileStarburstFlare = 303;
    public static final int kMissileSprayFlame = 304;
    public static final int kMissileFireball = 305;
    public static final int kMissileTesla = 306;
    public static final int kMissileEctoSkull = 307;
    public static final int kMissileHoundFire = 308;
    public static final int kMissileGreenPuke = 309;
    public static final int kMissileRedPuke = 310;
    public static final int kMissileBone = 311;
    public static final int kMissileNapalm = 312;
    public static final int kMissileTchernobog = 313;
    public static final int kMissileTchernobog2 = 314;
    public static final int kMissileLifeLeech = 315;
    public static final int kMissileAltLeech1 = 316;
    public static final int kMissileAltLeech2 = 317;
    public static final int kMissileMax = 318;
    public static final int kThingBase = 400;
    public static final int kThingTNTBarrel = 400;
    public static final int kThingTNTProx = 401;
    public static final int kThingTNTRem = 402;
    public static final int kThingBlueVase = 403;
    public static final int kThingBrownVase = 404;
    public static final int kThingCrateFace = 405;
    public static final int kThingClearGlass = 406;
    public static final int kThingFluorescent = 407;
    public static final int kThingWallCrack = 408;
    public static final int kThingWoodBeam = 409;
    public static final int kThingWeb = 410;
    public static final int kThingMetalGrate1 = 411;
    public static final int kThingFlammableTree = 412;
    public static final int kThingMachineGun = 413;
    public static final int kThingFallingRock = 414;
    public static final int kThingPail = 415;
    public static final int kThingGibObject = 416;
    public static final int kThingExplodeObject = 417;
    public static final int kThingTNTStick = 418;
    public static final int kThingTNTBundle = 419;
    public static final int kThingSprayBundle = 420;
    public static final int kThingBoneClub = 421;
    public static final int kThingWaterDrip = 423;
    public static final int kThingBloodDrip = 424;
    public static final int kThingGibSmall = 425;
    public static final int kThingGib = 426;
    public static final int kThingZombieHead = 427;
    public static final int kThingAltNapalm = 428;
    public static final int kThingPodFire = 429;
    public static final int kThingPodGreen = 430;
    public static final int kThingLifeLeech = 431;
    public static final int kGDXThingTNTProx = 433;
    public static final int kGDXThingThrowableRock = 434;
    public static final int kGDXThingCustomDudeLifeLeech = 435;
    public static final int kThingMax = 436;
    public static final int kThingFlameTrap = 452;
    public static final int kTrapSawBlade = 454;
    public static final int kTrapPoweredZap = 456;
    public static final int kThingHiddenExploder = 459;
    public static final int kWallGlass = 511;
    public static final int kGenTrigger = 700;
    public static final int kGenWaterDrip = 701;
    public static final int kGenBloodDrip = 702;
    public static final int kGenFireball = 703;
    public static final int kGenEctoSkull = 704;
    public static final int kGenDart = 705;
    public static final int kGenBubble = 706;
    public static final int kGenMultiBubble = 707;
    public static final int kGenSFX = 708;
    public static final int kGenSectorSFX = 709;
    public static final int kGenAmbientSFX = 710;
    public static final int kGenPlayerSFX = 711;
    public static final int kSectorBase = 600;
    public static final int kSectorZMotion = 600;
    public static final int kSectorZSprite = 602;
    public static final int kSectorWarp = 603;
    public static final int kSectorTeleport = 604;
    public static final int kSectorPath = 612;
    public static final int kSectorRotateStep = 613;
    public static final int kSectorSlideMarked = 614;
    public static final int kSectorRotateMarked = 615;
    public static final int kSectorSlide = 616;
    public static final int kSectorRotate = 617;
    public static final int kSectorDamage = 618;
    public static final int kSectorCounter = 619;
    public static final int kSectorMax = 620;
    public static final int kWeaponItemBase = 40;
    public static final int kWeaponLifeLeech = 50;
    public static final int kWeaponItemMax = 51;
    public static final int kAmmoItemBase = 60;
    public static final int kAmmoItemRandom = 80;
    public static final int kAmmoItemMax = 81;
    public static final int kItemBase = 100;
    public static final int kItemKey1 = 100;
    public static final int kItemKey2 = 101;
    public static final int kItemKey3 = 102;
    public static final int kItemKey4 = 103;
    public static final int kItemKey5 = 104;
    public static final int kItemKey6 = 105;
    public static final int kItemKey7 = 106;
    public static final int kItemDoctorBag = 107;
    public static final int kItemMedPouch = 108;
    public static final int kItemLifeEssence = 109;
    public static final int kItemLifeSeed = 110;
    public static final int kItemPotion1 = 111;
    public static final int kItemFeatherFall = 112;
    public static final int kItemLtdInvisibility = 113;
    public static final int kItemInvulnerability = 114;
    public static final int kItemJumpBoots = 115;
    public static final int kItemRavenFlight = 116;
    public static final int kItemGunsAkimbo = 117;
    public static final int kItemDivingSuit = 118;
    public static final int kItemGasMask = 119;
    public static final int kItemClone = 120;
    public static final int kItemCrystalBall = 121;
    public static final int kItemDecoy = 122;
    public static final int kItemDoppleganger = 123;
    public static final int kItemReflectiveShots = 124;
    public static final int kItemBeastVision = 125;
    public static final int kItemShadowCloak = 126;
    public static final int kItemShroomRage = 127;
    public static final int kItemShroomDelirium = 128;
    public static final int kItemShroomGrow = 129;
    public static final int kItemShroomShrink = 130;
    public static final int kItemDeathMask = 131;
    public static final int kItemWineGoblet = 132;
    public static final int kItemWineBottle = 133;
    public static final int kItemSkullGrail = 134;
    public static final int kItemSilverGrail = 135;
    public static final int kItemTome = 136;
    public static final int kItemBlackChest = 137;
    public static final int kItemWoodenChest = 138;
    public static final int kItemAsbestosArmor = 139;
    public static final int kArmorItemBase = 140;
    public static final int kItemBasicArmor = 140;
    public static final int kItemBodyArmor = 141;
    public static final int kItemFireArmor = 142;
    public static final int kItemSpiritArmor = 143;
    public static final int kItemSuperArmor = 144;
    public static final int kItemBlueTeamBase = 145;
    public static final int kItemRedTeamBase = 146;
    public static final int kItemBlueFlag = 147;
    public static final int kItemRedFlag = 148;
    public static final int kItemJetpack = 149;
    public static final int kItemMax = 149;
    public static final int kMaxItemTypes = 49;
    public static final int kMaxPowerUps = 49;
    public static final int kRespawnNever = 0;
    public static final int kRespawnOptional = 1;
    public static final int kRespawnAlways = 2;
    public static final int kRespawnPermanent = 3;
    public static final String[] gItemText = new String[]{"Skull Key", "Eye Key", "Fire Key", "Dagger Key", "Spider Key", "Moon Key", "Key 7", "Doctor's Bag", "Medicine Pouch", "Life Essence", "Life Seed", "Red Potion", "Feather Fall", "Limited Invisibility", "INVULNERABILITY", "Boots of Jumping", "Raven Flight", "Guns Akimbo", "Diving Suit", "Gas mask", "Clone", "Crystal Ball", "Decoy", "Doppleganger", "Reflective shots", "Beast Vision", "ShadowCloak", "Rage shroom", "Delirium Shroom", "Grow shroom", "Shrink shroom", "Death mask", "Wine Goblet", "Wine Bottle", "Skull Grail", "Silver Grail", "Tome", "Black Chest", "Wooden Chest", "Asbestos Armor", "Basic Armor", "Body Armor", "Fire Armor", "Spirit Armor", "Super Armor", "Blue Team Base", "Red Team Base", "Blue Flag", "Red Flag", "Level map"};
    public static final String[] gWeaponText = new String[]{"RANDOM", "Sawed-off", "Tommy Gun", "Flare Pistol", "Voodoo Doll", "Tesla Cannon", "Napalm Launcher", "Pitchfork", "Spray Can", "Dynamite", "Life Leech"};
    public static final String[] gAmmoText = new String[]{"Spray can", "Bundle of TNT*", "Bundle of TNT", "Case of TNT", "Proximity Detonator", "Remote Detonator", "Trapped Soul", "4 shotgun shells", "Box of shotgun shells", "A few bullets", "Voodoo Doll", "OBSOLETE", "Full drum of bullets", "Tesla Charge", "OBSOLETE", "OBSOLETE", "Flares", "OBSOLETE", "OBSOLETE", "Gasoline Can"};
    private static final int kFreeHead = 0;
    private static final short[] gHealthInfo = new short[8];
    private static final PLAYER[] gPlayerInfo = new PLAYER[8];
    public static XWALL[] xwall = new XWALL[512];
    public static XSECTOR[] xsector = new XSECTOR[512];
    public static int[] nextXWall = new int[512];
    public static int[] nextXSector = new int[512];
    public static int gSkyCount;
    public static int gVisibility;
    private static short gProxySpritesCount;
    private static byte gMaxBadProxySprites;
    private static short gSightSpritesCount;
    private static byte gMaxBadSightSprites;

    public static boolean prepareboard(ScreenAdapter screen) {
        try {
            int i;
            Console.out.println("debug: start prepareboard()", OsdColor.BLUE);
            BloodBoard board = DB.dbLoadMap(Globals.pGameInfo.zLevelName);
            Screen.scrReset();
            View.PaletteView = 0;
            Main.engine.getPaletteManager().setPalette(View.PaletteView);
            View.gViewMode = 3;
            View.gViewPos = 0;
            View.resetQuotes();
            Actor.gNoEnemies = 0;
            SOUND.sndStopAllSounds();
            SeqHandling.seqKillAll();
            if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    if (gPlayerInfo[j] == null) {
                        DB.gPlayerInfo[j] = new PLAYER();
                    }
                    gPlayerInfo[j].copy(Globals.gPlayer[j]);
                    DB.gPlayerInfo[j].pSprite = Globals.gPlayer[j].pSprite;
                    DB.gHealthInfo[j] = (short)Globals.gPlayer[j].pXsprite.getHealth();
                    j = Mmulti.connectpoint2[j];
                }
            }
            Gameutils.sRandom(Globals.pGameInfo.uMapCRC);
            Engine.automapping = 1;
            LEVELS.levelResetKills();
            LEVELS.levelResetSecrets();
            gProxySpritesCount = 0;
            gSightSpritesCount = 0;
            List<Sprite> sprites = board.getSprites();
            for (int i2 = 0; i2 < sprites.size(); ++i2) {
                BloodSprite pSprite = (BloodSprite)sprites.get(i2);
                pSprite.setVelocity(0L, 0L, 0L);
                XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
                if (pSprite.getStatnum() == 1024 || pXSprite == null) continue;
                if ((1 << Globals.pGameInfo.nEnemyQuantity & pXSprite.getLSkill()) != 0 || pXSprite.islS() && Globals.pGameInfo.nGameType == 0 || pXSprite.islB() && Globals.pGameInfo.nGameType == 2 || pXSprite.islT() && Globals.pGameInfo.nGameType == 3 || pXSprite.islC() && Globals.pGameInfo.nGameType == 1) {
                    Main.engine.deletesprite(i2);
                    continue;
                }
                if (DemoUtils.IsOriginalDemo(screen) || pSprite.getLotag() != 33) continue;
                Main.engine.changespritestat(i2, 20);
            }
            Main.engine.getPaletteManager().loadPLUs(Main.engine.getPaletteManager().isFogMode());
            BuildPos pos = board.getPos();
            int z = pos.getZ();
            if (pos.getSectnum() != -1) {
                z = Main.engine.getflorzofslope(pos.getSectnum(), pos.getX(), pos.getY());
            }
            for (i = 0; i < 8; ++i) {
                Warp.gStartZone[i] = DB.getStartZone(pos, z);
                if (i > 4) continue;
                Warp.gStartZoneTeam1[i] = DB.getStartZone(pos, z);
                Warp.gStartZoneTeam2[i] = DB.getStartZone(pos, z);
            }
            SECTORFX.InitSectorFX();
            Warp.InitPlayerStartZones(board);
            Actor.actInit(false, DemoUtils.IsOriginalDemo(screen));
            EVENT.evInit(board, DemoUtils.IsOriginalDemo(screen));
            if (Globals.pGameInfo.nFragLimit != 0) {
                Arrays.fill(Globals.nTeamCount, 0);
                Arrays.fill(Globals.nTeamClock, 0);
            }
            short j = Mmulti.connecthead;
            while (j >= 0) {
                if ((Globals.pGameInfo.uGameFlags & 1) == 0 || Globals.pGameInfo.nGameType > 1) {
                    if (Mmulti.numplayers == 1) {
                        Main.game.net.gProfile[j].autoaim = Main.cfg.gAutoAim;
                        Main.game.net.gProfile[j].slopetilt = Main.cfg.gSlopeTilt;
                        Main.game.net.gProfile[j].skill = (byte)Globals.pGameInfo.nDifficulty;
                    }
                    PLAYER.playerInit(j, false);
                }
                PLAYER.playerReset(j);
                if (Globals.pGameInfo.nFragLimit != 0) {
                    Globals.gPlayer[j].fragCount = 0;
                    Arrays.fill(Globals.gPlayer[j].fragInfo, 0);
                }
                j = Mmulti.connectpoint2[j];
            }
            if (Globals.kFakeMultiplayer) {
                for (i = 1; i < Globals.nFakePlayers; ++i) {
                    if ((Globals.pGameInfo.uGameFlags & 1) == 0 || Globals.pGameInfo.nGameType > 1) {
                        PLAYER.playerInit(i, false);
                    }
                    PLAYER.playerReset(i);
                }
            }
            if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
                j = Mmulti.connecthead;
                while (j >= 0) {
                    int i3;
                    PLAYER pPlayer = Globals.gPlayer[j];
                    pPlayer.pXsprite.setHealth(gHealthInfo[j]);
                    pPlayer.pWeaponQAV = DB.gPlayerInfo[j].pWeaponQAV;
                    pPlayer.currentWeapon = DB.gPlayerInfo[j].currentWeapon;
                    pPlayer.weaponState = DB.gPlayerInfo[j].weaponState;
                    pPlayer.weaponAmmo = DB.gPlayerInfo[j].weaponAmmo;
                    pPlayer.weaponCallback = DB.gPlayerInfo[j].weaponCallback;
                    pPlayer.fLoopQAV = DB.gPlayerInfo[j].fLoopQAV;
                    pPlayer.weaponTimer = DB.gPlayerInfo[j].weaponTimer;
                    pPlayer.updateWeapon = DB.gPlayerInfo[j].updateWeapon;
                    pPlayer.LastWeapon = DB.gPlayerInfo[j].LastWeapon;
                    for (i3 = 0; i3 < 49; ++i3) {
                        int nPowerUp = i3 + 100;
                        if (!Main.cfg.gVanilla && (nPowerUp == 114 || nPowerUp == 119 || nPowerUp == 139 || nPowerUp == 112 || nPowerUp == 113 || nPowerUp == 116 || nPowerUp == 120 || nPowerUp == 122 || nPowerUp == 123 || nPowerUp == 124 || nPowerUp == 126 || nPowerUp == 127 || nPowerUp == 128 || nPowerUp == 129 || nPowerUp == 130 || nPowerUp == 131 || nPowerUp == 117)) continue;
                        pPlayer.powerUpTimer[i3] = DB.gPlayerInfo[j].powerUpTimer[i3];
                    }
                    if (!Main.cfg.gVanilla && pPlayer.currentWeapon == 3) {
                        pPlayer.weaponState = Globals.gInfiniteAmmo || pPlayer.ammoCount[2] > 1 ? 3 : 2;
                    }
                    if (Globals.pGameInfo.nGameType == 0 && Globals.pGameInfo.nPitchforkOnly) {
                        for (i3 = 0; i3 < 14; ++i3) {
                            pPlayer.weaponMode[i3] = 0;
                        }
                        pPlayer.hasWeapon[1] = true;
                        pPlayer.LastWeapon = 0;
                        pPlayer.currentWeapon = 0;
                        pPlayer.weaponCallback = -1;
                        pPlayer.pInput.newWeapon = 1;
                        for (i3 = 0; i3 < 14; ++i3) {
                            pPlayer.weaponOrder[0][i3] = Weapon.defaultOrder[i3];
                            pPlayer.weaponOrder[1][i3] = Weapon.defaultOrder[i3];
                        }
                        for (i3 = 0; i3 < 12; ++i3) {
                            pPlayer.ammoCount[i3] = 0;
                        }
                        pPlayer.weaponTimer = 0;
                        pPlayer.weaponState = 0;
                        pPlayer.pWeaponQAV = -1;
                        pPlayer.fLoopQAV = false;
                    }
                    j = Mmulti.connectpoint2[j];
                }
            }
            Globals.pGameInfo.uGameFlags &= 0xFFFFFFFC;
            if (Globals.SplitScreen) {
                DB.InsertPlayer();
            }
            Mirror.InitMirrors();
            SOUND.setReverb(false, 0.0f);
            Globals.gFrame = 0;
            Globals.gFrameClock = 0;
            if (screen != Main.gDemoScreen) {
                View.gViewIndex = Mmulti.myconnectindex;
            }
            Trigger.trInit(board);
            SOUND.ambPrepare();
            SOUND.sndPlayMusic();
            Console.out.println("debug: end prepareboard()", OsdColor.BLUE);
            return true;
        }
        catch (Exception e) {
            Console.out.println("Load map exception: " + e);
            if (e.getMessage() != null) {
                Main.game.GameMessage("Load map exception:\n" + e.getMessage());
            } else {
                Main.game.GameMessage("Can't load the map " + Globals.pGameInfo.zLevelName);
            }
            return false;
        }
    }

    private static ZONE getStartZone(BuildPos pos, int z) {
        ZONE zone = new ZONE();
        zone.x = pos.getX();
        zone.y = pos.getY();
        zone.z = z;
        zone.sector = pos.getSectnum();
        zone.angle = pos.getAng();
        return zone;
    }

    public static BloodBoard dbLoadMap(Entry entry) throws WarningException {
        if (!entry.exists()) {
            throw new WarningException("Error opening map file \"" + entry.getName() + "\"");
        }
        return (BloodBoard)Main.engine.loadboard(entry);
    }

    public static int dbInsertXSector(Sector sector, int nSector) {
        int nXSector = DB.RemoveFree(nextXSector);
        if (nXSector == 0) {
            System.err.println("Out of free XSectors");
        }
        xsector[nXSector].free();
        sector.setExtra((short)nXSector);
        DB.xsector[nXSector].reference = nSector;
        return nXSector;
    }

    public static void dbDeleteXSector(int nXSector) {
        if (DB.xsector[nXSector].reference < 0) {
            throw new AssertException("xsector[nXSector].reference >= 0");
        }
        DB.InsertFree(nextXSector, nXSector);
        Main.boardService.getSector(DB.xsector[nXSector].reference).setExtra(-1);
        DB.xsector[nXSector].reference = -1;
    }

    public static void InsertFree(int[] next, int n) {
        next[n] = next[0];
        next[0] = n;
    }

    public static void InitFreeList(int[] xlist, int xlistSize) {
        for (int i = 1; i < xlistSize; ++i) {
            xlist[i] = i - 1;
        }
        xlist[0] = xlistSize - 1;
    }

    public static int RemoveFree(int[] next) {
        int n = next[0];
        next[0] = next[n];
        return n;
    }

    public static void InsertPlayer() {
        if (Mmulti.numplayers < 8) {
            Mmulti.connectpoint2[Mmulti.numplayers - 1] = Mmulti.numplayers;
            Mmulti.connectpoint2[Mmulti.numplayers] = -1;
            Main.game.pNet.gNetFifoHead[Mmulti.numplayers] = Main.game.pNet.gNetFifoHead[0];
            PLAYER.playerInit(Mmulti.numplayers, false);
            PLAYER.playerReset(Mmulti.numplayers);
            Globals.gPlayer[Mmulti.numplayers].pDudeInfo = DudeInfo.dudeInfo[Globals.gPlayer[Mmulti.numplayers].pSprite.getLotag() - 200];
            Globals.gPlayer[Mmulti.numplayers].pSprite = Main.boardService.getSprite(Globals.gPlayer[Mmulti.numplayers].nSprite);
            Globals.gPlayer[Mmulti.numplayers].pXsprite = Main.boardService.getXSprite(Globals.gPlayer[Mmulti.numplayers].pSprite.getExtra());
            View.gViewIndex = Mmulti.numplayers;
            Globals.gMe = Globals.gPlayer[View.gViewIndex];
            Mmulti.numplayers = (short)(Mmulti.numplayers + 1);
        }
    }

    public static void DeletePlayer() {
        if (Mmulti.numplayers > 1) {
            Mmulti.numplayers = (short)(Mmulti.numplayers - 1);
            Mmulti.connectpoint2[Mmulti.numplayers - 1] = -1;
            Main.engine.deletesprite((short)Globals.gPlayer[Mmulti.numplayers].nSprite);
            if (View.gViewIndex >= Mmulti.numplayers) {
                View.gViewIndex = 0;
                Globals.gMe = Globals.gPlayer[View.gViewIndex];
            }
        }
    }
}

