/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import java.util.List;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.BPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.IPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.JPriorityQueue;
import ru.m210projects.Blood.RXBUCKET;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class EVENT {
    public static final int kMaxChannels = 4096;
    public static final int kMaxID = 1024;
    public static final int kCommandOff = 0;
    public static final int kCommandOn = 1;
    public static final int kCommandState = 2;
    public static final int kCommandToggle = 3;
    public static final int kCommandNotState = 4;
    public static final int kCommandLink = 5;
    public static final int kCommandLock = 6;
    public static final int kCommandUnlock = 7;
    public static final int kCommandToggleLock = 8;
    public static final int kCommandStopOff = 9;
    public static final int kCommandStopOn = 10;
    public static final int kCommandStopNext = 11;
    public static final int kCommandCounter = 12;
    public static final int kCommandRespawn = 21;
    public static final int kCommandCallback = 20;
    public static final int kCallbackRespawn = 9;
    public static final int kCommandSpritePush = 30;
    public static final int kCommandSpriteImpact = 31;
    public static final int kCommandSpritePickup = 32;
    public static final int kCommandSpriteTouch = 33;
    public static final int kCommandSpriteSight = 34;
    public static final int kCommandSpriteProximity = 35;
    public static final int kCommandSpriteExplode = 36;
    public static final int kCommandSectorPush = 40;
    public static final int kCommandSectorImpact = 41;
    public static final int kCommandSectorEnter = 42;
    public static final int kCommandSectorExit = 43;
    public static final int kCommandWallPush = 50;
    public static final int kCommandWallImpact = 51;
    public static final int kCommandWallTouch = 52;
    public static final int kGDXCommandPaste = 53;
    public static final int kCommandNumbered = 64;
    public static final int kChannelNull = 0;
    public static final int kChannelSetupSecret = 1;
    public static final int kChannelSecret = 2;
    public static final int kChannelTextOver = 3;
    public static final int kChannelEndLevelA = 4;
    public static final int kChannelEndLevelB = 5;
    public static final int kGDXChannelEndLevel = 6;
    public static final int kChannelTriggerStart = 7;
    public static final int kChannelTriggerMatch = 8;
    public static final int kChannelTriggerCoop = 9;
    public static final int kChannelTriggerTeam = 10;
    public static final int kChannelTeamADeath = 15;
    public static final int kChannelTeamBDeath = 16;
    public static final int kChannelFlag0Captured = 80;
    public static final int kChannelFlag1Captured = 81;
    public static final int kChannelRemoteFire1 = 90;
    public static final int kChannelRemoteFire2 = 91;
    public static final int kChannelRemoteFire3 = 92;
    public static final int kChannelRemoteFire4 = 93;
    public static final int kChannelRemoteFire5 = 94;
    public static final int kChannelRemoteFire6 = 95;
    public static final int kChannelRemoteFire7 = 96;
    public static final int kChannelRemoteFire8 = 97;
    public static final int kUserChannelStart = 100;
    public static final int kPQueueSize = 1024;
    public static final int kCallbackMax = 25;
    public static RXBUCKET[] rxBucket = new RXBUCKET[4096];
    public static short[] bucketHead = new short[1025];
    public static IPriorityQueue eventQ;
    public static final CALLPROC[] gCallback;
    public static BPriorityQueue origEventQ;
    public static JPriorityQueue gdxEventQ;

    public static void makeMissileBlocking(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        pSprite.setCstat(pSprite.getCstat() | 1);
    }

    public static void UniMissileBurstCallback(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int nAngle = EngineUtils.getAngle((int)pSprite.getVelocityX(), (int)pSprite.getVelocityY());
        int nVel = 349525;
        for (int i = 0; i < 8; ++i) {
            BloodSprite pBurst = Actor.actCloneSprite(pSprite, 5);
            pBurst.setLotag(pSprite.getLotag());
            pBurst.setShade(pSprite.getShade());
            pBurst.setPicnum(pSprite.getPicnum());
            pBurst.setCstat(pSprite.getCstat());
            if ((pBurst.getCstat() & 1) != 0) {
                pBurst.setCstat(pBurst.getCstat() & 0xFFFFFFFE);
                EVENT.evPostCallback(pBurst.getXvel(), 3, 100L, 24);
            }
            pBurst.setPal(pSprite.getPal());
            pBurst.setXrepeat((short)(pSprite.getXrepeat() / 2));
            pBurst.setYrepeat((short)(pSprite.getYrepeat() / 2));
            pBurst.setClipdist(pSprite.getClipdist() / 2);
            pBurst.setHitag(pSprite.getHitag());
            pBurst.setAng((short)(pSprite.getAng() + Actor.gMissileData[pSprite.getLotag() - 300].angleOfs & 0x7FF));
            pBurst.setOwner(pSprite.getOwner());
            Actor.actBuildMissile(pBurst, pBurst.getExtra(), pSprite);
            int dxVel = 0;
            int dyVel = Pragmas.mulscaler(nVel, Trig.Sin(i * 2048 / 8), 30);
            int dzVel = Pragmas.mulscaler(nVel, -Trig.Cos(i * 2048 / 8), 30);
            if ((i & 1) != 0) {
                dyVel >>= 1;
                dzVel >>= 1;
            }
            Trig.RotateVector(dxVel, dyVel, nAngle);
            pBurst.addVelocity((int)Trig.rotated.x, (int)Trig.rotated.y, dzVel);
            EVENT.evPostCallback(pBurst.getXvel(), 3, 960L, 1);
        }
        EVENT.evPostCallback(nSprite, 3, 0L, 1);
    }

    public static XSPRITE getNextIncarnation(XSPRITE pXSprite) {
        if (pXSprite.getTxID() <= 0) {
            return null;
        }
        for (int i = bucketHead[pXSprite.getTxID()]; i < bucketHead[pXSprite.getTxID() + 1]; ++i) {
            BloodSprite pSprite;
            if (EVENT.rxBucket[i].type != 3 || !Actor.IsDudeSprite(pSprite = Main.boardService.getSprite(EVENT.rxBucket[i].index)) || pSprite.getStatnum() != 7) continue;
            return Main.boardService.getXSprite(pSprite.getExtra());
        }
        return null;
    }

    public static void gdxFragLimitCallback(int nIndex) {
        LEVELS.levelEndLevel(0);
    }

    public static void FlagCaptureCallback(int nIndex) {
        BloodSprite pFlag = Main.boardService.getSprite(nIndex);
        if (pFlag == null) {
            throw new AssertException("nSprite != null");
        }
        if (pFlag.getOwner() >= 0 && pFlag.getOwner() < 4096) {
            BloodSprite pOwner = Main.boardService.getSprite(pFlag.getOwner());
            short type = pFlag.getLotag();
            XSPRITE pXBase = Main.boardService.getXSprite(pOwner.getExtra());
            if (type == 147) {
                Trigger.trTriggerSprite(pOwner.getXvel(), pXBase, 1);
                SOUND.sndStartSample(8003, 255, 2, false);
                View.viewSetMessage("Blue Flag returned to base.", -1, 10);
            }
            if (type == 148) {
                Trigger.trTriggerSprite(pOwner.getXvel(), pXBase, 1);
                SOUND.sndStartSample(8002, 255, 2, false);
                View.viewSetMessage("Red Flag returned to base.", -1, 7);
            }
        }
        EVENT.evPostCallback(nIndex, 3, 0L, 1);
    }

    public static void SpawnSmoke(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite.getVelocityZ() != 0L) {
            int radius = Main.engine.getTile(pSprite.getPicnum()).getWidth() / 2 * pSprite.getXrepeat() >> 2;
            BloodSprite pEffect = Actor.actSpawnEffect(7, pSprite.getSectnum(), pSprite.getX() + Pragmas.mulscale(radius, Trig.Cos(pSprite.getAng() - 512), 30), pSprite.getY() + Pragmas.mulscale(radius, Trig.Sin(pSprite.getAng() - 512), 30), pSprite.getZ(), 0);
            if (pEffect != null) {
                pEffect.setVelocity(pSprite.getVelocityX(), pSprite.getVelocityY(), pSprite.getVelocityZ());
            }
        }
        if (DemoUtils.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 12L, 8);
        }
    }

    public static void KillSpriteCallback(int nIndex) {
        EVENT.checkEventList(nIndex, 3);
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        short nXSprite = pSprite.getExtra();
        if (nXSprite >= 0) {
            SeqHandling.seqKill(3, nXSprite);
        }
        SOUND.sfxKill3DSound(pSprite, -1, -1);
        Main.engine.deletesprite(nIndex);
    }

    public static void FlareFireEffect(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        BloodSprite pEffect = Actor.actSpawnEffect(28, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
        if (pEffect != null) {
            pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityY() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityZ() - (long)Gameutils.Random(109226));
        }
        EVENT.evPostCallback(nIndex, 3, 4L, 3);
    }

    public static void FlareFireEffect2(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        BloodSprite pEffect = Actor.actSpawnEffect(28, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
        if (pEffect != null) {
            pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityY() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityZ() - (long)Gameutils.Random(109226));
        }
        EVENT.evPostCallback(nIndex, 3, 12L, 4);
    }

    public static void AltTeslaEffect(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        BloodSprite pEffect = Actor.actSpawnEffect(49, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
        if (pEffect != null) {
            pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityY() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityZ() - (long)Gameutils.Random(109226));
        }
        if (DemoUtils.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 3L, 15);
        }
    }

    public static void FatalityCallback(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (PLAYER.checkPlayerSeq(Globals.gPlayer[pSprite.getLotag() - 231], VERSION.getPlayerSeq(12)) && pXSprite.getTarget() == Globals.gMe.nSprite) {
            SOUND.sndStartSample(3313, -1, 2, false);
        }
    }

    public static void WaterBubblesCallback(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        Gameutils.GetSpriteExtents(pSprite);
        int i = 0;
        while ((long)i < Pragmas.klabs(pSprite.getVelocityZ()) >> 18) {
            int radius = pSprite.getXrepeat() * (Main.engine.getTile(pSprite.getPicnum()).getWidth() / 2) >> 2;
            int nAngle = Gameutils.Random(2048);
            int dx = Pragmas.mulscale(Trig.Cos(nAngle), radius, 30);
            int dy = Pragmas.mulscale(Trig.Sin(nAngle), radius, 30);
            int range = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
            BloodSprite pEffect = Actor.actSpawnEffect(Gameutils.Random(3) + 23, pSprite.getSectnum(), pSprite.getX() + dx, pSprite.getY() + dy, range, 0);
            if (pEffect != null) {
                pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityY() + (long)Gameutils.BiRandom(109226), pSprite.getVelocityZ() + (long)Gameutils.BiRandom(109226));
            }
            ++i;
        }
        if (DemoUtils.IsOriginalDemo() || eventQ.getSize() < 768) {
            EVENT.evPostCallback(nIndex, 3, 4L, 11);
        }
    }

    private static void PlayerWaterBubblesCallback(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        if (Gameutils.IsPlayerSprite(pSprite)) {
            PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
            if (pPlayer == null) {
                throw new AssertException("pPlayer != NULL");
            }
            if (pPlayer.bubbleTime != 0) {
                Gameutils.GetSpriteExtents(pSprite);
                for (int i = 0; i < pPlayer.bubbleTime >> 6; ++i) {
                    ArtEntry pic = Main.engine.getTile(pSprite.getPicnum());
                    int radius = pSprite.getXrepeat() * (pic.getWidth() / 2) >> 2;
                    int nAngle = Gameutils.Random(2048);
                    int dx = pSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), radius, 30);
                    int dy = pSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), radius, 30);
                    int range = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
                    BloodSprite pEffect = Actor.actSpawnEffect(Gameutils.Random(3) + 23, pSprite.getSectnum(), dx, dy, range, 0);
                    if (pEffect == null) continue;
                    pEffect.setVelocity((long)Gameutils.BiRandom(109226) + pSprite.getVelocityX(), (long)Gameutils.BiRandom(109226) + pSprite.getVelocityY(), (long)Gameutils.BiRandom(109226) + pSprite.getVelocityZ());
                }
                EVENT.evPostCallback(nSprite, 3, 4L, 10);
            }
        }
    }

    public static void LeechSparks(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        BloodSprite pEffect = Actor.actSpawnEffect(15, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
        if (pEffect != null) {
            pEffect.setVelocity((long)Gameutils.BiRandom(65536) + pSprite.getVelocityX(), (long)Gameutils.BiRandom(65536) + pSprite.getVelocityY(), pSprite.getVelocityZ() - (long)Gameutils.Random(109226));
        }
        EVENT.evPostCallback(nIndex, 3, 3L, 7);
    }

    public static void RespawnCallback(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        if (pSprite.getStatnum() != 8 && pSprite.getStatnum() != 4) {
            Console.out.println("Sprite " + nSprite + " is not on Respawn list", OsdColor.RED);
        }
        if ((pSprite.getHitag() & 0x10) == 0) {
            Console.out.println("Sprite " + nSprite + " does not have the respawn attribute", OsdColor.RED);
        }
        int respawnTime = 0;
        switch (pXSprite.getRespawnPending()) {
            case 1: {
                respawnTime = Pragmas.mulscale(Actor.actGetRespawnTime(pSprite), 16384L, 16);
                pXSprite.setRespawnPending(2);
                EVENT.evPostCallback(nSprite, 3, Integer.toUnsignedLong(respawnTime), 9);
                return;
            }
            case 2: {
                respawnTime = Pragmas.mulscale(Actor.actGetRespawnTime(pSprite), 8192L, 16);
                pXSprite.setRespawnPending(3);
                EVENT.evPostCallback(nSprite, 3, Integer.toUnsignedLong(respawnTime), 9);
                return;
            }
            case 3: {
                if (pSprite.getOwner() == 8) {
                    throw new AssertException("pSprite.owner != kStatRespawn");
                }
                Main.engine.changespritestat(nSprite, pSprite.getOwner());
                pSprite.setOwner(-1);
                pSprite.setLotag(pSprite.getZvel());
                pSprite.setHitag(pSprite.getHitag() & 0xFFFFFFEF);
                pSprite.setVelocity(0L, 0L, 0L);
                pXSprite.setRespawnPending(0);
                pXSprite.setTriggered(false);
                pXSprite.setBurnTime(0);
                if (Actor.IsDudeSprite(pSprite)) {
                    pXSprite.setKey(0);
                    Vector3 kSprite = pSprite.getKSprite();
                    pSprite.setX((int)kSprite.x);
                    pSprite.setY((int)kSprite.y);
                    pSprite.setZ((int)kSprite.z);
                    pSprite.setCstat(pSprite.getCstat() | 0x1101);
                    short nType = pSprite.getLotag();
                    pSprite.setClipdist(DudeInfo.dudeInfo[nType - 200].clipdist);
                    pXSprite.setHealth(DudeInfo.dudeInfo[nType - 200].startHealth << 4);
                    if (Main.game.getCache().contains(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, "SEQ")) {
                        SeqHandling.seqSpawn(DudeInfo.dudeInfo[nType - 200].seqStartID + 0, 3, pSprite.getExtra(), null);
                    }
                    Ai.aiInit(pSprite, DemoUtils.IsOriginalDemo());
                }
                if (pSprite.getLotag() == 400) {
                    pSprite.setCstat(pSprite.getCstat() | 0x101);
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFF7FFF);
                }
                Actor.actSpawnEffect(29, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
                SOUND.sfxStart3DSound(pSprite, 350, -1, 0);
                return;
            }
        }
        Console.out.println("Unexpected respawnPending value = " + pXSprite.getRespawn());
    }

    public static void ZombieOverHead(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        Gameutils.GetSpriteExtents(pSprite);
        BloodSprite pEffect = Actor.actSpawnEffect(27, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), Gameutils.extents_zTop, 0);
        if (pEffect != null) {
            pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(69905), pSprite.getVelocityY() + (long)Gameutils.BiRandom(69905), pSprite.getVelocityZ() - 436906L);
        }
        if (pXSprite.getData1() <= 0) {
            if (pXSprite.getData2() > 0) {
                EVENT.evPostCallback(nSprite, 3, 60L, 5);
                pXSprite.setData1(40);
                pXSprite.setData2(pXSprite.getData2() - 1);
            }
        } else {
            EVENT.evPostCallback(nSprite, 3, 4L, 5);
            pXSprite.setData1(pXSprite.getData1() - Globals.kFrameTicks);
        }
    }

    public static void FireEffect(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        Gameutils.GetSpriteExtents(pSprite);
        for (int i = 0; i < 3; ++i) {
            int size = pSprite.getXrepeat() * (Main.engine.getTile(pSprite.getPicnum()).getWidth() / 2) >> 3;
            int nAngle = Gameutils.Random(2048);
            int dx = Pragmas.mulscale(Trig.Cos(nAngle), size, 30);
            int dy = Pragmas.mulscale(Trig.Sin(nAngle), size, 30);
            BloodSprite pEffect = Actor.actSpawnEffect(32, pSprite.getSectnum(), pSprite.getX() + dx, pSprite.getY() + dy, Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop), 0);
            if (pEffect == null) continue;
            pEffect.setVelocity(pSprite.getVelocityX() + (long)Gameutils.BiRandom(-dx), pSprite.getVelocityY() + (long)Gameutils.BiRandom(-dy), pSprite.getVelocityZ() - (long)Gameutils.Random(109226));
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite != null && pXSprite.getBurnTime() != 0) {
            EVENT.evPostCallback(nSprite, 3, 5L, 0);
        }
    }

    public static void FlareStarburstCallback(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        int nAngle = EngineUtils.getAngle((int)pSprite.getVelocityX(), (int)pSprite.getVelocityY());
        int nVel = 349525;
        for (int i = 0; i < 8; ++i) {
            BloodSprite pBurst = Actor.actCloneSprite(pSprite, 5);
            pBurst.setPicnum(2424);
            pBurst.setShade(-128);
            pBurst.setYrepeat(32);
            pBurst.setLotag(303);
            pBurst.setClipdist(2);
            pBurst.setOwner(pSprite.getOwner());
            pBurst.setXrepeat(pBurst.getYrepeat());
            int dxVel = 0;
            int dyVel = Pragmas.mulscaler(nVel, Trig.Sin(i * 2048 / 8), 30);
            int dzVel = Pragmas.mulscaler(nVel, -Trig.Cos(i * 2048 / 8), 30);
            if ((i & 1) != 0) {
                dyVel >>= 1;
                dzVel >>= 1;
            }
            Trig.RotateVector(dxVel, dyVel, nAngle);
            pBurst.addVelocity((int)Trig.rotated.x, (int)Trig.rotated.y, dzVel);
            EVENT.evPostCallback(pBurst.getXvel(), 3, 960L, 1);
        }
        EVENT.evPostCallback(nSprite, 3, 0L, 1);
    }

    public static void BulletFloor(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        Gameutils.GetZRange(pSprite, pSprite.getClipdist(), 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.setZ(pSprite.getZ() + (Gameutils.gz_floorZ - Gameutils.extents_zBot));
        int velocity = (int)(pSprite.getVelocityZ() - Actor.floorVel[pSprite.getSectnum()]);
        if (velocity <= 0) {
            if (pSprite.getVelocityZ() != 0L) {
                return;
            }
            EVENT.updateBullet(pSprite);
            return;
        }
        Actor.GravityVector(pSprite.getVelocityX(), pSprite.getVelocityY(), velocity, pSprite.getSectnum(), 36864);
        pSprite.setVelocity(Actor.refl_x, Actor.refl_y, Actor.refl_z);
        if (Actor.floorVel[pSprite.getSectnum()] == 0L && Pragmas.klabs(pSprite.getVelocityZ()) < 131072L) {
            EVENT.updateBullet(pSprite);
            return;
        }
        int nChannel = (pSprite.getXvel() & 2) + 28;
        if (!DemoUtils.IsOriginalDemo()) {
            pSprite.setAng((short)(pSprite.getAng() + Gameutils.vRandom() & 0x7FF));
        }
        if (pSprite.getLotag() < 37 || pSprite.getLotag() > 39) {
            int snd = 612;
            if (Gameutils.Chance(16384)) {
                snd = 610;
            }
            SOUND.sfxStart3DSound(pSprite, snd, nChannel, 1);
        } else {
            Gameutils.bRandom();
            SOUND.sfxStart3DSound(pSprite, Gameutils.Random(2) + 608, nChannel, 1);
        }
    }

    public static void updateBullet(BloodSprite pSprite) {
        pSprite.setVelocity(0L, 0L, 0L);
        short nXSprite = pSprite.getExtra();
        if (nXSprite >= 0) {
            SeqHandling.seqKill(3, nXSprite);
        }
        SOUND.sfxKill3DSound(pSprite, -1, -1);
        if (pSprite.getLotag() < 37 || pSprite.getLotag() > 39) {
            pSprite.setPicnum(2464);
        } else {
            pSprite.setPicnum(2465);
        }
        pSprite.setLotag(51);
        pSprite.setYrepeat(10);
        pSprite.setXrepeat(pSprite.getYrepeat());
    }

    public static void BloodSplat(int nIndex) {
        BloodSprite pSpawn;
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        Gameutils.GetZRange(pSprite, pSprite.getClipdist(), 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.setZ(pSprite.getZ() + (Gameutils.gz_floorZ - Gameutils.extents_zBot));
        int nAngle = Gameutils.Random(2048);
        int Dist = Gameutils.Random(16) << 4;
        int x = pSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), Dist, 28);
        int y = pSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), Dist, 28);
        Actor.actSpawnEffect(48, pSprite.getSectnum(), x, y, pSprite.getZ(), 0);
        if (pSprite.getAng() == 1024) {
            int nChannel = (pSprite.getXvel() & 2) + 28;
            if (nChannel >= 32) {
                throw new AssertException("nChannel < 32");
            }
            SOUND.sfxStart3DSound(pSprite, 385, nChannel, 1);
        }
        if (Gameutils.Chance(10240) && (pSpawn = Actor.actSpawnEffect(36, pSprite.getSectnum(), x, y, Gameutils.gz_floorZ - 64, 0)) != null) {
            if (!DemoUtils.IsOriginalDemo() && pSprite.getSectnum() != pSpawn.getSectnum()) {
                pSpawn.setZ(Main.engine.getflorzofslope(pSpawn.getSectnum(), x, y) - 64);
            }
            pSpawn.setAng((short)nAngle);
        }
        Actor.actDeleteEffect2(nIndex);
    }

    public static void PodBloodSplat(int nIndex) {
        BloodSprite pSpawn;
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        Gameutils.GetZRange(pSprite, pSprite.getClipdist(), 65537);
        Gameutils.GetSpriteExtents(pSprite);
        pSprite.setZ(pSprite.getZ() + (Gameutils.gz_floorZ - Gameutils.extents_zBot));
        int nAngle = Gameutils.Random(2048);
        int Dist = Gameutils.Random(16) << 4;
        int x = pSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), Dist, 28);
        int y = pSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), Dist, 28);
        if (pSprite.getAng() == 1024 && pSprite.getLotag() == 53) {
            int nChannel = (pSprite.getXvel() & 2) + 28;
            SOUND.sfxStart3DSound(pSprite, 385, nChannel, 1);
        }
        if (pSprite.getLotag() != 53 && pSprite.getLotag() != 430) {
            BloodSprite pSpawn2 = Actor.actSpawnEffect(32, pSprite.getSectnum(), x, y, Gameutils.gz_floorZ - 64, 0);
            if (pSpawn2 != null) {
                if (pSprite.getSectnum() != pSpawn2.getSectnum()) {
                    pSpawn2.setZ(Main.engine.getflorzofslope(pSpawn2.getSectnum(), x, y) - 64);
                }
                pSpawn2.setAng((short)nAngle);
            }
        } else if ((Gameutils.Chance(640) || pSprite.getLotag() == 430) && (pSpawn = Actor.actSpawnEffect(55, pSprite.getSectnum(), x, y, Gameutils.gz_floorZ - 64, 0)) != null) {
            if (pSprite.getSectnum() != pSpawn.getSectnum()) {
                pSpawn.setZ(Main.engine.getflorzofslope(pSpawn.getSectnum(), x, y) - 64);
            }
            pSpawn.setAng((short)nAngle);
        }
        Actor.actDeleteEffect2(nIndex);
    }

    private static void LeechCallback(int nIndex) {
        BloodSprite pSprite = Main.boardService.getSprite(nIndex);
        if (pSprite.getStatnum() == 4 && (pSprite.getHitag() & 0x20) == 0) {
            switch (pSprite.getLotag()) {
                case 431: 
                case 435: {
                    Main.boardService.getXSprite(pSprite.getExtra()).setStateTimer(0);
                }
            }
        }
    }

    public static void CounterCheck(int nSector) {
        if (!Main.boardService.isValidSector(nSector)) {
            throw new AssertException("boardService.isValidSector(nSector)");
        }
        Sector pSector = Main.boardService.getSector(nSector);
        short nXSector = pSector.getExtra();
        if (nXSector > 0) {
            XSECTOR pXSector = DB.xsector[nXSector];
            int data = pXSector.data;
            int waitTime = pXSector.waitTime[1];
            if (data != 0 && waitTime != 0) {
                int cnt = 0;
                for (ListNode<Sprite> node = Main.boardService.getSectNode(nSector); node != null; node = node.getNext()) {
                    if (node.get().getLotag() != data) continue;
                    ++cnt;
                }
                if (cnt < waitTime) {
                    EVENT.evPostCallback(nSector, 6, 5L, 12);
                } else {
                    Trigger.trTriggerSector(nSector, pXSector, 1);
                    pXSector.locked = 1;
                }
            }
        }
    }

    public static void BloodTrail(int nSprite) {
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite == null) {
            throw new AssertException("nSprite != null");
        }
        BloodSprite pEffect = Actor.actSpawnEffect(27, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0);
        if (pEffect != null) {
            pEffect.setAng(0);
            pEffect.setVelocity(pSprite.getVelocityX() >> 8, pSprite.getVelocityY() >> 8, pSprite.getVelocityZ() >> 8);
        }
        EVENT.evPostCallback(nSprite, 3, 6L, 6);
    }

    public static void PodBloodTrail(int nSprite) {
        BloodSprite pEffect;
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int type = 53;
        if (pSprite.getLotag() != 53) {
            type = 54;
        }
        if ((pEffect = Actor.actSpawnEffect(type, pSprite.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ(), 0)) != null) {
            pEffect.setAng(0);
            pEffect.setVelocity(pSprite.getVelocityX() >> 8, pSprite.getVelocityY() >> 8, pSprite.getVelocityZ() >> 8);
        }
        EVENT.evPostCallback(nSprite, 3, 6L, 18);
    }

    public static int getEvent(int index, int type, int command, int funcId) {
        return index & 0x1FFF | (type & 7) << 13 | command << 16 | funcId << 24;
    }

    public static int getIndex(int event) {
        return event & 0x1FFF;
    }

    public static int getType(int event) {
        return (event & 0xE000) >> 13;
    }

    public static int getCommand(int event) {
        return (event & 0xFF0000) >> 16;
    }

    public static int getFuncID(int event) {
        return event >> 24;
    }

    static int GetBucketChannel(RXBUCKET pBucket) {
        switch (pBucket.type) {
            case 6: {
                short nXIndex = Main.boardService.getSector(pBucket.index).getExtra();
                if (nXIndex < 0) {
                    throw new AssertException("Sector nXIndex > 0");
                }
                return DB.xsector[nXIndex].rxID;
            }
            case 0: {
                short nXIndex = Main.boardService.getWall(pBucket.index).getExtra();
                if (nXIndex < 0) {
                    throw new AssertException("Wall nXIndex > 0");
                }
                return DB.xwall[nXIndex].rxID;
            }
            case 3: {
                short nXIndex = Main.boardService.getSprite(pBucket.index).getExtra();
                if (nXIndex < 0) {
                    throw new AssertException("Sprite nXIndex >= 0");
                }
                return Main.boardService.getXSprite(nXIndex).getRxID();
            }
        }
        Console.out.println("Unexpected rxBucket type " + pBucket.type, OsdColor.RED);
        return 0;
    }

    public static int CompareChannels(RXBUCKET ref1, RXBUCKET ref2) {
        return EVENT.GetBucketChannel(ref1) - EVENT.GetBucketChannel(ref2);
    }

    public static void eventQueryInit(boolean isOriginal) {
        if (origEventQ == null) {
            origEventQ = new BPriorityQueue(1024);
        }
        if (gdxEventQ == null) {
            gdxEventQ = new JPriorityQueue(1024);
        }
        eventQ = isOriginal ? origEventQ : gdxEventQ;
    }

    public static void evInit(Board board, boolean isOriginal) {
        int i;
        int i2;
        EVENT.eventQueryInit(isOriginal);
        for (int i3 = 0; i3 < 4096; ++i3) {
            if (rxBucket[i3] == null) {
                EVENT.rxBucket[i3] = new RXBUCKET();
                continue;
            }
            rxBucket[i3].flush();
        }
        eventQ.flush();
        int nCount = 0;
        for (i2 = 0; i2 < board.getSectorCount(); ++i2) {
            short nXSector;
            if (board.getSector(i2) == null || (nXSector = board.getSector(i2).getExtra()) <= 0 || DB.xsector[nXSector].rxID <= 0) continue;
            if (nCount >= 4096) {
                throw new AssertException("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 6;
            EVENT.rxBucket[nCount].index = i2;
            ++nCount;
        }
        for (i2 = 0; i2 < board.getWallCount(); ++i2) {
            short nXWall;
            if (board.getWall(i2) == null || (nXWall = board.getWall(i2).getExtra()) <= 0 || DB.xwall[nXWall].rxID <= 0) continue;
            if (nCount >= 4096) {
                throw new AssertException("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 0;
            EVENT.rxBucket[nCount].index = i2;
            ++nCount;
        }
        List<Sprite> sprites = board.getSprites();
        for (i = 0; i < sprites.size(); ++i) {
            short nXSprite;
            if (sprites.get(i).getStatnum() >= 1024 || (nXSprite = sprites.get(i).getExtra()) < 0 || Main.boardService.getXSprite(nXSprite).getRxID() <= 0) continue;
            if (nCount >= 4096) {
                throw new AssertException("nCount < kMaxChannels");
            }
            EVENT.rxBucket[nCount].type = 3;
            EVENT.rxBucket[nCount].index = i;
            ++nCount;
        }
        EVENT.qsort(nCount);
        int j = 0;
        for (i = 0; i < 1024; ++i) {
            EVENT.bucketHead[i] = (short)j;
            while (j < nCount && EVENT.GetBucketChannel(rxBucket[j]) == i) {
                ++j;
            }
        }
        EVENT.bucketHead[i] = (short)j;
    }

    public static boolean evGetSourceState(int type, int nIndex) {
        switch (type) {
            case 6: {
                short nXIndex = Main.boardService.getSector(nIndex).getExtra();
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXSectors");
                }
                return DB.xsector[nXIndex].state != 0;
            }
            case 0: {
                short nXIndex = Main.boardService.getWall(nIndex).getExtra();
                if (nXIndex <= 0 || nXIndex >= 512) {
                    throw new AssertException("nXIndex > 0 && nXIndex < kMaxXWalls");
                }
                return DB.xwall[nXIndex].state != 0;
            }
            case 3: {
                short nXIndex = Main.boardService.getSprite(nIndex).getExtra();
                return Main.boardService.getXSprite(nXIndex).getState() != 0;
            }
        }
        return false;
    }

    public static void evSend(int index, int type, int to, int command) {
        if (command == 2) {
            command = EVENT.evGetSourceState(type, index) ? 1 : 0;
        } else if (command == 4) {
            command = EVENT.evGetSourceState(type, index) ? 0 : 1;
        }
        int pEvent = EVENT.getEvent(index, type, command, 0);
        if (to > 0) {
            switch (to) {
                case 1: {
                    if (command < 64) {
                        Console.out.println("Invalid SetupSecret command by xobject " + index, OsdColor.RED);
                    }
                    LEVELS.levelSetupSecret(command - 64);
                    break;
                }
                case 2: {
                    if (command < 64) {
                        Console.out.println("Invalid Secret command by xobject " + index, OsdColor.RED);
                    }
                    LEVELS.levelCountSecret(command - 64);
                    break;
                }
                case 4: {
                    LEVELS.levelEndLevel(0);
                    return;
                }
                case 5: {
                    LEVELS.levelEndLevel(1);
                    return;
                }
                case 6: {
                    LEVELS.levelEndLevelCustom(command - 64);
                    return;
                }
                case 3: {
                    if (command < 64) {
                        Console.out.println("Invalid TextOver command by xobject " + index, OsdColor.RED);
                        View.viewSetMessage("Invalid TextOver command", -1, 7);
                        return;
                    }
                    Trigger.trTextOver(command - 64);
                    return;
                }
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
                        XSPRITE pXSprite;
                        int nSprite = node.getIndex();
                        Sprite pSprite = node.get();
                        if ((pSprite.getHitag() & 0x20) != 0 || (pXSprite = Main.boardService.getXSprite(pSprite.getExtra())) == null || pXSprite.getRxID() != to) continue;
                        Trigger.trMessageSprite(nSprite, pEvent);
                    }
                    return;
                }
                case 80: 
                case 81: {
                    for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
                        XSPRITE pXSprite;
                        int nSprite = node.getIndex();
                        Sprite pSprite = node.get();
                        if ((pSprite.getHitag() & 0x20) != 0 || (pXSprite = Main.boardService.getXSprite(pSprite.getExtra())) == null || pXSprite.getRxID() != to) continue;
                        Trigger.trMessageSprite(nSprite, pEvent);
                    }
                    return;
                }
            }
        }
        block17: for (int i = bucketHead[to]; i < bucketHead[to + 1]; ++i) {
            if (EVENT.rxBucket[i].type == EVENT.getType(pEvent) && EVENT.rxBucket[i].index == EVENT.getIndex(pEvent)) continue;
            switch (EVENT.rxBucket[i].type) {
                case 6: {
                    Trigger.trMessageSector(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
                case 0: {
                    Trigger.trMessageWall(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
                case 3: {
                    XSPRITE pXSprite;
                    BloodSprite pSprite = Main.boardService.getSprite(EVENT.rxBucket[i].index);
                    if ((pSprite.getHitag() & 0x20) != 0 || (pXSprite = Main.boardService.getXSprite(pSprite.getExtra())) == null || pXSprite.getRxID() == 0) continue block17;
                    Trigger.trMessageSprite(EVENT.rxBucket[i].index, pEvent);
                    continue block17;
                }
            }
        }
    }

    public static void checkEventList(int nIndex, int nType) {
        eventQ.checkList(nIndex, nType);
    }

    public static void checkEventList(int nIndex, int nType, int funcId) {
        eventQ.checkList(nIndex, nType, funcId);
    }

    public static void evPost(int index, int type, long time, int command) {
        if (command == 20) {
            throw new AssertException("command != kCommandCallback");
        }
        if (command == 2) {
            command = EVENT.evGetSourceState(type, index) ? 1 : 0;
        } else if (command == 4) {
            command = EVENT.evGetSourceState(type, index) ? 0 : 1;
        }
        int pEvent = EVENT.getEvent(index, type, command, 0);
        eventQ.Insert((long)Globals.gFrameClock + time, pEvent);
    }

    public static void evPostCallback(int index, int type, long time, int funcId) {
        int pEvent = EVENT.getEvent(index, type, 20, funcId);
        eventQ.Insert((long)Globals.gFrameClock + time, pEvent);
    }

    public static void evProcess(long time) {
        while (eventQ.Check(time)) {
            int event = eventQ.Remove();
            if (event == 0) continue;
            if (EVENT.getCommand(event) == 20) {
                int nFunc = EVENT.getFuncID(event);
                if (nFunc >= 25) {
                    throw new AssertException("event.funcID < kCallbackMax");
                }
                if (gCallback[nFunc] == null) {
                    throw new AssertException("gCallback[event.funcID] != null");
                }
                gCallback[nFunc].run(EVENT.getIndex(event));
                continue;
            }
            switch (EVENT.getType(event)) {
                case 6: {
                    Trigger.trMessageSector(EVENT.getIndex(event), event);
                    break;
                }
                case 0: {
                    Trigger.trMessageWall(EVENT.getIndex(event), event);
                    break;
                }
                case 3: {
                    Trigger.trMessageSprite(EVENT.getIndex(event), event);
                }
            }
        }
    }

    private static void qsort(int n) {
        int base = 0;
        int sp = 0;
        int[] base_stack = new int[32];
        int[] n_stack = new int[32];
        while (true) {
            block18: {
                block21: {
                    int r;
                    int s;
                    int pn;
                    block20: {
                        int i;
                        int pb;
                        int p2;
                        block19: {
                            if (n <= 1) break block18;
                            if (n >= 16) break block19;
                            for (int shell = 3; shell > 0; shell -= 2) {
                                for (int p1 = base + shell; p1 < base + n; p1 += shell) {
                                    for (p2 = p1; p2 > base && EVENT.CompareChannels(rxBucket[p2 - shell], rxBucket[p2]) > 0; p2 -= shell) {
                                        EVENT.swap(p2, p2 - shell);
                                    }
                                }
                            }
                            break block18;
                        }
                        int mid = base + (n >> 1);
                        if (n > 29) {
                            int p1 = base;
                            p2 = base + (n - 1);
                            if (n > 42) {
                                int s2 = n >> 3;
                                p1 = EVENT.med3(p1, p1 + s2, p1 + (s2 << 1));
                                mid = EVENT.med3(mid - s2, mid, mid + s2);
                                p2 = EVENT.med3(p2 - (s2 << 1), p2 - s2, p2);
                            }
                            mid = EVENT.med3(p1, mid, p2);
                        }
                        RXBUCKET pv = rxBucket[mid];
                        int pa = pb = base;
                        int pd = base + (n - 1);
                        int pc = base + (n - 1);
                        while (true) {
                            int comparison;
                            if (pb <= pc && (comparison = EVENT.CompareChannels(rxBucket[pb], pv)) <= 0) {
                                if (comparison == 0) {
                                    EVENT.swap(pa, pb);
                                    ++pa;
                                }
                                ++pb;
                                continue;
                            }
                            while (pb <= pc && (comparison = EVENT.CompareChannels(rxBucket[pc], pv)) >= 0) {
                                if (comparison == 0) {
                                    EVENT.swap(pc, pd);
                                    --pd;
                                }
                                --pc;
                            }
                            if (pb > pc) break;
                            EVENT.swap(pb, pc);
                            ++pb;
                            --pc;
                        }
                        pn = base + n;
                        s = Math.min(pa - base, pb - pa);
                        if (s > 0) {
                            for (i = 0; i < s; ++i) {
                                EVENT.swap(base + i, pb - s + i);
                            }
                        }
                        if ((s = Math.min(pd - pc, pn - pd - 1)) > 0) {
                            for (i = 0; i < s; ++i) {
                                EVENT.swap(pb + i, pn - s + i);
                            }
                        }
                        if ((s = pd - pc) < (r = pb - pa)) break block20;
                        base_stack[sp] = pn - s;
                        n_stack[sp] = s;
                        n = r;
                        break block21;
                    }
                    if (r <= 1) break block18;
                    base_stack[sp] = base;
                    n_stack[sp] = r;
                    base = pn - s;
                    n = s;
                }
                ++sp;
                continue;
            }
            if (sp-- == 0) break;
            base = base_stack[sp];
            n = n_stack[sp];
        }
    }

    private static void swap(int i, int j) {
        RXBUCKET temp = rxBucket[i];
        EVENT.rxBucket[i] = rxBucket[j];
        EVENT.rxBucket[j] = temp;
    }

    private static int med3(int a, int b, int c) {
        if (EVENT.CompareChannels(rxBucket[a], rxBucket[b]) > 0) {
            if (EVENT.CompareChannels(rxBucket[a], rxBucket[c]) > 0) {
                if (EVENT.CompareChannels(rxBucket[b], rxBucket[c]) > 0) {
                    return b;
                }
                return c;
            }
            return a;
        }
        if (EVENT.CompareChannels(rxBucket[a], rxBucket[c]) >= 0) {
            return a;
        }
        if (EVENT.CompareChannels(rxBucket[b], rxBucket[c]) > 0) {
            return c;
        }
        return b;
    }

    static {
        gCallback = new CALLPROC[]{EVENT::FireEffect, EVENT::KillSpriteCallback, EVENT::FlareStarburstCallback, EVENT::FlareFireEffect, EVENT::FlareFireEffect2, EVENT::ZombieOverHead, EVENT::BloodTrail, EVENT::LeechSparks, EVENT::SpawnSmoke, EVENT::RespawnCallback, EVENT::PlayerWaterBubblesCallback, EVENT::WaterBubblesCallback, EVENT::CounterCheck, EVENT::FatalityCallback, EVENT::BloodSplat, EVENT::AltTeslaEffect, EVENT::BulletFloor, EVENT::FlagCaptureCallback, EVENT::PodBloodTrail, EVENT::PodBloodSplat, EVENT::LeechCallback, nIndex -> {}, EVENT::gdxFragLimitCallback, EVENT::UniMissileBurstCallback, EVENT::makeMissileBlocking};
    }
}

