/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodBoard;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Factory.BloodXSpriteMap;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.Types.BloodSpriteMap;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.filehandlers.ChecksumInputStream;
import ru.m210projects.Blood.filehandlers.CryptedInputStream;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class BloodBoardService
extends BoardService {
    public static final String kBloodMapExt = "MAP";
    public static final String kBloodMapSig = "BLM\u001a";
    public static final int kBloodMapVersion6 = 1536;
    public static final int kBloodMapVersion7 = 1792;
    public static final int kMajorVersionMask = 65280;
    public static final int kMinorVersionMask = 255;
    private static final byte[] crypt = new byte[]{77, 97, 116, 116};
    private static final int key = LittleEndian.getInt(crypt);
    private BloodXSpriteMap xSpriteMap = new BloodXSpriteMap(new ArrayList<XSPRITE>());

    @Override
    protected Board loadBoard(Entry entry) throws IOException {
        ChecksumInputStream is = new ChecksumInputStream(entry.getInputStream());
        this.dbInit();
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(kBloodMapSig)) {
            throw new WarningException("Wrong signature! Perhaps not a Blood map or map file corrupted. Map signature: \"" + signature + "\" != " + kBloodMapSig);
        }
        boolean crypted = false;
        short version = StreamUtils.readShort(is);
        if ((version & 0xFF00) != 1536) {
            if ((version & 0xFF00) == 1792) {
                crypted = true;
            } else {
                throw new WarningException("Map file is wrong version 0x" + Integer.toHexString(version & 0xFF00));
            }
        }
        CryptedInputStream cis = new CryptedInputStream(is, key, 37);
        BuildPos startPos = new BuildPos(StreamUtils.readInt(cis), StreamUtils.readInt(cis), StreamUtils.readInt(cis), StreamUtils.readShort(cis), StreamUtils.readShort(cis));
        short pskybits = StreamUtils.readShort(cis);
        int gVisibility = StreamUtils.readInt(cis);
        int gSongId = StreamUtils.readInt(cis);
        byte parallaxtype = StreamUtils.readByte(cis);
        int gMapRev = StreamUtils.readInt(cis);
        short numsectors = StreamUtils.readShort(cis);
        short numwalls = StreamUtils.readShort(cis);
        int numSprites = StreamUtils.readShort(cis);
        int secrets = 0;
        if (numsectors >= 1024 || numwalls >= 8192 || numSprites >= 4096) {
            Console.out.println("Map limits of sectors, walls or sprites are overflow. Map version is wrong!", OsdColor.RED);
        }
        if (numsectors == 0 || numwalls == 0) {
            throw new WarningException("Empty map! (numsectors == 0 || numwalls == 0)\r\nor map file is corrupt");
        }
        int spr = 44;
        int xspr = 56;
        int xwal = 24;
        int xsec = 60;
        if (crypted) {
            cis = new CryptedInputStream(is, numwalls, 128);
            String copyright = StreamUtils.readString(cis, 64);
            xspr = StreamUtils.readInt(cis);
            xwal = StreamUtils.readInt(cis);
            xsec = StreamUtils.readInt(cis);
            StreamUtils.skip(cis, 52);
        } else {
            StreamUtils.skip(is, 128);
        }
        int gSkyCount = 1 << pskybits;
        short[] pskyoff = new short[gSkyCount];
        int length = pskyoff.length * 2;
        ByteBuffer.wrap(StreamUtils.readBytes((InputStream)new CryptedInputStream(is, length, length), length)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(pskyoff);
        long dec = (long)gMapRev * 40L;
        Mirror.MirrorSector = numsectors;
        Sector[] sectors = new Sector[numsectors + 1];
        for (int i = 0; i < sectors.length; ++i) {
            Sector sec = new Sector();
            if (i < numsectors) {
                cis = new CryptedInputStream(is, dec, 40);
                sec.setWallptr(StreamUtils.readShort(cis));
                sec.setWallnum(StreamUtils.readShort(cis));
                sec.setCeilingz(StreamUtils.readInt(cis));
                sec.setFloorz(StreamUtils.readInt(cis));
                sec.setCeilingstat(StreamUtils.readShort(cis));
                sec.setFloorstat(StreamUtils.readShort(cis));
                sec.setCeilingpicnum(StreamUtils.readShort(cis));
                sec.setCeilingheinum(StreamUtils.readShort(cis));
                sec.setCeilingshade(StreamUtils.readByte(cis));
                sec.setCeilingpal(StreamUtils.readByte(cis));
                sec.setCeilingxpanning(StreamUtils.readByte(cis));
                sec.setCeilingypanning(StreamUtils.readByte(cis));
                sec.setFloorpicnum(StreamUtils.readShort(cis));
                sec.setFloorheinum(StreamUtils.readShort(cis));
                sec.setFloorshade(StreamUtils.readByte(cis));
                sec.setFloorpal(StreamUtils.readByte(cis));
                sec.setFloorxpanning(StreamUtils.readByte(cis));
                sec.setFloorypanning(StreamUtils.readByte(cis));
                sec.setVisibility(StreamUtils.readByte(cis));
                sec.setFiller(StreamUtils.readByte(cis));
                sec.setLotag(StreamUtils.readShort(cis));
                sec.setHitag(StreamUtils.readShort(cis));
                sec.setExtra(StreamUtils.readShort(cis));
                if (sec.getExtra() > 0) {
                    XSECTOR pXSector = DB.xsector[DB.dbInsertXSector(sec, i)];
                    pXSector.init(StreamUtils.readBytes((InputStream)cis, xsec));
                    pXSector.reference = i;
                    pXSector.busy = pXSector.state << 16;
                    if (pXSector.txID == 2 && pXSector.command == 64) {
                        ++secrets;
                    }
                }
            } else {
                sec.setCeilingpicnum(504);
                sec.setFloorpicnum(504);
                sec.setWallnum(4);
                sec.setWallptr(numwalls);
            }
            sectors[i] = sec;
        }
        dec |= (long)key;
        Wall[] walls = new Wall[numwalls + 4];
        for (int i = 0; i < walls.length; ++i) {
            Wall wal = new Wall();
            if (i < numwalls) {
                cis = new CryptedInputStream(is, dec, 32);
                wal.setX(StreamUtils.readInt(cis));
                wal.setY(StreamUtils.readInt(cis));
                wal.setPoint2(StreamUtils.readShort(cis));
                wal.setNextwall(StreamUtils.readShort(cis));
                wal.setNextsector(StreamUtils.readShort(cis));
                wal.setCstat(StreamUtils.readShort(cis));
                wal.setPicnum(StreamUtils.readShort(cis));
                wal.setOverpicnum(StreamUtils.readShort(cis));
                wal.setShade(StreamUtils.readByte(cis));
                wal.setPal(StreamUtils.readByte(cis));
                wal.setXrepeat(StreamUtils.readByte(cis));
                wal.setYrepeat(StreamUtils.readByte(cis));
                wal.setXpanning(StreamUtils.readByte(cis));
                wal.setYpanning(StreamUtils.readByte(cis));
                wal.setLotag(StreamUtils.readShort(cis));
                wal.setHitag(StreamUtils.readShort(cis));
                wal.setExtra(StreamUtils.readShort(cis));
                if (wal.getExtra() > 0) {
                    XWALL pXWall = DB.xwall[this.dbInsertXWall(wal, i)];
                    pXWall.init(StreamUtils.readBytes((InputStream)cis, xwal));
                    pXWall.reference = i;
                    pXWall.busy = pXWall.state << 16;
                    if (pXWall.txID == 2 && pXWall.command == 64) {
                        ++secrets;
                    }
                }
            } else {
                Mirror.MirrorWall[i - numwalls] = i;
                wal.setPicnum(504);
                wal.setOverpicnum(504);
                wal.setCstat(0);
                wal.setNextsector(-1);
                wal.setNextwall(-1);
                if (i < numwalls + 3) {
                    wal.setPoint2(i + 1);
                } else {
                    wal.setPoint2(numwalls);
                }
            }
            walls[i] = wal;
        }
        dec = (long)gMapRev * (long)spr | (long)key;
        ArrayList<Sprite> sprites = new ArrayList<Sprite>(numSprites * 2);
        for (int i = 0; i < numSprites; ++i) {
            cis = new CryptedInputStream(is, dec, spr);
            BloodSprite s = new BloodSprite();
            s.setX(StreamUtils.readInt(cis));
            s.setY(StreamUtils.readInt(cis));
            s.setZ(StreamUtils.readInt(cis));
            s.setCstat(StreamUtils.readShort(cis));
            s.setPicnum(StreamUtils.readShort(cis));
            s.setShade(StreamUtils.readByte(cis));
            s.setPal(StreamUtils.readByte(cis));
            s.setClipdist(StreamUtils.readByte(cis));
            s.setDetail(StreamUtils.readByte(cis));
            s.setXrepeat(StreamUtils.readByte(cis));
            s.setYrepeat(StreamUtils.readByte(cis));
            s.setXoffset(StreamUtils.readByte(cis));
            s.setYoffset(StreamUtils.readByte(cis));
            s.setSectnum(StreamUtils.readShort(cis));
            s.setStatnum(StreamUtils.readShort(cis));
            s.setAng(StreamUtils.readShort(cis));
            s.setOwner(StreamUtils.readShort(cis));
            s.setXvel(StreamUtils.readShort(cis));
            s.setYvel(StreamUtils.readShort(cis));
            s.setZvel(StreamUtils.readShort(cis));
            s.setLotag(StreamUtils.readShort(cis));
            s.setHitag(StreamUtils.readShort(cis));
            s.setExtra(StreamUtils.readShort(cis));
            if (s.getExtra() > 0) {
                XSPRITE pXSprite = this.getXSprite(this.insertXSprite(s));
                pXSprite.init(StreamUtils.readBytes((InputStream)cis, xspr));
                pXSprite.setReference(i);
                pXSprite.setBusy(pXSprite.getState() << 16);
                if (!crypted) {
                    // empty if block
                }
                if (pXSprite.getTxID() == 2 && pXSprite.getCommand() == 64 && (1 << Globals.pGameInfo.nEnemyQuantity & pXSprite.getLSkill()) == 0 && (!pXSprite.islS() && Globals.pGameInfo.nGameType == 0 || !pXSprite.islB() && Globals.pGameInfo.nGameType == 2 || !pXSprite.islT() && Globals.pGameInfo.nGameType == 3 || !pXSprite.islC() && Globals.pGameInfo.nGameType == 1)) {
                    ++secrets;
                }
                s.setXSprite(pXSprite);
            }
            s.setXvel(i);
            if ((s.getCstat() & 0x30) == 48) {
                Console.out.println("ERROR: Sprite " + i + " has an invalid rotate", OsdColor.YELLOW);
                s.setCstat(s.getCstat() & 0xFFFFFFCF);
            }
            sprites.add(s);
        }
        long uMapCRC = is.getChecksum();
        if (uMapCRC != ((long)StreamUtils.readInt(is) & 0xFFFFFFFFL)) {
            throw new WarningException("File does not match CRC");
        }
        BloodBoard board = new BloodBoard(startPos, sectors, walls, sprites);
        board.setSecrets(secrets);
        board.setVisibility(gVisibility);
        board.setSkyBits(pskybits);
        board.setSongId(gSongId);
        board.setMapCRC(uMapCRC);
        board.setMapRev(gMapRev);
        board.setParallaxType(parallaxtype);
        board.setSkyOffset(pskyoff);
        return board;
    }

    @Override
    public void setBoard(Board board) {
        this.board = board;
        this.initSpriteLists(board);
        List<Sprite> sprites = board.getSprites();
        for (int i = 0; i < sprites.size(); ++i) {
            Sprite spr = sprites.get(i);
            this.spriteStatMap.set(i, spr.getStatnum());
            this.spriteSectMap.set(i, spr.getSectnum());
        }
    }

    @Override
    public BloodBoard prepareBoard(Board b) {
        BloodBoard board = (BloodBoard)b;
        DB.gSkyCount = 1 << board.getSkyBits();
        Arrays.fill(Engine.zeropskyoff, (short)0);
        short[] boardSkyOff = board.getSkyOffset();
        System.arraycopy(boardSkyOff, 0, Engine.zeropskyoff, 0, Math.min(boardSkyOff.length, Engine.zeropskyoff.length));
        System.arraycopy(boardSkyOff, 0, Engine.pskyoff, 0, Math.min(boardSkyOff.length, Engine.pskyoff.length));
        Globals.pGameInfo.uMapCRC = board.getMapCRC();
        LEVELS.autoTotalSecrets = board.getSecrets();
        DB.gVisibility = Engine.visibility = board.getVisibility();
        Engine.pskybits = (short)board.getSkyBits();
        Engine.parallaxtype = (byte)board.getParallaxType();
        this.board = board;
        this.initSpriteLists(board);
        List<Sprite> sprites = board.getSprites();
        for (int i = 0; i < sprites.size(); ++i) {
            Sprite spr = sprites.get(i);
            this.InsertSpriteSect(i, spr.getSectnum());
            this.InsertSpriteStat(i, spr.getStatnum());
        }
        this.PropagateMarkerReferences(board);
        return board;
    }

    public ListNode<XSPRITE> getXSpriteNode() {
        return this.xSpriteMap.getFirst(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void PropagateMarkerReferences(Board board) {
        ListNode node = this.spriteStatMap.getFirst(10);
        while (true) {
            block6: {
                if (node == null) {
                    return;
                }
                int nSprite = node.getIndex();
                Sprite pSprite = (Sprite)node.get();
                switch (pSprite.getLotag()) {
                    case 3: 
                    case 5: 
                    case 8: {
                        short nXSector;
                        Sector pSector = board.getSector(pSprite.getOwner());
                        if (pSector == null || (nXSector = pSector.getExtra()) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker0 = nSprite;
                        break block6;
                    }
                    case 4: {
                        short nXSector;
                        Sector pSector = board.getSector(pSprite.getOwner());
                        if (pSector == null || (nXSector = pSector.getExtra()) <= 0 || nXSector >= 512) break;
                        DB.xsector[nXSector].marker1 = nSprite;
                        break block6;
                    }
                }
                System.out.println("Deleting invalid marker sprite");
                this.deletesprite(nSprite);
            }
            node = node.getNext();
        }
    }

    @Override
    public int getSectorCount() {
        return this.board.getSectorCount() - 1;
    }

    @Override
    public int getWallCount() {
        return this.board.getWallCount() - 4;
    }

    public int getXSpriteCount() {
        return this.xSpriteMap.getSize();
    }

    @Override
    public boolean deletesprite(int nSprite) {
        Sprite pSprite = this.board.getSprite(nSprite);
        if (pSprite == null || pSprite.getStatnum() == 1024 && pSprite.getSectnum() == -1) {
            return false;
        }
        if (pSprite.getExtra() >= 0) {
            this.deleteXSprite(pSprite);
        }
        if (pSprite.getStatnum() < 0 || pSprite.getStatnum() >= 1024) {
            Console.out.println("deletesprite() statnum throw new AssertException: " + pSprite, OsdColor.RED);
            throw new AssertException("pSprite.statnum >= 0 && pSprite.statnum < kMaxStatus");
        }
        this.InsertSpriteSect(nSprite, -1);
        this.InsertSpriteStat(nSprite, 1024);
        pSprite.setSectnum(-1);
        return true;
    }

    @Override
    public int insertsprite(int nSector, int nStatus) {
        int nSprite = this.spriteStatMap.insert(nStatus);
        if (nSprite >= 0) {
            BloodSprite pSprite = this.getSprite(nSprite);
            pSprite.reset((byte)0);
            this.InsertSpriteStat(nSprite, nStatus);
            this.InsertSpriteSect(nSprite, nSector);
            pSprite.setCstat(128);
            pSprite.setClipdist(32);
            pSprite.setXrepeat(64);
            pSprite.setYrepeat(64);
            pSprite.setOwner(-1);
            pSprite.setExtra(-1);
            pSprite.setXSprite(null);
            pSprite.setXvel((short)nSprite);
            pSprite.setVelocity(0L, 0L, 0L);
        }
        return nSprite;
    }

    @Override
    public boolean setSprite(int spritenum, int newx, int newy, int newz, boolean checkZ) {
        Sprite pSprite = this.board.getSprite(spritenum);
        if (pSprite == null) {
            return false;
        }
        pSprite.setX(newx);
        pSprite.setY(newy);
        pSprite.setZ(newz);
        int tempsectnum = this.updatesector(newx, newy, pSprite.getSectnum());
        if (tempsectnum < 0) {
            return false;
        }
        if (tempsectnum != pSprite.getSectnum()) {
            this.changespritesect(spritenum, tempsectnum);
        }
        return true;
    }

    @Override
    public boolean changespritestat(int nSprite, int nStatus) {
        if (!this.isValidSprite(nSprite)) {
            throw new AssertException("isValidSprite(nSprite)");
        }
        if (nStatus < 0 || nStatus > 1024) {
            throw new AssertException("nStatus >= 0 && nStatus <= kMaxStatus");
        }
        Sprite pSprite = this.board.getSprite(nSprite);
        if (pSprite == null) {
            return false;
        }
        if (pSprite.getStatnum() < 0 || pSprite.getStatnum() >= 1024) {
            throw new AssertException("boardService.getSprite(nSprite).statnum >= 0 && boardService.getSprite(nSprite).statnum < kMaxStatus");
        }
        if (!this.isValidSector(pSprite.getSectnum())) {
            throw new AssertException("isValidSector(pSprite.getSectnum())");
        }
        this.InsertSpriteStat(nSprite, nStatus);
        return true;
    }

    private void RemoveSpriteSect(int nSprite) {
        if (!this.isValidSprite(nSprite)) {
            throw new AssertException("isValidSprite(nSprite)");
        }
        this.spriteSectMap.remove(nSprite);
    }

    private void RemoveSpriteStat(int nSprite) {
        if (!this.isValidSprite(nSprite)) {
            throw new AssertException("isValidSprite(nSprite)");
        }
        this.spriteStatMap.remove(nSprite);
    }

    private void InsertSpriteSect(int nSprite, int nSector) {
        this.spriteSectMap.set(nSprite, nSector);
    }

    private void InsertSpriteStat(int nSprite, int nStat) {
        this.spriteStatMap.set(nSprite, nStat);
    }

    public void dbInit() {
        int i;
        this.xSpriteMap = new BloodXSpriteMap(new ArrayList<XSPRITE>());
        for (i = 0; i < 512; ++i) {
            if (DB.xwall[i] == null) {
                DB.xwall[i] = new XWALL();
                continue;
            }
            DB.xwall[i].free();
        }
        for (i = 0; i < 512; ++i) {
            if (DB.xsector[i] == null) {
                DB.xsector[i] = new XSECTOR();
                continue;
            }
            DB.xsector[i].free();
        }
        DB.InitFreeList(DB.nextXWall, 512);
        for (i = 1; i < 512; ++i) {
            DB.xwall[i].reference = -1;
        }
        DB.InitFreeList(DB.nextXSector, 512);
        for (i = 1; i < 512; ++i) {
            DB.xsector[i].reference = -1;
        }
    }

    @Override
    protected void initSpriteLists(Board board) {
        List<Sprite> sprites = board.getSprites();
        this.spriteStatMap = new BloodSpriteMap(1024, sprites, Sprite::setStatnum){

            @Override
            protected void setValue(ListNode<Sprite> node, int value) {
                super.setValue(node, value == -1 ? this.poolIndex : value);
            }
        };
        this.spriteSectMap = new BloodSpriteMap(Engine.MAXSECTORS, sprites, Sprite::setSectnum);
    }

    private int dbInsertXWall(Wall wall, int nWall) {
        int nXWall = DB.RemoveFree(DB.nextXWall);
        if (nXWall == 0) {
            System.err.println("Out of free XWalls");
        }
        DB.xwall[nXWall].free();
        wall.setExtra((short)nXWall);
        DB.xwall[nXWall].reference = nWall;
        return nXWall;
    }

    private void dbDeleteXWall(int nXWall) {
        if (DB.xwall[nXWall].reference < 0) {
            throw new AssertException("xwall[nXWall].reference >= 0");
        }
        DB.InsertFree(DB.nextXWall, nXWall);
        this.getWall(DB.xwall[nXWall].reference).setExtra(-1);
        DB.xwall[nXWall].reference = -1;
    }

    public int getStatSize(int nStat) {
        return this.spriteStatMap.get(nStat).getSize();
    }

    public int insertXSprite(Sprite pSprite) {
        return this.xSpriteMap.insert(pSprite);
    }

    private void deleteXSprite(Sprite pSprite) {
        short nXSprite = pSprite.getExtra();
        if (this.getXSprite(nXSprite).getReference() < 0) {
            throw new AssertException("getXSprite(nXSprite).reference >= 0");
        }
        this.xSpriteMap.remove(nXSprite);
    }

    public XSPRITE setXSprite(int nXSprite) {
        this.xSpriteMap.insert(nXSprite);
        XSPRITE pXSprite = this.getXSprite(nXSprite);
        pXSprite.free();
        return pXSprite;
    }

    public XSPRITE getXSprite(int nXSprite) {
        if (nXSprite == -1) {
            return null;
        }
        return this.xSpriteMap.getXSprite(nXSprite);
    }

    @Override
    public BloodSprite getSprite(int index) {
        return (BloodSprite)super.getSprite(index);
    }
}

