/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Factory.BloodBoardService;
import ru.m210projects.Blood.Factory.BloodPaletteManager;
import ru.m210projects.Blood.Factory.BloodTileManager;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.ClipMover;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Types.TileManager;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.commands.OsdCommand;

public class BloodEngine
extends Engine {
    public BloodEngine(BuildGame game) throws Exception {
        super(game);
        if (game.getCache().getGroup("blood.rff").isEmpty() || game.getCache().getGroup("sounds.rff").isEmpty()) {
            throw new Exception("Looks like you have tried to launch unsupported version of Blood");
        }
        this.clipmove = new ClipMover(this);
        this.inittimer(game.pCfg.isLegacyTimer(), 120, Globals.kFrameTicks);
        Console.out.registerCommand(new OsdCommand("fastdemo", "fastdemo \"demo speed\""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    return CommandResponse.DESCRIPTION_RESPONSE;
                }
                try {
                    BloodEngine.this.getTimer().setSkipTicks(Math.max(0, Integer.parseInt(argv[0])));
                }
                catch (Exception e) {
                    return CommandResponse.BAD_ARGUMENT_RESPONSE;
                }
                return CommandResponse.OK_RESPONSE;
            }
        });
    }

    @Override
    protected TileManager loadTileManager() {
        return new BloodTileManager();
    }

    @Override
    protected BoardService createBoardService() {
        return new BloodBoardService();
    }

    @Override
    public BloodPaletteManager loadpalette() throws Exception {
        return new BloodPaletteManager(this, false);
    }

    @Override
    public BloodPaletteManager getPaletteManager() {
        return (BloodPaletteManager)this.paletteManager;
    }

    @Override
    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        this.clipmove.setTraceNum(clipmoveboxtracenum);
        this.clipmove.setNeedUpdateSector(!DemoUtils.IsOriginalDemo());
        return super.clipmove(x, y, z, sectnum, xvect, yvect, walldist, ceildist, flordist, cliptype);
    }
}

