/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import com.badlogic.gdx.math.Vector2;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.Factory.BloodPrompt;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;

public class BloodGameProcessor
extends GameProcessor {
    private final BloodPrompt bloodMessage = new BloodPrompt();
    private int turnAccel = 0;

    public BloodGameProcessor(Main game) {
        super(game);
    }

    public BloodPrompt getBloodMessage() {
        return this.bloodMessage;
    }

    @Override
    public void fillInput(BuildNet.NetInput input) {
        float k;
        int run;
        INPUT gInput = (INPUT)input;
        gInput.reset();
        if (Console.out.isShowing() || this.game.pMenu.gShowMenu) {
            return;
        }
        if (Globals.pGameInfo.nGameType > 0 && (this.isKeyPressed(57) || this.isKeyPressed(59))) {
            int fkey = -1;
            for (int i = 0; i < 10; ++i) {
                if (!this.isKeyPressed(i + 8)) continue;
                fkey = i;
                break;
            }
            if (this.isKeyPressed(57) && fkey != -1) {
                Main.game.net.TauntSound(fkey);
            }
            if (this.isKeyPressed(59) && fkey != -1) {
                Main.game.net.TauntMessage(fkey);
            }
            return;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.AutoRun)) {
            if (!Main.cfg.gAutoRun) {
                Main.cfg.gAutoRun = true;
                View.viewSetMessage("Auto run On", Globals.gPlayer[View.gViewIndex].nPlayer);
            } else {
                Main.cfg.gAutoRun = false;
                View.viewSetMessage("Auto run Off", Globals.gPlayer[View.gViewIndex].nPlayer);
            }
        }
        if ((View.gViewMode == 4 || View.gViewMode == 2) && this.isGameKeyJustPressed(Config.BloodKeys.Map_Follow_Mode)) {
            boolean bl = Globals.gMapScrollMode = !Globals.gMapScrollMode;
        }
        if (this.isGameKeyJustPressed(GameKeys.Map_Toggle)) {
            Screen.scrSetView(View.gViewMode);
        }
        if (this.isGameKeyJustPressed(GameKeys.Next_Weapon)) {
            gInput.NextWeapon = true;
        }
        if (this.isGameKeyJustPressed(GameKeys.Previous_Weapon)) {
            gInput.PrevWeapon = true;
        }
        gInput.Jump = this.isGameKeyPressed(GameKeys.Jump);
        gInput.Crouch = this.isGameKeyPressed(GameKeys.Crouch);
        gInput.Shoot = this.isGameKeyPressed(GameKeys.Weapon_Fire);
        gInput.AltShoot = this.isGameKeyPressed(Config.BloodKeys.Weapon_Special_Fire);
        gInput.Run = this.isGameKeyPressed(GameKeys.Run);
        gInput.TurnAround = this.isGameKeyJustPressed(GameKeys.Turn_Around);
        gInput.Use = this.isGameKeyJustPressed(GameKeys.Open);
        gInput.InventoryLeft = this.isGameKeyJustPressed(Config.BloodKeys.Inventory_Left);
        gInput.InventoryRight = this.isGameKeyJustPressed(Config.BloodKeys.Inventory_Right);
        gInput.InventoryUse = this.isGameKeyJustPressed(Config.BloodKeys.Inventory_Use);
        gInput.HolsterWeapon = this.isGameKeyJustPressed(Config.BloodKeys.Holster_Weapon);
        gInput.CrouchMode = Globals.gMe.moveState != 1 ? this.isGameKeyJustPressed(Config.BloodKeys.Crouch_toggle) : this.isGameKeyPressed(Config.BloodKeys.Crouch_toggle);
        gInput.LastWeapon = this.isGameKeyJustPressed(Config.BloodKeys.Last_Used_Weapon);
        for (int i = 0; i < 10; ++i) {
            GameKey gameKey = Main.cfg.getKeymap()[i + Main.cfg.weaponIndex];
            if (!this.isGameKeyJustPressed(gameKey)) continue;
            gInput.newWeapon = i + 1;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.See_Chase_View)) {
            View.gViewPos ^= 1;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.Show_Opponents_Weapon)) {
            boolean bl = Main.cfg.gShowWeapon = !Main.cfg.gShowWeapon;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.See_Coop_View) && Mmulti.numplayers > 1 && (Globals.pGameInfo.nGameType == 1 || Globals.pGameInfo.nGameType == 3) && !Globals.kFakeMultiplayer) {
            if (Globals.pGameInfo.nGameType == 1) {
                if ((View.gViewIndex = Mmulti.connectpoint2[View.gViewIndex]) == -1) {
                    View.gViewIndex = Mmulti.connecthead;
                }
            } else {
                int index = View.gViewIndex;
                do {
                    if ((View.gViewIndex = Mmulti.connectpoint2[View.gViewIndex]) != -1) continue;
                    View.gViewIndex = Mmulti.connecthead;
                } while (index != View.gViewIndex && Globals.gMe.teamID != Globals.gPlayer[View.gViewIndex].teamID && index != View.gViewIndex);
            }
        }
        gInput.UseBeastVision = this.isGameKeyJustPressed(Config.BloodKeys.BeastVision);
        gInput.UseCrystalBall = this.isGameKeyJustPressed(Config.BloodKeys.CrystalBall);
        gInput.UseJumpBoots = this.isGameKeyJustPressed(Config.BloodKeys.JumpBoots);
        gInput.UseMedKit = this.isGameKeyJustPressed(Config.BloodKeys.MedKit);
        if (this.isGameKeyJustPressed(Config.BloodKeys.ProximityBombs)) {
            gInput.newWeapon = 11;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.RemoteBombs)) {
            gInput.newWeapon = 12;
        }
        boolean up = this.isGameKeyPressed(GameKeys.Move_Forward);
        boolean down = this.isGameKeyPressed(GameKeys.Move_Backward);
        int n = run = !Main.cfg.gAutoRun && gInput.Run || !gInput.Run && Main.cfg.gAutoRun ? 1 : 0;
        if (up) {
            gInput.Forward += Globals.kFrameTicks * (run + 1);
        }
        if (down) {
            gInput.Forward -= Globals.kFrameTicks * (run + 1);
        }
        boolean strafe = this.isGameKeyPressed(GameKeys.Strafe);
        boolean sleft = this.isGameKeyPressed(GameKeys.Strafe_Left);
        boolean sright = this.isGameKeyPressed(GameKeys.Strafe_Right);
        if (sleft) {
            gInput.Strafe += Globals.kFrameTicks * (run + 1);
        }
        if (sright) {
            gInput.Strafe -= Globals.kFrameTicks * (run + 1);
        }
        boolean left = this.isGameKeyPressed(GameKeys.Turn_Left);
        boolean right = this.isGameKeyPressed(GameKeys.Turn_Right);
        this.turnAccel = left || right ? (this.turnAccel += Globals.kFrameTicks) : 0;
        if (!strafe) {
            if (left) {
                gInput.Turn -= (float)Gameutils.ClipHigh(this.turnAccel * 12, Main.cfg.gTurnSpeed);
            }
            if (right) {
                gInput.Turn += (float)Gameutils.ClipHigh(this.turnAccel * 12, Main.cfg.gTurnSpeed);
            }
            gInput.Turn = ru.m210projects.Build.Gameutils.BClipRange(gInput.Turn + this.ctrlGetMouseTurn(), -1024.0f, 1024.0f);
        } else {
            if (left) {
                gInput.Strafe += Globals.kFrameTicks * (run + 1);
            }
            if (right) {
                gInput.Strafe -= Globals.kFrameTicks * (run + 1);
            }
            gInput.Strafe = ru.m210projects.Build.Gameutils.BClipRange(gInput.Strafe - (int)this.ctrlGetMouseStrafe(), -Globals.kFrameTicks * (run + 1), Globals.kFrameTicks * (run + 1));
        }
        if ((gInput.Run || Main.cfg.gAutoRun) && this.turnAccel > 24) {
            gInput.Turn *= 2.0f;
        }
        if (this.isGameKeyJustPressed(GameKeys.Mouse_Aiming)) {
            if (!Main.cfg.isgMouseAim()) {
                Main.cfg.setgMouseAim(true);
                View.viewSetMessage("Mouse aiming on", Globals.gPlayer[View.gViewIndex].nPlayer);
            } else {
                Main.cfg.setgMouseAim(false);
                gInput.LookCenter = true;
                View.viewSetMessage("Mouse aiming off", Globals.gPlayer[View.gViewIndex].nPlayer);
            }
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.Toggle_Crosshair)) {
            if (!Main.cfg.gCrosshair) {
                Main.cfg.gCrosshair = true;
                View.viewSetMessage("Crosshair on", Globals.gPlayer[View.gViewIndex].nPlayer);
            } else {
                Main.cfg.gCrosshair = false;
                View.viewSetMessage("Crosshair off", Globals.gPlayer[View.gViewIndex].nPlayer);
            }
        }
        gInput.LookLeft = this.isGameKeyPressed(Config.BloodKeys.Tilt_Left);
        gInput.LookRight = this.isGameKeyPressed(Config.BloodKeys.Tilt_Right);
        gInput.Lookup = false;
        gInput.Lookdown = false;
        if (this.isGameKeyPressed(Config.BloodKeys.Aim_Up)) {
            gInput.Lookup = true;
        }
        if (this.isGameKeyPressed(Config.BloodKeys.Aim_Down)) {
            gInput.Lookdown = true;
        }
        if (this.isGameKeyPressed(GameKeys.Look_Up)) {
            gInput.Lookup = true;
            gInput.LookCenter = true;
        }
        if (this.isGameKeyPressed(GameKeys.Look_Down)) {
            gInput.Lookdown = true;
            gInput.LookCenter = true;
        }
        if (this.isGameKeyJustPressed(Config.BloodKeys.Aim_Center)) {
            gInput.LookCenter = true;
        }
        if (Main.cfg.isgMouseAim() && View.gViewMode != 4) {
            gInput.mlook = ru.m210projects.Build.Gameutils.BClipRange(this.ctrlGetMouseLook(!Main.cfg.isgInvertmouse()) / 16.0f, -177.0f, 178.0f);
        } else {
            gInput.Forward = Gameutils.ClipRange(gInput.Forward - (int)this.ctrlGetMouseMove(), -Globals.kFrameTicks * (run + 1), Globals.kFrameTicks * (run + 1));
        }
        Vector2 stick1 = this.ctrlGetStick(GameProcessor.JoyStick.LOOKING);
        Vector2 stick2 = this.ctrlGetStick(GameProcessor.JoyStick.MOVING);
        float lookx = stick1.x;
        float looky = stick1.y;
        if (looky != 0.0f) {
            k = 1.5f;
            gInput.mlook = ru.m210projects.Build.Gameutils.BClipRange(gInput.mlook - k * looky * Main.cfg.getJoyLookSpeed(), -177.0f, 178.0f);
        }
        if (lookx != 0.0f) {
            k = 64.0f;
            gInput.Turn = ru.m210projects.Build.Gameutils.BClipRange(gInput.Turn + k * lookx * Main.cfg.getJoyTurnSpeed(), -1024.0f, 1024.0f);
        }
        if (stick2.y != 0.0f) {
            gInput.Forward = (short)ru.m210projects.Build.Gameutils.BClipRange((float)gInput.Forward - 20.0f * stick2.y, (float)(-Globals.kFrameTicks * (run + 1)), (float)(Globals.kFrameTicks * (run + 1)));
        }
        if (stick2.x != 0.0f) {
            gInput.Strafe = (short)ru.m210projects.Build.Gameutils.BClipRange((float)gInput.Strafe - 20.0f * stick2.x, (float)(-Globals.kFrameTicks * (run + 1)), (float)(Globals.kFrameTicks * (run + 1)));
        }
        if (this.isKeyJustPressed(121)) {
            boolean bl = gInput.Pause = !gInput.Pause;
        }
        if (this.isGameKeyPressed(GameKeys.Send_Message)) {
            this.bloodMessage.setCaptureInput(true);
        }
        if ((View.gViewMode == 4 || View.gViewMode == 2) && Globals.gMapScrollMode) {
            View.scrollOX = View.scrollX;
            View.scrollOY = View.scrollY;
            View.scrollOAng = View.scrollAng;
            if (gInput.Forward != 0) {
                View.scrollX += Pragmas.mulscale(Trig.Cos(View.scrollAng), gInput.Forward, 24);
                View.scrollY += Pragmas.mulscale(Trig.Sin(View.scrollAng), gInput.Forward, 24);
                gInput.Forward = 0;
            }
            if (gInput.Strafe != 0) {
                View.scrollX += Pragmas.mulscale(Trig.Sin(View.scrollAng), gInput.Strafe, 24);
                View.scrollY -= Pragmas.mulscale(Trig.Cos(View.scrollAng), gInput.Strafe, 24);
                gInput.Strafe = 0;
            }
            if (gInput.Turn != 0.0f) {
                View.scrollAng = (short)(View.scrollAng + (Globals.kFrameTicks * (int)gInput.Turn >> 4) & 0x7FF);
                gInput.Turn = 0.0f;
            }
        }
    }

    @Override
    public boolean keyDown(int keycode) {
        if (this.bloodMessage.isCaptured()) {
            if (keycode == 111) {
                this.bloodMessage.setCaptureInput(false);
                this.bloodMessage.clear();
            } else {
                this.bloodMessage.keyDown(keycode);
            }
            return true;
        }
        return super.keyDown(keycode);
    }

    @Override
    public boolean keyUp(int i) {
        this.bloodMessage.keyUp(i);
        return super.keyUp(i);
    }

    @Override
    public boolean keyRepeat(int keycode) {
        if (this.bloodMessage.isCaptured()) {
            this.bloodMessage.keyRepeat(keycode);
            return true;
        }
        return super.keyRepeat(keycode);
    }

    @Override
    public boolean keyTyped(char i) {
        if (this.bloodMessage.isCaptured()) {
            this.bloodMessage.keyTyped(i);
            return true;
        }
        return super.keyTyped(i);
    }
}

