/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.Menus.MenuQav;
import ru.m210projects.Blood.Screens.MenuScreen;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class BloodMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int SOUNDSET = 3;
    public static final int DIFFICULTY = 4;
    public static final int CREDITS = 5;
    public static final int HELP = 6;
    public static final int LOADGAME = 7;
    public static final int SAVEGAME = 8;
    public static final int QUIT = 9;
    public static final int QUITTITLE = 10;
    public static final int NETWORKGAME = 11;
    public static final int MULTIPLAYER = 12;
    public static final int COLORCORR = 13;
    public static final int NEWADDON = 14;
    public static final int OPTIONS = 15;
    public static final int USERCONTENT = 16;
    public static final int CORRUPTLOAD = 17;
    private final Engine engine;
    private final BuildGame app;
    private MenuQav Bdrip;

    public BloodMenuHandler(BuildGame app) {
        super(app);
        this.mMenus = new BuildMenu[19];
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof BuildMenuList || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            Renderer renderer = this.game.getRenderer();
            int xdim = renderer.getWidth();
            int ydim = renderer.getHeight();
            int tile = 2046;
            ArtEntry pic = this.engine.getTile(tile);
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            renderer.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 5, 57);
        }
        super.mDrawMenu();
    }

    public MenuQav addMenuBlood() {
        if (this.Bdrip == null) {
            this.Bdrip = new MenuQav(160, 100, 256){

                @Override
                public void draw(MenuHandler handler) {
                    Renderer renderer = BloodMenuHandler.this.game.getRenderer();
                    int frames = renderer.getWidth() / 320;
                    this.pQAV.origin.x = 0.0f;
                    for (int i = 0; i <= frames; ++i) {
                        super.draw(handler);
                        this.pQAV.origin.x += 319.0f;
                    }
                }
            };
        }
        return this.Bdrip;
    }

    @Override
    public int getShade(MenuItem item) {
        int shade = 32;
        if (item != null && item.isFocused()) {
            shade = 32 - (this.engine.getTotalClock() & 0x3F);
        }
        return shade;
    }

    @Override
    public int getPal(Font font, MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 10;
            }
            return item.pal;
        }
        return 0;
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int zoom = Pragmas.scale(65536L, renderer.getHeight(), 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.getgMouseCursorSize(), 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        renderer.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.isMenuMouse()) {
            return;
        }
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        if (this.mCount > 1) {
            ArtEntry pic = this.engine.getTile(9216);
            int shade = 16 + Pragmas.mulscale(16L, EngineUtils.sin(20 * this.engine.getTotalClock()), 16);
            renderer.rotatesprite(0, ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, pic.getWidth() - 1, 16), ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        Renderer renderer = this.game.getRenderer();
        int ydim = renderer.getHeight();
        int zoom = Pragmas.scale(16384L, ydim, 200L);
        ArtEntry pic = renderer.getTile(9216);
        int size = Pragmas.mulscale(pic.getWidth(), zoom, 16);
        int bx = 0;
        int by = ydim - Pragmas.mulscale(pic.getHeight(), zoom, 16);
        if (mx >= bx && mx < bx + size) {
            return my >= by && my < by + size;
        }
        return false;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
    }

    @Override
    public void mPostDraw(MenuItem item) {
    }
}

