/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import ru.m210projects.Blood.Factory.BloodMapSettings;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodTextureManager;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.GLFog;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.Polymost.Polymost2D;
import ru.m210projects.Build.Render.RenderingType;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.ScreenFade;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.settings.GameConfig;

public class BloodPolymost
extends Polymost
implements BloodRenderer {
    private final float[] pal1_color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected int framew;
    protected int frameh;
    protected GLTile frameTexture;
    private GLTile dummy;
    private boolean drunk;
    private float drunkIntensive = 1.0f;
    private boolean restorepalette;

    public BloodPolymost(GameConfig config) {
        super(config);
        this.globalfog = new GLFog(){

            @Override
            public void calc() {
                int numshades = this.paletteManager.getShadeCount();
                if (this.combvis == 0.0f) {
                    this.start = 2.9E30f;
                    this.end = 3.0E30f;
                } else if (this.shade >= numshades - 1) {
                    this.start = -1.0f;
                    this.end = 0.001f;
                } else {
                    this.start = this.shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * this.shade)) / this.combvis;
                    this.end = (float)(this.FOGDISTCONST * (numshades - 1 - this.shade)) / this.combvis;
                }
                ru.m210projects.Build.Render.Types.Color fog = this.paletteManager.getFogColor(this.pal);
                this.color[0] = (float)fog.r / 63.0f;
                this.color[1] = (float)fog.g / 63.0f;
                this.color[2] = (float)fog.b / 63.0f;
                this.color[3] = 1.0f;
                if (!(this.pal != 1 || GLInfo.multisample != 0 && Main.game.pCfg.isPaletteEmulation())) {
                    this.start = 0.0f;
                    if (this.end > 2.0f) {
                        this.end = 2.0f;
                    }
                }
                this.gl.glFogfv(2918, this.color, 0);
                this.gl.glFogf(2915, this.start);
                this.gl.glFogf(2916, this.end);
            }
        };
        this.globalfog.setFogScale(64);
    }

    @Override
    public void init(Engine engine) {
        super.init(engine);
        this.TRANSLUSCENT1 = 0.33f;
        this.TRANSLUSCENT2 = 0.66f;
    }

    @Override
    public int getCurrentShade() {
        return this.globalshade;
    }

    @Override
    public void drawmasks() {
        super.drawmasks();
        if (this.drunk) {
            boolean hasShader;
            Gdx.gl.glActiveTexture(33984);
            boolean bl = hasShader = this.texshader != null && this.texshader.isBinded();
            if (hasShader) {
                this.texshader.unbind();
            }
            if (this.frameTexture == null || this.framew != this.xdim || this.frameh != this.ydim) {
                int size;
                for (size = 1; size < Math.max(this.xdim, this.ydim); size <<= 1) {
                }
                if (this.frameTexture != null) {
                    this.frameTexture.dispose();
                } else {
                    this.frameTexture = this.textureCache.newTile(TileData.PixelFormat.Rgb, size, size);
                }
                this.frameTexture.bind();
                this.gl.glTexImage2D(3553, 0, 6407, this.frameTexture.getWidth(), this.frameTexture.getHeight(), 0, 6407, 5121, null);
                this.frameTexture.unsafeSetFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                this.framew = this.xdim;
                this.frameh = this.ydim;
            }
            this.textureCache.bind(this.frameTexture);
            this.gl.glCopyTexSubImage2D(3553, 0, 0, 0, 0, 0, this.frameTexture.getWidth(), this.frameTexture.getHeight());
            this.gl.glDisable(2929);
            this.gl.glDisable(3008);
            this.gl.glEnable(3553);
            this.gl.glMatrixMode(5889);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            float tiltang = this.drunkIntensive * 360.0f / 2048.0f;
            float tilt = Math.min(Math.max(tiltang, -MAXDRUNKANGLE), MAXDRUNKANGLE);
            this.gl.glScalef(1.05f, 1.05f, 1.0f);
            this.gl.glRotatef(tilt, 0.0f, 0.0f, 1.0f);
            this.gl.glMatrixMode(5888);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            float u = (float)this.xdim / (float)this.frameTexture.getWidth();
            float v = (float)this.ydim / (float)this.frameTexture.getHeight();
            this.gl.glColor4f(1.0f, 1.0f, 1.0f, Math.abs(tilt) / (2.0f * MAXDRUNKANGLE));
            this.gl.glBegin(6);
            this.gl.glTexCoord2f(0.0f, 0.0f);
            this.gl.glVertex2f(-1.0f, -1.0f);
            this.gl.glTexCoord2f(0.0f, v);
            this.gl.glVertex2f(-1.0f, 1.0f);
            this.gl.glTexCoord2f(u, v);
            this.gl.glVertex2f(1.0f, 1.0f);
            this.gl.glTexCoord2f(u, 0.0f);
            this.gl.glVertex2f(1.0f, -1.0f);
            this.gl.glEnd();
            this.gl.glMatrixMode(5888);
            this.gl.glPopMatrix();
            this.gl.glMatrixMode(5889);
            this.gl.glPopMatrix();
            this.gl.glEnable(2929);
            this.gl.glEnable(3008);
            this.gl.glDisable(3553);
            if (hasShader) {
                this.texshader.bind();
            }
        }
    }

    @Override
    public void setdrunk(float intensive) {
        if (intensive == 0.0f) {
            this.drunk = false;
            this.drunkIntensive = 0.0f;
        } else {
            this.drunk = true;
            this.drunkIntensive = intensive;
        }
    }

    @Override
    public void setRestorePalette() {
        this.restorepalette = true;
    }

    @Override
    public boolean isRestorePalette() {
        if (this.restorepalette) {
            this.restorepalette = false;
            return true;
        }
        return false;
    }

    @Override
    public void setaspect(int daxrange, int daaspect) {
        super.setaspect(daxrange, daaspect);
    }

    @Override
    protected Polymost2D allocOrphoRenderer(Engine engine) {
        return new Polymost2D(this, (IOverheadMapSettings)new BloodMapSettings(engine.getBoardService()));
    }

    @Override
    protected void calc_and_apply_fog(int shade, int vis, int pal) {
        TileData.PixelFormat fmt = this.textureCache.getFmt(this.globalpicnum);
        if (fmt != TileData.PixelFormat.Pal8) {
            if (this.renderingType == RenderingType.Sprite && this.globalpal == 5 && this.globalshade == 127) {
                shade = 0;
            }
            if (this.globalpal == 1 || pal == 1) {
                if (this.renderingType == RenderingType.Model) {
                    shade = this.tspriteptr[RenderingType.Model.getIndex()].getShade();
                    if (shade > 0) {
                        shade = Gameutils.BClipRange((int)(2.8f * (float)shade), 32, 52);
                    }
                } else {
                    shade = 0;
                }
            }
        }
        super.calc_and_apply_fog(shade, vis, pal);
    }

    @Override
    public void uninit() {
        if (this.dummy != null) {
            this.dummy.delete();
        }
        this.dummy = null;
        super.uninit();
    }

    @Override
    public Color getshadefactor(int shade, int method) {
        if (RenderingType.Skybox.getIndex() != 0 && this.globalpal == 1 && GLInfo.multisample != 0) {
            this.bindBloodPalette(shade);
            return super.getshadefactor(0, 0);
        }
        Color c = super.getshadefactor(shade, method);
        if (this.globalpal == 1) {
            c.b = 1.0f;
            c.g = 1.0f;
            c.r = 1.0f;
        }
        return c;
    }

    protected void bindDummyTexture() {
        if (this.dummy == null) {
            this.dummy = new GLTile(new DummyTileData(TileData.PixelFormat.Rgba, 1, 1), 1, TexFilter.NONE);
        }
        this.bind(this.dummy);
    }

    public void bindBloodPalette(int shade) {
        this.textureCache.activateEffect();
        this.bindDummyTexture();
        int numshades = this.paletteManager.getShadeCount();
        this.pal1_color[3] = (float)(numshades - shade) / (float)numshades + 0.1f;
        this.gl.glTexEnvfv(8960, 8705, this.pal1_color, 0);
        this.gl.glTexEnvf(8960, 8704, 34160.0f);
        this.gl.glTexEnvf(8960, 34161, 34165.0f);
        this.gl.glTexEnvf(8960, 34176, 34168.0f);
        this.gl.glTexEnvf(8960, 34192, 768.0f);
        this.gl.glTexEnvf(8960, 34177, 34166.0f);
        this.gl.glTexEnvf(8960, 34193, 768.0f);
        this.gl.glTexEnvf(8960, 34178, 34166.0f);
        this.gl.glTexEnvf(8960, 34194, 770.0f);
    }

    @Override
    public TextureManager newTextureManager(Engine engine) {
        return new BloodTextureManager(engine);
    }

    @Override
    public void setTextureParameters(GLTile tile, ArtEntry artEntry, int pal, int shade, int skybox, int method) {
        if (tile.getPixelFormat() == TileData.PixelFormat.Pal8) {
            if (!this.texshader.isBinded()) {
                this.gl.glActiveTexture(33984);
                this.texshader.bind();
            }
            this.texshader.setTextureParams(pal, shade);
            float alpha = 1.0f;
            switch (method & 3) {
                case 2: {
                    alpha = this.TRANSLUSCENT1;
                    break;
                }
                case 3: {
                    alpha = this.TRANSLUSCENT2;
                }
            }
            if (!artEntry.exists()) {
                alpha = 0.01f;
            }
            this.texshader.setTextureSize(tile.getWidth(), tile.getHeight());
            this.texshader.setPaletteFiltered(this.config.getPaletteFiltered());
            this.texshader.setSoftShading(this.config.getSoftShading());
            this.texshader.setDrawLastIndex((method & 3) == 0 || !this.textureCache.alphaMode(method));
            this.texshader.setTransparent(alpha);
        } else {
            if (tile.isHighTile() && (tile.getHiresXScale() != 1.0f || tile.getHiresYScale() != 1.0f) && RenderingType.Skybox.getIndex() == 0) {
                this.gl.glMatrixMode(5890);
                this.gl.glLoadIdentity();
                this.gl.glScalef(tile.getHiresXScale(), tile.getHiresYScale(), 1.0f);
                this.gl.glMatrixMode(5888);
            }
            if (GLInfo.multisample != 0 && this.config.isUseHighTiles() && RenderingType.Skybox.getIndex() == 0) {
                GLTile glow;
                GLTile detail;
                if (this.config.isDetailMapping() && (detail = this.textureCache.get(tile.getPixelFormat(), artEntry, 255, 0, method)) != null) {
                    this.bind(detail);
                    this.setupTextureDetail(detail);
                    this.gl.glMatrixMode(5890);
                    this.gl.glLoadIdentity();
                    if (detail.isHighTile() && detail.getHiresXScale() != 1.0f || detail.getHiresYScale() != 1.0f) {
                        this.gl.glScalef(detail.getHiresXScale(), detail.getHiresYScale(), 1.0f);
                    }
                    this.gl.glMatrixMode(5888);
                }
                if (this.config.isGlowMapping() && (glow = this.textureCache.get(tile.getPixelFormat(), artEntry, 254, 0, method)) != null) {
                    this.bind(glow);
                    this.setupTextureGlow(glow);
                }
            }
            Color c = this.getshadefactor(shade, method);
            if (tile.isHighTile() && this.defs.texInfo != null) {
                if (tile.getPal() != pal) {
                    ru.m210projects.Build.Render.Types.Color p = this.defs.texInfo.getTints(pal);
                    c.r *= (float)p.r / 255.0f;
                    c.g *= (float)p.g / 255.0f;
                    c.b *= (float)p.b / 255.0f;
                }
                ru.m210projects.Build.Render.Types.Color pdetail = this.defs.texInfo.getTints(255);
                if (pdetail.r != 255 || pdetail.g != 255 || pdetail.b != 255) {
                    c.r *= (float)pdetail.r / 255.0f;
                    c.g *= (float)pdetail.g / 255.0f;
                    c.b *= (float)pdetail.b / 255.0f;
                }
            }
            if (!artEntry.exists()) {
                c.a = 0.01f;
            }
            this.gl.glColor4f(c.r, c.g, c.b, c.a);
        }
    }

    @Override
    public void scrSetDac() {
        if (this.config.isPaletteEmulation()) {
            BloodRenderer.super.scrSetDac();
            return;
        }
        boolean hasShader = this.beginShowFade();
        for (ScreenFade fade : ScreenEffect.SCREEN_DAC_ARRAY) {
            this.showScreenFade(fade);
        }
        this.endShowFade(hasShader);
    }

    private void renderScreenFade() {
        this.gl.glBegin(4);
        for (int i = 0; i < 6; i += 2) {
            this.gl.glVertex2f(vertices[i], vertices[i + 1]);
        }
        this.gl.glEnd();
    }

    @Override
    public void showScreenFade(ScreenFade screenFade) {
        int intensive = screenFade.getIntensive();
        if (intensive == 0) {
            return;
        }
        int g = 0;
        int b = 0;
        switch (screenFade.getName()) {
            case "Pickup": {
                int r;
                g = r = Math.min(4 * intensive, 255);
                int a = Math.min(intensive + 32, 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(intensive, intensive, 0, 0);
                this.renderScreenFade();
                break;
            }
            case "Hit": {
                int r = Math.min(3 * ((intensive *= 3) + 32), 255);
                int a = Math.min(2 * (intensive + 32), 255);
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(intensive, 0, 0, 0);
                this.renderScreenFade();
                break;
            }
            case "Drown": {
                int multiple;
                int a;
                int r;
                if ((intensive >>= 5) < 128) {
                    r = b = Math.min(255, 3 * intensive);
                    a = 0;
                } else {
                    b = 255;
                    r = 255;
                    a = Math.min(255, 2 * (intensive - 128));
                }
                this.gl.glBlendFunc(774, 771);
                this.gl.glColor4ub(r, g, b, a);
                this.renderScreenFade();
                int kintensive = intensive >> 6;
                int attenuation = 128 - kintensive;
                if (attenuation < 0) {
                    attenuation = 0;
                }
                this.gl.glBlendFunc(774, 774);
                this.gl.glColor4ub(attenuation, attenuation, attenuation, 0);
                this.renderScreenFade();
                if (intensive > 2000) {
                    this.renderScreenFade();
                }
                if ((multiple = intensive / 10) > 160) {
                    multiple = 160;
                }
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(0, 0, 0, multiple);
                this.renderScreenFade();
                break;
            }
            case "Blind": {
                int attenuation = Math.max(0, 128 - intensive);
                this.gl.glBlendFunc(774, 774);
                this.gl.glColor4ub(attenuation, attenuation, attenuation, 0);
                this.renderScreenFade();
                this.renderScreenFade();
                this.gl.glBlendFunc(771, 771);
                this.gl.glColor4ub(0, 0, 0, intensive);
                this.renderScreenFade();
            }
        }
    }
}

