/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Factory.BloodMapSettings;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.Software.Software;
import ru.m210projects.Build.Render.Software.SoftwareOrpho;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.settings.GameConfig;

public class BloodSoftware
extends Software
implements BloodRenderer {
    private boolean restorepalette;

    public BloodSoftware(GameConfig config) {
        super(config);
    }

    @Override
    protected SoftwareOrpho allocOrphoRenderer(Engine engine) {
        return new SoftwareOrpho(this, (IOverheadMapSettings)new BloodMapSettings(engine.getBoardService()));
    }

    @Override
    public void setaspect(int daxrange, int daaspect) {
        super.setaspect(daxrange, daaspect);
    }

    @Override
    public void setdrunk(float deliriumTilt) {
        if (deliriumTilt != 0.0f) {
            ArtEntry pic = this.engine.getTile(4078);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists() || pic.getWidth() == 0 || pic.getHeight() == 0) {
                this.engine.allocatepermanenttile(4078, 320, 320);
            }
            this.setviewtotile(this.engine.getTileManager().getDynamicTile(4078));
            int tilt = (int)deliriumTilt & 0x1FF;
            if (tilt > 256) {
                tilt = 512 - tilt;
            }
            this.setaspect(Pragmas.dmulscale(256000L, Trig.Cos(tilt), 160000L, Trig.Sin(tilt), 32), this.yxaspect);
        }
    }

    @Override
    public void setRestorePalette() {
        this.restorepalette = true;
    }

    @Override
    public boolean isRestorePalette() {
        if (this.restorepalette) {
            this.restorepalette = false;
            return true;
        }
        return false;
    }

    @Override
    public int getCurrentShade() {
        return this.globalshade;
    }
}

