/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import java.util.List;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.LinkedMap;
import ru.m210projects.Build.Types.collections.ListNode;

public class BloodXSpriteMap
extends LinkedMap<XSPRITE> {
    private static final int kMaxXSprites = 2048;

    public BloodXSpriteMap(List<XSPRITE> list) {
        super(1, list, 2048, XSPRITE::setReference);
        LinkedList oldList = this.basket[this.poolIndex];
        LinkedList newList = new LinkedList();
        while (oldList.getSize() != 0) {
            newList.addFirst(oldList.removeFirst());
        }
        this.basket[this.poolIndex] = newList;
    }

    public XSPRITE getXSprite(int nXSprite) {
        if (nXSprite < 0) {
            return null;
        }
        if (nXSprite >= this.nodeMap.length) {
            this.increase(nXSprite);
        }
        return (XSPRITE)this.list.get(nXSprite);
    }

    @Override
    protected int insert(ListNode<XSPRITE> node, int nSprite) {
        LinkedList list = this.basket[0];
        list.addLast(node);
        this.setValue(node, nSprite);
        return node.getIndex();
    }

    public int insert(Sprite pSprite) {
        ListNode<XSPRITE> node = this.obtain();
        int nXSprite = node.getIndex();
        XSPRITE pXSprite = (XSPRITE)this.list.get(nXSprite);
        pXSprite.free();
        this.insert(node, (int)pSprite.getXvel());
        pSprite.setExtra(nXSprite);
        ((BloodSprite)pSprite).setXSprite(pXSprite);
        return nXSprite;
    }

    @Override
    public boolean remove(int nXSprite) {
        BloodSprite pSprite;
        if (nXSprite < 0) {
            return false;
        }
        if (nXSprite >= this.nodeMap.length) {
            this.increase(nXSprite);
        }
        XSPRITE pXSprite = (XSPRITE)this.list.get(nXSprite);
        int nSprite = pXSprite.getReference();
        if (super.remove(nXSprite) && (pSprite = Main.boardService.getSprite(nSprite)) != null) {
            pSprite.setXSprite(null);
            pSprite.setExtra(-1);
            return true;
        }
        return false;
    }

    @Override
    protected XSPRITE getInstance() {
        return new XSPRITE();
    }

    @Override
    public int insert(int nXSprite) {
        if (this.getXSprite(nXSprite).getReference() != -1) {
            throw new RuntimeException("The XSprite already allocated!");
        }
        this.set(nXSprite, 0);
        return nXSprite;
    }

    public int getSize() {
        return this.basket[0].getSize();
    }
}

