/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Main;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.osd.Console;

public class Fire {
    private final short kSize = (short)128;
    private final int kSeedLines = 3;
    private final int kPorchLines = 4;
    private final int kSeedBuffers = 16;
    private final int kPicFire = 2342;
    private final int fireSize = 128;
    private final byte[] FrameBuffer;
    private final byte[][] SeedBuffer = new byte[16][128];
    private final byte[] CoolTable = new byte[1024];
    private final int gDamping = 7;
    private final byte[] gCLU;
    private int gFireClock;

    public Fire() throws InitializationException {
        Console.out.println("Initializing dynamic fire");
        ArtEntry pic = Main.engine.getTile(2342);
        if (128 != pic.getWidth() && pic.getWidth() != 0 || 128 != pic.getHeight() && pic.getHeight() != 0) {
            throw new InitializationException("Fire tile size(#2342) is wrong!");
        }
        this.FrameBuffer = new byte[17280];
        this.BuildCoolTable();
        this.InitSeedBuffers();
        Entry entry = Main.game.getCache().getEntry("RFIRE.CLU", true);
        if (!entry.exists()) {
            throw new InitializationException("RFIRE.CLU not found");
        }
        this.gCLU = entry.getBytes();
        for (int i = 0; i < 50; ++i) {
            this.update();
        }
    }

    public int getPicture() {
        return 2342;
    }

    private void InitSeedBuffers() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 128; j += 2) {
                byte c;
                this.SeedBuffer[i][j] = c = (byte)Gameutils.bRandom();
                this.SeedBuffer[i][j + 1] = c;
            }
        }
    }

    public void process() {
        if (Main.engine.getTotalClock() < this.gFireClock || this.gFireClock + 2 < Main.engine.getTotalClock()) {
            BloodRenderer renderer = Main.game.getRenderer();
            if (renderer.gotPic(2342)) {
                this.update();
            }
            this.gFireClock = Main.engine.getTotalClock();
        }
    }

    private void BuildCoolTable() {
        for (int i = 0; i < 1024; ++i) {
            this.CoolTable[i] = (byte)Gameutils.ClipLow((i - 7) / 4, 0);
        }
    }

    private void update() {
        int nSeed = Gameutils.vRandom() & 0xF;
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(this.SeedBuffer[nSeed], 0, this.FrameBuffer, (132 + i) * 128, 128);
        }
        this.CellularFrame(this.FrameBuffer, 128, 132);
        ArtEntry picFire = Main.engine.getTile(2342);
        if (!(picFire instanceof DynamicArtEntry) || !picFire.exists()) {
            picFire = Main.engine.allocatepermanenttile(2342, 128, 128);
        }
        this.UpdateTile(this.gCLU, (DynamicArtEntry)picFire);
    }

    /*
     * Unable to fully structure code
     */
    private void CellularFrame(byte[] buff, int cols, int rows) {
        idx = 0;
        o = 0;
        size = rows * cols;
        pos = 0;
        while (true) {
            for (k = 0; k < 3; ++k) {
                o = cols + pos - 1;
                idx = (buff[o] & 255) + (buff[o + 1] & 255) + (buff[o + 2] & 255) + (buff[o + cols + 1] & 255);
                if ((buff[o + cols + 1] & 255) > 96) break;
                buff[pos] = this.CoolTable[idx];
                if (++pos < size) continue;
                return;
            }
            if ((buff[o + cols + 1] & 255) <= 96) ** continue;
            idx = (idx + (buff[o + cols] & 255) + (buff[o + cols + 1] & 255) + (buff[o + cols + 2] & 255) + (buff[o + cols * 2 + 1] & 255)) / 2;
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) {
                return;
            }
            o = cols + pos - 1;
            idx = (buff[o] & 255) + (buff[o + 1] & 255) + (buff[o + 2] & 255) + (buff[o + cols + 1] & 255);
            if ((buff[o + cols + 1] & 255) > 96) {
                idx = (idx + (buff[o + cols] & 255) + (buff[o + cols + 1] & 255) + (buff[o + cols + 2] & 255) + (buff[o + cols * 2 + 1] & 255)) / 2;
            }
            buff[pos] = this.CoolTable[idx];
            if (++pos >= size) break;
        }
    }

    private void UpdateTile(byte[] pCLU, DynamicArtEntry picFire) {
        byte[] pTile = picFire.getBytes();
        int k = 0;
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                pTile[i + j * 128] = pCLU[this.FrameBuffer[k] & 0xFF];
                ++k;
            }
        }
        picFire.invalidate();
    }
}

