/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Fonts;

import java.io.InputStream;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Fonts.QFont;
import ru.m210projects.Blood.Main;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class QFNFont
extends Font {
    private final int nTile;
    private QFont pQFN;

    public QFNFont(int nTile, int nFontId) {
        this.nTile = nTile;
        BloodRenderer renderer = Main.game.getRenderer();
        Entry hQFN = Main.game.getCache().getEntry(nFontId, "qfn");
        if (hQFN.exists()) {
            try (InputStream is = hQFN.getInputStream();){
                this.pQFN = new QFont(is);
                this.size = this.pQFN.height & 0xFF;
                for (int i = 0; i < 96; ++i) {
                    this.pQFN.buildChar(this.nTile, i);
                    ArtEntry pic = renderer.getTile(nTile + i);
                    if (pic.getWidth() == 0) continue;
                    if (i == 0) {
                        this.addCharInfo((char)(i + 32), new CharInfo((Font)this, nTile + i, 1.0f, renderer.getTile(nTile).getWidth() + this.pQFN.charSpace));
                        continue;
                    }
                    this.addCharInfo((char)(i + 32), new CharInfo(this, nTile + i, 1.0f, pic.getWidth() + this.pQFN.charSpace, pic.getWidth(), 0, 0));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void rebuildChar() {
        if (this.pQFN != null) {
            for (int i = 0; i < 96; ++i) {
                this.pQFN.buildChar(this.nTile, (char)(i + 32));
            }
        }
    }
}

