/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.GIBFX;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.THINKFX;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;

public class Gib {
    public static final THINKFX[] kThinkFXHuman = new THINKFX[]{new THINKFX(425, 1454, 917504, 300, 900), new THINKFX(425, 1454, 917504, 300, 900), new THINKFX(425, 1267, 917504, 300, 900), new THINKFX(425, 1267, 917504, 300, 900), new THINKFX(425, 1268, 917504, 300, 900), new THINKFX(425, 1269, 917504, 300, 900), new THINKFX(425, 1456, 917504, 300, 900)};
    public static final THINKFX[] kThinkFXMime = new THINKFX[]{new THINKFX(425, 2405, 917504, 300, 900), new THINKFX(425, 2405, 917504, 300, 900), new THINKFX(425, 2404, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXHound = new THINKFX[]{new THINKFX(425, 1326, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXGargoyle = new THINKFX[]{new THINKFX(425, 1369, 917504, 300, 900), new THINKFX(425, 1361, 917504, 300, 900), new THINKFX(425, 1268, 32768, 300, 900), new THINKFX(425, 1269, 32768, 300, 900), new THINKFX(425, 1456, 32768, 300, 900)};
    public static final THINKFX[] kThinkFXZombie = new THINKFX[]{new THINKFX(427, 3405, 917504, 0, 0)};
    public static final GIBFX[] kGibFXGlassT = new GIBFX[]{new GIBFX(18, 0, 65536, 3, 200, 400), new GIBFX(31, 0, 32768, 5, 200, 400)};
    public static final GIBFX[] kGibFXGlassS = new GIBFX[]{new GIBFX(18, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBurnShard = new GIBFX[]{new GIBFX(16, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXWoodShard = new GIBFX[]{new GIBFX(17, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXMetalShard = new GIBFX[]{new GIBFX(30, 0, 65536, 12, 500, 1000)};
    public static final GIBFX[] kGibFXFireSpark = new GIBFX[]{new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXShockSpark = new GIBFX[]{new GIBFX(15, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXBloodChunks = new GIBFX[]{new GIBFX(13, 0, 65536, 8, 90, 600)};
    public static final GIBFX[] kGibFXFlames2 = new GIBFX[]{new GIBFX(56, 0, 65536, 8, 100, 0)};
    public static final GIBFX[] kGibFXFlames1 = new GIBFX[]{new GIBFX(32, 0, 65536, 8, 100, 0)};
    public static final GIBFX[] kGibFXBubblesS = new GIBFX[]{new GIBFX(25, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBubblesM = new GIBFX[]{new GIBFX(24, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXBubblesL = new GIBFX[]{new GIBFX(23, 0, 65536, 8, 200, 400)};
    public static final GIBFX[] kGibFXIcicles = new GIBFX[]{new GIBFX(31, 0, 65536, 15, 200, 400)};
    public static final GIBFX[] kGibFXGlassCombo1 = new GIBFX[]{new GIBFX(18, 0, 65536, 15, 200, 400), new GIBFX(31, 0, 65536, 10, 200, 400)};
    public static final GIBFX[] kGibFXGlassCombo2 = new GIBFX[]{new GIBFX(18, 0, 65536, 5, 200, 400), new GIBFX(20, 0, 53248, 5, 200, 400), new GIBFX(21, 0, 53248, 5, 200, 400), new GIBFX(19, 0, 53248, 5, 200, 400), new GIBFX(22, 0, 53248, 5, 200, 400)};
    public static final GIBFX[] kGibFXWoodCombo = new GIBFX[]{new GIBFX(16, 0, 65536, 8, 500, 1000), new GIBFX(17, 0, 65536, 8, 500, 1000), new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXMedicCombo = new GIBFX[]{new GIBFX(18, 0, 32768, 7, 200, 400), new GIBFX(30, 0, 65536, 7, 500, 1000), new GIBFX(13, 0, 65536, 10, 90, 600), new GIBFX(14, 0, 32768, 7, 500, 1000)};
    public static final GIBFX[] kGibFXFlareSpark = new GIBFX[]{new GIBFX(28, 0, 32768, 15, 128, -128)};
    public static final GIBFX[] kGibFXBloodBits = new GIBFX[]{new GIBFX(13, 0, 45056, 8, 90, 600)};
    public static final GIBFX[] kGibFXRockShards = new GIBFX[]{new GIBFX(46, 0, 65536, 10, 300, 800), new GIBFX(31, 0, 32768, 10, 200, 1000)};
    public static final GIBFX[] kGibFXPaperCombo1 = new GIBFX[]{new GIBFX(47, 0, 65536, 12, 300, 600), new GIBFX(14, 0, 65536, 8, 500, 1000)};
    public static final GIBFX[] kGibFXPlantCombo1 = new GIBFX[]{new GIBFX(44, 0, 45056, 8, 400, 800), new GIBFX(45, 0, 45056, 8, 300, 800), new GIBFX(14, 0, 45056, 6, 500, 1000)};
    public static final GIBFX[] kGibFXShockGibs1 = new GIBFX[]{new GIBFX(49, 0, 65536, 4, 80, 300)};
    public static final GIBFX[] kGibFXShockGibs2 = new GIBFX[]{new GIBFX(50, 0, 65536, 4, 80, 0)};
    public static final GIBFX[] kGibFXShockGibs3 = new GIBFX[]{new GIBFX(50, 0, 65536, 20, 800, -40), new GIBFX(15, 0, 65536, 15, 400, 10)};
    public static final int kGibMax = 31;
    public static final Gib[] gGIBInfo = new Gib[]{new Gib(kGibFXGlassT, 2, null, 0, 300), new Gib(kGibFXGlassS, 1, null, 0, 300), new Gib(kGibFXBurnShard, 1, null, 0, 0), new Gib(kGibFXWoodShard, 1, null, 0, 0), new Gib(kGibFXMetalShard, 1, null, 0, 0), new Gib(kGibFXFireSpark, 1, null, 0, 0), new Gib(kGibFXShockSpark, 1, null, 0, 0), new Gib(kGibFXBloodChunks, 1, null, 0, 0), new Gib(kGibFXBubblesS, 1, null, 0, 0), new Gib(kGibFXBubblesM, 1, null, 0, 0), new Gib(kGibFXBubblesL, 1, null, 0, 0), new Gib(kGibFXIcicles, 1, null, 0, 0), new Gib(kGibFXGlassCombo1, 2, null, 0, 300), new Gib(kGibFXGlassCombo2, 5, null, 0, 300), new Gib(kGibFXWoodCombo, 3, null, 0, 0), new Gib(null, 0, kThinkFXHuman, 7, 0), new Gib(kGibFXMedicCombo, 4, null, 0, 0), new Gib(kGibFXFlareSpark, 1, null, 0, 0), new Gib(kGibFXBloodBits, 1, null, 0, 0), new Gib(kGibFXRockShards, 2, null, 0, 0), new Gib(kGibFXPaperCombo1, 2, null, 0, 0), new Gib(kGibFXPlantCombo1, 3, null, 0, 0), new Gib(kGibFXShockGibs1, 1, null, 0, 0), new Gib(kGibFXShockGibs2, 1, null, 0, 0), new Gib(kGibFXShockGibs3, 2, null, 0, 0), new Gib(kGibFXFlames1, 1, null, 0, 0), new Gib(kGibFXFlames2, 1, null, 0, 0), new Gib(null, 0, kThinkFXZombie, 1, 0), new Gib(null, 0, kThinkFXMime, 6, 0), new Gib(null, 0, kThinkFXHound, 4, 0), new Gib(null, 0, kThinkFXGargoyle, 5, 0)};
    public static Vector3 startVel = new Vector3();
    public static Vector3 startPos = new Vector3();
    THINKFX[] kThinkFX;
    int nThinkFX;
    GIBFX[] kGibFX;
    int nGibFx;
    int nSoundId;

    public Gib(GIBFX[] kGibFX, int nGibFx, THINKFX[] kThinkFX, int nThinkFX, int nSoundId) {
        this.kThinkFX = kThinkFX;
        this.nThinkFX = nThinkFX;
        this.kGibFX = kGibFX;
        this.nGibFx = nGibFx;
        this.nSoundId = nSoundId;
    }

    public static void actGenerateGibs(Sprite pSprite, int nGibType, Vector3 startPos, Vector3 startVel) {
        if (pSprite == null) {
            throw new AssertException("pSprite != null");
        }
        if (nGibType < 0 || nGibType >= 31) {
            throw new AssertException("nGibType >= 0 && nGibType < kGibMax");
        }
        if (pSprite.getSectnum() >= 0 && pSprite.getSectnum() < Main.boardService.getSectorCount()) {
            Gib pGib = gGIBInfo[nGibType];
            for (int nGib = 0; nGib < pGib.nGibFx; ++nGib) {
                GIBFX pGibFX = pGib.kGibFX[nGib];
                if (pGibFX.Chance <= 0) {
                    throw new AssertException("pGibFX.Chance > 0");
                }
                Gib.actGenerateGibFX(pSprite, pGibFX, startPos, startVel);
            }
            for (int nThink = 0; nThink < pGib.nThinkFX; ++nThink) {
                THINKFX pGibThing = pGib.kThinkFX[nThink];
                if (pGibThing.Chance <= 0) {
                    throw new AssertException("pGibThing.Chance > 0");
                }
                Gib.actGenerateThinkFX(pSprite, pGibThing, startPos, startVel);
            }
        }
    }

    public static void actGenerateGibFX(Sprite pSprite, GIBFX pGibFX, Vector3 startPos, Vector3 startVel) {
        if (!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0 || pGibFX.nType != 13) {
            int x = pSprite.getX();
            int y = pSprite.getY();
            int z = pSprite.getZ();
            if (startPos != null) {
                x = (int)startPos.x;
                y = (int)startPos.y;
                z = (int)startPos.z;
            }
            Main.engine.getzsofslope(pSprite.getSectnum(), x, y, Globals.floorz, Globals.ceilz);
            int quantity = Gib.gibCalcQuantity(pGibFX.Chance, pGibFX.Quantity);
            int fz = Globals.floorz.get() - z;
            int cz = z - Globals.ceilz.get();
            Gameutils.GetSpriteExtents(pSprite);
            for (int i = 0; i < quantity; ++i) {
                int sprZVel;
                BloodSprite pSpawn;
                if (startPos == null && (pSprite.getCstat() & 0x30) == 0) {
                    int nAngle = Gameutils.Random(2048);
                    x = pSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), (long)pSprite.getClipdist() << 2, 30);
                    y = pSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), (long)pSprite.getClipdist() << 2, 30);
                    z = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
                }
                if ((pSpawn = Actor.actSpawnEffect(pGibFX.nType, pSprite.getSectnum(), x, y, z, 0)) == null) continue;
                if (pSpawn.getPal() < 0) {
                    pSpawn.setPal(pSprite.getPal());
                }
                if (startVel != null) {
                    pSpawn.setVelocity(Gameutils.BiRandom(pGibFX.Velocity) + (int)startVel.x / 2, Gameutils.BiRandom(pGibFX.Velocity) + (int)startVel.y / 2, (int)startVel.z - Gameutils.Random(pGibFX.zVelocity));
                    continue;
                }
                int vel = Pragmas.divscale(pGibFX.Velocity, 120L, 18);
                int zvel = Pragmas.divscale(pGibFX.zVelocity, 120L, 18);
                int sprXVel = Gameutils.BiRandom(vel);
                int sprYVel = Gameutils.BiRandom(vel);
                if ((pSprite.getCstat() & 0x30) == 16) {
                    sprZVel = Gameutils.BiRandom(zvel);
                } else if (fz <= cz || cz >= 16384) {
                    if (fz >= cz || fz >= 16384) {
                        if (zvel >= 0) {
                            sprZVel = Gameutils.BiRandom(zvel);
                        } else {
                            zvel = Pragmas.divscale(Pragmas.klabs(pGibFX.zVelocity), 120L, 18);
                            sprZVel = -Gameutils.Random(zvel);
                        }
                    } else {
                        zvel = Pragmas.divscale(Pragmas.klabs(pGibFX.zVelocity), 120L, 18);
                        sprZVel = -Gameutils.Random(zvel);
                    }
                } else {
                    sprZVel = 0;
                }
                pSpawn.setVelocity(sprXVel, sprYVel, sprZVel);
            }
        }
    }

    public static void actGenerateThinkFX(Sprite pSprite, THINKFX pGibThing, Vector3 startPos, Vector3 startVel) {
        if ((!Main.cfg.gParentalLock || Globals.pGameInfo.nGameType > 0 || pGibThing.nType < 425 || pGibThing.nType > 425 && pGibThing.nType != 427) && (pGibThing.Chance == 65536 || Gameutils.Chance(pGibThing.Chance >> 1))) {
            int z;
            int y;
            int x;
            Gameutils.GetSpriteExtents(pSprite);
            if (startPos != null) {
                x = (int)startPos.x;
                y = (int)startPos.y;
                z = (int)startPos.z;
            } else {
                int nAngle = Gameutils.Random(2048);
                x = pSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), (long)pSprite.getClipdist() << 2, 30);
                y = pSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), (long)pSprite.getClipdist() << 2, 30);
                z = Gameutils.extents_zBot - Gameutils.Random(Gameutils.extents_zBot - Gameutils.extents_zTop);
            }
            Main.engine.getzsofslope(pSprite.getSectnum(), x, y, Globals.floorz, Globals.ceilz);
            int fz = Globals.floorz.get() - z;
            int cz = z - Globals.ceilz.get();
            BloodSprite pSpawn = Actor.actSpawnThing(pSprite.getSectnum(), x, y, z, pGibThing.nType);
            if (pSpawn == null) {
                throw new AssertException("pSpawn != null");
            }
            if (pGibThing.nTile > -1) {
                pSpawn.setPicnum((short)pGibThing.nTile);
            }
            if (startVel != null) {
                pSpawn.setVelocity(Gameutils.BiRandom(pGibThing.Velocity) + (int)startVel.x, Gameutils.BiRandom(pGibThing.Velocity) + (int)startVel.y, (int)startVel.z - Gameutils.Random(pGibThing.zVelocity));
            } else {
                int vel = Pragmas.divscale(pGibThing.Velocity, 120L, 18);
                int zvel = Pragmas.divscale(pGibThing.zVelocity, 120L, 18);
                int sprXVel = Gameutils.BiRandom(vel);
                int sprYVel = Gameutils.BiRandom(vel);
                int sprZVel = (pSprite.getCstat() & 0x30) == 16 ? Gameutils.BiRandom(Pragmas.divscale(pGibThing.zVelocity, 120L, 18)) : (fz <= cz || cz >= 16384 ? (fz >= cz || fz >= 16384 ? Gameutils.BiRandom(zvel) : -Gameutils.Random(zvel)) : 0);
                pSpawn.setVelocity(sprXVel, sprYVel, sprZVel);
            }
        }
    }

    public static int gibCalcQuantity(int Chance, int Quantity) {
        int out = Quantity;
        if (Chance < 65536) {
            for (int i = 0; i < Quantity; ++i) {
                if (Gameutils.Chance(Chance / 2)) continue;
                --out;
            }
        }
        return out;
    }

    public static void walGenerateGib(int nWall, int nGibType, Vector3 startVel) {
        if (nWall < 0 || nWall >= Main.boardService.getWallCount()) {
            throw new AssertException("nWall >= 0 && nWall < numwalls");
        }
        if (nGibType < 0 || nGibType >= 31) {
            throw new AssertException("nGibType >= 0 && nGibType < kGibMax");
        }
        Wall pWall = Main.boardService.getWall(nWall);
        int cx = (Main.boardService.getWall(pWall.getPoint2()).getX() + pWall.getX()) / 2;
        int cy = (Main.boardService.getWall(pWall.getPoint2()).getY() + pWall.getY()) / 2;
        int nSector = Main.engine.sectorofwall((short)nWall);
        Main.engine.getzsofslope((short)nSector, cx, cy, Globals.floorz, Globals.ceilz);
        int floorz = Globals.floorz.get();
        int ceilz = Globals.ceilz.get();
        if (pWall.getNextsector() != -1) {
            Main.engine.getzsofslope(pWall.getNextsector(), cx, cy, Globals.floorz, Globals.ceilz);
        }
        int nextfloorz = Globals.floorz.get();
        int nextceilz = Globals.ceilz.get();
        int cz = Math.max(ceilz, nextceilz);
        int fz = Math.min(floorz, nextfloorz);
        int dx = Main.boardService.getWall(pWall.getPoint2()).getX() - pWall.getX();
        int dy = Main.boardService.getWall(pWall.getPoint2()).getY() - pWall.getY();
        int dz = fz - cz;
        Gib pGib = gGIBInfo[nGibType];
        SOUND.sfxCreate3DSound(cx, cy, fz + cz >> 1, pGib.nSoundId, nSector);
        for (int nGib = 0; nGib < pGib.nGibFx; ++nGib) {
            GIBFX pGibFX = pGib.kGibFX[nGib];
            if (pGibFX.Chance <= 0) {
                throw new AssertException("pGibFX.Chance > 0");
            }
            Gib.walGenerateGibFX(nWall, pGibFX, cz, dx, dy, dz, startVel);
        }
    }

    public static void walGenerateGibFX(int nWall, GIBFX pGibFX, int cz, int dx, int dy, int dz, Vector3 startVel) {
        if (nWall < 0 || nWall >= Main.boardService.getWallCount()) {
            throw new AssertException("nWall >= 0 && nWall < numwalls");
        }
        Wall pWall = Main.boardService.getWall(nWall);
        int nSector = Main.engine.sectorofwall((short)nWall);
        int quantity = Gib.gibCalcQuantity(pGibFX.Chance, pGibFX.Quantity);
        for (int i = 0; i < quantity; ++i) {
            int wallz = cz + Gameutils.Random(dz);
            int wally = pWall.getY() + Gameutils.Random(dy);
            int wallx = pWall.getX() + Gameutils.Random(dx);
            BloodSprite pSpawn = Actor.actSpawnEffect(pGibFX.nType, (short)nSector, wallx, wally, wallz, 0);
            if (pSpawn == null) continue;
            if (pSpawn.getPal() < 0) {
                pSpawn.setPal((byte)pWall.getPal());
            }
            if (startVel != null) {
                pSpawn.setVelocity(Gameutils.BiRandom(Pragmas.divscale((int)startVel.x, 120L, 18)), Gameutils.BiRandom(Pragmas.divscale((int)startVel.y, 120L, 18)), -Gameutils.Random(Pragmas.divscale((int)startVel.z, 120L, 18)));
                continue;
            }
            pSpawn.setVelocity(Gameutils.BiRandom(Pragmas.divscale(pGibFX.Velocity, 120L, 18)), Gameutils.BiRandom(Pragmas.divscale(pGibFX.Velocity, 120L, 18)), -Gameutils.Random(Pragmas.divscale(pGibFX.zVelocity, 120L, 18)));
        }
    }
}

