/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodBoard;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuCorruptGame;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Blood.RXBUCKET;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.LSInfo;
import ru.m210projects.Blood.Types.POSTPONE;
import ru.m210projects.Blood.Types.SafeLoader;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.SpriteInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.BloodSaveHeader;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.SaveReader;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class LOADSAVE {
    public static final String savsign = "BLUD";
    public static final int gdxSave = 302;
    public static final int currentGdxSave = 304;
    public static final int SAVETIME = 8;
    public static final int SAVENAME = 16;
    public static final int SAVELEVELINFO = 9;
    public static final int SAVESCREENSHOTSIZE = 64000;
    public static final int SAVEGDXDATA = 128;
    public static final char[] filenum = new char[4];
    private static final SafeLoader loader = new SafeLoader();
    public static boolean gQuickSaving;
    public static boolean gAutosaveRequest;
    public static LSInfo lsInf;
    public static int quickslot;
    public static FileEntry lastload;
    SaveReader saveReader = new SaveReader(Main.engine, "BLUD", 304){

        @Override
        protected SaveReader.SaveHeader getNewHeader(String saveName) {
            return new BloodSaveHeader();
        }
    };

    public static void FindSaves(Directory dir) {
        for (Entry file : dir) {
            if (!file.isExtension("sav") || !(file instanceof FileEntry)) continue;
            try {
                InputStream is = file.getInputStream();
                try {
                    short nVersion;
                    String signature = StreamUtils.readString(is, 4);
                    if (signature.isEmpty() || !signature.equals(savsign) || (nVersion = StreamUtils.readShort(is)) < 302) continue;
                    StreamUtils.skip(is, 4);
                    long time = StreamUtils.readLong(is);
                    String savname = StreamUtils.readString(is, 16);
                    Main.game.pSavemgr.add(savname, time, (FileEntry)file);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        Main.game.pSavemgr.sort();
    }

    public static String makeNum(int num) {
        LOADSAVE.filenum[3] = (char)(num % 10 + 48);
        LOADSAVE.filenum[2] = (char)(num / 10 % 10 + 48);
        LOADSAVE.filenum[1] = (char)(num / 100 % 10 + 48);
        LOADSAVE.filenum[0] = (char)(num / 1000 % 10 + 48);
        return new String(filenum);
    }

    public static void savegame(Directory dir, String savename, String filename) {
        block9: {
            FileEntry file = dir.getEntry(filename);
            if (file.exists() && !file.delete()) {
                View.viewSetMessage("Game not saved. Access denied!", -1, 7);
                return;
            }
            Path path = dir.getPath().resolve(filename);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                long time = Main.game.date.getCurrentDate();
                LOADSAVE.save(os, savename, time);
                file = dir.addEntry(path);
                if (file.exists()) {
                    Main.game.pSavemgr.add(savename, time, file);
                    lastload = file;
                    View.viewSetMessage("Game saved", -1, 10);
                    break block9;
                }
                throw new FileNotFoundException(filename);
            }
            catch (Exception e) {
                View.viewSetMessage("Game not saved! " + e, -1, 7);
            }
        }
    }

    private static void save(OutputStream os, String savename, long time) throws Exception {
        LOADSAVE.SaveVersion(os, 304);
        LOADSAVE.SaveInfo(os, savename, time);
        LOADSAVE.SaveGDXBlock(os);
        LOADSAVE.MySave110(os);
        StreamUtils.writeByte(os, Globals.cheatsOn ? 1 : 0);
        LOADSAVE.WarpSave(os);
        LOADSAVE.MirrorSave(os);
        LOADSAVE.SeqSave(os);
        LOADSAVE.EventSave(os);
        LOADSAVE.TriggersSave(os);
        LOADSAVE.PlayersSave(os, 304);
        LOADSAVE.ActorsSave(os);
        StreamUtils.writeInt(os, LEVELS.gNextMap);
        LOADSAVE.StatsSave(os);
        LOADSAVE.ScreenSave(os);
        os.flush();
    }

    public static void SaveInfo(OutputStream os, String savename, long time) throws IOException {
        StreamUtils.writeLong(os, time);
        StreamUtils.writeString(os, savename, 16);
        StreamUtils.writeByte(os, Globals.pGameInfo.nDifficulty);
        StreamUtils.writeInt(os, Globals.pGameInfo.nEpisode);
        StreamUtils.writeInt(os, Globals.pGameInfo.nLevel);
        LOADSAVE.SaveScreenshot(os);
        LOADSAVE.SaveUserEpisodeInfo(os);
    }

    public static void SaveGDXBlock(OutputStream os) throws IOException {
        ByteBuffer gdxDataBuffer = ByteBuffer.allocate(128);
        gdxDataBuffer.put((byte)Globals.pGameInfo.nEnemyDamage);
        gdxDataBuffer.put((byte)Globals.pGameInfo.nEnemyQuantity);
        gdxDataBuffer.put((byte)Globals.pGameInfo.nDifficulty);
        gdxDataBuffer.put((byte)(Globals.pGameInfo.nPitchforkOnly ? 1 : 0));
        gdxDataBuffer.put((byte)(Globals.gInfiniteAmmo ? 1 : 0));
        StreamUtils.writeBytes(os, gdxDataBuffer.array());
    }

    public static void SaveUserEpisodeInfo(OutputStream os) throws IOException {
        StreamUtils.writeBoolean(os, Main.mUserFlag == Main.UserFlag.Addon);
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            if (LEVELS.currentEpisode != null && LEVELS.currentEpisode.iniFile != null) {
                EpisodeEntry episodeEntry = LEVELS.currentEpisode.iniFile.getEpisodeEntry();
                boolean isPacked = episodeEntry.isPackageEpisode();
                StreamUtils.writeBoolean(os, isPacked);
                StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
                if (isPacked) {
                    StreamUtils.writeDataString(os, episodeEntry.getIniFile().getName());
                }
            } else {
                StreamUtils.writeBoolean(os, false);
                StreamUtils.writeInt(os, 0L);
            }
        }
    }

    public static void SaveScreenshot(OutputStream os) throws IOException {
        StreamUtils.writeBytes(os, Main.gGameScreen.captBuffer);
        Main.gGameScreen.captBuffer = null;
    }

    public static void SaveVersion(OutputStream os, int nVersion) throws IOException {
        StreamUtils.writeString(os, savsign);
        StreamUtils.writeShort(os, nVersion);
        StreamUtils.writeInt(os, 4L);
    }

    public static void MySave110(OutputStream os) throws IOException {
        int i;
        int i2;
        BloodRenderer renderer = Main.game.getRenderer();
        LOADSAVE.GameInfoSave(os);
        Board board = Main.boardService.getBoard();
        int numsectors = Main.boardService.getSectorCount();
        int numwalls = Main.boardService.getWallCount();
        int numsprites = Main.boardService.getSpriteCount();
        StreamUtils.writeInt(os, numsectors);
        StreamUtils.writeInt(os, numwalls);
        StreamUtils.writeInt(os, numsprites);
        for (i2 = 0; i2 < numsectors + 1; ++i2) {
            Main.boardService.getSector(i2).writeObject(os);
        }
        for (i2 = 0; i2 < numwalls + 4; ++i2) {
            Main.boardService.getWall(i2).writeObject(os);
        }
        List<Sprite> sprites = board.getSprites();
        for (Sprite spr : sprites) {
            spr.writeObject(os);
            if (spr.getStatnum() >= 1024 || spr.getExtra() < 0) continue;
            XSPRITE pXSprite = Main.boardService.getXSprite(spr.getExtra());
            pXSprite.writeObject(os);
            pXSprite.getSpriteHit().writeObject(os);
            pXSprite.getSeqInst().writeObject(os);
            pXSprite.getDudeExtra().writeObject(os);
        }
        StreamUtils.writeInt(os, Gameutils.bseed);
        StreamUtils.writeByte(os, 0);
        StreamUtils.writeByte(os, 0);
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeInt(os, renderer.getParallaxScale());
        StreamUtils.writeInt(os, Engine.visibility);
        StreamUtils.writeInt(os, Engine.parallaxvisibility);
        for (i = 0; i < 256; ++i) {
            StreamUtils.writeShort(os, Engine.pskyoff[i]);
        }
        StreamUtils.writeShort(os, Engine.pskybits);
        Engine.show2dsector.writeObject(os);
        Engine.show2dwall.writeObject(os);
        Engine.show2dsprite.writeObject(os);
        StreamUtils.writeByte(os, Engine.automapping);
        StreamUtils.writeInt(os, Globals.gFrameClock);
        StreamUtils.writeInt(os, Globals.gTicks);
        StreamUtils.writeInt(os, Globals.gFrame);
        StreamUtils.writeInt(os, Main.engine.getTotalClock());
        StreamUtils.writeByte(os, Main.game.gPaused ? 1 : 0);
        for (i = 0; i < numwalls; ++i) {
            StreamUtils.writeInt(os, (int)Trigger.kwall[i].x);
            StreamUtils.writeInt(os, (int)Trigger.kwall[i].y);
        }
        for (i = 0; i < numsectors; ++i) {
            StreamUtils.writeInt(os, Trigger.secFloorZ[i]);
        }
        for (i = 0; i < numsectors; ++i) {
            StreamUtils.writeInt(os, Trigger.secCeilZ[i]);
        }
        for (i = 0; i < numsectors; ++i) {
            StreamUtils.writeInt(os, (int)Actor.floorVel[i]);
        }
        for (i = 0; i < numsectors; ++i) {
            StreamUtils.writeInt(os, (int)Actor.ceilingVel[i]);
        }
        StreamUtils.writeShort(os, Engine.pHitInfo.hitsect);
        StreamUtils.writeShort(os, Engine.pHitInfo.hitwall);
        StreamUtils.writeShort(os, Engine.pHitInfo.hitsprite);
        StreamUtils.writeInt(os, Engine.pHitInfo.hitx);
        StreamUtils.writeInt(os, Engine.pHitInfo.hity);
        StreamUtils.writeInt(os, Engine.pHitInfo.hitz);
        StreamUtils.writeByte(os, Main.mUserFlag == Main.UserFlag.UserMap ? 1 : 0);
        StreamUtils.writeString(os, "Copyright 1997 Monolith Productions.", 128);
        for (i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, (short)DB.nextXWall[i]);
        }
        for (i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, (short)DB.nextXSector[i]);
        }
        for (i = 0; i < numwalls; ++i) {
            if (Main.boardService.getWall(i).getExtra() <= 0) continue;
            DB.xwall[Main.boardService.getWall(i).getExtra()].writeObject(os);
        }
        for (i = 0; i < numsectors; ++i) {
            if (Main.boardService.getSector(i).getExtra() <= 0) continue;
            DB.xsector[Main.boardService.getSector(i).getExtra()].writeObject(os);
        }
        StreamUtils.writeInt(os, DB.gSkyCount);
        StreamUtils.writeByte(os, Main.engine.getPaletteManager().isFogMode() ? 1 : 0);
    }

    public static void WarpSave(OutputStream os) throws IOException {
        int i;
        for (i = 0; i < 8; ++i) {
            StreamUtils.writeInt(os, Warp.gStartZone[i].x);
            StreamUtils.writeInt(os, Warp.gStartZone[i].y);
            StreamUtils.writeInt(os, Warp.gStartZone[i].z);
            StreamUtils.writeShort(os, (short)Warp.gStartZone[i].sector);
            StreamUtils.writeShort(os, (short)Warp.gStartZone[i].angle);
        }
        for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
            StreamUtils.writeInt(os, (short)Warp.gUpperLink[i]);
            StreamUtils.writeInt(os, (short)Warp.gLowerLink[i]);
        }
    }

    public static void MirrorSave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeInt(os, Mirror.mirrorcnt);
        StreamUtils.writeInt(os, Mirror.MirrorSector);
        for (i = 0; i < 16; ++i) {
            StreamUtils.writeShort(os, (short)Mirror.MirrorType[i]);
            StreamUtils.writeInt(os, Mirror.MirrorLower[i]);
            StreamUtils.writeInt(os, Mirror.MirrorX[i]);
            StreamUtils.writeInt(os, Mirror.MirrorY[i]);
            StreamUtils.writeInt(os, Mirror.MirrorZ[i]);
            StreamUtils.writeInt(os, Mirror.MirrorUpper[i]);
        }
        for (i = 0; i < 4; ++i) {
            StreamUtils.writeInt(os, Mirror.MirrorWall[i]);
        }
    }

    public static void SeqSave(OutputStream os) throws IOException {
        int i;
        for (i = 0; i < 512; ++i) {
            SeqHandling.siWall[i].writeObject(os);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siMasked[i].writeObject(os);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siCeiling[i].writeObject(os);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siFloor[i].writeObject(os);
        }
        StreamUtils.writeInt(os, SeqHandling.activeList.getSize());
        for (i = 0; i < SeqHandling.activeList.getSize(); ++i) {
            SeqInst pInst = SeqHandling.activeList.getInst(i);
            if (pInst instanceof WallInst) {
                StreamUtils.writeByte(os, 0);
            } else if (pInst instanceof MaskedWallInst) {
                StreamUtils.writeByte(os, 4);
            } else if (pInst instanceof FloorInst) {
                StreamUtils.writeByte(os, 2);
            } else if (pInst instanceof CeilingInst) {
                StreamUtils.writeByte(os, 1);
            } else if (pInst instanceof SpriteInst) {
                StreamUtils.writeByte(os, 3);
            } else {
                StreamUtils.writeByte(os, -1);
            }
            StreamUtils.writeShort(os, SeqHandling.activeList.getIndex(i));
        }
    }

    public static void EventSave(OutputStream os) throws IOException {
        int i;
        EVENT.eventQ.writeObject(os);
        for (i = 0; i < 4096; ++i) {
            StreamUtils.writeInt(os, EVENT.getEvent(EVENT.rxBucket[i].index, EVENT.rxBucket[i].type, 0, 0));
        }
        for (i = 0; i <= 1024; ++i) {
            StreamUtils.writeShort(os, EVENT.bucketHead[i]);
        }
    }

    public static void TriggersSave(OutputStream os) throws IOException {
        int i;
        StreamUtils.writeInt(os, Trigger.gBusyCount);
        for (i = 0; i < 128; ++i) {
            StreamUtils.writeInt(os, Trigger.gBusy[i].nIndex);
            StreamUtils.writeInt(os, Trigger.gBusy[i].nDelta);
            StreamUtils.writeInt(os, Trigger.gBusy[i].nBusy);
            StreamUtils.writeByte(os, (byte)Trigger.gBusy[i].busyProc);
        }
        for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
            StreamUtils.writeInt(os, Trigger.secPath[i]);
        }
    }

    public static void PlayersSave(OutputStream os, int nVersion) throws IOException {
        int i;
        for (i = 0; i < 8; ++i) {
            StreamUtils.writeInt(os, Globals.nTeamCount[i]);
        }
        StreamUtils.writeInt(os, Mmulti.numplayers);
        for (i = 0; i < 8; ++i) {
            StreamUtils.writeByte(os, Main.game.net.gProfile[i].autoaim ? 1 : 0);
            if (nVersion >= 304) {
                StreamUtils.writeByte(os, Main.game.net.gProfile[i].slopetilt ? 1 : 0);
            }
            StreamUtils.writeByte(os, Main.game.net.gProfile[i].skill);
            StreamUtils.writeString(os, Main.game.net.gProfile[i].name, 15);
        }
        for (i = 0; i < 8; ++i) {
            Globals.gPlayer[i].pInput.writeObject(os, nVersion);
            Globals.gPlayer[i].setVersion(nVersion).writeObject(os);
        }
    }

    public static void ActorsSave(OutputStream os) throws IOException {
        int i;
        for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
            StreamUtils.writeShort(os, (short)Actor.gSectorExp[i]);
        }
        for (i = 0; i < 512; ++i) {
            StreamUtils.writeShort(os, (short)Actor.gWallExp[i]);
        }
        StreamUtils.writeInt(os, Actor.gPost.getSize());
        for (i = 0; i < Actor.gPost.getSize(); ++i) {
            StreamUtils.writeInt(os, Actor.gPost.get((int)i).nSprite);
            StreamUtils.writeInt(os, Actor.gPost.get((int)i).nStatus);
        }
    }

    public static void GameInfoSave(OutputStream os) throws IOException {
        StreamUtils.writeByte(os, Globals.pGameInfo.nGameType);
        StreamUtils.writeByte(os, Globals.pGameInfo.nDifficulty);
        StreamUtils.writeInt(os, Globals.pGameInfo.nEpisode);
        StreamUtils.writeInt(os, Globals.pGameInfo.nLevel);
        if (Globals.pGameInfo.zLevelName instanceof FileEntry) {
            StreamUtils.writeString(os, ((FileEntry)Globals.pGameInfo.zLevelName).getRelativePath().toString(), 144);
        } else {
            StreamUtils.writeString(os, Globals.pGameInfo.zLevelName.getName(), 144);
        }
        StreamUtils.writeString(os, Globals.pGameInfo.zLevelSong, 144);
        StreamUtils.writeInt(os, Globals.pGameInfo.nTrackNumber);
        StreamUtils.writeInt(os, (int)Globals.pGameInfo.uMapCRC);
        StreamUtils.writeByte(os, Globals.pGameInfo.nMonsterSettings);
        StreamUtils.writeInt(os, Globals.pGameInfo.uGameFlags);
        StreamUtils.writeInt(os, Globals.pGameInfo.uNetGameFlags);
        StreamUtils.writeByte(os, Globals.pGameInfo.nWeaponSettings);
        StreamUtils.writeByte(os, Globals.pGameInfo.nItemSettings);
        StreamUtils.writeByte(os, Globals.pGameInfo.nRespawnSettings);
        StreamUtils.writeByte(os, Globals.pGameInfo.nTeamSettings);
        StreamUtils.writeInt(os, Globals.pGameInfo.nMonsterRespawnTime);
        StreamUtils.writeInt(os, Globals.pGameInfo.nWeaponRespawnTime);
        StreamUtils.writeInt(os, Globals.pGameInfo.nItemRespawnTime);
        StreamUtils.writeInt(os, Globals.pGameInfo.nSpecialRespawnTime);
    }

    public static void StatsSave(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, LEVELS.totalSecrets);
        StreamUtils.writeInt(os, LEVELS.foundSecret);
        StreamUtils.writeInt(os, LEVELS.superSecrets);
        StreamUtils.writeInt(os, LEVELS.totalKills);
        StreamUtils.writeInt(os, LEVELS.kills);
    }

    public static void ScreenSave(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, View.deliriumTilt);
        StreamUtils.writeInt(os, View.deliriumTurn);
        StreamUtils.writeInt(os, View.deliriumPitch);
    }

    public static void quicksave() {
        if (Mmulti.numplayers > 1 || Globals.kFakeMultiplayer) {
            return;
        }
        if (Globals.gMe.pXsprite.getHealth() != 0) {
            gQuickSaving = true;
        }
    }

    public static boolean checkfile(InputStream is) throws IOException {
        int saveHeader = LOADSAVE.checkSave(is);
        int nVersion = saveHeader & 0xFFFF;
        if (nVersion < 302) {
            Console.out.println("Dos saved game found, version: " + nVersion);
        }
        if (nVersion != 304) {
            return false;
        }
        return loader.load(is);
    }

    public static boolean canLoad(FileEntry fil) {
        if (fil.exists()) {
            boolean bl;
            block11: {
                InputStream is = fil.getInputStream();
                try {
                    int nVersion = LOADSAVE.checkSave(is) & 0xFFFF;
                    if (nVersion != 304 && nVersion >= 302) {
                        BloodIniFile addon = loader.LoadGDXHeader(is);
                        if (LOADSAVE.loader.safeGameInfo.nLevel <= 16 && LOADSAVE.loader.safeGameInfo.nEpisode < 6 && LOADSAVE.loader.safeGameInfo.nDifficulty >= 0 && LOADSAVE.loader.safeGameInfo.nDifficulty < 5 && !LOADSAVE.loader.gForceMap) {
                            MenuCorruptGame menu = (MenuCorruptGame)Main.game.menu.mMenus[17];
                            menu.setRunnable(() -> {
                                int nEpisode = LOADSAVE.loader.safeGameInfo.nEpisode;
                                int nLevel = LOADSAVE.loader.safeGameInfo.nLevel;
                                int nSkill = LOADSAVE.loader.safeGameInfo.nDifficulty;
                                Main.gGameScreen.newgame(false, addon, nEpisode, nLevel, nSkill, nSkill, nSkill, false);
                            });
                            Main.game.menu.mOpen(menu, -1);
                        }
                    }
                    boolean bl2 = bl = nVersion == 304;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return bl;
        }
        return false;
    }

    public static void quickload() {
        if (Mmulti.numplayers > 1) {
            return;
        }
        FileEntry loadFile = Main.game.pSavemgr.getLast();
        if (LOADSAVE.canLoad(loadFile)) {
            Main.game.changeScreen(Main.gLoadingScreen.setTitle(loadFile.getName()));
            Main.gLoadingScreen.init(() -> {
                if (!LOADSAVE.loadgame(loadFile)) {
                    Main.game.setPrevScreen();
                    Main.game.pNet.ready2send = true;
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lsReadLoadData(FileEntry file) {
        if (file.exists()) {
            ArtEntry pic = Main.engine.getTile(SaveManager.Screenshot);
            if (!(pic instanceof DynamicArtEntry) || !pic.exists()) {
                pic = Main.engine.allocatepermanenttile(SaveManager.Screenshot, 320, 200);
            }
            try (InputStream is = file.getInputStream();){
                int nVersion = LOADSAVE.checkSave(is) & 0xFFFF;
                lsInf.clear();
                if (nVersion == 304) {
                    LOADSAVE.lsInf.date = Main.game.date.getDate(StreamUtils.readLong(is));
                    StreamUtils.skip(is, 16);
                    lsInf.read(is);
                    if (is.available() <= 64000) {
                        int n = -1;
                        return n;
                    }
                    StreamUtils.readBytes(is, pic.getBytes(), 64000);
                    ((DynamicArtEntry)pic).invalidate();
                    boolean gUserEpisode = StreamUtils.readBoolean(is);
                    if (gUserEpisode) {
                        String ininame;
                        boolean isPacked = StreamUtils.readBoolean(is);
                        String fullname = StreamUtils.readDataString(is);
                        if (isPacked) {
                            String ext = FileUtils.getExtension(fullname);
                            ininame = ext + ":" + Main.game.getFilename(StreamUtils.readDataString(is));
                        } else {
                            ininame = Main.game.getFilename(fullname);
                        }
                        if (!ininame.isEmpty()) {
                            LOADSAVE.lsInf.iniName = "File: " + ininame;
                        }
                    }
                    int nEnemyDamage = StreamUtils.readUnsignedByte(is) + 1;
                    int nEnemyQuantity = StreamUtils.readUnsignedByte(is) + 1;
                    int nDifficulty = StreamUtils.readUnsignedByte(is) + 1;
                    boolean nPitchforkOnly = StreamUtils.readBoolean(is);
                    if (LOADSAVE.lsInf.skill != nEnemyDamage || LOADSAVE.lsInf.skill != nEnemyQuantity || LOADSAVE.lsInf.skill != nDifficulty || nPitchforkOnly) {
                        LOADSAVE.lsInf.skill = 6;
                    }
                    lsInf.update();
                    int n = 1;
                    return n;
                }
                LOADSAVE.lsInf.info = "Incompatible ver. " + nVersion + " != " + 304;
                int n = -1;
                return n;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        lsInf.clear();
        return -1;
    }

    public static void LoadGameInfo() {
        Globals.pGameInfo.copy(LOADSAVE.loader.safeGameInfo);
    }

    public static int checkSave(InputStream is) throws IOException {
        String signature = StreamUtils.readString(is, 4);
        if (!signature.equals(savsign)) {
            return 0;
        }
        short nVersion = StreamUtils.readShort(is);
        int nBuild = StreamUtils.readInt(is);
        return nVersion | nBuild << 16;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadgame(FileEntry fil) {
        if (fil.exists()) {
            try (InputStream is = fil.getInputStream();){
                Console.out.println("debug: start loadgame()", OsdColor.BLUE);
                boolean status = LOADSAVE.checkfile(is);
                if (status) {
                    LOADSAVE.load();
                    if (lastload == null || !lastload.exists()) {
                        lastload = fil;
                    }
                    if (loader.getMessage() != null) {
                        View.viewSetMessage(loader.getMessage(), -1, 7);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                View.viewSetMessage("Incompatible version of saved game found!", -1, 7);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                Console.out.println(e.toString(), OsdColor.RED);
            }
        }
        View.viewSetMessage("Can't access to file or file not found!", -1, 7);
        return false;
    }

    public static boolean load() {
        Main.boardService.dbInit();
        SOUND.sndStopAllSamples();
        SOUND.sfxKillAll3DSounds();
        SOUND.ambStopAll();
        SeqHandling.seqKillAll();
        View.resetQuotes();
        Trigger.trInitStructs();
        LOADSAVE.LoadGDXBlock();
        LOADSAVE.MyLoad();
        LOADSAVE.WarpLoad();
        LOADSAVE.MirrorLoad();
        LOADSAVE.SeqLoad();
        LOADSAVE.EventLoad();
        LOADSAVE.TriggersLoad();
        LOADSAVE.PlayersLoad();
        LOADSAVE.ActorsLoad();
        LOADSAVE.GameInfoLoad();
        LOADSAVE.StatsLoad();
        LOADSAVE.ScreenLoad();
        LOADSAVE.LoadUserEpisodeInfo();
        Globals.cheatsOn = LOADSAVE.loader.cheatsOn;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
        Mirror.InitMirrorTiles();
        LEVELS.loadMapInfo(Globals.pGameInfo.nEpisode, Globals.pGameInfo.nLevel);
        if (Main.mUserFlag == Main.UserFlag.UserMap || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel] == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title == null) {
            Globals.boardfilename = LEVELS.gUserMapInfo.Title = Globals.pGameInfo.zLevelName.getName();
            LEVELS.gUserMapInfo.MapName = Globals.pGameInfo.zLevelName;
            LEVELS.gUserMapInfo.Song = null;
            LEVELS.gUserMapInfo.Track = 0;
        } else {
            Globals.boardfilename = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        if (!Main.game.isCurrentScreen(Main.gGameScreen) && !Main.game.isCurrentScreen(Main.gDemoScreen)) {
            Main.engine.getPaletteManager().loadPLUs(LOADSAVE.loader.gFogMode);
        }
        SECTORFX.InitSectorFX();
        SOUND.sfxResetListener();
        ((BloodNetwork)Main.game.pNet).PredictReset();
        Main.game.doPrecache(() -> {
            SOUND.ambPrepare();
            SOUND.sndPlayMusic();
            View.viewSetMessage("Game loaded", -1, 10);
            Globals.gTicks = 0;
            Globals.gFrame = 0;
            Screen.scrReset();
            View.gViewPos = 0;
            View.gViewMode = 3;
            Main.engine.getTimer().reset();
            Main.game.gPaused = false;
            Main.game.changeScreen(Main.gGameScreen);
            Main.game.pNet.ResetTimers();
            Main.game.pNet.WaitForAllPlayers(0);
            Main.game.pNet.ready2send = true;
            Main.game.nNetMode = BuildGame.NetMode.Single;
            SOUND.setReverb(false, 0.0f);
            View.PaletteView = 0;
            Main.engine.getPaletteManager().setPalette(View.PaletteView);
            if (PLAYER.powerupCheck(Globals.gMe, 18) != 0) {
                SOUND.setReverb(true, 0.2f);
            }
            if (PLAYER.powerupCheck(Globals.gMe, 24) != 0) {
                SOUND.setReverb(true, 0.4f);
            }
            Console.out.println("debug: end loadgame()", OsdColor.BLUE);
        });
        return true;
    }

    public static void LoadGDXBlock() {
        Globals.pGameInfo.nEnemyDamage = LOADSAVE.loader.safeGameInfo.nEnemyDamage;
        Globals.pGameInfo.nEnemyQuantity = LOADSAVE.loader.safeGameInfo.nEnemyQuantity;
        Globals.pGameInfo.nDifficulty = LOADSAVE.loader.safeGameInfo.nDifficulty;
        Globals.pGameInfo.nPitchforkOnly = LOADSAVE.loader.safeGameInfo.nPitchforkOnly;
        Globals.gInfiniteAmmo = LOADSAVE.loader.gInfiniteAmmo;
    }

    public static void MyLoad() {
        int i;
        LOADSAVE.LoadGameInfo();
        BloodBoard board = new BloodBoard(null, Arrays.copyOf(LOADSAVE.loader.sector.toArray(new Sector[0]), LOADSAVE.loader.numsectors + 1), Arrays.copyOf(LOADSAVE.loader.wall.toArray(new Wall[0]), LOADSAVE.loader.numwalls + 4), LOADSAVE.loader.sprite);
        board.setSecrets(LOADSAVE.loader.totalSecrets);
        board.setVisibility(LOADSAVE.loader.visibility);
        board.setSkyBits(LOADSAVE.loader.pskybits);
        board.setParallaxType(Engine.parallaxtype);
        board.setSkyOffset(Engine.pskyoff);
        Main.boardService.setBoard(board);
        LEVELS.autoTotalSecrets = board.getSecrets();
        Gameutils.bseed = LOADSAVE.loader.randomseed;
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.setParallaxScale(LOADSAVE.loader.parallaxyscale);
        Engine.visibility = LOADSAVE.loader.visibility;
        Engine.parallaxvisibility = LOADSAVE.loader.parallaxvisibility;
        DB.gVisibility = Engine.visibility;
        System.arraycopy(LOADSAVE.loader.pskyoff, 0, Engine.pskyoff, 0, 256);
        Engine.pskybits = LOADSAVE.loader.pskybits;
        Arrays.fill(Engine.zeropskyoff, (short)0);
        System.arraycopy(Engine.pskyoff, 0, Engine.zeropskyoff, 0, 256);
        Engine.show2dsector.copy(LOADSAVE.loader.show2dsector);
        Engine.show2dwall.copy(LOADSAVE.loader.show2dwall);
        Engine.show2dsprite.copy(LOADSAVE.loader.show2dsprite);
        Engine.automapping = LOADSAVE.loader.automapping;
        Globals.gFrameClock = LOADSAVE.loader.gFrameClock;
        Globals.gTicks = LOADSAVE.loader.gTicks;
        Globals.gFrame = LOADSAVE.loader.gFrame;
        Main.game.pEngine.getTimer().setTotalClock(LOADSAVE.loader.gGameClock);
        Main.game.gPaused = LOADSAVE.loader.gPaused;
        for (int i2 = 0; i2 < LOADSAVE.loader.kwall.size; ++i2) {
            Trigger.kwall[i2].set(((Vector2[])LOADSAVE.loader.kwall.items)[i2]);
        }
        int numsectors = LOADSAVE.loader.numsectors;
        System.arraycopy(LOADSAVE.loader.secFloorZ.items, 0, Trigger.secFloorZ, 0, numsectors);
        System.arraycopy(LOADSAVE.loader.secCeilZ.items, 0, Trigger.secCeilZ, 0, numsectors);
        System.arraycopy(LOADSAVE.loader.floorVel.items, 0, Actor.floorVel, 0, numsectors);
        System.arraycopy(LOADSAVE.loader.ceilingVel.items, 0, Actor.ceilingVel, 0, numsectors);
        Engine.pHitInfo.hitsect = LOADSAVE.loader.safeHitInfo.hitsect;
        Engine.pHitInfo.hitwall = LOADSAVE.loader.safeHitInfo.hitwall;
        Engine.pHitInfo.hitsprite = LOADSAVE.loader.safeHitInfo.hitsprite;
        Engine.pHitInfo.hitx = LOADSAVE.loader.safeHitInfo.hitx;
        Engine.pHitInfo.hity = LOADSAVE.loader.safeHitInfo.hity;
        Engine.pHitInfo.hitz = LOADSAVE.loader.safeHitInfo.hitz;
        Main.mUserFlag = Main.UserFlag.None;
        if (LOADSAVE.loader.gForceMap) {
            Main.mUserFlag = Main.UserFlag.UserMap;
        }
        System.arraycopy(LOADSAVE.loader.nextXWall, 0, DB.nextXWall, 0, 512);
        System.arraycopy(LOADSAVE.loader.nextXSector, 0, DB.nextXSector, 0, 512);
        for (int nSprite = 0; nSprite < Main.boardService.getSpriteCount(); ++nSprite) {
            BloodSprite spr = Main.boardService.getSprite(nSprite);
            if (spr == null) continue;
            short nXSprite = spr.getExtra();
            if (spr.getStatnum() >= 1024 || spr.getExtra() < 0) continue;
            XSPRITE pXSprite = Main.boardService.setXSprite(nXSprite);
            pXSprite.copy(LOADSAVE.loader.xspriteMap.get(nXSprite));
            spr.setXSprite(pXSprite);
            pXSprite.getDudeExtra().setCumulDamage(0);
        }
        for (i = 0; i < 512; ++i) {
            DB.xwall[i].copy(LOADSAVE.loader.xwall[i]);
        }
        for (i = 0; i < 512; ++i) {
            DB.xsector[i].copy(LOADSAVE.loader.xsector[i]);
        }
        DB.gSkyCount = LOADSAVE.loader.gSkyCount;
        Globals.gNoClip = LOADSAVE.loader.gNoClip;
        Globals.gFullMap = LOADSAVE.loader.gFullMap;
    }

    public static void WarpLoad() {
        for (int i = 0; i < 8; ++i) {
            Warp.gStartZone[i] = new ZONE();
            Warp.gStartZone[i].x = LOADSAVE.loader.gStartZone[i].x;
            Warp.gStartZone[i].y = LOADSAVE.loader.gStartZone[i].y;
            Warp.gStartZone[i].z = LOADSAVE.loader.gStartZone[i].z;
            Warp.gStartZone[i].sector = LOADSAVE.loader.gStartZone[i].sector;
            Warp.gStartZone[i].angle = LOADSAVE.loader.gStartZone[i].angle;
        }
        System.arraycopy(LOADSAVE.loader.gUpperLink.items, 0, Warp.gUpperLink, 0, LOADSAVE.loader.numsectors);
        System.arraycopy(LOADSAVE.loader.gLowerLink.items, 0, Warp.gLowerLink, 0, LOADSAVE.loader.numsectors);
    }

    public static void MirrorLoad() {
        Mirror.mirrorcnt = LOADSAVE.loader.mirrorcnt;
        Mirror.MirrorSector = LOADSAVE.loader.MirrorSector;
        for (int i = 0; i < 16; ++i) {
            Mirror.MirrorType[i] = LOADSAVE.loader.MirrorType[i];
            Mirror.MirrorLower[i] = LOADSAVE.loader.MirrorLower[i];
            Mirror.MirrorX[i] = LOADSAVE.loader.MirrorX[i];
            Mirror.MirrorY[i] = LOADSAVE.loader.MirrorY[i];
            Mirror.MirrorZ[i] = LOADSAVE.loader.MirrorZ[i];
            Mirror.MirrorUpper[i] = LOADSAVE.loader.MirrorUpper[i];
        }
        System.arraycopy(LOADSAVE.loader.MirrorWall, 0, Mirror.MirrorWall, 0, 4);
    }

    public static void SeqLoad() {
        int i;
        for (i = 0; i < 512; ++i) {
            SeqHandling.siWall[i].copy(LOADSAVE.loader.siWall[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siMasked[i].copy(LOADSAVE.loader.siMasked[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siCeiling[i].copy(LOADSAVE.loader.siCeiling[i]);
        }
        for (i = 0; i < 512; ++i) {
            SeqHandling.siFloor[i].copy(LOADSAVE.loader.siFloor[i]);
        }
        SeqHandling.activeList.set(LOADSAVE.loader.actListType, LOADSAVE.loader.actListIndex, LOADSAVE.loader.activeCount);
    }

    public static void EventLoad() {
        int i;
        EVENT.eventQueryInit(DemoUtils.IsOriginalDemo());
        for (i = 0; i < 4096; ++i) {
            if (EVENT.rxBucket[i] == null) {
                EVENT.rxBucket[i] = new RXBUCKET();
                continue;
            }
            EVENT.rxBucket[i].flush();
        }
        EVENT.eventQ.flush();
        for (i = 0; i < LOADSAVE.loader.fNodeCount; ++i) {
            PriorityItem item = LOADSAVE.loader.qEventItems[i];
            EVENT.eventQ.Insert(item.priority, item.event);
        }
        for (i = 0; i < 4096; ++i) {
            EVENT.rxBucket[i].index = LOADSAVE.loader.rxBucketIndex[i];
            EVENT.rxBucket[i].type = LOADSAVE.loader.rxBucketType[i];
        }
        System.arraycopy(LOADSAVE.loader.bucketHead, 0, EVENT.bucketHead, 0, 1025);
    }

    public static void TriggersLoad() {
        Trigger.gBusyCount = LOADSAVE.loader.gBusyCount;
        for (int i = 0; i < 128; ++i) {
            Trigger.gBusy[i].nIndex = LOADSAVE.loader.gBusy[i].nIndex;
            Trigger.gBusy[i].nDelta = LOADSAVE.loader.gBusy[i].nDelta;
            Trigger.gBusy[i].nBusy = LOADSAVE.loader.gBusy[i].nBusy;
            Trigger.gBusy[i].busyProc = LOADSAVE.loader.gBusy[i].busyProc;
        }
        System.arraycopy(LOADSAVE.loader.secPath.items, 0, Trigger.secPath, 0, LOADSAVE.loader.numsectors);
    }

    public static void PlayersLoad() {
        int i;
        System.arraycopy(LOADSAVE.loader.nTeamCount, 0, Globals.nTeamCount, 0, 8);
        Mmulti.numplayers = (short)LOADSAVE.loader.gNetPlayers;
        if (Mmulti.numplayers >= 0) {
            System.arraycopy(LOADSAVE.loader.connectpoint2, 0, Mmulti.connectpoint2, 0, Mmulti.numplayers);
        }
        for (i = 0; i < 8; ++i) {
            if (LOADSAVE.loader.autoaim[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].autoaim = LOADSAVE.loader.autoaim[i] == 1;
            }
            if (LOADSAVE.loader.slopetilt[i] != -1) {
                boolean bl = Main.game.net.gProfile[i].slopetilt = LOADSAVE.loader.slopetilt[i] == 1;
            }
            if (LOADSAVE.loader.skill[i] != -1) {
                Main.game.net.gProfile[i].skill = LOADSAVE.loader.skill[i];
            }
            if (LOADSAVE.loader.name[i] == null) continue;
            Main.game.net.gProfile[i].name = LOADSAVE.loader.name[i];
        }
        for (i = 0; i < 8; ++i) {
            LOADSAVE.loader.safePlayer[i].pInput.Copy(Globals.gPlayer[i].pInput);
            Globals.gPlayer[i].copy(LOADSAVE.loader.safePlayer[i]);
        }
        for (i = 0; i < Mmulti.numplayers; ++i) {
            Globals.gPlayer[i].pSprite = Main.boardService.getSprite(Globals.gPlayer[i].nSprite);
            Globals.gPlayer[i].pXsprite = Main.boardService.getXSprite(Globals.gPlayer[i].pSprite.getExtra());
            Globals.gPlayer[i].pDudeInfo = DudeInfo.dudeInfo[Globals.gPlayer[i].pSprite.getLotag() - 200];
        }
        View.gViewIndex = Mmulti.myconnectindex;
    }

    public static void ActorsLoad() throws WarningException {
        System.arraycopy(LOADSAVE.loader.gSectorExp.items, 0, Actor.gSectorExp, 0, LOADSAVE.loader.numsectors);
        System.arraycopy(LOADSAVE.loader.gWallExp.items, 0, Actor.gWallExp, 0, 512);
        for (int i = 0; i < LOADSAVE.loader.gPostCount; ++i) {
            POSTPONE pPost = Actor.gPost.obtain();
            pPost.nSprite = ((POSTPONE[])LOADSAVE.loader.gPost.items)[i].nSprite;
            pPost.nStatus = ((POSTPONE[])LOADSAVE.loader.gPost.items)[i].nStatus;
        }
        Actor.actInit(true, DemoUtils.IsOriginalDemo());
        for (int p = 0; p < Mmulti.numplayers; ++p) {
            PLAYER.playerSetRace(Globals.gPlayer[p], Globals.gPlayer[p].nLifeMode);
            Globals.gPlayer[p].ang = Globals.gPlayer[p].pSprite.getAng();
        }
    }

    public static void GameInfoLoad() {
        LEVELS.gNextMap = LOADSAVE.loader.gNextMap;
        LOADSAVE.LoadGameInfo();
    }

    public static void StatsLoad() {
        LEVELS.totalSecrets = LOADSAVE.loader.totalSecrets;
        LEVELS.foundSecret = LOADSAVE.loader.foundSecret;
        LEVELS.superSecrets = LOADSAVE.loader.superSecrets;
        LEVELS.totalKills = LOADSAVE.loader.totalKills;
        LEVELS.kills = LOADSAVE.loader.kills;
    }

    public static void ScreenLoad() {
        View.deliriumTilt = LOADSAVE.loader.deliriumTilt;
        View.deliriumTurn = LOADSAVE.loader.deliriumTurn;
        View.deliriumPitch = LOADSAVE.loader.deliriumPitch;
    }

    public static void LoadUserEpisodeInfo() throws WarningException {
        if (LOADSAVE.loader.gUserEpisode) {
            Main.mUserFlag = Main.UserFlag.Addon;
        }
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            BloodIniFile ini = LOADSAVE.loader.addon;
            ResourceHandler.checkEpisodeResources(ini);
            LEVELS.getEpisodeInfo(LEVELS.gUserEpisodeInfo, ini);
        } else {
            ResourceHandler.resetEpisodeResources();
        }
    }

    static {
        lsInf = new LSInfo();
        quickslot = 0;
    }
}

