/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import java.util.List;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuDifficulty;
import ru.m210projects.Blood.Menus.MenuNetwork;
import ru.m210projects.Blood.Menus.MenuNewAddon;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;

public class BLUserContent
extends BuildMenu {
    private final Main app;
    private final MenuFileBrowser list;
    public boolean showmain;

    public BLUserContent(Main app) {
        super(app.menu);
        this.app = app;
        MenuTitle title = new MenuTitle(app.pEngine, "User content", app.getFont(1), 160, 20, 2038);
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(3), app.getFont(1), app.getFont(3), 40, 40, width, 1, 10, 2046){

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("rff", 7, 1);
                this.registerExtension("grp", 7, 1);
                this.registerExtension("zip", 7, 1);
                this.registerExtension("pk3", 7, 1);
                this.registerExtension("ini", 7, 1);
                this.registerExtension("dem", 10, -1);
            }

            @Override
            public void handleFile(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "INI": {
                        boolean skipMain = Main.game.getCache().isGameDirectory(fil.getParent());
                        if (BLUserContent.this.showmain) {
                            skipMain = false;
                        }
                        if (skipMain && fil.getName().equalsIgnoreCase(Globals.MainINI.getName())) break;
                    }
                    case "GRP": 
                    case "ZIP": 
                    case "RFF": 
                    case "PK3": {
                        for (EpisodeEntry entry : ResourceHandler.episodeManager.getEpisodeEntries(fil)) {
                            this.addFile((FileEntry)((Object)entry));
                        }
                        break;
                    }
                    case "DEM": {
                        if (BLUserContent.this.showmain || !DemoUtils.checkDemoEntry(fil, false)) break;
                        this.addFile(fil);
                        break;
                    }
                    default: {
                        this.addFile(fil);
                    }
                }
            }

            @Override
            public void invoke(FileEntry fil) {
                switch (fil.getExtension()) {
                    case "MAP": {
                        BLUserContent.this.launchMap(fil);
                        break;
                    }
                    case "INI": 
                    case "GRP": 
                    case "ZIP": 
                    case "RFF": 
                    case "PK3:": {
                        if (!(fil instanceof EpisodeEntry)) break;
                        BLUserContent.this.launchEpisode(ResourceHandler.episodeManager.getEpisode((EpisodeEntry)((Object)fil)));
                        break;
                    }
                    case "DEM": {
                        BloodIniFile episode = null;
                        Directory parent = fil.getParent();
                        List<Entry> demoList = DemoUtils.checkDemoEntry(parent);
                        if (!Main.game.getCache().isGameDirectory(parent)) {
                            for (Entry entry : parent.getEntries()) {
                                if (entry.isExtension("ini") && (episode = ResourceHandler.levelGetEpisode(entry)) != null) break;
                            }
                        }
                        DemoUtils.nDemonum = demoList.indexOf(fil);
                        Main.gDemoScreen.showDemo(fil, episode);
                        this.app.pMenu.mClose();
                    }
                }
            }

            @Override
            public void handleDirectory(Directory dir) {
            }

            @Override
            public void drawHeader(Renderer renderer, int x1, int x2, int y) {
                this.topFont.drawTextScaled(renderer, x1 + 11, y + 5, this.dirs, 0.5f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
                this.topFont.drawTextScaled(renderer, x2 + 10, y + 5, this.ffs, 0.5f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
            }

            @Override
            public void drawPath(Renderer renderer, int x, int y, String path) {
                super.drawPath(renderer, x, y, this.path);
            }
        };
        this.list.transparent = 33;
        this.list.topPal = 8;
        this.list.pathPal = 8;
        this.addItem(title, false);
        this.addItem(this.list, true);
        this.addItem(((BloodMenuHandler)app.pMenu).addMenuBlood(), false);
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (Main.game.getCache().isGameDirectory(this.list.getDirectory())) {
            this.list.refreshList();
        }
    }

    private void launchEpisode(BloodIniFile ini) {
        if (ini == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setEpisode(ini);
            this.app.menu.mMenuBack();
            return;
        }
        MenuNewAddon next = (MenuNewAddon)this.app.menu.mMenus[14];
        next.setEpisode(ini);
        this.app.menu.mOpen(next, -1);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        MenuDifficulty next = (MenuDifficulty)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }
}

