/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.filehandlers.art.BloodArtEntry;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Mirror {
    public static final int MIRROR = 504;
    public static final int MIRRORLABEL = 4080;
    public static final int MAXMIRRORS = 16;
    public static int mirrorcnt;
    public static boolean display_mirror;
    public static int[] MirrorType;
    public static int[] MirrorX;
    public static int[] MirrorY;
    public static int[] MirrorZ;
    public static int[] MirrorLower;
    public static int[] MirrorUpper;
    public static int MirrorSector;
    public static int[] MirrorWall;

    public static void InitMirrors() {
        int i;
        mirrorcnt = 0;
        Mirror.InitMirrorTiles();
        for (i = Main.boardService.getWallCount() - 1; i >= 0 && mirrorcnt != 16; --i) {
            Wall pWall = Main.boardService.getWall(i);
            if (pWall.getOverpicnum() == 504) {
                if (pWall.getExtra() <= 0 || pWall.getLotag() != 501) continue;
                Console.out.println("Initializing wall overpicnum mirror for");
                pWall.setCstat(pWall.getCstat() | 0x20);
                pWall.setOverpicnum((short)(mirrorcnt + 4080));
                Mirror.MirrorType[Mirror.mirrorcnt] = 0;
                short nXWall = pWall.getExtra();
                Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
                int data = DB.xwall[nXWall].data;
                int nWall = Main.boardService.getWallCount();
                while (--nWall >= 0) {
                    short nXWall2;
                    if (nWall == i || (nXWall2 = Main.boardService.getWall(nWall).getExtra()) <= 0 || Main.boardService.getWall(nWall).getLotag() != 501 || DB.xwall[nXWall2].data != data) continue;
                    pWall.setHitag((short)nWall);
                    Main.boardService.getWall(nWall).setHitag((short)i);
                    Mirror.MirrorLower[Mirror.mirrorcnt] = nWall;
                    break;
                }
                if (nWall < 0) {
                    throw new AssertException("wall[" + i + "] has no matching wall link! (data=" + DB.xwall[nXWall].data + ")");
                }
                ++mirrorcnt;
                continue;
            }
            if (pWall.getPicnum() != 504) continue;
            pWall.setCstat(pWall.getCstat() | 0x20);
            pWall.setPicnum((short)(mirrorcnt + 4080));
            Mirror.MirrorType[Mirror.mirrorcnt] = 0;
            Mirror.MirrorLower[Mirror.mirrorcnt] = i;
            Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
            ++mirrorcnt;
        }
        for (i = Main.boardService.getSectorCount() - 1; i >= 0 && mirrorcnt < 15; --i) {
            short nLower;
            int nUpper;
            Sector pSector = Main.boardService.getSector(i);
            if (pSector.getFloorpicnum() != 504 || (nUpper = Warp.gUpperLink[i]) < 0 || (nLower = Main.boardService.getSprite(nUpper).getOwner()) == -1) continue;
            if (Main.boardService.getSector(Main.boardService.getSprite(nLower).getSectnum()).getCeilingpicnum() != 504) {
                Console.out.println("Lower link sector " + i + " doesn't have mirror picnum!", OsdColor.RED);
            }
            Mirror.MirrorType[Mirror.mirrorcnt] = 2;
            Mirror.MirrorX[Mirror.mirrorcnt] = Main.boardService.getSprite(nLower).getX() - Main.boardService.getSprite(nUpper).getX();
            Mirror.MirrorY[Mirror.mirrorcnt] = Main.boardService.getSprite(nLower).getY() - Main.boardService.getSprite(nUpper).getY();
            Mirror.MirrorZ[Mirror.mirrorcnt] = Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ();
            Mirror.MirrorLower[Mirror.mirrorcnt] = Main.boardService.getSprite(nLower).getSectnum();
            Mirror.MirrorUpper[Mirror.mirrorcnt] = i;
            pSector.setFloorpicnum((short)(4080 + mirrorcnt++));
            Mirror.MirrorType[Mirror.mirrorcnt] = 1;
            Mirror.MirrorX[Mirror.mirrorcnt] = Main.boardService.getSprite(nUpper).getX() - Main.boardService.getSprite(nLower).getX();
            Mirror.MirrorY[Mirror.mirrorcnt] = Main.boardService.getSprite(nUpper).getY() - Main.boardService.getSprite(nLower).getY();
            Mirror.MirrorZ[Mirror.mirrorcnt] = Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ();
            Mirror.MirrorLower[Mirror.mirrorcnt] = i;
            Mirror.MirrorUpper[Mirror.mirrorcnt] = Main.boardService.getSprite(nLower).getSectnum();
            Main.boardService.getSector(Main.boardService.getSprite(nLower).getSectnum()).setCeilingpicnum((short)(4080 + mirrorcnt++));
        }
    }

    public static void InitMirrorTiles() {
        Main.engine.allocatepermanenttile(504, 0, 0);
        for (int i = 0; i < 16; ++i) {
            Main.engine.allocatepermanenttile(i + 4080, 0, 0);
        }
    }

    public static void processMirror(long nViewX, long nViewY) {
        int i;
        BloodRenderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        for (i = renderedSpriteList.getSize() - 1; i >= 0; --i) {
            TSprite tSprite = (TSprite)renderedSpriteList.get(i);
            tSprite.setXrepeat(0);
            tSprite.setYrepeat(0);
        }
        for (i = mirrorcnt - 1; i >= 0; --i) {
            int type;
            int nMirror = i + 4080;
            if (!renderer.gotPic(nMirror) || (type = MirrorType[i]) != 1 && type != 2) continue;
            for (ListNode<Sprite> node = Main.boardService.getSectNode(MirrorLower[i]); node != null; node = node.getNext()) {
                int j = node.getIndex();
                BloodSprite pSprite = Main.boardService.getSprite(j);
                if (pSprite == Globals.gPlayer[View.gViewIndex].pSprite) continue;
                Gameutils.GetSpriteExtents(pSprite);
                Main.engine.getzsofslope((short)MirrorLower[i], pSprite.getX(), pSprite.getY(), Globals.floorz, Globals.ceilz);
                if (pSprite.getLotag() != 6 || Gameutils.extents_zTop >= Globals.ceilz.get() && Gameutils.extents_zBot <= Globals.floorz.get()) continue;
                int cnt = type == 2 ? i + 1 : i - 1;
                int mirX = MirrorX[cnt];
                int mirY = MirrorY[cnt];
                int mirZ = MirrorZ[cnt];
                TSprite tSprite = View.viewInsertTSprite(MirrorUpper[i], 0, null);
                tSprite.reset((byte)0);
                tSprite.setLotag(pSprite.getLotag());
                tSprite.setXvel(pSprite.getXvel());
                tSprite.update(mirX + pSprite.getX(), mirY + pSprite.getY(), mirZ + pSprite.getZ(), MirrorUpper[i]);
                tSprite.setAng(pSprite.getAng());
                tSprite.setPicnum(pSprite.getPicnum());
                tSprite.setShade(pSprite.getShade());
                tSprite.setPal(pSprite.getPal());
                tSprite.setXrepeat(pSprite.getXrepeat());
                tSprite.setYrepeat(pSprite.getYrepeat());
                tSprite.setXoffset(pSprite.getXoffset());
                tSprite.setYoffset(pSprite.getYoffset());
                tSprite.setStatnum(0);
                tSprite.setCstat(pSprite.getCstat());
                tSprite.setOwner(pSprite.getXvel());
                tSprite.setExtra(pSprite.getExtra());
                tSprite.setHitag((short)(pSprite.getHitag() | 2));
                View.viewBackupSpriteLoc(pSprite.getXvel(), pSprite);
            }
        }
        for (int nTSprite = renderedSpriteList.getSize() - 1; nTSprite >= 0; --nTSprite) {
            Sprite pTSprite = (Sprite)renderedSpriteList.get(nTSprite);
            int nFrames = 0;
            ArtEntry pic = Main.engine.getTile(pTSprite.getPicnum());
            if (!(pic instanceof BloodArtEntry)) continue;
            switch (((BloodArtEntry)pic).getView()) {
                case kSpriteView5Full: {
                    int dx = (int)(nViewX - (long)pTSprite.getX());
                    int dy = (int)(nViewY - (long)pTSprite.getY());
                    Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTSprite.setCstat(pTSprite.getCstat() | 4);
                        break;
                    }
                    pTSprite.setCstat(pTSprite.getCstat() & 0xFFFFFFFB);
                    break;
                }
                case kSpriteView8Full: {
                    int dx = (int)(nViewX - (long)pTSprite.getX());
                    int dy = (int)(nViewY - (long)pTSprite.getY());
                    Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    break;
                }
            }
            while (nFrames > 0) {
                --nFrames;
                pTSprite.setPicnum(pTSprite.getPicnum() + pic.getAnimFrames() + 1);
            }
        }
    }

    public static void setMirrorParalax(boolean mirror) {
        BloodRenderer renderer = Main.game.getRenderer();
        for (int i = mirrorcnt - 1; i >= 0; --i) {
            int nMirror = i + 4080;
            if (!renderer.gotPic(nMirror)) continue;
            int type = MirrorType[i];
            int nSector = MirrorUpper[i];
            if (type == 1) {
                if (mirror) {
                    Main.boardService.getSector(nSector).setCeilingstat(Main.boardService.getSector(nSector).getCeilingstat() | 1);
                    continue;
                }
                Main.boardService.getSector(nSector).setCeilingstat(Main.boardService.getSector(nSector).getCeilingstat() & 0xFFFFFFFE);
                continue;
            }
            if (type != 2) continue;
            if (mirror) {
                Main.boardService.getSector(nSector).setFloorstat(Main.boardService.getSector(nSector).getFloorstat() | 1);
                continue;
            }
            Main.boardService.getSector(nSector).setFloorstat(Main.boardService.getSector(nSector).getFloorstat() & 0xFFFFFFFE);
        }
    }

    public static void DrawMirrors(long x, long y, long z, float ang, float horiz) {
        BloodRenderer renderer = Main.game.getRenderer();
        for (int i = mirrorcnt - 1; i >= 0; --i) {
            int nMirror = i + 4080;
            if (!renderer.gotPic(nMirror)) continue;
            int type = MirrorType[i];
            if (type == 0) {
                int nWall = MirrorLower[i];
                Wall pWall = Main.boardService.getWall(nWall);
                int nSector = Main.engine.sectorofwall((short)nWall);
                short oldNextwall = pWall.getNextwall();
                short oldNextsector = pWall.getNextsector();
                pWall.setNextwall((short)MirrorWall[0]);
                pWall.setNextsector((short)MirrorSector);
                Main.boardService.getWall(MirrorWall[0]).setNextwall((short)nWall);
                Main.boardService.getWall(MirrorWall[0]).setNextsector((short)nSector);
                Main.boardService.getWall(MirrorWall[0]).setX(Main.boardService.getWall(pWall.getPoint2()).getX());
                Main.boardService.getWall(MirrorWall[0]).setY(Main.boardService.getWall(pWall.getPoint2()).getY());
                Main.boardService.getWall(MirrorWall[1]).setX(pWall.getX());
                Main.boardService.getWall(MirrorWall[1]).setY(pWall.getY());
                Main.boardService.getWall(MirrorWall[2]).setX(16 * (Main.boardService.getWall(MirrorWall[1]).getX() - Main.boardService.getWall(MirrorWall[0]).getX()) + Main.boardService.getWall(MirrorWall[1]).getX());
                Main.boardService.getWall(MirrorWall[2]).setY(16 * (Main.boardService.getWall(MirrorWall[1]).getY() - Main.boardService.getWall(MirrorWall[0]).getY()) + Main.boardService.getWall(MirrorWall[1]).getY());
                Main.boardService.getWall(MirrorWall[3]).setX(16 * (Main.boardService.getWall(MirrorWall[0]).getX() - Main.boardService.getWall(MirrorWall[1]).getX()) + Main.boardService.getWall(MirrorWall[0]).getX());
                Main.boardService.getWall(MirrorWall[3]).setY(16 * (Main.boardService.getWall(MirrorWall[0]).getY() - Main.boardService.getWall(MirrorWall[1]).getY()) + Main.boardService.getWall(MirrorWall[0]).getY());
                Main.boardService.getSector(MirrorSector).setFloorz(Main.boardService.getSector(nSector).getFloorz());
                Main.boardService.getSector(MirrorSector).setCeilingz(Main.boardService.getSector(nSector).getCeilingz());
                int mirX = 0;
                int mirY = 0;
                float mirAng = 0.0f;
                if (pWall.getLotag() == 501) {
                    mirX = (int)(x - (long)(Main.boardService.getWall(pWall.getHitag()).getX() - Main.boardService.getWall(pWall.getPoint2()).getX()));
                    mirY = (int)(y - (long)(Main.boardService.getWall(pWall.getHitag()).getY() - Main.boardService.getWall(pWall.getPoint2()).getY()));
                    mirAng = ang;
                } else {
                    ru.m210projects.Build.Render.Mirror mirror = renderer.preparemirror((int)x, (int)y, (int)z, ang, horiz, nWall, MirrorSector);
                    mirX = (int)mirror.getX();
                    mirY = (int)mirror.getY();
                    mirAng = mirror.getAngle();
                }
                renderer.drawrooms(mirX, mirY, z, mirAng, horiz, (short)(MirrorSector + Main.boardService.getSectorCount()));
                display_mirror = true;
                View.viewProcessSprites(mirX, mirY, z);
                display_mirror = false;
                renderer.drawmasks();
                if (pWall.getLotag() != 501) {
                    renderer.completemirror();
                }
                pWall.setNextwall(oldNextwall);
                pWall.setNextsector(oldNextsector);
            } else if (type == 1) {
                int nSector = MirrorLower[i];
                renderer.drawrooms(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i], ang, horiz, (short)(nSector + Main.boardService.getSectorCount()));
                View.viewProcessSprites(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i]);
                short oldstat = Main.boardService.getSector(nSector).getFloorstat();
                Main.boardService.getSector(nSector).setFloorstat(Main.boardService.getSector(nSector).getFloorstat() | 1);
                renderer.drawmasks();
                Main.boardService.getSector(nSector).setFloorstat(oldstat);
            } else if (type == 2) {
                int nSector = MirrorLower[i];
                renderer.drawrooms(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i], ang, horiz, (short)(nSector + Main.boardService.getSectorCount()));
                View.viewProcessSprites(x + (long)MirrorX[i], (long)MirrorY[i] + y, z + (long)MirrorZ[i]);
                short oldstat = Main.boardService.getSector(nSector).getCeilingstat();
                Main.boardService.getSector(nSector).setCeilingstat(Main.boardService.getSector(nSector).getCeilingstat() | 1);
                renderer.drawmasks();
                Main.boardService.getSector(nSector).setCeilingstat(oldstat);
            }
            byte[] byArray = renderer.getRenderedPics();
            int n = nMirror >> 3;
            byArray[n] = (byte)(byArray[n] & (byte)(~Engine.pow2char[nMirror & 7]));
            return;
        }
    }

    static {
        MirrorType = new int[16];
        MirrorX = new int[16];
        MirrorY = new int[16];
        MirrorZ = new int[16];
        MirrorLower = new int[16];
        MirrorUpper = new int[16];
        MirrorWall = new int[4];
    }
}

