/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.PriorityQueue;

import java.io.IOException;
import java.io.OutputStream;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.PriorityQueue.IPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;

public class BPriorityQueue
implements IPriorityQueue {
    private final int kPQueueSize;
    public int fNodeCount;
    public PriorityItem[] qList;

    public BPriorityQueue(int size) {
        this.kPQueueSize = size;
        this.qList = new PriorityItem[size];
        for (int i = 0; i < size; ++i) {
            this.qList[i] = new PriorityItem(0L, 0);
        }
        this.fNodeCount = 0;
    }

    @Override
    public void flush() {
        for (int i = 0; i < this.kPQueueSize; ++i) {
            this.qList[i].priority = 0L;
            this.qList[i].event = (int)0L;
        }
        this.fNodeCount = 0;
    }

    @Override
    public void Insert(long time, int event) {
        if (this.fNodeCount >= this.kPQueueSize) {
            throw new AssertException("fNodeCount < kPQueueSize");
        }
        ++this.fNodeCount;
        this.qList[this.fNodeCount].priority = time;
        this.qList[this.fNodeCount].event = event;
        this.insert();
    }

    @Override
    public int Remove() {
        int out = this.qList[1].event;
        this.qList[1].priority = this.qList[this.fNodeCount].priority;
        this.qList[1].event = this.qList[this.fNodeCount].event;
        --this.fNodeCount;
        this.remove(1);
        return out;
    }

    private int Remove(int k) {
        if (k > this.fNodeCount) {
            throw new AssertException("k <= fNodeCount");
        }
        this.qList[k].priority = this.qList[this.fNodeCount].priority;
        this.qList[k].event = this.qList[this.fNodeCount].event;
        --this.fNodeCount;
        return this.remove(k);
    }

    @Override
    public void checkList(int nIndex, int nType) {
        int i = 0;
        while (i <= this.fNodeCount) {
            PriorityItem item = this.qList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event)) {
                this.Remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void checkList(int nIndex, int nType, int funcId) {
        int i = 0;
        while (i <= this.fNodeCount) {
            PriorityItem item = this.qList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event) && funcId == EVENT.getFuncID(item.event)) {
                this.Remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public boolean Check(long time) {
        return this.fNodeCount > 0 && time >= this.qList[1].priority;
    }

    @Override
    public int getSize() {
        return this.fNodeCount;
    }

    @Override
    public PriorityItem getItem(int i) {
        return this.qList[i];
    }

    @Override
    public void writeObject(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.fNodeCount);
        for (int i = 0; i < this.fNodeCount; ++i) {
            PriorityItem item = this.qList[i];
            StreamUtils.writeInt(os, (int)item.priority);
            StreamUtils.writeInt(os, item.event);
        }
    }

    private void insert() {
        long priority = this.qList[this.fNodeCount].priority;
        int event = this.qList[this.fNodeCount].event;
        int tNodeCount = this.fNodeCount;
        this.qList[0].priority = 0L;
        while (priority < this.qList[tNodeCount >> 1].priority) {
            PriorityItem qList1 = this.qList[tNodeCount >> 1];
            PriorityItem qList2 = this.qList[tNodeCount];
            qList2.priority = qList1.priority;
            qList2.event = qList1.event;
            tNodeCount >>= 1;
        }
        this.qList[tNodeCount].priority = priority;
        this.qList[tNodeCount].event = event;
    }

    private int remove(int item) {
        PriorityItem qItem = this.qList[item];
        long priority = qItem.priority;
        int event = qItem.event;
        while (this.fNodeCount / 2 >= item) {
            int k = 2 * item;
            if (k < this.fNodeCount && this.qList[k].priority > this.qList[k + 1].priority) {
                ++k;
            }
            if (priority <= this.qList[k].priority) break;
            this.qList[item].priority = this.qList[k].priority;
            this.qList[item].event = this.qList[k].event;
            item = k;
        }
        this.qList[item].priority = priority;
        this.qList[item].event = event;
        return event;
    }

    public String toString() {
        String out = "fNodeCount " + this.fNodeCount + " \r\n";
        for (int i = 0; i < this.fNodeCount; ++i) {
            out = out + "priority " + this.qList[i].priority + " \r\n";
            out = out + "event " + this.qList[i].event + " \r\n";
        }
        return out;
    }
}

