/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screens.PrecacheScreen;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class QAV {
    public static final String kQAVSig = "QAV\u001a";
    public static final int kQAVVersion = 512;
    public static final int kMaxLayers = 8;
    public static final int kQFrameNormal = 0;
    public static final int kQFrameTranslucent = 1;
    public static final int kQFrameScale = 2;
    public static final int kQFrameYFlip = 4;
    public static final int kQFrameUnclipped = 8;
    public static final int kQFrameStatus = 10;
    public static final int kQFrameCorner = 16;
    public static final int kQFrameTranslucentR = 32;
    public static final int kQFrameNoMask = 64;
    public static final int kQFrameAllPages = 128;
    public static final int kQFrameXFlip = 256;
    public static final int kQFrameWideLeft = 512;
    public static final int kFlagSoundKill = 1;
    public static final int kFlagSoundKillAll = 2;
    public String signature;
    public short version;
    public Vector2 origin;
    public int ticksPerFrame;
    public int duration;
    public FRAME[] frame;
    public int nFrames;
    public Sprite sprite;
    public int mindisp;

    public QAV(InputStream is) throws IOException {
        this.signature = StreamUtils.readString(is, 4);
        this.version = StreamUtils.readShort(is);
        StreamUtils.skip(is, 2);
        this.nFrames = StreamUtils.readInt(is);
        this.frame = new FRAME[this.nFrames];
        this.ticksPerFrame = StreamUtils.readInt(is);
        this.duration = StreamUtils.readInt(is);
        this.origin = new Vector2(StreamUtils.readInt(is), StreamUtils.readInt(is));
        StreamUtils.skip(is, 8);
        int maxsizy = 0;
        int tframey = 0;
        int yoffs = 0;
        for (int f = 0; f < this.nFrames; ++f) {
            int trigger_frameid = StreamUtils.readInt(is);
            int sound_frameid = StreamUtils.readInt(is);
            int sound_frame_priority = StreamUtils.readUnsignedByte(is);
            int sound_frame_flags = StreamUtils.readUnsignedByte(is);
            short sound_frame_range = StreamUtils.readShort(is);
            TILE_FRAME[] layer = new TILE_FRAME[8];
            for (int i = 0; i < 8; ++i) {
                ArtEntry pic;
                layer[i] = new TILE_FRAME(is);
                int picnum = layer[i].id;
                if (picnum < 0 || picnum >= Engine.MAXTILES || (pic = Main.engine.getTile(picnum)).getHeight() <= maxsizy) continue;
                maxsizy = pic.getHeight();
                tframey = layer[i].y;
                yoffs = pic.getOffsetY();
            }
            this.frame[f] = new FRAME(trigger_frameid, sound_frameid, sound_frame_priority, sound_frame_flags, sound_frame_range, layer);
        }
        this.mindisp = yoffs - maxsizy / 2 - tframey;
    }

    public void Preload(PrecacheScreen precacheScreen) {
        for (int i = 0; i < this.nFrames; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (this.frame[i].layer[j].id < 0) continue;
                precacheScreen.tilePreloadTile(this.frame[i].layer[j].id);
            }
        }
    }

    private void DrawFrame(int x, int y, TILE_FRAME f, int shade, int flags, int pal, int nScale) {
        short nAngle = f.angle;
        if (((flags |= f.flags) & 0x100) != 0) {
            nAngle = (short)(nAngle + 1024 & 0x7FF);
            flags &= 0xFFFFFEFF;
            flags ^= 4;
        }
        if ((flags & 0x200) != 0) {
            flags &= 0xFFFFFDFF;
            flags |= 0x100;
        }
        int nPal = f.pal;
        if (pal > 0) {
            nPal = pal;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        int zoom = Pragmas.mulscale(f.zoom, nScale, 16);
        int fx = Pragmas.mulscale(f.x, nScale, 16);
        int fy = Pragmas.mulscale(f.y, nScale, 16);
        int windowx1 = 0;
        int windowy1 = 0;
        int windowx2 = renderer.getWidth();
        int windowy2 = renderer.getHeight();
        renderer.rotatesprite(x + fx << 16, y + fy << 16, zoom, nAngle, (short)f.id, Gameutils.ClipRange(f.shade + shade, -128, 127), (char)nPal, (char)flags, windowx1, windowy1, windowx2, windowy2);
    }

    public void Draw(int t, int shade, int flags, int nPLU, int nScale) {
        if (this.ticksPerFrame <= 0) {
            throw new AssertException("ticksPerFrame > 0");
        }
        int nFrame = t / this.ticksPerFrame;
        if (nFrame < 0 || nFrame > this.nFrames) {
            throw new AssertException("nFrame >= 0 && nFrame < nFrames, nFrame: " + nFrame);
        }
        FRAME f = this.frame[nFrame];
        for (int i = 0; i < 8; ++i) {
            if (f.layer[i].id <= 0) continue;
            this.DrawFrame((int)this.origin.x, (int)this.origin.y, f.layer[i], shade, flags, nPLU, nScale);
        }
    }

    public void Play(int t0, int t1, int callback, PLAYER player) {
        if (this.ticksPerFrame > 0) {
            int nFrame = t0 < 0 ? (t0 + 1) / this.ticksPerFrame : t0 / this.ticksPerFrame + 1;
            int t = nFrame * this.ticksPerFrame;
            while (t <= t1) {
                if (nFrame >= 0 && nFrame < this.nFrames) {
                    FRAME f = this.frame[nFrame];
                    if (f.sound_frame_flags > 0 && f.sound_frame_flags <= 2) {
                        for (int i = 0; i < this.nFrames; ++i) {
                            FRAME sFrame = this.frame[i];
                            if (sFrame.sound_frameid == 0 || f.sound_frame_flags != 2 && sFrame.sound_frame_priority != f.sound_frame_priority) continue;
                            if (this.sprite != null) {
                                for (int a = 0; a <= sFrame.sound_frame_range; ++a) {
                                    SOUND.sfxKill3DSound(this.sprite, -1, sFrame.sound_frameid + a);
                                }
                                continue;
                            }
                            SOUND.sndStopAllSamples();
                        }
                    }
                    if (f.sound_frameid != 0) {
                        int sound_frameid = f.sound_frameid;
                        if (f.sound_frame_range > 0 && !DemoUtils.IsOriginalDemo()) {
                            sound_frameid += Gameutils.Random(f.sound_frame_range == 1 ? 2 : (int)f.sound_frame_range);
                        }
                        if (this.sprite != null) {
                            SOUND.sfxStart3DSound(this.sprite, sound_frameid, f.sound_frame_priority + 16, 6);
                            this.sprite = null;
                        } else {
                            SOUND.sndStartSample(sound_frameid, -1, -1, false);
                        }
                    }
                    if (f.trigger_frameid > 0 && callback != -1) {
                        Weapon.gWeaponCallback[callback].run(f.trigger_frameid, player);
                    }
                }
                t += this.ticksPerFrame;
                ++nFrame;
            }
        }
    }

    class FRAME {
        int trigger_frameid;
        int sound_frameid;
        int sound_frame_priority;
        int sound_frame_flags;
        short sound_frame_range;
        TILE_FRAME[] layer;

        public FRAME(int trigger_frameid, int sound_frameid, int sound_frame_priority, int sound_frame_flags, short sound_frame_range, TILE_FRAME[] layer) {
            this.trigger_frameid = trigger_frameid;
            this.sound_frameid = sound_frameid;
            this.sound_frame_priority = sound_frame_priority;
            this.sound_frame_flags = sound_frame_flags;
            this.sound_frame_range = sound_frame_range;
            this.layer = layer;
        }
    }

    static class TILE_FRAME {
        public static final int sizeof = 24;
        int id;
        int x;
        int y;
        int zoom;
        int flags;
        byte shade;
        int pal;
        short angle;

        public TILE_FRAME(InputStream is) throws IOException {
            this.id = StreamUtils.readInt(is);
            this.x = StreamUtils.readInt(is);
            this.y = StreamUtils.readInt(is);
            this.zoom = StreamUtils.readInt(is);
            this.flags = StreamUtils.readInt(is);
            this.shade = StreamUtils.readByte(is);
            this.pal = StreamUtils.readUnsignedByte(is);
            this.angle = StreamUtils.readShort(is);
        }
    }
}

