/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Blood.Fonts.QFNFont;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.EpisodeManager;
import ru.m210projects.Blood.Types.SFX;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Blood.filehandlers.UserEntry;
import ru.m210projects.Blood.filehandlers.scripts.BloodDef;
import ru.m210projects.Blood.filehandlers.scripts.RFScript;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.rff.RffEntry;
import ru.m210projects.Build.filehandle.rff.RffFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class ResourceHandler {
    public static EpisodeManager episodeManager = new EpisodeManager();
    public static boolean usecustomarts;
    public static boolean usecustomqavs;
    private static RffFile usergroup;

    public static void searchEpisodeResources(Group container, RffFile resourceHolder) {
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        ArrayList<Entry> resources = new ArrayList<Entry>();
        ResourceHandler.searchScripts(container, resources, ids);
        for (Entry file : resources) {
            if (file instanceof RffEntry) {
                resourceHolder.addEntry((RffEntry)file);
                continue;
            }
            Integer id = ids.getOrDefault(file.getName().toUpperCase(), -1);
            resourceHolder.addEntry(new UserEntry(file, id));
        }
    }

    private static void searchScripts(Group container, List<Entry> entries, Map<String, Integer> ids) {
        for (Entry file : container.getEntries()) {
            if (file.isExtension("rfs")) {
                RFScript scr = new RFScript(file.getName(), file);
                for (Map.Entry<Integer, SFX> sfx : scr.getSfxList().entrySet()) {
                    SOUND.pSFXs[sfx.getKey().intValue()] = sfx.getValue();
                }
                ids.putAll(scr.getIds());
                continue;
            }
            if (!file.isExtension("cue")) continue;
            CueScript cdTracks = new CueScript(file.getName(), file);
            String[] cdtracks = cdTracks.getTracks();
            int num = 0;
            for (int i = 0; i < cdtracks.length; ++i) {
                if (cdtracks[i] == null) continue;
                SOUND.usertrack[i] = Main.game.getFilename(cdtracks[i]);
                ++num;
            }
            Console.out.println(num + " cd tracks found...");
        }
        for (Entry file : container.getEntries()) {
            Group subContainer = Directory.DUMMY_DIRECTORY;
            if (file.isDirectory() && file instanceof FileEntry) {
                subContainer = ((FileEntry)file).getDirectory();
            } else if (file.isExtension("zip") || file.isExtension("grp") || file.isExtension("pk3") || file.isExtension("rff")) {
                subContainer = Main.game.getCache().newGroup(file);
            }
            if (!((Object)subContainer).equals(Directory.DUMMY_DIRECTORY)) {
                ResourceHandler.searchScripts(subContainer, entries, ids);
                continue;
            }
            entries.add(file);
        }
    }

    public static void checkEpisodeResources(BloodIniFile ini) throws WarningException {
        BloodDef addonScript;
        if (ini == null) {
            return;
        }
        if (LEVELS.currentEpisode != null && ini.equals(LEVELS.currentEpisode.iniFile)) {
            return;
        }
        ResourceHandler.resetEpisodeResources();
        usergroup = new RffFile("RemovableGroup");
        EpisodeEntry addonEntry = ini.getEpisodeEntry();
        Group parent = addonEntry.getGroup();
        if (addonEntry.isPackageEpisode()) {
            addonScript = new BloodDef(Main.game.getBaseDef(), (Entry)addonEntry.getFileEntry());
            try {
                Entry res = parent.getEntry("bloodgdx.def");
                if (res.exists()) {
                    addonScript.loadScript(parent.getName() + " script", res);
                }
                ResourceHandler.searchEpisodeResources(parent, usergroup);
            }
            catch (Exception e) {
                throw new WarningException("Error found in " + ((EpisodeEntry.Pack)addonEntry).getName() + "\r\n" + e);
            }
        } else {
            addonScript = new BloodDef(Main.game.getBaseDef(), (Entry)addonEntry.getFileEntry());
            if (!Main.game.getCache().isGameDirectory(parent)) {
                ResourceHandler.searchEpisodeResources(parent, usergroup);
                Entry def = parent.getEntry("bloodgdx.def");
                if (def.exists()) {
                    addonScript.loadScript(def);
                }
            }
        }
        if (ini.getName().equalsIgnoreCase("cryptic.ini")) {
            Main.engine.loadpic(parent.getEntry("CPART07.AR_"));
            Main.engine.loadpic(parent.getEntry("CPART15.AR_"));
            Main.engine.loadpic(parent.getEntry("BART07.AR_"));
            Main.engine.loadpic(parent.getEntry("BART15.AR_"));
            usecustomarts = true;
        }
        Main.game.getCache().addGroup(usergroup, CacheResourceMap.CachePriority.HIGHEST);
        ResourceHandler.InitGroupResources(addonScript, usergroup.getEntries());
        Main.game.setDefs(addonScript);
        View.InitBallBuffer();
    }

    public static void InitGroupResources(BloodDef script, List<Entry> list) {
        for (Entry res : list) {
            if (res.isExtension("art")) {
                Main.engine.loadpic(res);
                usecustomarts = true;
                continue;
            }
            if (res.getName().equalsIgnoreCase("voxel.dat")) {
                Tile.voxelsInit(res.getName());
                Console.out.println("Found voxel.dat. Loading... ");
                continue;
            }
            if (res.getName().equalsIgnoreCase("surface.dat")) {
                script.surfaceInit(res.getName());
                Console.out.println("Found surface.dat. Loading... ");
                continue;
            }
            if (res.getName().equalsIgnoreCase("shade.dat")) {
                Tile.shadeInit(res.getName());
                Console.out.println("Found shade.dat. Loading... ");
                continue;
            }
            if (!res.isExtension("qav")) continue;
            usecustomqavs = true;
        }
        if (usecustomqavs) {
            Console.out.println("Found qav files. Loading... ");
            Weapon.WeaponInit();
        }
    }

    public static void resetEpisodeResources() {
        Console.out.println("Resetting custom resources", OsdColor.GREEN);
        if (usergroup != null) {
            Main.game.getCache().removeGroup(usergroup);
        }
        usergroup = null;
        Arrays.fill(SOUND.pSFXs, null);
        SeqType.flushCache();
        Arrays.fill(SOUND.usertrack, null);
        if (usecustomqavs) {
            Weapon.WeaponInit();
            usecustomqavs = false;
        }
        if (!usecustomarts) {
            Main.game.setDefs(Main.game.baseDef);
            return;
        }
        System.err.println("Reset to default resources");
        if (Main.engine.loadpics() == 0) {
            throw new AssertException("ART files not found " + Main.game.getCache().getGameDirectory().getPath().resolve(Main.engine.getTileManager().getTilesPath()));
        }
        Tile.tileInit();
        Main.game.setDefs(Main.game.baseDef);
        Mirror.InitMirrorTiles();
        if (VERSION.hasQFN) {
            for (int i = 0; i < 5; ++i) {
                ((QFNFont)Main.game.getFont(i)).rebuildChar();
            }
        }
        View.InitBallBuffer();
        usecustomarts = false;
    }

    public static BloodIniFile levelGetEpisode(Entry entry) {
        List<EpisodeEntry> list;
        if (!entry.exists() || !entry.isExtension("ini")) {
            return null;
        }
        if (entry instanceof FileEntry && !(list = episodeManager.getEpisodeEntries((FileEntry)entry)).isEmpty()) {
            return episodeManager.getEpisode(list.get(0));
        }
        return null;
    }
}

