/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.MovieScreen;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.BuildSmacker.SMKFile;

public class CutsceneScreen
extends MovieScreen {
    private final BloodEngine engine = Main.engine;

    public CutsceneScreen(BuildGame game) {
        super(game, Engine.MAXTILES - 3);
        this.nFlags |= 4;
    }

    public boolean init(String path, String sndPath) {
        if (!Main.cfg.showCutscenes || this.isInited()) {
            return false;
        }
        if (!this.open(path)) {
            return false;
        }
        ((SMKMovieFile)this.mvfil).setSoundPath(sndPath);
        return true;
    }

    @Override
    protected MovieScreen.MovieFile GetFile(String file) {
        try {
            return new SMKMovieFile(file);
        }
        catch (FileNotFoundException fnf) {
            Console.out.println(file + " is not found!", OsdColor.RED);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void StopAllSounds() {
        SOUND.sndStopAllSounds();
    }

    @Override
    protected byte[] DoDrawFrame(int num) {
        byte[] pic = this.mvfil.getFrame(num);
        if (((SMKMovieFile)this.mvfil).paletteChanged) {
            this.changepalette(this.mvfil.getPalette());
            this.engine.getPaletteManager().invalidate();
        }
        return pic;
    }

    @Override
    protected Font GetFont() {
        return this.game.getFont(4);
    }

    @Override
    protected void DrawEscText(Font font, int pal) {
        Renderer renderer = this.game.getRenderer();
        int shade = 32 + Pragmas.mulscale(32L, Trig.Sin(20 * this.engine.getTotalClock() & 0x7FF), 30);
        font.drawTextScaled(renderer, 160, 5, Strings.cutskip, 1.0f, shade, pal, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    protected static class SMKMovieFile
    implements MovieScreen.MovieFile {
        protected SMKFile smkfil;
        protected boolean paletteChanged;
        protected String sndPath;
        private Source smkSource;

        public SMKMovieFile(String file) throws Exception {
            Entry entry = Main.game.getCache().getEntry(file, true);
            if (!entry.exists()) {
                throw new FileNotFoundException();
            }
            byte[] smkbuf = entry.getBytes();
            ByteBuffer bb = ByteBuffer.wrap(smkbuf);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.smkfil = new SMKFile(bb);
            this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask());
        }

        @Override
        public int getFrames() {
            return this.smkfil.getFrames();
        }

        @Override
        public float getRate() {
            return (float)this.smkfil.getRate() / 1000.0f;
        }

        @Override
        public byte[] getFrame(int num) {
            this.paletteChanged = this.smkfil.setFrame(num) != 0;
            return this.smkfil.getVideoBuffer().array();
        }

        @Override
        public byte[] getPalette() {
            return this.smkfil.getPalette();
        }

        @Override
        public int getWidth() {
            return (short)this.smkfil.getWidth();
        }

        @Override
        public int getHeight() {
            return (short)this.smkfil.getHeight();
        }

        @Override
        public void close() {
            if (this.smkSource != null) {
                this.smkSource.stop();
            }
            this.smkSource = null;
        }

        @Override
        public void playAudio() {
            this.smkStartWAV(this.sndPath);
        }

        public void setSoundPath(String sndPath) {
            this.sndPath = sndPath;
        }

        private void smkStartWAV(String sampleName) {
            if (Main.cfg.isNoSound() || sampleName == null || sampleName.isEmpty()) {
                return;
            }
            Entry entry = Main.game.getCache().getEntry(sampleName, true);
            if (!entry.exists()) {
                Console.out.println("Could not load wav file: " + sampleName, OsdColor.RED);
                return;
            }
            byte[] buf = entry.getBytes();
            int sampleSize = buf.length;
            if (sampleSize == 0) {
                return;
            }
            try {
                SoundData wavData = SOUND.getSoundDecoder("WAV").decode(entry);
                if (wavData != null) {
                    this.smkSource = SOUND.newSound(wavData.getData(), wavData.getRate(), wavData.getBits(), wavData.getChannels(), 255);
                    if (this.smkSource != null) {
                        this.smkSource.play(1.0f);
                    }
                }
            }
            catch (Exception e) {
                Console.out.println(e + " in " + sampleName, OsdColor.RED);
            }
        }
    }
}

