/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import java.io.InputStream;
import java.util.List;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Screens.GameScreen;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.DemoFile;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameKeys;

public class DemoScreen
extends GameScreen {
    protected Entry lastDemoFile = Directory.DUMMY_ENTRY;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LOADSAVE.lastload = null;
        View.resetQuotes();
    }

    public boolean showDemo(Entry res, BloodIniFile ini) {
        String name = res.getName();
        if (res.exists()) {
            if (!res.isExtension("dem")) {
                Console.out.println("Wrong file format: " + name, OsdColor.RED);
                return false;
            }
            Globals.gInfiniteAmmo = false;
            Globals.gFullMap = false;
            Globals.gNoClip = false;
            Globals.kFakeMultiplayer = false;
            Globals.pGameInfo.copy(Globals.defGameInfo);
            if (Mmulti.numplayers > 1) {
                Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
            }
            try (InputStream is = res.getInputStream();){
                DemoUtils.demfile = new DemoFile(is);
            }
            catch (Exception e) {
                Console.out.println("Can't play the demo file: " + name, OsdColor.RED);
                return false;
            }
            if (DemoUtils.demfile.nInputCount == 0) {
                Console.out.println("Can't play the demo file: " + name, OsdColor.RED);
                return false;
            }
            View.gViewIndex = DemoUtils.demfile.nMyConnectIndex;
            Mmulti.connecthead = DemoUtils.demfile.nConnectHead;
            System.arraycopy(DemoUtils.demfile.connectPoints, 0, Mmulti.connectpoint2, 0, 8);
            this.lastDemoFile = res;
            Main.gDemoScreen.newgame(false, ini, Globals.pGameInfo.nEpisode, Globals.pGameInfo.nLevel, Globals.pGameInfo.nDifficulty, Globals.pGameInfo.nDifficulty, Globals.pGameInfo.nDifficulty, false);
            Console.out.println("Playing demo " + name);
            return true;
        }
        Console.out.println("Can't play the demo file: " + name, OsdColor.RED);
        return false;
    }

    @Override
    protected void startboard(Runnable startboard) {
        Main.game.doPrecache(() -> {
            startboard.run();
            this.pNet.ResetTimers();
            this.pNet.ready2send = false;
        });
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, false)) {
            return true;
        }
        if (GameKeys.Shrink_Screen.equals(gameKey)) {
            View.viewResizeView(Main.cfg.gViewSize + 1);
        }
        if (GameKeys.Enlarge_Screen.equals(gameKey)) {
            View.viewResizeView(Main.cfg.gViewSize - 1);
        }
        return false;
    }

    @Override
    public void render(float delta) {
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!Main.game.gPaused && ((smoothratio = (float)this.pEngine.getTimer().getsmoothratio(delta)) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        Main.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        Main.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        this.pEngine.nextpage(delta);
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!Main.game.isCurrentScreen(this)) {
            return;
        }
        while (!Main.game.gPaused && Main.engine.getTotalClock() >= this.pNet.ototalclock) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                INPUT pInput = DemoUtils.demfile.pDemoInput[DemoUtils.demfile.rcnt][i];
                if (pInput != null) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[i] & 0xFF][i].Copy(pInput);
                    short s = i;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                }
                if (++DemoUtils.demfile.rcnt >= DemoUtils.demfile.nInputCount) {
                    DemoUtils.demfile = null;
                    Group group = this.lastDemoFile.getParent();
                    if (!this.showDemo(group)) {
                        Main.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                i = Mmulti.connectpoint2[i];
            }
            Main.game.pInt.clearinterpolations();
            this.pNet.ototalclock += Main.game.pEngine.getTimer().getFrameTicks();
            this.ProcessFrame(this.pNet);
        }
    }

    public boolean showDemo(Group group) {
        List<Entry> list = DemoUtils.checkDemoEntry(group);
        switch (Main.cfg.gDemoSeq) {
            case 0: {
                return false;
            }
            case 1: {
                if (DemoUtils.nDemonum < list.size() - 1) {
                    ++DemoUtils.nDemonum;
                    break;
                }
                DemoUtils.nDemonum = 0;
                break;
            }
            case 2: {
                int nextnum = DemoUtils.nDemonum;
                if (list.size() > 1) {
                    while (nextnum == DemoUtils.nDemonum) {
                        nextnum = (int)(Math.random() * (double)list.size());
                    }
                }
                DemoUtils.nDemonum = Gameutils.BClipRange(nextnum, 0, list.size() - 1);
            }
        }
        if (!list.isEmpty()) {
            boolean result = this.showDemo(list.get(DemoUtils.nDemonum), LEVELS.currentEpisode != null ? LEVELS.currentEpisode.iniFile : null);
            if (!result) {
                list.remove(DemoUtils.nDemonum);
                return this.showDemo(group);
            }
            return true;
        }
        return false;
    }

    public boolean isRecordEnabled() {
        return false;
    }

    public void onPrepareboard(GameScreen screen) {
        if (screen != this && DemoScreen.isDemoPlaying()) {
            Main.gDemoScreen.onStopPlaying();
        }
    }

    public boolean isDemoRecording() {
        return false;
    }

    public static boolean isDemoPlaying() {
        return DemoUtils.demfile != null;
    }

    public void onLoad() {
    }

    public void onStopPlaying() {
        DemoUtils.demfile = null;
    }

    public void onRecord() {
    }

    public void onStopRecord() {
    }
}

