/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.net.Mmulti;

public class StatisticScreen
extends SkippableAdapter {
    protected float gTicks;
    protected float gShowTime;
    protected boolean maySkipped;
    protected Main app;
    protected BloodEngine engine;

    public StatisticScreen(Main game, float gShowTime) {
        super(game);
        this.app = game;
        this.engine = Main.engine;
        this.gShowTime = gShowTime;
    }

    @Override
    public void show() {
        this.gTicks = 0.0f;
        this.maySkipped = false;
        Screen.scrReset();
        this.engine.getPaletteManager().setPalette(0);
        SOUND.sndStopAllSounds();
        SOUND.sndStartSample(268, 128, -1, false);
    }

    @Override
    public void draw(float delta) {
        float f;
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        this.viewShowStatus(this.maySkipped);
        this.gTicks += delta;
        if (f >= this.gShowTime) {
            this.maySkipped = true;
        }
    }

    public void viewShowStatus(boolean maySkipped) {
        View.viewShowLoadingTile();
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x140000, 65536, 0, 2038, -128, 0, 78);
        if (Globals.pGameInfo.nGameType > 1) {
            this.game.getFont(1).drawTextScaled(renderer, 160, 20 - this.game.getFont(1).getSize() / 2, Strings.frags, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            this.game.getFont(3).drawTextScaled(renderer, 85, 35, "#", 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
            this.game.getFont(3).drawTextScaled(renderer, 110, 35, "name", 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
            this.game.getFont(3).drawTextScaled(renderer, 225, 35, "frags", 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
            short i = Mmulti.connecthead;
            while (i >= 0) {
                View.viewDrawNumber(3, i, 85, 50 + i * 10, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
                this.game.getFont(3).drawTextScaled(renderer, 110, 50 + i * 10, this.app.net.gProfile[i].name, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
                View.viewDrawNumber(3, Globals.gPlayer[i].fragCount, 225, 50 + i * 10, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
                i = Mmulti.connectpoint2[i];
            }
        } else {
            this.game.getFont(1).drawTextScaled(renderer, 160, 20 - this.game.getFont(1).getSize() / 2, Strings.levelstats, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            if (Globals.cheatsOn) {
                this.game.getFont(3).drawTextScaled(renderer, 160, 32, ">>> YOU CHEATED! <<<", 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
            }
            View.viewFragStat();
            View.viewSecretStat();
        }
        this.game.getFont(3).drawTextScaled(renderer, 20, 191, Main.game.sversion, 1.0f, 32, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        if (maySkipped && (this.engine.getTotalClock() & 0x20) != 0) {
            this.game.getFont(3).drawTextScaled(renderer, 160, 134, Strings.keycontinue, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        }
    }

    @Override
    public void skip() {
        if (this.maySkipped) {
            Main.gGameScreen.nextmap();
        }
        super.skip();
    }
}

