/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.CompareService;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Blood.Types.CompareService.CompareItem;
import ru.m210projects.Build.filehandle.StreamUtils;

public class QueueItem
implements CompareItem {
    private final PriorityItem[] qList;
    private final int nodeCount;

    public QueueItem(PriorityItem[] qList, int nodeCount) {
        this.nodeCount = nodeCount;
        this.qList = qList;
    }

    @Override
    public boolean compare(InputStream is) throws IOException {
        int readCount = StreamUtils.readInt(is);
        boolean equals = this.nodeCount == readCount;
        for (int i = 0; i < 1024; ++i) {
            PriorityItem item = this.qList[i];
            int readPriority = StreamUtils.readInt(is);
            int readEvent = StreamUtils.readInt(is);
            if (item.priority == (long)readPriority && item.event == readEvent) continue;
            System.out.println("Unsync in " + this.getName() + ": " + i);
            equals = false;
        }
        return equals;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.nodeCount);
        for (int i = 0; i < 1024; ++i) {
            StreamUtils.writeInt(os, (int)this.qList[i].priority);
            StreamUtils.writeInt(os, this.qList[i].event);
        }
    }

    @Override
    public String getName() {
        return "PriorityQueue";
    }
}

