/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import com.badlogic.gdx.ScreenAdapter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.filehandlers.DemoFile;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class DemoUtils {
    public static Map<Group, List<Entry>> demofiles = new HashMap<Group, List<Entry>>();
    public static int nDemonum = -1;
    public static DemoFile demfile = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkDemoEntry(Entry file, boolean showErrorMessage) {
        if (!file.exists()) return false;
        if (!file.isExtension("dem")) return false;
        try (InputStream is = file.getInputStream();){
            String signature = StreamUtils.readString(is, 4);
            short version = StreamUtils.readShort(is);
            if (signature.equals("DEM\u001a") && version == 277) {
                boolean bl = true;
                return bl;
            }
            if (!showErrorMessage) return false;
            String demVersion = "unknown";
            if (version == 256) {
                demVersion = "v1.00";
            }
            if (version == 266) {
                demVersion = "v1.10";
            } else if (version == 267) {
                demVersion = "v1.11";
            }
            String name = file.getName();
            Console.out.println("Wrong version of the demofile found: " + name + " (" + demVersion + " != v1.21)", OsdColor.RED);
            return false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List<Entry> checkDemoEntry(Group group) {
        if (demofiles.containsKey(group)) {
            return demofiles.get(group);
        }
        nDemonum = -1;
        List<Entry> demos = group.stream().filter(e -> DemoUtils.checkDemoEntry(e, true)).sorted(Entry::compareTo).collect(Collectors.toList());
        demofiles.put(group, demos);
        Console.out.println("There are " + demos.size() + " demo(s) in the loop", OsdColor.YELLOW);
        if (Main.cfg.gDemoSeq == 2) {
            int nextnum = nDemonum;
            if (demos.size() > 1) {
                while (nextnum == nDemonum) {
                    nextnum = (int)(Math.random() * (double)demos.size());
                }
            }
            nDemonum = nextnum;
        }
        return demos;
    }

    public static boolean IsOriginalDemo(ScreenAdapter screen) {
        return screen == Main.gDemoScreen && demfile != null && DemoUtils.demfile.nVersion == 277 || Globals.pGameInfo.nGameType == 0 && Main.cfg.gVanilla;
    }

    public static boolean IsOriginalDemo() {
        return Globals.pGameInfo.nGameType == 0 && Main.cfg.gVanilla || Main.game.isCurrentScreen(Main.gDemoScreen) && demfile != null && DemoUtils.demfile.nVersion == 277;
    }
}

