/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.FileEntry;

public class EpisodeManager {
    private final Map<String, BloodIniFile> episodeCache = new HashMap<String, BloodIniFile>();

    public void putEpisode(BloodIniFile bloodIniFile) {
        this.episodeCache.put(bloodIniFile.getEpisodeEntry().getHashKey(), bloodIniFile);
    }

    public List<EpisodeEntry> getEpisodeEntries(FileEntry file) {
        EpisodeEntry.File entry;
        BloodIniFile ini;
        ArrayList<EpisodeEntry> list = new ArrayList<EpisodeEntry>();
        if (file.isExtension("zip") || file.isExtension("pk3") || file.isExtension("grp") || file.isExtension("rff")) {
            Group group = Main.game.getCache().getGroup(file.getRelativePath().toString());
            if (group.isEmpty()) {
                group = Main.game.getCache().newGroup(file);
            }
            for (Entry groupEntry : group.getEntries()) {
                EpisodeEntry.Pack entry2;
                BloodIniFile ini2;
                if (!groupEntry.isExtension("ini") || (ini2 = this.episodeCache.computeIfAbsent((entry2 = new EpisodeEntry.Pack(file, groupEntry)).getHashKey(), e -> this.buildEpisode(entry2))) == null) continue;
                list.add(entry2);
            }
        } else if (file.isExtension("ini") && (ini = this.episodeCache.computeIfAbsent((entry = new EpisodeEntry.File(file)).getHashKey(), e -> this.buildEpisode(entry))) != null) {
            list.add(entry);
        }
        return list;
    }

    public BloodIniFile getEpisode(EpisodeEntry entry) {
        if (entry != null) {
            return this.episodeCache.get(entry.getHashKey());
        }
        return null;
    }

    private BloodIniFile buildEpisode(EpisodeEntry file) {
        BloodIniFile ini = new BloodIniFile(file);
        for (int i = 0; i < 6; ++i) {
            if (!ini.set("Episode" + (i + 1))) continue;
            return ini;
        }
        return null;
    }
}

