/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Hud;

import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Types.Hud.HudRenderer;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public abstract class HudScaledRenderer
extends HudRenderer {
    protected int nScale = 65536;

    public void setScale(int nScale) {
        BloodRenderer renderer = Main.game.getRenderer();
        this.nScale = Pragmas.scale(renderer.getHeight(), nScale, 240L);
    }

    @Override
    public abstract void draw(PLAYER var1, int var2, int var3);

    protected float convertX(float x, int scale, ConvertType type) {
        BloodRenderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        if (type == ConvertType.AlignLeft) {
            return x * (float)scale / 65536.0f;
        }
        if (type == ConvertType.AlignRight) {
            return (float)xdim - (320.0f - x) * (float)scale / 65536.0f;
        }
        if (type == ConvertType.Normal) {
            return (float)(xdim / 2) - (160.0f - x) * (float)scale / 65536.0f;
        }
        return x;
    }

    protected float convertY(float y, int nScale) {
        BloodRenderer renderer = Main.game.getRenderer();
        int ydim = renderer.getHeight();
        return (float)ydim - (200.0f - y) * (float)nScale / 65536.0f;
    }

    protected ConvertType getType(int nFlags) {
        ConvertType type = ConvertType.Normal;
        if ((nFlags & 0x100) != 0) {
            type = ConvertType.AlignLeft;
        }
        if ((nFlags & 0x200) != 0) {
            type = ConvertType.AlignRight;
        }
        if ((nFlags & 0x400) != 0) {
            type = ConvertType.Stretch;
        }
        return type;
    }

    @Override
    public void showInventoryItems(PLAYER pPlayer, int sx, int sy, int fx, int fy, int nFlags) {
        if (pPlayer.choosedInven >= 0) {
            this.DrawStatSprite(viewInventoryTile[pPlayer.choosedInven], sx, sy, 0, 0, nFlags, this.nScale);
            this.DrawStatNumber(3, pPlayer.Inventory[pPlayer.choosedInven].amount, 2250, fx, fy, 4, 0, nFlags, this.nScale);
        }
    }

    @Override
    public void DrawStatNumber(int slen, int n, int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        Strhandler.Bsprintf(number_buffer, slen, n, 1);
        BloodRenderer renderer = Main.game.getRenderer();
        ConvertType type = this.getType(nFlags);
        y = (int)(this.convertY(y, nScale) * 65536.0f);
        ArtEntry pic = Main.engine.getTile(nTile);
        for (int i = 0; i < slen; ++i) {
            if (number_buffer[i] != ' ') {
                renderer.rotatesprite((int)(this.convertX(x, nScale, type) * 65536.0f), y, nScale, 0, nTile + number_buffer[i] - 48, nShade, nPLU, nFlags | 8);
            }
            x += pic.getWidth() + 1;
        }
    }

    @Override
    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags) {
        int nAngle = 0;
        BloodRenderer renderer = Main.game.getRenderer();
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        renderer.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, nAngle, (short)nTile, nShade, nPLU, nFlags | 8);
    }

    @Override
    public void DrawStatMaskedSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags, float cx1, float cy1, float cx2, float cy2) {
        int nAngle = 0;
        BloodRenderer renderer = Main.game.getRenderer();
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        renderer.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale / 2, nAngle, (short)nTile, nShade, nPLU, nFlags | 8, (int)this.convertX(cx1, this.nScale / 2, this.getType(nFlags)), (int)this.convertY(cy1, this.nScale / 2), (int)this.convertX(cx2, this.nScale / 2, this.getType(nFlags)), (int)this.convertY(cy2, this.nScale / 2));
    }

    @Override
    public void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlags, int nScale) {
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite((int)(this.convertX(x, nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, nScale) * 65536.0f), nScale, 0, nTile, nShade, nPLU, nFlags | 8);
    }

    @Override
    public void TileHGauge(int nTile, int x, int y, int n, int total, int nFlags) {
        int nGauge = n * Main.engine.getTile(nTile).getWidth() / total;
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite((int)(this.convertX(x, this.nScale, this.getType(nFlags)) * 65536.0f), (int)(this.convertY(y, this.nScale) * 65536.0f), this.nScale, 0, nTile, 0, 0, 0x18 | nFlags, 0, 0, (int)this.convertX(x + nGauge + 1, this.nScale, this.getType(nFlags)), renderer.getHeight() - 1);
    }

    @Override
    protected void viewDrawStats(int yoffs) {
        this.viewDrawStats((int)this.convertX(5.0f, this.nScale, ConvertType.AlignLeft), (int)this.convertY(160 + yoffs, this.nScale), Main.cfg.gStatSize);
    }

    @Override
    protected void viewDrawStats(int x, int y, int zoom) {
        if (Main.cfg.gShowStat == 0 || Globals.pGameInfo.nGameType >= 2 || Main.cfg.gShowStat == 2 && View.gViewMode != 4) {
            return;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        zoom = Pragmas.scale(renderer.getHeight(), zoom, 240L);
        float viewzoom = (float)zoom / 65536.0f;
        Strhandler.Bitoa(LEVELS.kills, number_buffer);
        int alignx = Main.game.getFont(3).getWidth(number_buffer, viewzoom);
        int yoffset = (int)((float)(2 * (Main.game.getFont(3).getSize() - 1)) * viewzoom);
        int statx = x;
        int staty = y -= yoffset;
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, Strings.killsstat2, viewzoom, 32, 7, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, number_buffer, viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx += alignx + 2, staty, "/", viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        Strhandler.Bitoa(LEVELS.totalKills, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, number_buffer, viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        statx = x;
        staty = y + (int)(8.0f * viewzoom);
        Strhandler.Bitoa(LEVELS.foundSecret, number_buffer);
        alignx = Main.game.getFont(3).getWidth(number_buffer, viewzoom);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, Strings.secretsstat, viewzoom, 32, 7, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        statx = (int)((float)statx + 9.0f * viewzoom);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, number_buffer, viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx += alignx + 2, staty, "/", viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
        Strhandler.Bitoa(LEVELS.totalSecrets, number_buffer);
        statx = (int)((float)statx + 8.0f * viewzoom);
        Main.game.getFont(3).drawTextScaled((Renderer)renderer, statx, staty, number_buffer, viewzoom, 32, 0, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
    }
}

