/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.LongArray;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.Types.BUSY;
import ru.m210projects.Blood.Types.GAMEINFO;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.POSTPONE;
import ru.m210projects.Blood.Types.Seq.CeilingInst;
import ru.m210projects.Blood.Types.Seq.FloorInst;
import ru.m210projects.Blood.Types.Seq.MaskedWallInst;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.Seq.WallInst;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.fs.NotFoundEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class SafeLoader {
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public short[] connectpoint2 = new short[8];
    public int randomseed;
    public int visibility;
    public int parallaxvisibility;
    public byte automapping;
    public BitMap show2dsector = new BitMap(1024);
    public BitMap show2dwall = new BitMap(8192);
    public BitMap show2dsprite = new BitMap(4096);
    public byte[] gotpic = new byte[Engine.MAXTILES + 7 >> 3];
    public Hitscan safeHitInfo;
    public int numsectors;
    public int numwalls;
    public int numsprites;
    public List<Sector> sector;
    public List<Wall> wall;
    public List<Sprite> sprite;
    public Array<Vector2> kwall = new Array(true, 8192, Vector2.class);
    public IntArray secFloorZ = new IntArray(1024);
    public IntArray secCeilZ = new IntArray(1024);
    public IntArray secPath = new IntArray(1024);
    public LongArray floorVel = new LongArray(1024);
    public LongArray ceilingVel = new LongArray(1024);
    public IntArray gUpperLink = new IntArray(1024);
    public IntArray gLowerLink = new IntArray(1024);
    public Map<Integer, XSPRITE> xspriteMap = new HashMap<Integer, XSPRITE>();
    public XWALL[] xwall = new XWALL[512];
    public XSECTOR[] xsector = new XSECTOR[512];
    public int[] nextXWall = new int[512];
    public int[] nextXSector = new int[512];
    public GAMEINFO safeGameInfo = new GAMEINFO();
    public boolean showinvisibility;
    public boolean gNoClip;
    public boolean gFogMode;
    public boolean gFullMap;
    public boolean gPaused;
    public boolean gInfiniteAmmo;
    public boolean cheatsOn;
    public int gSkyCount;
    public int gFrameClock;
    public int gTicks;
    public int gFrame;
    public int gGameClock;
    public ZONE[] gStartZone = new ZONE[8];
    public int mirrorcnt;
    public int[] MirrorType = new int[16];
    public int[] MirrorX = new int[16];
    public int[] MirrorY = new int[16];
    public int[] MirrorZ = new int[16];
    public int[] MirrorLower = new int[16];
    public int[] MirrorUpper = new int[16];
    public int MirrorSector;
    public int[] MirrorWall = new int[4];
    public SeqInst[] siWall = new SeqInst[512];
    public SeqInst[] siMasked = new SeqInst[512];
    public SeqInst[] siCeiling = new SeqInst[512];
    public SeqInst[] siFloor = new SeqInst[512];
    public short[] actListIndex = new short[4096];
    public byte[] actListType = new byte[4096];
    public int activeCount;
    public int[] rxBucketIndex = new int[4096];
    public int[] rxBucketType = new int[4096];
    public short[] bucketHead = new short[1025];
    public PriorityItem[] qEventItems = new PriorityItem[1025];
    public int fNodeCount;
    public int gBusyCount = 0;
    public BUSY[] gBusy = new BUSY[128];
    public int[] nTeamCount = new int[8];
    public int gNetPlayers;
    public byte[] autoaim = new byte[8];
    public byte[] slopetilt = new byte[8];
    public byte[] skill = new byte[8];
    public String[] name = new String[8];
    public PLAYER[] safePlayer = new PLAYER[8];
    public IntArray gWallExp = new IntArray(512);
    public IntArray gSectorExp = new IntArray(1024);
    public Array<POSTPONE> gPost = new Array(true, 4096, POSTPONE.class);
    public int gPostCount;
    public int gNextMap;
    public int foundSecret;
    public int totalSecrets;
    public int superSecrets;
    public int totalKills;
    public int kills;
    public int deliriumTilt = 0;
    public int deliriumTurn = 0;
    public int deliriumPitch = 0;
    public boolean gUserEpisode;
    public boolean gForceMap;
    public BloodIniFile addon;
    public String addonFileName;
    public String addonPackedIniName;
    private String message;

    public SafeLoader() {
        int i;
        for (i = 0; i < 512; ++i) {
            this.xwall[i] = new XWALL();
        }
        for (i = 0; i < 512; ++i) {
            this.xsector[i] = new XSECTOR();
        }
        for (i = 0; i < 8; ++i) {
            this.gStartZone[i] = new ZONE();
            this.safePlayer[i] = new PLAYER();
        }
        for (i = 0; i < 512; ++i) {
            this.siWall[i] = new WallInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siMasked[i] = new MaskedWallInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siCeiling[i] = new CeilingInst();
        }
        for (i = 0; i < 512; ++i) {
            this.siFloor[i] = new FloorInst();
        }
        for (i = 0; i < 128; ++i) {
            this.gBusy[i] = new BUSY();
        }
        this.safeHitInfo = new Hitscan();
    }

    public String getMessage() {
        return this.message;
    }

    public boolean load(InputStream is) {
        this.addon = null;
        this.addonFileName = null;
        this.addonPackedIniName = null;
        this.message = null;
        this.gUserEpisode = false;
        try {
            this.gPost.clear();
            this.xspriteMap.clear();
            this.kwall.clear();
            this.gSectorExp.clear();
            this.gWallExp.clear();
            this.secFloorZ.clear();
            this.secCeilZ.clear();
            this.secPath.clear();
            this.floorVel.clear();
            this.ceilingVel.clear();
            this.gUpperLink.clear();
            this.gLowerLink.clear();
            Arrays.fill(this.gotpic, (byte)0);
            for (int i = 0; i < 8; ++i) {
                this.autoaim[i] = -1;
                this.slopetilt[i] = -1;
                this.skill[i] = -1;
                this.name[i] = null;
            }
            StreamUtils.skip(is, 64033);
            this.LoadGDXBlock(is);
            this.MyLoad110(is);
            this.cheatsOn = StreamUtils.readBoolean(is);
            this.WarpLoad(is);
            this.MirrorLoad(is);
            this.SeqLoad(is);
            this.EventLoad(is);
            this.TriggersLoad(is);
            this.PlayersLoad(is, 304);
            this.ActorsLoad(is);
            this.gNextMap = StreamUtils.readInt(is);
            this.StatsLoad(is);
            this.ScreenLoad(is);
            if (this.gUserEpisode) {
                this.addon = SafeLoader.findAddon(this.addonFileName, this.addonPackedIniName);
                if (this.addon == null) {
                    this.message = "Can't find user episode file: " + this.addonFileName;
                    this.gUserEpisode = false;
                    this.safeGameInfo.nEpisode = 0;
                    this.safeGameInfo.nLevel = 16;
                    this.gForceMap = true;
                }
            }
            if (is.available() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void MyLoad110(InputStream is) throws IOException {
        int i;
        this.LoadGameInfo(is);
        this.numsectors = StreamUtils.readInt(is);
        this.numwalls = StreamUtils.readInt(is);
        this.numsprites = StreamUtils.readInt(is);
        this.sector = new ArrayList<Sector>(this.numsectors * 2);
        for (i = 0; i < this.numsectors + 1; ++i) {
            this.sector.add(new Sector().readObject(is));
        }
        this.wall = new ArrayList<Wall>(this.numwalls * 2);
        for (i = 0; i < this.numwalls + 4; ++i) {
            this.wall.add(new Wall().readObject(is));
        }
        this.sprite = new ArrayList<Sprite>(this.numsprites * 2);
        for (i = 0; i < this.numsprites; ++i) {
            BloodSprite spr = new BloodSprite();
            this.sprite.add(spr.readObject(is));
            if (spr.getStatnum() >= 1024 || spr.getExtra() < 0) continue;
            XSPRITE pXSprite = new XSPRITE();
            pXSprite.readObject(is);
            pXSprite.getSpriteHit().readObject(is);
            pXSprite.getSeqInst().readObject(is);
            pXSprite.getDudeExtra().readObject(is);
            this.xspriteMap.put(Integer.valueOf(spr.getExtra()), pXSprite);
        }
        this.randomseed = StreamUtils.readInt(is);
        StreamUtils.readUnsignedByte(is);
        this.showinvisibility = StreamUtils.readBoolean(is);
        StreamUtils.readInt(is);
        this.parallaxyscale = StreamUtils.readInt(is);
        this.visibility = StreamUtils.readInt(is);
        this.parallaxvisibility = StreamUtils.readInt(is);
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = StreamUtils.readShort(is);
        }
        this.pskybits = StreamUtils.readShort(is);
        this.show2dsector.readObject(is);
        this.show2dwall.readObject(is);
        this.show2dsprite.readObject(is);
        this.automapping = (byte)StreamUtils.readUnsignedByte(is);
        this.gFrameClock = StreamUtils.readInt(is);
        this.gTicks = StreamUtils.readInt(is);
        this.gFrame = StreamUtils.readInt(is);
        this.gGameClock = StreamUtils.readInt(is);
        this.gPaused = StreamUtils.readBoolean(is);
        for (i = 0; i < this.numwalls; ++i) {
            this.kwall.add(new Vector2(StreamUtils.readInt(is), StreamUtils.readInt(is)));
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.secFloorZ.add(StreamUtils.readInt(is));
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.secCeilZ.add(StreamUtils.readInt(is));
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.floorVel.add(StreamUtils.readInt(is));
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.ceilingVel.add(StreamUtils.readInt(is));
        }
        this.safeHitInfo.hitsect = StreamUtils.readShort(is);
        this.safeHitInfo.hitwall = StreamUtils.readShort(is);
        this.safeHitInfo.hitsprite = StreamUtils.readShort(is);
        this.safeHitInfo.hitx = StreamUtils.readInt(is);
        this.safeHitInfo.hity = StreamUtils.readInt(is);
        this.safeHitInfo.hitz = StreamUtils.readInt(is);
        this.gForceMap = StreamUtils.readBoolean(is);
        StreamUtils.skip(is, 128);
        for (i = 0; i < 512; ++i) {
            this.nextXWall[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 512; ++i) {
            this.nextXSector[i] = StreamUtils.readShort(is);
        }
        for (i = 0; i < 512; ++i) {
            this.xwall[i].free();
        }
        for (i = 0; i < this.numwalls; ++i) {
            Wall pWall = this.wall.get(i);
            if (pWall.getExtra() <= 0) continue;
            this.xwall[pWall.getExtra()].readObject(is);
        }
        for (i = 0; i < 512; ++i) {
            this.xsector[i].free();
        }
        for (i = 0; i < this.numsectors; ++i) {
            Sector pSector = this.sector.get(i);
            if (pSector.getExtra() <= 0) continue;
            this.xsector[pSector.getExtra()].readObject(is);
        }
        this.gSkyCount = StreamUtils.readInt(is);
        this.gFogMode = StreamUtils.readBoolean(is);
        this.gNoClip = false;
        this.gFullMap = false;
    }

    public void LoadGameInfo(InputStream is) throws IOException {
        this.safeGameInfo.nGameType = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nDifficulty = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nEpisode = StreamUtils.readInt(is);
        this.safeGameInfo.nLevel = StreamUtils.readInt(is);
        Path path = FileUtils.getPath(StreamUtils.readString(is, 144).trim(), new String[0]);
        this.safeGameInfo.zLevelName = Main.game.getCache().getEntry(path, true);
        if (!this.safeGameInfo.zLevelName.exists()) {
            this.safeGameInfo.zLevelName = new NotFoundEntry(path);
        }
        this.safeGameInfo.zLevelSong = StreamUtils.readString(is, 144).trim();
        this.safeGameInfo.nTrackNumber = StreamUtils.readInt(is);
        this.safeGameInfo.uMapCRC = StreamUtils.readInt(is);
        this.safeGameInfo.nMonsterSettings = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.uGameFlags = StreamUtils.readInt(is);
        this.safeGameInfo.uNetGameFlags = StreamUtils.readInt(is);
        this.safeGameInfo.nWeaponSettings = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nItemSettings = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nRespawnSettings = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nTeamSettings = StreamUtils.readUnsignedByte(is);
        this.safeGameInfo.nMonsterRespawnTime = StreamUtils.readInt(is);
        this.safeGameInfo.nWeaponRespawnTime = StreamUtils.readInt(is);
        this.safeGameInfo.nItemRespawnTime = StreamUtils.readInt(is);
        this.safeGameInfo.nSpecialRespawnTime = StreamUtils.readInt(is);
    }

    public void WarpLoad(InputStream is) throws IOException {
        int i;
        for (i = 0; i < 8; ++i) {
            this.gStartZone[i].x = StreamUtils.readInt(is);
            this.gStartZone[i].y = StreamUtils.readInt(is);
            this.gStartZone[i].z = StreamUtils.readInt(is);
            this.gStartZone[i].sector = StreamUtils.readShort(is);
            this.gStartZone[i].angle = StreamUtils.readShort(is);
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.gUpperLink.add(StreamUtils.readInt(is));
            this.gLowerLink.add(StreamUtils.readInt(is));
        }
    }

    public void MirrorLoad(InputStream is) throws IOException {
        int i;
        this.mirrorcnt = StreamUtils.readInt(is);
        this.MirrorSector = StreamUtils.readInt(is);
        for (i = 0; i < 16; ++i) {
            this.MirrorType[i] = StreamUtils.readShort(is);
            this.MirrorLower[i] = StreamUtils.readInt(is);
            this.MirrorX[i] = StreamUtils.readInt(is);
            this.MirrorY[i] = StreamUtils.readInt(is);
            this.MirrorZ[i] = StreamUtils.readInt(is);
            this.MirrorUpper[i] = StreamUtils.readInt(is);
        }
        for (i = 0; i < 4; ++i) {
            this.MirrorWall[i] = StreamUtils.readInt(is);
        }
    }

    public void SeqLoad(InputStream is) throws IOException {
        int i;
        for (i = 0; i < 512; ++i) {
            this.siWall[i].readObject(is);
        }
        for (i = 0; i < 512; ++i) {
            this.siMasked[i].readObject(is);
        }
        for (i = 0; i < 512; ++i) {
            this.siCeiling[i].readObject(is);
        }
        for (i = 0; i < 512; ++i) {
            this.siFloor[i].readObject(is);
        }
        this.activeCount = StreamUtils.readInt(is);
        Arrays.fill(this.actListType, (byte)0);
        Arrays.fill(this.actListIndex, (short)0);
        for (i = 0; i < this.activeCount; ++i) {
            this.actListType[i] = StreamUtils.readByte(is);
            this.actListIndex[i] = StreamUtils.readShort(is);
            SeqInst pInst = this.GetInstance(this.actListType[i], this.actListIndex[i]);
            if (pInst != null) {
                if (!pInst.isPlaying() || Main.game.getCache().contains(pInst.getSeqIndex(), "SEQ")) continue;
                throw new FileNotFoundException("hSeq != null, id=" + pInst.getSeqIndex() + " \n\rWrong Blood.RFF version or file corrupt!");
            }
            throw new FileNotFoundException("pInst != null\n\rWrong Blood.RFF version or file corrupt!");
        }
    }

    private SeqInst GetInstance(int type, int nXIndex) {
        switch (type) {
            case 0: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siWall[nXIndex];
            }
            case 1: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siCeiling[nXIndex];
            }
            case 2: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siFloor[nXIndex];
            }
            case 3: {
                if (!this.xspriteMap.containsKey(nXIndex)) {
                    return null;
                }
                return this.xspriteMap.get(nXIndex).getSeqInst();
            }
            case 4: {
                if (nXIndex <= 0 || nXIndex >= 512) {
                    return null;
                }
                return this.siMasked[nXIndex];
            }
        }
        return null;
    }

    public void EventLoad(InputStream is) throws IOException {
        int i;
        this.fNodeCount = StreamUtils.readInt(is);
        for (i = 0; i < this.fNodeCount; ++i) {
            this.qEventItems[i] = new PriorityItem(StreamUtils.readInt(is), StreamUtils.readInt(is));
        }
        for (i = 0; i < 4096; ++i) {
            int data = StreamUtils.readInt(is);
            this.rxBucketIndex[i] = EVENT.getIndex(data);
            this.rxBucketType[i] = EVENT.getType(data);
        }
        for (i = 0; i <= 1024; ++i) {
            this.bucketHead[i] = StreamUtils.readShort(is);
        }
    }

    public void TriggersLoad(InputStream is) throws IOException {
        int i;
        this.gBusyCount = StreamUtils.readInt(is);
        for (i = 0; i < 128; ++i) {
            this.gBusy[i].nIndex = StreamUtils.readInt(is);
            this.gBusy[i].nDelta = StreamUtils.readInt(is);
            this.gBusy[i].nBusy = StreamUtils.readInt(is);
            this.gBusy[i].busyProc = StreamUtils.readUnsignedByte(is);
        }
        for (i = 0; i < this.numsectors; ++i) {
            this.secPath.add(StreamUtils.readInt(is));
        }
    }

    public void PlayersLoad(InputStream is, int nVersion) throws IOException {
        int i;
        int i2;
        for (i2 = 0; i2 < 8; ++i2) {
            this.nTeamCount[i2] = StreamUtils.readInt(is);
        }
        this.gNetPlayers = StreamUtils.readInt(is);
        for (i2 = 0; i2 < this.gNetPlayers - 1; ++i2) {
            this.connectpoint2[i2] = (short)(i2 + 1);
        }
        this.connectpoint2[this.gNetPlayers - 1] = -1;
        byte[] plname = new byte[15];
        for (i = 0; i < 8; ++i) {
            this.autoaim[i] = (byte)StreamUtils.readUnsignedByte(is);
            if (nVersion >= 304) {
                this.slopetilt[i] = (byte)StreamUtils.readUnsignedByte(is);
            }
            this.skill[i] = (byte)StreamUtils.readUnsignedByte(is);
            StreamUtils.readBytes(is, plname);
            this.name[i] = new String(plname).trim();
        }
        for (i = 0; i < 8; ++i) {
            this.safePlayer[i].pInput = new INPUT(is, nVersion);
            this.safePlayer[i].setVersion(nVersion).readObject(is);
        }
    }

    public void ActorsLoad(InputStream is) throws IOException {
        int i;
        for (i = 0; i < this.numsectors; ++i) {
            this.gSectorExp.add(StreamUtils.readShort(is));
        }
        for (i = 0; i < 512; ++i) {
            this.gWallExp.add(StreamUtils.readShort(is));
        }
        this.gPostCount = StreamUtils.readInt(is);
        for (i = 0; i < this.gPostCount; ++i) {
            POSTPONE pPost = new POSTPONE();
            pPost.nSprite = StreamUtils.readShort(is);
            pPost.nStatus = StreamUtils.readShort(is);
            this.gPost.add(pPost);
        }
    }

    public void StatsLoad(InputStream is) throws IOException {
        this.totalSecrets = StreamUtils.readInt(is);
        this.foundSecret = StreamUtils.readInt(is);
        this.superSecrets = StreamUtils.readInt(is);
        this.totalKills = StreamUtils.readInt(is);
        this.kills = StreamUtils.readInt(is);
    }

    public void ScreenLoad(InputStream is) throws IOException {
        this.deliriumTilt = StreamUtils.readInt(is);
        this.deliriumTurn = StreamUtils.readInt(is);
        this.deliriumPitch = StreamUtils.readInt(is);
    }

    public void LoadUserEpisodeInfo(InputStream is) throws IOException {
        this.gUserEpisode = StreamUtils.readBoolean(is);
        if (this.gUserEpisode) {
            boolean isPacked = StreamUtils.readBoolean(is);
            this.addonFileName = StreamUtils.readDataString(is).toLowerCase();
            if (isPacked) {
                this.addonPackedIniName = StreamUtils.readDataString(is).toLowerCase();
            }
        }
    }

    public void LoadGDXBlock(InputStream is) throws IOException {
        this.LoadUserEpisodeInfo(is);
        byte[] data = StreamUtils.readBytes(is, 128);
        int pos = 0;
        this.safeGameInfo.nEnemyDamage = data[pos++];
        this.safeGameInfo.nEnemyQuantity = data[pos++];
        this.safeGameInfo.nDifficulty = data[pos++];
        this.safeGameInfo.nPitchforkOnly = data[pos++] == 1;
        this.gInfiniteAmmo = data[pos] == 1;
    }

    public BloodIniFile LoadGDXHeader(InputStream is) throws IOException {
        this.addon = null;
        this.addonFileName = null;
        this.addonPackedIniName = null;
        this.message = null;
        this.gUserEpisode = false;
        this.safeGameInfo.nDifficulty = -1;
        this.safeGameInfo.nEpisode = -1;
        this.safeGameInfo.nLevel = -1;
        StreamUtils.skip(is, 64033);
        this.LoadUserEpisodeInfo(is);
        StreamUtils.skip(is, 128);
        this.LoadGameInfo(is);
        if (this.gUserEpisode) {
            this.addon = SafeLoader.findAddon(this.addonFileName, this.addonPackedIniName);
        }
        return this.addon;
    }

    public static BloodIniFile findAddon(String addonFileName, String iniName) {
        try {
            FileEntry addonEntry = Main.game.getCache().getGameDirectory().getEntry(FileUtils.getPath(addonFileName, new String[0]));
            if (addonEntry.exists()) {
                if (iniName == null) {
                    iniName = addonEntry.getName();
                }
                String finalIniName = iniName;
                return ResourceHandler.episodeManager.getEpisodeEntries(addonEntry).stream().filter(e -> e.getIniFile().getName().equalsIgnoreCase(finalIniName)).map(e -> ResourceHandler.episodeManager.getEpisode((EpisodeEntry)e)).findAny().orElse(null);
            }
        }
        catch (Exception e2) {
            Console.out.println(e2.toString(), OsdColor.RED);
        }
        return null;
    }
}

