/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types;

import ru.m210projects.Build.Render.Types.ScreenFade;

public class ScreenEffect {
    public static final ScreenFade PICKUP_DAC = new PickupEffect();
    public static final ScreenFade HIT_DAC = new HitEffect();
    public static final ScreenFade BLIND_DAC = new BlindEffect();
    public static final ScreenFade DROWN_DAC = new DrownEffect();
    public static final ScreenFade[] SCREEN_DAC_ARRAY = new ScreenFade[]{PICKUP_DAC, HIT_DAC, BLIND_DAC, DROWN_DAC};

    public static void resetDacEffects() {
        PICKUP_DAC.setIntensive(0);
        HIT_DAC.setIntensive(0);
        BLIND_DAC.setIntensive(0);
        DROWN_DAC.setIntensive(0);
    }

    public static final class PickupEffect
    implements ScreenFade {
        private int pickupEffect;

        @Override
        public int getIntensive() {
            return this.pickupEffect;
        }

        @Override
        public PickupEffect setIntensive(int intensive) {
            this.pickupEffect = Math.min(255, intensive);
            return this;
        }

        @Override
        public String getName() {
            return "Pickup";
        }
    }

    public static final class HitEffect
    implements ScreenFade {
        private int hitEffect;

        @Override
        public int getRed() {
            return 2 * this.hitEffect;
        }

        @Override
        public int getGreen() {
            return -3 * this.hitEffect;
        }

        @Override
        public int getBlue() {
            return 3 * this.hitEffect;
        }

        @Override
        public int getIntensive() {
            return this.hitEffect;
        }

        @Override
        public ScreenFade setIntensive(int intensive) {
            this.hitEffect = Math.min(255, intensive);
            return this;
        }

        @Override
        public String getName() {
            return "Hit";
        }
    }

    public static final class BlindEffect
    implements ScreenFade {
        private int blindEffect;

        @Override
        public int getRed() {
            return -this.blindEffect;
        }

        @Override
        public int getGreen() {
            return -this.blindEffect;
        }

        @Override
        public int getIntensive() {
            return this.blindEffect;
        }

        @Override
        public ScreenFade setIntensive(int intensive) {
            this.blindEffect = Math.min(255, intensive);
            return this;
        }

        @Override
        public String getName() {
            return "Blind";
        }
    }

    public static final class DrownEffect
    implements ScreenFade {
        private int drownEffect;

        @Override
        public int getRed() {
            return -(this.drownEffect >> 6);
        }

        @Override
        public int getGreen() {
            return -(this.drownEffect >> 5);
        }

        @Override
        public int getBlue() {
            return this.drownEffect >> 6;
        }

        @Override
        public int getIntensive() {
            return this.drownEffect;
        }

        @Override
        public ScreenFade setIntensive(int intensive) {
            this.drownEffect = intensive;
            return this;
        }

        @Override
        public String getName() {
            return "Drown";
        }
    }
}

