/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.Seq.SeqFrame;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;

public class MaskedWallInst
extends SeqInst {
    @Override
    protected void updateInstance(int index) {
        if (index <= 0 || index >= 512) {
            throw new AssertException("nXWall > 0 && nXWall < kMaxXWalls");
        }
        int nWall = DB.xwall[index].reference;
        if (!Main.boardService.isValidWall(nWall)) {
            throw new AssertException("boardService.isValidWall(nWall)");
        }
        Wall pWall = Main.boardService.getWall(nWall);
        if (pWall.getExtra() != index) {
            throw new AssertException("pWall.extra == nXWall");
        }
        if (pWall.getNextwall() < 0) {
            throw new AssertException("pWall.nextwall >= 0");
        }
        Wall pWall2 = Main.boardService.getWall(pWall.getNextwall());
        SeqFrame pFrame = this.pSequence.getFrame(this.frameIndex);
        pWall.setOverpicnum(pFrame.nTile);
        pWall2.setOverpicnum(pFrame.nTile);
        if (pFrame.pal != 0) {
            pWall2.setPal(pFrame.pal);
            pWall.setPal(pFrame.pal);
        }
        if (pFrame.translucent) {
            pWall.setCstat(pWall.getCstat() | 0x80);
            pWall2.setCstat(pWall2.getCstat() | 0x80);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFF7F);
            pWall2.setCstat(pWall2.getCstat() & 0xFFFFFF7F);
        }
        if (pFrame.translucentR) {
            pWall.setCstat(pWall.getCstat() | 0x200);
            pWall2.setCstat(pWall2.getCstat() | 0x200);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFDFF);
            pWall2.setCstat(pWall2.getCstat() & 0xFFFFFDFF);
        }
        if (pFrame.blocking) {
            pWall.setCstat(pWall.getCstat() | 1);
            pWall2.setCstat(pWall2.getCstat() | 1);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFFFE);
            pWall2.setCstat(pWall2.getCstat() & 0xFFFFFFFE);
        }
        if (pFrame.hitscan) {
            pWall.setCstat(pWall.getCstat() | 0x40);
            pWall2.setCstat(pWall2.getCstat() | 0x40);
        } else {
            pWall.setCstat(pWall.getCstat() & 0xFFFFFFBF);
            pWall2.setCstat(pWall2.getCstat() & 0xFFFFFFBF);
        }
    }
}

