/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Types.Seq;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.Seq.SeqFrame;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class SeqType {
    private static final HashMap<Integer, SeqType> pSEQs = new HashMap();
    private final int kSeqLoop = 1;
    private final int kSeqRemove = 2;
    private final int kSEQSig = 441533779;
    protected int nFrames;
    protected int ticksPerFrame;
    protected int soundId;
    protected byte flags;
    protected SeqFrame[] frame;

    public SeqType(InputStream is) throws IOException {
        short version;
        int signature = StreamUtils.readInt(is);
        if (signature != 441533779) {
            System.err.println("Invalid sequence");
        }
        if (((version = StreamUtils.readShort(is)) & 0xFF00) != 768) {
            System.err.println("Obsolete sequence version");
        }
        this.nFrames = StreamUtils.readShort(is);
        this.ticksPerFrame = StreamUtils.readShort(is);
        this.soundId = StreamUtils.readShort(is);
        this.flags = (byte)StreamUtils.readUnsignedByte(is);
        StreamUtils.skip(is, 3);
        this.frame = new SeqFrame[this.nFrames];
        for (int i = 0; i < this.nFrames; ++i) {
            this.frame[i] = new SeqFrame(is);
        }
    }

    public static SeqType getInstance(int nSeqId) {
        Entry data;
        SeqType pSequence = pSEQs.get(nSeqId);
        if (pSequence == null && (data = Main.game.getCache().getEntry(nSeqId, "SEQ")).exists()) {
            try (InputStream is = data.getInputStream();){
                pSequence = new SeqType(is);
                pSEQs.put(nSeqId, pSequence);
            }
            catch (Exception e) {
                return null;
            }
        }
        return pSequence;
    }

    public static void flushCache() {
        pSEQs.clear();
    }

    public int getFrames() {
        return this.nFrames;
    }

    public SeqFrame getFrame(int num) {
        if (num < 0 || num >= this.nFrames) {
            return null;
        }
        return this.frame[num];
    }

    public int getTicks() {
        return this.ticksPerFrame;
    }

    public int getSound() {
        return this.soundId;
    }

    public boolean isLooping() {
        return (this.flags & 1) != 0;
    }

    public boolean isRemovable() {
        return (this.flags & 2) != 0;
    }
}

