/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.Mirror;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BURN;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.HANDANIM;
import ru.m210projects.Blood.Types.Hud.AltHud;
import ru.m210projects.Blood.Types.Hud.FullHud;
import ru.m210projects.Blood.Types.Hud.HudRenderer;
import ru.m210projects.Blood.Types.Hud.MiniHud;
import ru.m210projects.Blood.Types.Hud.SplitHud;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.POSTURE;
import ru.m210projects.Blood.Types.QUOTE;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.filehandlers.art.BloodArtEntry;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class View {
    public static final int kStatBarHeight = 25;
    public static final int kView2D = 2;
    public static final int kView3D = 3;
    public static final int kView2DIcon = 4;
    public static final int kViewPosCenter = 0;
    private static final int kMaxQuotes = 16;
    private static final QUOTE[] quotes = new QUOTE[16];
    private static final char[] number_buffer = new char[256];
    private static final int kLensSize = 80;
    private static final byte[] otherMirrorGotpic = new byte[8];
    private static final byte[] bakMirrorGotpic = new byte[8];
    private static final int kViewEffectShadow = 0;
    private static final int kViewEffectFlareHalo = 1;
    private static final int kViewEffectCeilGlow = 2;
    private static final int kViewEffectFloorGlow = 3;
    private static final int kViewEffectTorchHigh = 4;
    private static final int kViewEffectTorchLow = 5;
    private static final int kViewEffectSmokeHigh = 6;
    private static final int kViewEffectSmokeLow = 7;
    private static final int kViewEffectFlame = 8;
    private static final int kViewEffectSpear = 9;
    private static final int kViewEffectTrail = 10;
    private static final int kViewEffectPhase = 11;
    private static final int kViewEffectShowWeapon = 12;
    private static final int kViewEffectReflectiveBall = 13;
    private static final int kViewEffectShoot = 14;
    private static final int kViewEffectTesla = 15;
    private static final int kViewEffectFlag = 16;
    private static final int kViewEffectBigFlag = 17;
    private static final int kViewEffectAtom = 18;
    private static final int kViewEffectMax = 19;
    private static final short[] viewWeaponTile = new short[]{-1, -1, 524, 559, 558, 526, 589, 618, 539, 800, 525, 811, 810, -1};
    private static final int kViewDistance = 1280;
    private static final int TA_LEFT = 0;
    private static final int TA_CENTER = 1;
    private static final int kDrawYFlip = 4;
    private static final int kDrawXFlip = 2048;
    private static final int[] gEffectDetail = new int[]{0, 4, 4, 4, 0, 0, 0, 0, 0, 1, 4, 4, 0, 0, 0, 1, 0, 0, 0};
    private static final Vector3[] atomEffectVelocity = new Vector3[16];
    private static final BURN[] burnTable = new BURN[]{new BURN(2101, 2, 0, 118784, 10, 220), new BURN(2101, 2, 0, 110592, 40, 220), new BURN(2101, 2, 0, 81920, 85, 220), new BURN(2101, 2, 0, 69632, 120, 220), new BURN(2101, 2, 0, 61440, 160, 220), new BURN(2101, 2, 0, 73728, 200, 220), new BURN(2101, 2, 0, 77824, 235, 220), new BURN(2101, 2, 0, 110592, 275, 220), new BURN(2101, 2, 0, 122880, 310, 220)};
    public static int smoothratio;
    public static int viewWeaponX;
    public static int viewWeaponY;
    public static int viewCrossX;
    public static int viewCrossY;
    public static int viewCrossZoom;
    public static int gPlayerIndex;
    public static int nextY;
    public static int numQuotes;
    public static int yOffset;
    public static int kMapZoom;
    public static int PaletteView;
    public static int gViewIndex;
    public static int gViewPos;
    public static int gViewMode;
    public static int deliriumTilt;
    public static int deliriumTurn;
    public static int deliriumPitch;
    public static int scrollX;
    public static int scrollOX;
    public static int scrollY;
    public static int scrollOY;
    public static short scrollAng;
    public static short scrollOAng;
    public static HANDANIM viewHandAnim;
    public static int gViewX0;
    public static int gViewY0;
    public static int gViewX1;
    public static int gViewY1;
    public static int gViewX0Scaled;
    public static int gViewX1Scaled;
    public static int gViewY0Scaled;
    public static int gViewY1Scaled;
    protected static HudRenderer[] hudlist;
    protected static HudRenderer splitHud;
    private static int nextTime;
    private static int hideQuotes;
    private static int totalQuotes;
    private static int viewThirdDist;
    private static int viewThirdClock;
    private static byte[] lensTable;
    private static int othercameradist;
    private static int othercameraclock;
    private static int lastDacUpdate;

    public static void viewHandInit() {
        viewHandAnim = new HANDANIM();
        Entry hQAV = Main.game.getCache().getEntry(518, "QAV");
        if (!hQAV.exists()) {
            Console.out.println("Could not load QAVID 518", OsdColor.RED);
            VERSION.SHAREWARE = true;
            return;
        }
        try (InputStream is = hQAV.getInputStream();){
            View.viewHandAnim.pQAV = new QAV(is);
            View.viewHandAnim.duration = View.viewHandAnim.pQAV.duration;
            View.viewHandAnim.clock = Main.engine.getTotalClock();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void resetQuotes() {
        numQuotes = 0;
        totalQuotes = 0;
        hideQuotes = 0;
    }

    public static void viewResizeView(int size) {
        if (hudlist == null) {
            return;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        gViewX0Scaled = (xdim << 16) / 320;
        gViewY0Scaled = (ydim << 16) / 200;
        gViewX1Scaled = 0x1400000 / xdim;
        gViewY1Scaled = 0xC80000 / ydim;
        Main.cfg.gViewSize = Gameutils.ClipRange(size, 0, hudlist.length - 1);
        if (Main.cfg.gViewSize > hudlist.length - 1) {
            gViewX0 = 0;
            gViewY0 = 0;
            gViewX1 = xdim - 1;
            gViewY1 = ydim - 1 - Pragmas.scale(25L, ydim, 200L);
            int vsiz = Main.cfg.gViewSize - (hudlist.length - 1);
            int dView = ((gViewY1 -= vsiz * ydim / 16) - (gViewY0 += vsiz * ydim / 16)) * vsiz;
            renderer.setview(gViewX0 += vsiz * xdim / 16, gViewY0 += dView / 16, gViewX1 -= vsiz * xdim / 16, gViewY1 -= dView / 16);
        } else {
            gViewX0 = 0;
            gViewY0 = 0;
            gViewX1 = xdim - 1;
            gViewY1 = ydim - 1;
            renderer.setview(gViewX0, gViewY0, gViewX1, gViewY1);
        }
    }

    public static QUOTE viewSetMessage(String message, int nPlayer) {
        return View.viewSetMessage(message, nPlayer, 0);
    }

    public static QUOTE viewSetMessage(String message, int nPlayer, int pal) {
        if (message.isEmpty()) {
            return null;
        }
        QUOTE quote = quotes[totalQuotes];
        quote.messageText = message;
        quote.pal = nPlayer != -1 && nPlayer != Mmulti.myconnectindex ? (int)Globals.gPlayer[nPlayer].pSprite.getPal() : pal;
        Console.out.println(message, OsdColor.findColor(quote.pal));
        quote.messageTime = 120 * Main.cfg.quoteTime + Globals.gFrameClock;
        ++totalQuotes;
        totalQuotes %= 16;
        if (++numQuotes > Main.cfg.showQuotes) {
            ++hideQuotes;
            hideQuotes %= 16;
            nextTime = 0;
            numQuotes = Main.cfg.showQuotes;
            nextY = yOffset;
        }
        return quote;
    }

    public static void InitBallBuffer() {
        DynamicArtEntry pLens = Main.engine.allocatepermanenttile(4077, 80, 80);
        Arrays.fill(pLens.getBytes(), (byte)-1);
    }

    public static void viewInit() {
        Console.out.println("Initializing status bar");
        hudlist = new HudRenderer[]{null, new MiniHud(), new AltHud(), new FullHud()};
        splitHud = new SplitHud();
        View.viewResizeView(Main.cfg.gViewSize);
        for (int i = 0; i < 16; ++i) {
            View.quotes[i] = new QUOTE();
        }
        Entry tableEntry = Main.game.getCache().getEntry("LENS.DAT", true);
        if (!tableEntry.exists()) {
            throw new AssertException("lens.dat == null");
        }
        lensTable = tableEntry.getBytes();
        if (lensTable.length != 25600) {
            throw new AssertException("gSysRes.Size(hLens) != kLensSize * kLensSize * sizeof(int)");
        }
        View.InitBallBuffer();
        for (int i = 0; i < 16; ++i) {
            View.atomEffectVelocity[i] = new Vector3();
            View.atomEffectVelocity[i].x = Gameutils.Random(2048);
            View.atomEffectVelocity[i].y = Gameutils.Random(2048);
            View.atomEffectVelocity[i].z = Gameutils.Random(2048);
        }
    }

    public static void viewUpdatePlayerLoc(PLAYER pPlayer) {
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        pPlayer.viewOffZ = pPlayer.pSprite.getZ() - cp.viewSpeed;
        pPlayer.weaponAboveZ = pPlayer.pSprite.getZ() - cp.weapSpeed;
        View.viewBackupView(pPlayer.nPlayer);
    }

    public static void viewBackupView(int nPlayer) {
        BloodSprite pSprite = Globals.gPlayer[nPlayer].pSprite;
        PLOCATION pPLocation = PLAYER.gPrevView[nPlayer];
        pPLocation.x = pSprite.getX();
        pPLocation.y = pSprite.getY();
        pPLocation.ang = Globals.gPlayer[nPlayer].ang;
        pPLocation.horiz = Globals.gPlayer[nPlayer].horiz;
        pPLocation.horizOff = Globals.gPlayer[nPlayer].horizOff;
        pPLocation.slope = Globals.gPlayer[nPlayer].slope;
        pPLocation.viewOffZ = Globals.gPlayer[nPlayer].viewOffZ;
        pPLocation.weapOffZ = Globals.gPlayer[nPlayer].weaponAboveZ - Globals.gPlayer[nPlayer].viewOffZ - 3072;
        pPLocation.bobHeight = Globals.gPlayer[nPlayer].bobHeight;
        pPLocation.bobWidth = Globals.gPlayer[nPlayer].bobWidth;
        pPLocation.swayHeight = Globals.gPlayer[nPlayer].swayHeight;
        pPLocation.swayWidth = Globals.gPlayer[nPlayer].swayWidth;
    }

    public static void viewDrawSplitHUD(PLAYER gView) {
        splitHud.draw(gView, 0, 0);
    }

    private static boolean showItem(int item) {
        switch (item + 100) {
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 139: {
                return true;
            }
        }
        return false;
    }

    public static void viewDrawHUD(PLAYER gView) {
        BloodRenderer renderer = Main.game.getRenderer();
        if (Main.cfg.gViewSize >= 0 && Main.cfg.gViewSize < hudlist.length && hudlist[Main.cfg.gViewSize] != null) {
            hudlist[Main.cfg.gViewSize].draw(gView, 0, 0);
        }
        int posy = 20;
        for (int i = 0; i < 49; ++i) {
            if (PLAYER.powerupCheck(gView, i) <= 0 || !View.showItem(i)) continue;
            ArtEntry pic = Main.engine.getTile(Actor.gItemInfo[i].picnum);
            View.DrawStatSprite(Actor.gItemInfo[i].picnum, 280 - renderer.getTile(Actor.gItemInfo[i].picnum + renderer.animateoffs(Actor.gItemInfo[i].picnum, 0)).getWidth() / 4, posy - pic.getHeight() / 4, 0, 0, 528, 32768);
            int fx = View.viewDrawNumber(3, gView.powerUpTimer[i] * 100 / Math.max(Actor.gPowerUpInfo[i].addPower, 1), 276, posy + pic.getHeight() / 4 + 4, 1.0f, 32, 0, TextAlign.Center, Transparent.None, ConvertType.AlignRight, false);
            Main.game.getFont(3).drawTextScaled((Renderer)renderer, 277 + fx, posy + pic.getHeight() / 4 + 4, "%", 1.0f, 24, 0, TextAlign.Center, Transparent.None, ConvertType.AlignRight, true);
            posy += 40;
        }
        if (Globals.pGameInfo.nGameType == 0) {
            return;
        }
        if (Globals.pGameInfo.nGameType == 3) {
            if (Globals.nTeamClock[0] == 0 || (Main.engine.getTotalClock() & 8) != 0) {
                Main.game.getFont(0).drawTextScaled((Renderer)renderer, 1, 1, "Blue", 1.0f, -128, 10, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
                Globals.nTeamClock[0] = Gameutils.ClipLow(Globals.nTeamClock[0] - Globals.kFrameTicks, 0);
                View.viewDrawNumber(0, Globals.nTeamCount[0], 1, 11, 1.0f, -128, 10, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
            }
            if (Globals.nTeamClock[1] == 0 || (Main.engine.getTotalClock() & 8) != 0) {
                Main.game.getFont(0).drawTextScaled((Renderer)renderer, 319, 1, "Red", 1.0f, -128, 7, TextAlign.Right, Transparent.None, ConvertType.AlignRight, false);
                Globals.nTeamClock[1] = Gameutils.ClipLow(Globals.nTeamClock[1] - Globals.kFrameTicks, 0);
                View.viewDrawNumber(0, Globals.nTeamCount[1], 319, 11, 1.0f, -128, 7, TextAlign.Right, Transparent.None, ConvertType.AlignRight, false);
            }
        } else {
            View.viewNetPlayers(0, true);
        }
        if (gView != Globals.gMe) {
            String viewed = "View from ";
            System.arraycopy("View from ".toCharArray(), 0, number_buffer, 0, "View from ".length());
            int len = Main.game.net.gProfile[gView.nPlayer].name.length();
            System.arraycopy(Main.game.net.gProfile[gView.nPlayer].name.toCharArray(), 0, number_buffer, "View from ".length(), len);
            View.number_buffer["View from ".length() + len] = '\u0000';
            int shade = 32 - (Main.engine.getTotalClock() & 0x3F);
            Main.game.getFont(0).drawTextScaled((Renderer)renderer, 160, 150, number_buffer, 1.0f, shade, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
    }

    public static void viewNetPlayers(int yoffset, boolean showpalette) {
        BloodRenderer renderer = Main.game.getRenderer();
        int row = (Mmulti.numplayers - 1) / 4;
        if (row >= 0) {
            if (yoffset > 0) {
                yoffset -= 9 * row;
            }
            ArtEntry pic = Main.engine.getTile(2229);
            for (int r = 0; r <= row; ++r) {
                for (int i = 0; i < 4; ++i) {
                    View.DrawStatSprite(2229, 80 * i + 40, 9 * r + 8 - pic.getHeight() / 2 + yoffset, 16, 0, 10, 65536);
                }
            }
            int plu = (Globals.gPlayer[Mmulti.myconnectindex].teamID & 3) + 11;
            if (plu == 13) {
                plu = 4;
            }
            if (!showpalette) {
                plu = 0;
            }
            if (Main.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gMe.pXsprite.getHealth() <= 0) {
                int shade = 32 - (Main.engine.getTotalClock() & 0x3F);
                View.DrawStatSprite(2229, 0, yoffset, shade, 2, 26, 65536);
            }
            Main.game.getFont(4).drawTextScaled((Renderer)renderer, 4, yoffset + 1, Main.game.net.gProfile[Mmulti.myconnectindex].name, 1.0f, -128, plu, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
            View.viewDrawNumber(4, Globals.gPlayer[Mmulti.myconnectindex].fragCount, 76, yoffset + 1, 1.0f, -128, plu, TextAlign.Right, Transparent.None, ConvertType.Normal, false);
            int p = 0;
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (i != Mmulti.myconnectindex) {
                    int posx = 80 * (++p & 3);
                    int posy = 9 * (p / 4);
                    plu = (Globals.gPlayer[i].teamID & 3) + 11;
                    if (plu == 13) {
                        plu = 4;
                    }
                    if (!showpalette) {
                        plu = 0;
                    }
                    if (Main.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Globals.gPlayer[i].pXsprite.getHealth() <= 0) {
                        int shade = 32 - (Main.engine.getTotalClock() & 0x3F);
                        View.DrawStatSprite(2229, posx, posy + yoffset, shade, 2, 26, 65536);
                    }
                    Main.game.getFont(4).drawTextScaled((Renderer)renderer, posx + 4, posy + yoffset + 1, Main.game.net.gProfile[i].name, 1.0f, -128, plu, TextAlign.Left, Transparent.None, ConvertType.Normal, false);
                    View.viewDrawNumber(4, Globals.gPlayer[i].fragCount, posx + 76, posy + yoffset + 1, 1.0f, -128, plu, TextAlign.Right, Transparent.None, ConvertType.Normal, false);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
    }

    public static void viewPaletteHandler(PLAYER gView) {
        BloodRenderer renderer = Main.game.getRenderer();
        int vPalette = 0;
        lastDacUpdate = Main.engine.getTotalClock();
        if (PLAYER.powerupCheck(gView, 14) > 0) {
            vPalette = 4;
        } else if (PLAYER.powerupCheck(gView, 24) > 0) {
            vPalette = 1;
        } else if (gView.Underwater) {
            vPalette = gView.pXsprite.getPalette();
        } else if (gView.nLifeMode == 1) {
            vPalette = 2;
        }
        if (vPalette != PaletteView) {
            Main.engine.getPaletteManager().setPalette(vPalette);
            PaletteView = vPalette;
        }
        ScreenEffect.PICKUP_DAC.setIntensive(Globals.gPlayer[View.gViewIndex].pickupEffect);
        ScreenEffect.HIT_DAC.setIntensive(Gameutils.ClipHigh(Globals.gPlayer[View.gViewIndex].hitEffect, 85));
        ScreenEffect.BLIND_DAC.setIntensive(Globals.gPlayer[View.gViewIndex].blindEffect);
        ScreenEffect.DROWN_DAC.setIntensive(Globals.gPlayer[View.gViewIndex].drownEffect);
        renderer.scrSetDac();
        lastDacUpdate = Main.engine.getTotalClock();
    }

    public static void viewDrawScreen(int gViewIndex, int smooth) {
        PLAYER gView = Globals.gPlayer[gViewIndex];
        if (gView == null || gView.pSprite == null) {
            short s = Mmulti.myconnectindex;
            View.gViewIndex = s;
            gViewIndex = s;
            gView = Globals.gPlayer[gViewIndex];
        }
        if (gView == null || gView.pSprite == null) {
            return;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        smoothratio = smooth;
        gPlayerIndex = -1;
        if (!Globals.gMapScrollMode) {
            scrollOX = scrollX = gView.pSprite.getX();
            scrollOY = scrollY = gView.pSprite.getY();
            scrollOAng = scrollAng = gView.pSprite.getAng();
        }
        if (gViewMode == 3 || gViewMode == 2) {
            int i;
            ListNode<Sprite> node;
            boolean bDelirious;
            SECTORFX.DoSectorLighting();
            long x = gView.pSprite.getX();
            long y = gView.pSprite.getY();
            long z = gView.viewOffZ;
            float nAngle = gView.ang;
            float nHoriz = gView.horiz;
            int bobWidth = gView.bobWidth;
            int bobHeight = gView.bobHeight;
            int swayWidth = gView.swayWidth;
            int swayHeight = gView.swayHeight;
            int nSlope = gView.slope;
            int nSector = gView.pSprite.getSectnum();
            if (nSector == -1) {
                return;
            }
            int weapOffZ = gView.weaponAboveZ - gView.viewOffZ - 3072;
            if (Main.cfg.gInterpolation != 0 && (!Main.game.menu.gShowMenu && !Console.out.isShowing() || Main.game.isCurrentScreen(Main.gDemoScreen))) {
                if (Mmulti.numplayers > 1 && gView == Globals.gMe && Globals.gMe.pXsprite.getHealth() != 0) {
                    BloodNetwork net = (BloodNetwork)Main.game.pNet;
                    nSector = net.predict.sectnum;
                    x = net.predictOld.x + Pragmas.mulscale(net.predict.x - net.predictOld.x, smoothratio, 16);
                    y = net.predictOld.y + Pragmas.mulscale(net.predict.y - net.predictOld.y, smoothratio, 16);
                    z = net.predictOld.viewOffZ + Pragmas.mulscale(net.predict.viewOffZ - net.predictOld.viewOffZ, smoothratio, 16);
                    weapOffZ = net.predictOld.weapOffZ + Pragmas.mulscale(net.predict.weapOffZ - net.predictOld.weapOffZ, smoothratio, 16);
                    nHoriz = net.predictOld.horiz + (net.predict.horiz - net.predictOld.horiz) * (float)smoothratio / 65536.0f;
                    nAngle = net.predictOld.ang + (ru.m210projects.Build.Gameutils.BClampAngle(net.predict.ang - net.predictOld.ang + 1024.0f) - 1024.0f) * (float)smoothratio / 65536.0f;
                    bobWidth = net.predictOld.bobWidth + Pragmas.mulscale(net.predict.bobWidth - net.predictOld.bobWidth, smoothratio, 16);
                    bobHeight = net.predictOld.bobHeight + Pragmas.mulscale(net.predict.bobHeight - net.predictOld.bobHeight, smoothratio, 16);
                    swayWidth = net.predictOld.swayWidth + Pragmas.mulscale(net.predict.swayWidth - net.predictOld.swayWidth, smoothratio, 16);
                    swayHeight = net.predictOld.swayHeight + Pragmas.mulscale(net.predict.swayHeight - net.predictOld.swayHeight, smoothratio, 16);
                    nSlope = net.predictOld.slope + Pragmas.mulscale(net.predict.slope - net.predictOld.slope, smoothratio, 16);
                } else {
                    x = PLAYER.gPrevView[gViewIndex].x + Pragmas.mulscale(x - (long)PLAYER.gPrevView[gViewIndex].x, smoothratio, 16);
                    y = PLAYER.gPrevView[gViewIndex].y + Pragmas.mulscale(y - (long)PLAYER.gPrevView[gViewIndex].y, smoothratio, 16);
                    z = PLAYER.gPrevView[gViewIndex].viewOffZ + Pragmas.mulscale(z - (long)PLAYER.gPrevView[gViewIndex].viewOffZ, smoothratio, 16);
                    weapOffZ = PLAYER.gPrevView[gViewIndex].weapOffZ + Pragmas.mulscale(weapOffZ - PLAYER.gPrevView[gViewIndex].weapOffZ, smoothratio, 16);
                    nHoriz = PLAYER.gPrevView[gViewIndex].horiz + (nHoriz - PLAYER.gPrevView[gViewIndex].horiz) * (float)smoothratio / 65536.0f;
                    nAngle = PLAYER.gPrevView[gViewIndex].ang + (ru.m210projects.Build.Gameutils.BClampAngle(nAngle - PLAYER.gPrevView[gViewIndex].ang + 1024.0f) - 1024.0f) * (float)smoothratio / 65536.0f;
                    bobWidth = PLAYER.gPrevView[gViewIndex].bobWidth + Pragmas.mulscale(bobWidth - PLAYER.gPrevView[gViewIndex].bobWidth, smoothratio, 16);
                    bobHeight = PLAYER.gPrevView[gViewIndex].bobHeight + Pragmas.mulscale(bobHeight - PLAYER.gPrevView[gViewIndex].bobHeight, smoothratio, 16);
                    swayWidth = PLAYER.gPrevView[gViewIndex].swayWidth + Pragmas.mulscale(swayWidth - PLAYER.gPrevView[gViewIndex].swayWidth, smoothratio, 16);
                    swayHeight = PLAYER.gPrevView[gViewIndex].swayHeight + Pragmas.mulscale(swayHeight - PLAYER.gPrevView[gViewIndex].swayHeight, smoothratio, 16);
                    nSlope = PLAYER.gPrevView[gViewIndex].slope + Pragmas.mulscale(nSlope - PLAYER.gPrevView[gViewIndex].slope, smoothratio, 16);
                }
            }
            if (gView.explosion != 0) {
                int explCount = Gameutils.ClipRange(gView.explosion * 8, 0, 2000);
                x += (long)Gameutils.ViRandom(explCount >> 4);
                y += (long)Gameutils.ViRandom(explCount >> 4);
                z += (long)Gameutils.ViRandom(explCount);
                nHoriz += (float)Gameutils.ViRandom(explCount >> 8);
                nAngle += (float)Gameutils.ViRandom(explCount >> 8);
                swayWidth += Gameutils.ViRandom(explCount);
                swayHeight += Gameutils.ViRandom(explCount);
            }
            if (gView.quakeTime != 0) {
                int explCount = Gameutils.ClipRange(gView.quakeTime * 8, 0, 2000);
                x += (long)Gameutils.ViRandom(explCount >> 4);
                y += (long)Gameutils.ViRandom(explCount >> 4);
                z += (long)Gameutils.ViRandom(explCount);
                nHoriz += (float)Gameutils.ViRandom(explCount >> 8);
                nAngle += (float)Gameutils.ViRandom(explCount >> 8);
                swayWidth += Gameutils.ViRandom(explCount);
                swayHeight += Gameutils.ViRandom(explCount);
            }
            nHoriz += (float)Pragmas.mulscale(30L, 0x40000000L - (long)Trig.Cos(4 * gView.tilt), 30);
            nAngle += (float)gView.lookang;
            if (gViewPos == 0) {
                if (Main.cfg.gBobWidth) {
                    x = (long)((double)x - (double)bobWidth * ru.m210projects.Build.Gameutils.BSinAngle(nAngle) / 261568.0);
                    y = (long)((double)y + (double)bobWidth * ru.m210projects.Build.Gameutils.BCosAngle(nAngle) / 261568.0);
                }
                if (Main.cfg.gBobHeight) {
                    z += (long)bobHeight;
                }
                if (Main.game.net.gProfile[Mmulti.myconnectindex].slopetilt) {
                    nHoriz += (float)nSlope;
                }
                z = (long)((float)z + 10.0f * nHoriz);
                viewThirdDist = -1;
                viewThirdClock = Main.engine.getTotalClock();
            } else {
                float dx = (float)(1280.0 * -ru.m210projects.Build.Gameutils.BCosAngle(nAngle) / 16384.0);
                float dy = (float)(1280.0 * -ru.m210projects.Build.Gameutils.BSinAngle(nAngle) / 16384.0);
                int dz = 160 * (int)nHoriz - 4096;
                short oldcstat = gView.pSprite.getCstat();
                gView.pSprite.setCstat(gView.pSprite.getCstat() & 0xFFFFFEFF);
                if (!Main.boardService.isValidSector(nSector)) {
                    throw new AssertException("boardService.isValidSector(nSector)");
                }
                Gameutils.FindSector((int)x, (int)y, (int)z, nSector);
                nSector = Gameutils.foundSector;
                Engine.hitscangoalx = 0x1FFFFFFF;
                Engine.hitscangoaly = 0x1FFFFFFF;
                Main.engine.hitscan((int)x, (int)y, (int)z, nSector, (int)dx, (int)dy, dz, Engine.pHitInfo, 0x1000040);
                int hx = (int)((long)Engine.pHitInfo.hitx - x);
                int hy = (int)((long)Engine.pHitInfo.hity - y);
                if ((float)(Pragmas.klabs(hx) + Pragmas.klabs(hy)) - (Math.abs(dx) + Math.abs(dy)) < 1024.0f) {
                    nSector = (short)Engine.pHitInfo.hitsect;
                    int wx = 1;
                    if (dx < 0.0f) {
                        wx = -1;
                    }
                    int wy = 1;
                    if (dy < 0.0f) {
                        wy = -1;
                    }
                    hx -= wx << 9;
                    hy -= wy << 9;
                    int dist = 0;
                    if (dx != 0.0f && dy != 0.0f) {
                        dist = Math.abs(dx) <= Math.abs(dy) ? (int)Gameutils.ClipHigh((float)(hy << 16) / dy, viewThirdDist) : (int)Gameutils.ClipHigh((float)(hx << 16) / dx, viewThirdDist);
                    }
                    viewThirdDist = dist;
                }
                x += (long)Pragmas.mulscale(viewThirdDist, (int)dx, 16);
                y += (long)Pragmas.mulscale(viewThirdDist, (int)dy, 16);
                z += (long)Pragmas.mulscale(viewThirdDist, dz, 16);
                viewThirdDist = Gameutils.ClipHigh(viewThirdDist + (Main.engine.getTotalClock() - viewThirdClock << 10), 65536);
                viewThirdClock = Main.engine.getTotalClock();
                if (!Main.boardService.isValidSector(nSector)) {
                    throw new AssertException("boardService.isValidSector(nSector)");
                }
                Gameutils.FindSector((int)x, (int)y, (int)z, nSector);
                nSector = Gameutils.foundSector;
                gView.pSprite.setCstat(oldcstat);
            }
            Warp.checkWarping(x, y, z, nSector);
            x = Warp.checkWx;
            y = Warp.checkWy;
            z = Warp.checkWz;
            nSector = Warp.checkWs;
            boolean bl = bDelirious = PLAYER.powerupCheck(gView, 28) > 0;
            if (deliriumTilt != 0 || bDelirious) {
                renderer.setdrunk(deliriumTilt);
            } else {
                renderer.setdrunk(0.0f);
                if (PLAYER.powerupCheck(gView, 21) > 0 && (Mmulti.numplayers > 1 || Main.game.isCurrentScreen(Main.gGameScreen) && Globals.kFakeMultiplayer && Globals.nFakePlayers > 1)) {
                    int nViewed;
                    int nP = Mmulti.numplayers;
                    if (Globals.kFakeMultiplayer) {
                        nP = Globals.nFakePlayers;
                    }
                    int nEyes = Main.engine.getTotalClock() / 240 % (nP - 1);
                    if (!Globals.kFakeMultiplayer) {
                        nViewed = Mmulti.connecthead;
                        while (true) {
                            if (nViewed == gViewIndex) {
                                nViewed = Mmulti.connectpoint2[nViewed];
                            }
                            if (nEyes != 0) {
                                nViewed = Mmulti.connectpoint2[nViewed];
                                --nEyes;
                                continue;
                            }
                            break;
                        }
                    } else {
                        nViewed = nEyes + 1;
                    }
                    if (nViewed != -1) {
                        int explCount;
                        PLAYER pViewed = Globals.gPlayer[nViewed];
                        ArtEntry pic = Main.engine.getTile(4079);
                        if (!(pic instanceof DynamicArtEntry) || !pic.exists() || pic.getWidth() != 128 || pic.getHeight() != 128) {
                            Main.engine.allocatepermanenttile(4079, 128, 128);
                        }
                        renderer.setviewtotile(Main.engine.getTileManager().getDynamicTile(4079));
                        renderer.setaspect(65536, 78643);
                        int cx = pViewed.pSprite.getX();
                        int cy = pViewed.pSprite.getY();
                        int cz = pViewed.viewOffZ;
                        int cnSector = pViewed.pSprite.getSectnum();
                        int cnAngle = pViewed.pSprite.getAng();
                        int cnHoriz = 0;
                        if (pViewed.explosion != 0) {
                            explCount = Gameutils.ClipRange(gView.explosion * 8, 0, 2000);
                            cx += Gameutils.ViRandom(explCount >> 4);
                            cy += Gameutils.ViRandom(explCount >> 4);
                            cz += Gameutils.ViRandom(explCount);
                            cnHoriz += Gameutils.ViRandom(explCount >> 8);
                            cnAngle += Gameutils.ViRandom(explCount >> 8);
                        }
                        if (pViewed.quakeTime != 0) {
                            explCount = Gameutils.ClipRange(gView.quakeTime * 8, 0, 2000);
                            cx += Gameutils.ViRandom(explCount >> 4);
                            cy += Gameutils.ViRandom(explCount >> 4);
                            cz += Gameutils.ViRandom(explCount);
                            cnHoriz += Gameutils.ViRandom(explCount >> 8);
                            cnAngle += Gameutils.ViRandom(explCount >> 8);
                        }
                        int nx = Pragmas.mulscale(-Trig.Cos(cnAngle), 1280L, 30);
                        int ny = Pragmas.mulscale(-Trig.Sin(cnAngle), 1280L, 30);
                        int nz = Pragmas.mulscale(cnHoriz, 1280L, 3);
                        nz -= 4096;
                        BloodSprite sp = pViewed.pSprite;
                        short bakcstat = sp.getCstat();
                        sp.setCstat(sp.getCstat() & 0xFFFFFEFF);
                        Gameutils.FindSector(cx, cy, cz, cnSector);
                        cnSector = Gameutils.foundSector;
                        Main.engine.hitscan(cx, cy, cz, cnSector, nx, ny, nz, Engine.pHitInfo, 0x1000040);
                        int hx = Engine.pHitInfo.hitx - cx;
                        int hy = Engine.pHitInfo.hity - cy;
                        if (Pragmas.klabs(nx) + Pragmas.klabs(ny) > Pragmas.klabs(hx) + Pragmas.klabs(hy)) {
                            cnSector = (short)Engine.pHitInfo.hitsect;
                            hx -= Pragmas.ksgn(nx) * 4 << 4;
                            hy -= Pragmas.ksgn(ny) * 4 << 4;
                            othercameradist = Pragmas.klabs(nx) > Pragmas.klabs(ny) ? Gameutils.ClipHigh(othercameradist, Pragmas.divscale(hx, nx, 16)) : Gameutils.ClipHigh(othercameradist, Pragmas.divscale(hy, ny, 16));
                        }
                        cx += Pragmas.mulscale(nx, othercameradist, 16);
                        cy += Pragmas.mulscale(ny, othercameradist, 16);
                        cz += Pragmas.mulscale(nz, othercameradist, 16);
                        if ((othercameradist += Main.engine.getTotalClock() - othercameraclock << 10) > 65536) {
                            othercameradist = 65536;
                        }
                        othercameraclock = Main.engine.getTotalClock();
                        Gameutils.FindSector(cx, cy, cz, cnSector);
                        cnSector = Gameutils.foundSector;
                        sp.setCstat(bakcstat);
                        Warp.checkWarping(cx, cy, cz, cnSector);
                        cx = (int)Warp.checkWx;
                        cy = (int)Warp.checkWy;
                        cz = (int)Warp.checkWz;
                        cnSector = Warp.checkWs;
                        Engine.visibility = Gameutils.ClipLow(DB.gVisibility - pViewed.visibility * 32, 0);
                        System.arraycopy(renderer.getRenderedPics(), 510, bakMirrorGotpic, 0, 8);
                        System.arraycopy(otherMirrorGotpic, 0, renderer.getRenderedPics(), 510, 8);
                        Mirror.DrawMirrors(cx, cy, cz, cnAngle, 90 + cnHoriz);
                        renderer.drawrooms(cx, cy, cz, cnAngle, 90 + cnHoriz, cnSector);
                        System.arraycopy(renderer.getRenderedPics(), 510, otherMirrorGotpic, 0, 8);
                        System.arraycopy(bakMirrorGotpic, 0, renderer.getRenderedPics(), 510, 8);
                        View.viewProcessSprites(cx, cy, cz);
                        renderer.drawmasks();
                        renderer.setviewback();
                    }
                } else {
                    othercameradist = -1;
                    othercameraclock = Main.engine.getTotalClock();
                }
            }
            int vis = 0;
            for (node = Main.boardService.getStatNode(2); node != null; node = node.getNext()) {
                i = node.getIndex();
                BloodSprite pSprite = Main.boardService.getSprite(i);
                XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
                if (pXSprite == null) {
                    throw new AssertException("pXSprite != null");
                }
                short sectnum = pSprite.getSectnum();
                if (!renderer.gotSector(sectnum)) continue;
                vis += 32 * pXSprite.getData3();
            }
            block5: for (node = Main.boardService.getStatNode(5); node != null; node = node.getNext()) {
                i = node.getIndex();
                BloodSprite pSprite = Main.boardService.getSprite(i);
                switch (pSprite.getLotag()) {
                    case 301: 
                    case 302: 
                    case 303: 
                    case 306: {
                        if (!renderer.gotSector(pSprite.getSectnum())) continue block5;
                        vis += 256;
                    }
                }
            }
            Engine.visibility = Gameutils.ClipLow(DB.gVisibility - 32 * gView.visibility - vis, 0);
            nAngle = ru.m210projects.Build.Gameutils.BClampAngle((float)deliriumTurn + nAngle);
            int nUpper = Warp.gUpperLink[nSector];
            int nLower = Warp.gLowerLink[nSector];
            Main.engine.getzsofslope(nSector, (int)x, (int)y, Globals.floorz, Globals.ceilz);
            int lz = 1024;
            long crossDz = 0L;
            if (z < (long)(Globals.ceilz.get() + lz) && (nLower == -1 || renderer.getType().equals((Object)Renderer.RenderType.Polymost) && Main.boardService.getSector(nSector).getCeilingpicnum() < 4080 || Main.boardService.getSector(nSector).getCeilingpicnum() >= 4096)) {
                crossDz = z;
                z = Globals.ceilz.get() + lz;
                crossDz -= z;
            }
            if (z > (long)(Globals.floorz.get() - lz) && (nUpper == -1 || renderer.getType().equals((Object)Renderer.RenderType.Polymost) && Main.boardService.getSector(nSector).getFloorpicnum() < 4080 || Main.boardService.getSector(nSector).getFloorpicnum() >= 4096)) {
                crossDz = z;
                z = Globals.floorz.get() - lz;
                crossDz -= z;
            }
            nHoriz = ru.m210projects.Build.Gameutils.BClipRange(nHoriz, -200.0f, 200.0f);
            int defHoriz = 90;
            if (PLAYER.newHoriz && !DemoUtils.IsOriginalDemo()) {
                defHoriz = 100;
            }
            renderer.settiltang(deliriumTilt);
            Mirror.DrawMirrors(x, y, z, nAngle, (float)defHoriz + nHoriz + (float)deliriumPitch);
            boolean gotFire = renderer.gotPic(Globals.fire.getPicture());
            short oldcstat = gView.pSprite.getCstat();
            if (gViewPos == 0) {
                gView.pSprite.setCstat(gView.pSprite.getCstat() | 0x8000);
            } else {
                gView.pSprite.setCstat(gView.pSprite.getCstat() | 0x202);
            }
            renderer.drawrooms(x, y, z, nAngle, (float)defHoriz + nHoriz + (float)deliriumPitch, nSector);
            if (gotFire) {
                byte[] byArray = renderer.getRenderedPics();
                int n = Globals.fire.getPicture() >> 3;
                byArray[n] = (byte)(byArray[n] | (byte)Engine.pow2char[Globals.fire.getPicture() & 7]);
            }
            View.viewProcessSprites(x, y, z);
            Mirror.setMirrorParalax(true);
            renderer.drawmasks();
            Mirror.setMirrorParalax(false);
            Mirror.processMirror(x, y);
            gView.pSprite.setCstat(oldcstat);
            if ((deliriumTilt != 0 || bDelirious) && Main.cfg.getRenderType() == Renderer.RenderType.Software) {
                ArtEntry tiltBufferPic = Main.engine.getTileManager().getTile(4078);
                if (!(tiltBufferPic instanceof DynamicArtEntry) || !tiltBufferPic.exists()) {
                    throw new AssertException("waloff[ TILTBUFFER ] != null");
                }
                renderer.setviewback();
                int nFlags = 1090;
                if (bDelirious) {
                    nFlags |= 0x21;
                }
                nFlags |= 4;
                int tilt = deliriumTilt & 0x1FF;
                if (tilt > 256) {
                    tilt = 512 - tilt;
                }
                renderer.rotatesprite(0xA00000, 0x640000, Pragmas.dmulscale(256000L, Trig.Cos(tilt), 160000L, Trig.Sin(tilt), 32), deliriumTilt + 512, 4078, 0, 0, nFlags, gViewX0, gViewY0, gViewX1, gViewY1);
            }
            if (!bDelirious) {
                deliriumTilt = 0;
                deliriumTurn = 0;
                deliriumPitch = 0;
            }
            if (gViewPos == 0) {
                if ((!Main.game.menu.gShowMenu || Main.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) && Main.cfg.gCrosshair) {
                    viewCrossX = 160 - (gView.lookang >> 1);
                    viewCrossY = 90;
                    if (PLAYER.newHoriz && !DemoUtils.IsOriginalDemo()) {
                        viewCrossY = 100;
                    }
                    viewCrossY += Pragmas.klabs(gView.lookang) / 9;
                    viewCrossY = (int)((long)viewCrossY + (crossDz >> 7));
                    int zoom = Main.cfg.gCrossSize;
                    if (Globals.SplitScreen) {
                        zoom >>= 1;
                    }
                    viewCrossX = Pragmas.divscale(viewCrossX, gViewX1Scaled, 16);
                    viewCrossY = Pragmas.divscale(viewCrossY, gViewY1Scaled, 16);
                    viewCrossZoom = Pragmas.divscale(zoom, gViewY1Scaled, 16);
                }
                viewWeaponX = 160 + (swayWidth >> 8);
                viewWeaponY = 220 + (swayHeight >> 8) + (weapOffZ >> 7);
                if (Globals.SplitScreen && gViewIndex == 0) {
                    viewWeaponY = 120 + (swayHeight >> 8) + (weapOffZ >> 7);
                }
            }
        }
    }

    public static void updateviewmap() {
        short i = Globals.gPlayer[View.gViewIndex].pSprite.getSectnum();
        if (i > -1) {
            int wallid = Main.boardService.getSector(i).getWallptr();
            Engine.show2dsector.setBit(i);
            for (int j = Main.boardService.getSector(i).getWallnum(); j > 0; --j) {
                Wall wal;
                if ((i = (wal = Main.boardService.getWall(wallid++)).getNextsector()) < 0 || (wal.getCstat() & 0x71) != 0 || Main.boardService.getWall(wal.getNextwall()) != null && (Main.boardService.getWall(wal.getNextwall()).getCstat() & 0x71) != 0 || Main.boardService.getSector(i) != null && Main.boardService.getSector(i).getCeilingz() >= Main.boardService.getSector(i).getFloorz()) continue;
                Engine.show2dsector.setBit(i);
            }
        }
    }

    public static void viewDrawBurn(int burnTime) {
        if (burnTime == 0) {
            return;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        int windowx1 = 0;
        int windowy1 = 0;
        int windowx2 = renderer.getWidth();
        int windowy2 = renderer.getHeight();
        for (int i = 0; i < 9; ++i) {
            int nTile = View.burnTable[i].nTile + renderer.animateoffs((short)View.burnTable[i].nTile, i - 32768);
            int nPal = View.burnTable[i].nPal;
            int nFlags = View.burnTable[i].nFlags;
            int zoom = View.burnTable[i].zoom;
            if (burnTime < 600) {
                zoom = burnTime * (zoom / 600);
            }
            View.viewDrawSprite(View.burnTable[i].x << 16, View.burnTable[i].y << 16, zoom, 0, nTile, 0, nPal, nFlags | 0x400, windowx1, windowy1, windowx2, windowy2);
        }
    }

    public static void viewDisplayMessage(int nPlayer) {
        BloodRenderer renderer = Main.game.getRenderer();
        if (!Main.cfg.MessageState || Main.game.menu.gShowMenu) {
            return;
        }
        int x = 0;
        int y = 0;
        int nShade = Gameutils.ClipHigh(numQuotes << 3, 48);
        if (gViewMode == 3) {
            x = Pragmas.mulscale(gViewX0, gViewX1Scaled, 16);
            y = Pragmas.mulscale(gViewY0, gViewY1Scaled, 16);
        }
        y += nextY;
        if (Globals.pGameInfo.nGameType != 0 && Globals.pGameInfo.nGameType != 3) {
            int row = (Mmulti.numplayers - 1) / 4;
            y += (row + 1) * 9;
        }
        if (Globals.pGameInfo.nGameType == 3) {
            y += 22;
        }
        for (int i = 0; i < numQuotes; ++i) {
            QUOTE quote = quotes[(i + hideQuotes) % 16];
            if (Globals.gFrameClock < quote.messageTime) {
                Main.game.getFont(Main.cfg.MessageFont).drawTextScaled((Renderer)renderer, x + 1, y, quote.messageText, 1.0f, nShade, quote.pal, TextAlign.Left, Transparent.None, ConvertType.AlignLeft, false);
                y += yOffset;
                nShade = Gameutils.ClipLow(nShade - 64 / numQuotes, -128);
                continue;
            }
            --numQuotes;
            ++hideQuotes;
            hideQuotes %= 16;
        }
        if (nextY != 0) {
            nextY = nextTime * yOffset / 120;
            nextTime += Globals.gTicks;
        }
    }

    public static int viewDrawNumber(int nFontId, int number, int x, int y, float zoom, int shade, int nPLU, TextAlign nAlign, Transparent transparent, ConvertType convertType, boolean textShadow) {
        Strhandler.Bitoa(number, number_buffer);
        BloodRenderer renderer = Main.game.getRenderer();
        return Main.game.getFont(nFontId).drawTextScaled((Renderer)renderer, x, y, number_buffer, zoom, shade, nPLU, nAlign, transparent, convertType, textShadow);
    }

    private static void viewDrawSprite(int sx, int sy, int nZoom, int nAngle, int nTile, int nShade, int nPLU, int nFlags, int wx1, int wy1, int wx2, int wy2) {
        if ((nFlags & 0x800) != 0) {
            nAngle = nAngle + 1024 & 0x7FF;
            nFlags ^= 4;
        }
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(sx, sy, nZoom, (short)nAngle, nTile, nShade, nPLU, nFlags, wx1, wy1, wx2, wy2);
    }

    /*
     * Unable to fully structure code
     */
    public static void viewProcessSprites(long nViewX, long nViewY, long nViewZ) {
        gView = Globals.gPlayer[View.gViewIndex];
        if (gView == null) {
            return;
        }
        renderer = Main.game.getRenderer();
        renderedSpriteList = renderer.getRenderedSprites();
        if (renderedSpriteList.getSize() > 1024) {
            return;
        }
        ospritesortcnt = renderedSpriteList.getSize();
        maphack_sprite = -1;
        if (Globals.maphack_highlight) {
            maphack_sprite = Main.game.getSprite();
        }
        block42: for (nTSprite = renderedSpriteList.getSize() - 1; nTSprite >= 0; --nTSprite) {
            pTSprite = (Sprite)renderedSpriteList.get(nTSprite);
            pTXSprite = Main.boardService.getXSprite(pTSprite.getExtra());
            if (pTSprite.getDetail() > Main.cfg.gDetail || pTSprite.getSectnum() == -1) {
                pTSprite.setXrepeat(0);
                continue;
            }
            nTile = pTSprite.getPicnum();
            if (nTile < 0 || nTile >= Globals.kMaxTiles) {
                System.err.println("tsprite[].cstat = " + pTSprite.getCstat());
                System.err.println("tsprite[].shade = " + pTSprite.getShade());
                System.err.println("tsprite[].pal = " + pTSprite.getPal());
                System.err.println("tsprite[].picnum = " + pTSprite.getPicnum());
                System.err.println("tsprite[].ang = " + pTSprite.getAng());
                System.err.println("tsprite[].owner = " + pTSprite.getOwner());
                System.err.println("tsprite[].sectnum = " + pTSprite.getSectnum());
                System.err.println("tsprite[].statnum = " + pTSprite.getStatnum());
                System.err.println("tsprite[].type = " + pTSprite.getLotag());
                System.err.println("tsprite[].flags = " + pTSprite.getHitag());
                System.err.println("tsprite[].extra = " + pTSprite.getExtra());
                throw new AssertException("nTile >= 0 && nTile < kMaxTiles");
            }
            oldLoc = Main.game.pInt.getsprinterpolate(pTSprite.getOwner());
            if (Main.cfg.gInterpolation == 1 && oldLoc != null && (pTSprite.getHitag() & 512) == 0) {
                x = oldLoc.x;
                y = oldLoc.y;
                z = oldLoc.z;
                nAngle = oldLoc.ang;
                nAngle = (short)(nAngle + Pragmas.mulscale((pTSprite.getAng() - oldLoc.ang + 1024 & 2047) - 1024, View.smoothratio, 16));
                pTSprite.setX(x += Pragmas.mulscale(pTSprite.getX() - oldLoc.x, View.smoothratio, 16));
                pTSprite.setY(y += Pragmas.mulscale(pTSprite.getY() - oldLoc.y, View.smoothratio, 16));
                pTSprite.setZ(z += Pragmas.mulscale(pTSprite.getZ() - oldLoc.z, View.smoothratio, 16));
                pTSprite.setAng(nAngle);
            }
            if ((pic = Main.engine.getTile(pTSprite.getPicnum())) instanceof BloodArtEntry) {
                nFrames = 0;
                switch (1.$SwitchMap$ru$m210projects$Blood$filehandlers$art$BloodArtEntry$ViewType[((BloodArtEntry)pic).getView().ordinal()]) {
                    case 1: {
                        if (pTXSprite == null) break;
                        switch (pTSprite.getLotag()) {
                            case 20: 
                            case 21: {
                                if (pTXSprite.getState() == 0) break;
                                nFrames = 1;
                                break;
                            }
                            case 22: {
                                nFrames = pTXSprite.getData1();
                            }
                        }
                        break;
                    }
                    case 2: {
                        dx = nViewX - (long)pTSprite.getX();
                        dy = nViewY - (long)pTSprite.getY();
                        Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                        nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                        if (nFrames > 4) {
                            nFrames = 8 - nFrames;
                            pTSprite.setCstat(pTSprite.getCstat() | 4);
                            break;
                        }
                        pTSprite.setCstat(pTSprite.getCstat() & -5);
                        break;
                    }
                    case 3: {
                        dx = nViewX - (long)pTSprite.getX();
                        dy = nViewY - (long)pTSprite.getY();
                        Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                        nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                        break;
                    }
                    case 4: {
                        if (pTXSprite == null) {
                            Gameutils.GetSpriteExtents(pTSprite);
                            if (Main.engine.getflorzofslope(pTSprite.getSectnum(), pTSprite.getX(), pTSprite.getY()) <= Gameutils.extents_zBot) break;
                            nFrames = 1;
                            break;
                        }
                        if (pTXSprite.getSpriteHit().floorHit != 0) break;
                        nFrames = 1;
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (Main.cfg.gDetail < 4 || (pTSprite.getHitag() & 16) != 0 || ((BloodArtEntry)pic).getView() != BloodArtEntry.ViewType.kSpriteViewSpinVoxel) break;
                        pTSprite.setAng((short)(8 * Main.engine.getTotalClock() & 2047));
                        break;
                    }
                }
                while (nFrames > 0) {
                    pTSprite.setPicnum(pTSprite.getPicnum() + Main.engine.getTile(pTSprite.getPicnum()).getAnimFrames() + 1);
                    if (pTSprite.getPicnum() >= Globals.kMaxTiles - 1) break;
                    --nFrames;
                }
            }
            if (pTSprite.getSectnum() < 0 || pTSprite.getSectnum() > Main.boardService.getSectorCount()) continue;
            sprshade = pTSprite.getShade();
            pSector = Main.boardService.getSector(pTSprite.getSectnum());
            pXSector = null;
            if (pSector.getExtra() > 0) {
                pXSector = DB.xsector[pSector.getExtra()];
            }
            if ((pSector.getCeilingstat() & 1) == 0 || (pSector.getFloorstat() & 32768) != 0) {
                shade1 = pSector.getFloorshade();
                shade2 = Tile.shadeTable[pSector.getFloorpicnum()];
            } else {
                shade1 = pSector.getCeilingshade();
                shade2 = Tile.shadeTable[pSector.getCeilingpicnum()];
            }
            sprshade = pTSprite.getShade() + shade1 + shade2 + (pTSprite.getPicnum() >= 0 ? Tile.shadeTable[pTSprite.getPicnum()] : 0);
            pTSprite.setShade((byte)Gameutils.ClipRange(sprshade, -128, Main.engine.getPaletteManager().getShadeCount() - 1));
            if ((pTSprite.getHitag() & 16) != 0 && Main.boardService.getSprite(pTSprite.getOwner()).getOwner() == 3) {
                if (pTXSprite == null) {
                    throw new AssertException("pTXSprite != NULL");
                }
                pTSprite.setPicnum((short)(2272 + 2 * pTXSprite.getRespawnPending()));
                pTSprite.setXrepeat(48);
                pTSprite.setYrepeat(48);
                pTSprite.setShade(-128);
                pTSprite.setCstat(pTSprite.getCstat() & -515);
                if ((Actor.IsItemSprite(pTSprite) || Actor.IsAmmoSprite(pTSprite)) && Globals.pGameInfo.nItemSettings == 2 || Actor.IsWeaponSprite(pTSprite) && Globals.pGameInfo.nWeaponSettings == 3) {
                    pTSprite.setYrepeat(48);
                } else {
                    pTSprite.setYrepeat(0);
                }
                pTSprite.setXrepeat(pTSprite.getYrepeat());
            }
            if (renderedSpriteList.getSize() >= 1024) continue;
            if (pTXSprite != null && Actor.actGetBurnTime(pTXSprite) > 0) {
                pTSprite.setShade((byte)Gameutils.ClipRange(pTSprite.getShade() - Pragmas.mulscale(8L, Gameutils.vRandom(), 15) - 16, -128, 127));
            }
            if ((pTSprite.getHitag() & 256) != 0) {
                View.viewAddEffect(nTSprite, 6);
            }
            if (Mirror.display_mirror) {
                // empty if block
            }
            if ((pTSprite.getHitag() & 1024) != 0) {
                pTSprite.setCstat(pTSprite.getCstat() | 4);
            }
            if ((pTSprite.getHitag() & 2048) != 0) {
                pTSprite.setCstat(pTSprite.getCstat() | 8);
            }
            switch (pTSprite.getStatnum()) {
                case 0: {
                    switch (pTSprite.getLotag()) {
                        case 30: {
                            if (pTXSprite != null) {
                                if (pTXSprite.getState() != 0) {
                                    pTSprite.setPicnum(pTSprite.getPicnum() + 1);
                                    View.viewAddEffect(nTSprite, 4);
                                    break;
                                }
                                View.viewAddEffect(nTSprite, 6);
                                break;
                            }
                            pTSprite.setPicnum(pTSprite.getPicnum() + 1);
                            View.viewAddEffect(nTSprite, 4);
                            break;
                        }
                        case 32: {
                            if (pTXSprite != null && pTXSprite.getState() == 0) {
                                pTSprite.setShade(-8);
                                break;
                            }
                            pTSprite.setShade(-128);
                            View.viewAddEffect(nTSprite, 11);
                            break;
                        }
                        default: {
                            if (pXSector != null && pXSector.color) {
                                pTSprite.setPal((byte)pSector.getFloorpal());
                                break;
                            }
                            ** GOTO lbl305
                        }
                    }
                    ** GOTO lbl305
                }
                case 3: {
                    switch (pTSprite.getLotag()) {
                        case 145: {
                            if (pTXSprite != null && pTXSprite.getState() != 0 && Globals.pGameInfo.nGameType == 3 && (pEffect = View.viewAddEffect(nTSprite, 17)) != null) {
                                pEffect.setPal(10);
                                break;
                            }
                            ** GOTO lbl305
                        }
                        case 146: {
                            if (pTXSprite != null && pTXSprite.getState() != 0 && Globals.pGameInfo.nGameType == 3 && (pEffect = View.viewAddEffect(nTSprite, 17)) != null) {
                                pEffect.setPal(7);
                                break;
                            }
                            ** GOTO lbl305
                        }
                        case 147: {
                            pTSprite.setPal(10);
                            pTSprite.setCstat(pTSprite.getCstat() | 4);
                            break;
                        }
                        case 148: {
                            pTSprite.setPal(7);
                            pTSprite.setCstat(pTSprite.getCstat() | 4);
                            break;
                        }
                        default: {
                            if (pTSprite.getLotag() >= 100 && pTSprite.getLotag() <= 106) {
                                pTSprite.setShade(-128);
                            }
                            if (pXSector != null && pXSector.color) {
                                pTSprite.setPal((byte)pSector.getFloorpal());
                                break;
                            }
                            ** GOTO lbl305
                        }
                    }
                    ** GOTO lbl305
                }
                case 5: {
                    switch (pTSprite.getLotag()) {
                        case 302: {
                            pTSprite.setCstat(pTSprite.getCstat() | 32);
                            pTSprite.setShade(-128);
                            ** GOTO lbl305
                        }
                        case 306: {
                            View.viewAddEffect(nTSprite, 15);
                            ** GOTO lbl305
                        }
                        case 300: {
                            View.viewAddEffect(nTSprite, 10);
                            ** GOTO lbl305
                        }
                        case 301: 
                        case 303: {
                            if (pTSprite.getStatnum() != 14) {
                                View.viewAddEffect(nTSprite, 1);
                                if (pTSprite.getLotag() == 301) {
                                    if ((pSector.getCeilingstat() & 1) == 0 && pTSprite.getZ() - pSector.getCeilingz() >> 8 < 64 && pSector.getCeilingpicnum() < 4080) {
                                        View.viewAddEffect(nTSprite, 2);
                                    }
                                    if ((pSector.getFloorstat() & 1) == 0 && pSector.getFloorz() - pTSprite.getZ() >> 8 < 64 && pSector.getFloorpicnum() < 4080) {
                                        View.viewAddEffect(nTSprite, 3);
                                    }
                                }
                            } else {
                                if (pTXSprite == null) {
                                    throw new AssertException("pTXSprite != NULL");
                                }
                                if (pTXSprite.getTarget() != gView.nSprite) {
                                    View.viewAddEffect(nTSprite, 1);
                                    if (pTSprite.getLotag() == 301) {
                                        if ((pSector.getCeilingstat() & 1) == 0 && pTSprite.getZ() - pSector.getCeilingz() >> 8 < 64 && pSector.getCeilingpicnum() < 4080) {
                                            View.viewAddEffect(nTSprite, 2);
                                        }
                                        if ((pSector.getFloorstat() & 1) == 0 && pSector.getFloorz() - pTSprite.getZ() >> 8 < 64 && pSector.getFloorpicnum() < 4080) {
                                            View.viewAddEffect(nTSprite, 3);
                                        }
                                    }
                                } else {
                                    pTSprite.setXrepeat(0);
                                }
                            }
                            ** GOTO lbl305
                        }
                    }
                    continue block42;
                }
                case 6: {
                    if (pTSprite.getLotag() == 242) {
                        pTSprite.setXrepeat(48);
                    }
                    if (Main.boardService.getSector(pTSprite.getSectnum()).getExtra() > 0 && DB.xsector[Main.boardService.getSector((int)pTSprite.getSectnum()).getExtra()].color) {
                        switch (pTSprite.getLotag()) {
                            case 201: 
                            case 202: 
                            case 230: 
                            case 246: 
                            case 247: 
                            case 248: 
                            case 249: {
                                break;
                            }
                            default: {
                                pTSprite.setPal((byte)Main.boardService.getSector(pTSprite.getSectnum()).getFloorpal());
                            }
                        }
                    }
                    if (PLAYER.powerupCheck(gView, 25) > 0) {
                        pTSprite.setShade(-128);
                    }
                    if (Gameutils.IsPlayerSprite(pTSprite)) {
                        pPlayer = Globals.gPlayer[pTSprite.getLotag() - 231];
                        if (pTSprite.getOwner() != gView.pSprite.getXvel() && Pragmas.klabs(Pragmas.mulscale(losAngle = (1024 + (nAngle = EngineUtils.getAngle(tx = pTSprite.getX() - (int)nViewX, ty = pTSprite.getY() - (int)nViewY)) - gView.pSprite.getAng() & 2047) - 1024, dist = (long)EngineUtils.qdist(tx, ty), 14)) < 4) {
                            z1 = (long)Pragmas.mulscale(dist, (int)gView.horizOff, 10) + nViewZ;
                            Gameutils.GetSpriteExtents(pTSprite);
                            if (z1 < (long)Gameutils.extents_zBot && z1 > (long)Gameutils.extents_zTop && Main.engine.cansee((int)nViewX, (int)nViewY, (int)nViewZ, gView.pSprite.getSectnum(), pTSprite.getX(), pTSprite.getY(), pTSprite.getZ(), pTSprite.getSectnum())) {
                                View.gPlayerIndex = pPlayer.nPlayer;
                            }
                        }
                        if (PLAYER.powerupCheck(pPlayer, 13) == 0 || PLAYER.powerupCheck(gView, 25) > 0) {
                            if (PLAYER.powerupCheck(pPlayer, 14) != 0) {
                                pTSprite.setShade(-128);
                                pTSprite.setPal(5);
                            } else if (PLAYER.powerupCheck(pPlayer, 23) != 0) {
                                pTSprite.setPal((byte)((gView.teamID & 3) + 11));
                            }
                        } else {
                            pTSprite.setCstat(pTSprite.getCstat() | 2);
                            pTSprite.setPal(5);
                        }
                        if (PLAYER.powerupCheck(pPlayer, 24) != 0) {
                            View.viewAddEffect(nTSprite, 13);
                        }
                        if (Main.cfg.gShowWeapon && Globals.pGameInfo.nGameType > 0 && pPlayer != gView) {
                            View.viewAddEffect(nTSprite, 12);
                        }
                        if ((pPlayer.fireEffect & 1) != 0 && (pPlayer != gView || View.gViewPos != 0) && (pEffect = View.viewAddEffect(nTSprite, 14)) != null) {
                            cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
                            pEffect.setX(pEffect.getX() + Pragmas.mulscale(Trig.Cos(pTSprite.getAng()), cp.xoffset, 28));
                            pEffect.setY(pEffect.getY() + Pragmas.mulscale(Trig.Sin(pTSprite.getAng()), cp.xoffset, 28));
                            pEffect.setZ(pPlayer.pSprite.getZ() - cp.zoffset);
                        }
                        if (pPlayer.hasFlag > 0 && Globals.pGameInfo.nGameType == 3) {
                            if ((pPlayer.hasFlag & 1) != 0 && (pEffect = View.viewAddEffect(nTSprite, 16)) != null) {
                                pEffect.setPal(10);
                                pEffect.setCstat(pEffect.getCstat() | 4);
                            }
                            if ((pPlayer.hasFlag & 2) != 0 && (pEffect = View.viewAddEffect(nTSprite, 16)) != null) {
                                pEffect.setPal(7);
                                pEffect.setCstat(pEffect.getCstat() | 4);
                            }
                        }
                    }
                    if ((pTSprite.getOwner() != gView.pSprite.getXvel() || View.gViewPos != 0) && (long)Main.engine.getflorzofslope(pTSprite.getSectnum(), pTSprite.getX(), pTSprite.getY()) >= nViewZ && (pTSpr = View.viewAddEffect(nTSprite, 0)) != null) {
                        camangle = EngineUtils.getAngle((int)nViewX - pTSprite.getX(), (int)nViewY - pTSprite.getY());
                        pTSpr.setX(pTSpr.getX() - Pragmas.mulscale(EngineUtils.sin(camangle + 512), 300L, 16));
                        pTSpr.setY(pTSpr.getY() + Pragmas.mulscale(EngineUtils.sin(camangle + 1024), 300L, 16));
                    }
                    ** GOTO lbl305
                }
                case 11: {
                    if (pTSprite.getLotag() == 454) {
                        if (pTXSprite != null && pTXSprite.getState() == 1) {
                            if (pTXSprite.getData1() != 0) {
                                pTSprite.setPicnum(772);
                                if (pTXSprite.getData2() != 0) {
                                    View.viewAddEffect(nTSprite, 9);
                                }
                            }
                        } else if (pTXSprite.getData1() != 0) {
                            pTSprite.setPicnum(773);
                        } else {
                            pTSprite.setPicnum(656);
                        }
                    }
                    ** GOTO lbl305
                }
                case 4: {
                    if (pXSector != null && pXSector.color) {
                        pTSprite.setPal((byte)pSector.getFloorpal());
                    }
                    if ((pTSprite.getHitag() & 1) != 0 && (long)Main.engine.getflorzofslope(pTSprite.getSectnum(), pTSprite.getX(), pTSprite.getY()) >= nViewZ && (pTSprite.getLotag() < 400 || pTSprite.getLotag() >= 436 || pTXSprite.getSpriteHit().floorHit == 0)) {
                        View.viewAddEffect(nTSprite, 0);
                    }
                }
lbl305:
                // 20 sources

                default: {
                    if (maphack_sprite == -1 || maphack_sprite != pTSprite.getOwner()) continue block42;
                    pTSprite.setShade((byte)(32 - Main.engine.getTotalClock() & 32));
                }
            }
        }
        for (nTSprite = renderedSpriteList.getSize() - 1; nTSprite >= ospritesortcnt; --nTSprite) {
            pTSprite = (Sprite)renderedSpriteList.get(nTSprite);
            art = Main.engine.getTile(pTSprite.getPicnum());
            if (!(art instanceof BloodArtEntry)) continue;
            nFrames = 0;
            switch (1.$SwitchMap$ru$m210projects$Blood$filehandlers$art$BloodArtEntry$ViewType[((BloodArtEntry)art).getView().ordinal()]) {
                case 2: {
                    dx = nViewX - (long)pTSprite.getX();
                    dy = nViewY - (long)pTSprite.getY();
                    Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTSprite.setCstat(pTSprite.getCstat() | 4);
                        break;
                    }
                    pTSprite.setCstat(pTSprite.getCstat() & -5);
                    break;
                }
                case 3: {
                    dx = nViewX - (long)pTSprite.getX();
                    dy = nViewY - (long)pTSprite.getY();
                    Trig.RotateVector(dx, dy, -pTSprite.getAng() + 128);
                    nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    break;
                }
            }
            while (nFrames > 0) {
                --nFrames;
                pTSprite.setPicnum(pTSprite.getPicnum() + art.getAnimFrames() + 1);
            }
        }
    }

    public static void viewShowLoadingTile() {
        BloodRenderer renderer = Main.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        int flags = 74;
        int pic = 2049;
        switch (4 * ydim / xdim) {
            default: {
                pic = 2049;
                break;
            }
            case 2: {
                if (!Main.engine.getTile(9223).exists()) break;
                pic = 9223;
                break;
            }
            case 1: {
                if (!Main.engine.getTile(9224).exists()) break;
                pic = 9224;
            }
        }
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, pic, 0, 0, flags);
    }

    public static void DoLensEffect(DynamicArtEntry ballBuffer) {
        byte[] d = ballBuffer.getBytes();
        byte[] s = Main.engine.getTile(4079).getBytes();
        int i = 0;
        int dptr = 0;
        while (i < 6400) {
            int lensData = LittleEndian.getInt(lensTable, 4 * i);
            if (lensData >= 0) {
                d[dptr] = s[lensData];
            }
            ++i;
            ++dptr;
        }
        ballBuffer.invalidate();
    }

    public static void viewSecretStat() {
        BloodRenderer renderer = Main.game.getRenderer();
        Main.game.getFont(1).drawTextScaled((Renderer)renderer, 75, 70, Strings.secrets, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        View.viewDrawNumber(1, LEVELS.foundSecret, 160, 70, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        Main.game.getFont(1).drawTextScaled((Renderer)renderer, 190, 70, Strings.of, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        View.viewDrawNumber(1, LEVELS.totalSecrets, 220, 70, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        if (LEVELS.superSecrets > 0) {
            Main.game.getFont(1).drawTextScaled((Renderer)renderer, 160, 100, Strings.supersecret, 1.0f, -128, 2, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        }
    }

    public static void viewFragStat() {
        BloodRenderer renderer = Main.game.getRenderer();
        Main.game.getFont(1).drawTextScaled((Renderer)renderer, 75, 50, Strings.killsstat, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        View.viewDrawNumber(1, LEVELS.kills, 160, 50, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        Main.game.getFont(1).drawTextScaled((Renderer)renderer, 190, 50, Strings.of, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
        View.viewDrawNumber(1, LEVELS.totalKills, 220, 50, 1.0f, -128, 0, TextAlign.Left, Transparent.None, ConvertType.Normal, true);
    }

    public static void viewBackupSpriteLoc(int nSprite, Sprite pSprite) {
        Main.game.pInt.setsprinterpolate(nSprite, pSprite);
    }

    public static void viewBackupSectorLoc(int nSector, Sector pSector) {
        Main.game.pInt.setceilinterpolate(nSector, pSector);
        Main.game.pInt.setfheinuminterpolate(nSector, pSector);
        Main.game.pInt.setfloorinterpolate(nSector, pSector);
    }

    public static TSprite viewInsertTSprite(int nSector, int nStatus, Sprite pSource) {
        BloodRenderer renderer = Main.game.getRenderer();
        TSprite pTSprite = (TSprite)renderer.getRenderedSprites().obtain();
        pTSprite.reset((byte)0);
        pTSprite.setLotag(-1);
        pTSprite.setStatnum((short)nStatus);
        pTSprite.setCstat(128);
        pTSprite.setXrepeat(64);
        pTSprite.setYrepeat(64);
        pTSprite.setOwner(-1);
        pTSprite.setExtra(-1);
        if (pSource != null) {
            pTSprite.setOwner(pSource.getOwner());
            pTSprite.setAng(pSource.getAng());
            pTSprite.update(pSource.getX(), pSource.getY(), pSource.getZ(), (short)nSector);
        } else {
            pTSprite.update(0, 0, 0, (short)nSector);
        }
        return pTSprite;
    }

    private static Sprite viewAddEffect(int nTSprite, int nViewEffect) {
        if (nViewEffect < 0 || nViewEffect >= 19) {
            throw new AssertException("nViewEffect >= 0 && nViewEffect < kViewEffectMax " + nViewEffect);
        }
        BloodRenderer renderer = Main.game.getRenderer();
        RenderedSpriteList renderedSpriteList = renderer.getRenderedSprites();
        Sprite pTSprite = (Sprite)renderedSpriteList.get(nTSprite);
        if (Main.cfg.gDetail < gEffectDetail[nViewEffect] || nViewEffect > 18) {
            return null;
        }
        switch (nViewEffect) {
            case 0: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setZ(Main.engine.getflorzofslope(pTSprite.getSectnum(), pTEffect.getX(), pTEffect.getY()));
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                ArtEntry art = Main.engine.getTile(Main.boardService.getSprite(pTSprite.getOwner()).getPicnum());
                if (art instanceof BloodArtEntry && ((BloodArtEntry)art).getView() == BloodArtEntry.ViewType.kSpriteView5Full) {
                    int dx = Globals.gPlayer[View.gViewIndex].pSprite.getX() - pTEffect.getX();
                    int dy = Globals.gPlayer[View.gViewIndex].pSprite.getY() - pTEffect.getY();
                    Trig.RotateVector(dx, dy, -pTEffect.getAng() + 128);
                    int nFrames = Trig.GetOctant((int)Trig.rotated.x, (int)Trig.rotated.y);
                    if (nFrames > 4) {
                        nFrames = 8 - nFrames;
                        pTEffect.setCstat(pTEffect.getCstat() | 4);
                    } else {
                        pTEffect.setCstat(pTEffect.getCstat() & 0xFFFFFFFB);
                    }
                }
                pTEffect.setShade(127);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                pTEffect.setYrepeat((short)(pTSprite.getYrepeat() >> 2));
                pTEffect.setPicnum(pTSprite.getPicnum());
                pTEffect.setPal(5);
                ArtEntry pic = Main.engine.getTile(pTEffect.getPicnum());
                pTEffect.setZ(pTEffect.getZ() - ((pic.getHeight() - (pic.getOffsetY() + pic.getHeight() / 2)) * pTEffect.getYrepeat() << 2));
                return pTEffect;
            }
            case 1: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setShade(-128);
                pTEffect.setPal(2);
                pTEffect.setZ(pTSprite.getZ());
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setPicnum(2427);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                pTEffect.setYrepeat(pTSprite.getYrepeat());
                break;
            }
            case 2: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setX(pTSprite.getX());
                pTEffect.setY(pTSprite.getY());
                pTEffect.setPal(2);
                pTEffect.setXrepeat(64);
                pTEffect.setYrepeat(64);
                pTEffect.setPicnum(624);
                pTEffect.setZ(Main.boardService.getSector(pTSprite.getSectnum()).getCeilingz());
                pTEffect.setShade((byte)((pTSprite.getZ() - Main.boardService.getSector(pTSprite.getSectnum()).getCeilingz() >> 8) - 64));
                pTEffect.setCstat(pTEffect.getCstat() | 0x6A);
                pTEffect.setAng(pTSprite.getAng());
                pTEffect.setOwner(pTSprite.getOwner());
                break;
            }
            case 3: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setX(pTSprite.getX());
                pTEffect.setY(pTSprite.getY());
                pTEffect.setPal(2);
                pTEffect.setPicnum(624);
                pTEffect.setZ(Main.boardService.getSector(pTSprite.getSectnum()).getFloorz());
                pTEffect.setShade((byte)((Main.boardService.getSector(pTSprite.getSectnum()).getFloorz() - pTSprite.getZ() >> 8) - 32));
                pTEffect.setXrepeat((short)(Main.boardService.getSector(pTSprite.getSectnum()).getFloorz() - pTSprite.getZ() >> 8));
                pTEffect.setYrepeat((short)(Main.boardService.getSector(pTSprite.getSectnum()).getFloorz() - pTSprite.getZ() >> 8));
                pTEffect.setCstat(pTEffect.getCstat() | 0x62);
                pTEffect.setAng(pTSprite.getAng());
                pTEffect.setOwner(pTSprite.getOwner());
                break;
            }
            case 4: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.setPicnum(2101);
                pTEffect.setShade(-128);
                pTEffect.setZ(Gameutils.extents_zTop);
                short size = (short)(Main.engine.getTile(pTSprite.getPicnum()).getWidth() * pTSprite.getXrepeat() / 32);
                pTEffect.setYrepeat(size);
                pTEffect.setXrepeat(size);
                break;
            }
            case 5: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.setPicnum(2101);
                pTEffect.setShade(-128);
                pTEffect.setZ(Gameutils.extents_zBot);
                short size = (short)(Main.engine.getTile(pTSprite.getPicnum()).getWidth() * pTSprite.getXrepeat() / 32);
                pTEffect.setYrepeat(size);
                pTEffect.setXrepeat(size);
                break;
            }
            case 6: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.setZ(Gameutils.extents_zTop);
                if (pTSprite.getLotag() >= 200 && pTSprite.getLotag() < 247) {
                    pTEffect.setPicnum(672);
                } else {
                    pTEffect.setPicnum(754);
                }
                pTEffect.setShade(8);
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                pTEffect.setYrepeat(pTSprite.getYrepeat());
                break;
            }
            case 7: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.setZ(Gameutils.extents_zBot);
                if (pTSprite.getLotag() >= 200 && pTSprite.getLotag() < 247) {
                    pTEffect.setPicnum(672);
                } else {
                    pTEffect.setPicnum(754);
                }
                pTEffect.setShade(8);
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                pTEffect.setYrepeat(pTSprite.getYrepeat());
                break;
            }
            case 8: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setShade(-128);
                pTEffect.setZ(pTSprite.getZ());
                short size = (short)(Main.engine.getTile(pTSprite.getPicnum()).getWidth() * pTSprite.getXrepeat() / 64);
                pTEffect.setPicnum(908);
                pTEffect.setStatnum(0);
                pTEffect.setYrepeat(size);
                pTEffect.setXrepeat(size);
                break;
            }
            case 9: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setZ(pTSprite.getZ());
                if (Main.cfg.gDetail > 1) {
                    pTEffect.setCstat(pTEffect.getCstat() | 0x202);
                }
                pTEffect.setShade((byte)Gameutils.ClipLow(pTSprite.getShade() - 32, -128));
                pTEffect.setYrepeat(64);
                pTEffect.setPicnum(775);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                break;
            }
            case 10: {
                int nAngle = pTSprite.getAng();
                nAngle = (pTSprite.getCstat() & 0x10) != 0 ? (nAngle += 512) : (nAngle += 1024);
                nAngle &= 0x7FF;
                for (int i = 0; i < 5; ++i) {
                    short nSector = pTSprite.getSectnum();
                    TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, null);
                    pTEffect.setAng(pTSprite.getAng());
                    pTEffect.setX(pTSprite.getX() + Pragmas.mulscale(Trig.Cos(nAngle), ((long)i << 7) + 128L, 30));
                    pTEffect.setY(pTSprite.getY() + Pragmas.mulscale(Trig.Sin(nAngle), ((long)i << 7) + 128L, 30));
                    pTEffect.setZ(pTSprite.getZ());
                    if (!Main.boardService.isValidSector(nSector)) {
                        throw new AssertException("boardService.isValidSector(nSector)");
                    }
                    Gameutils.FindSector(pTEffect.getX(), pTEffect.getY(), pTEffect.getZ(), pTSprite.getSectnum());
                    pTEffect.setOwner(pTSprite.getOwner());
                    pTEffect.setPicnum(pTSprite.getPicnum());
                    pTEffect.setCstat(pTEffect.getCstat() | 2);
                    if (i < 2) {
                        pTEffect.setCstat(pTEffect.getCstat() | 0x202);
                    }
                    pTEffect.setShade((byte)Gameutils.ClipLow(pTSprite.getShade() - 16, -128));
                    pTEffect.setXrepeat(pTSprite.getXrepeat());
                    pTEffect.setYrepeat(pTSprite.getYrepeat());
                    pTEffect.setPicnum(pTSprite.getPicnum());
                }
                break;
            }
            case 11: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                Gameutils.GetSpriteExtents(pTSprite);
                pTEffect.setShade(26);
                pTEffect.setPal(0);
                pTEffect.setYrepeat(24);
                pTEffect.setPicnum(626);
                pTEffect.setZ(Gameutils.extents_zTop);
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setXrepeat(pTEffect.getYrepeat());
                break;
            }
            case 12: {
                if (!Gameutils.IsPlayerSprite(pTSprite)) {
                    throw new AssertException("pTSprite.type >= kDudePlayer1 && pTSprite.type <= kDudePlayer8");
                }
                PLAYER pPlayer = Globals.gPlayer[pTSprite.getLotag() - 231];
                if (viewWeaponTile[pPlayer.currentWeapon] == -1) break;
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setX(pTSprite.getX());
                pTEffect.setY(pTSprite.getY());
                pTEffect.setZ(pTSprite.getZ() - 8192);
                pTEffect.setPicnum(viewWeaponTile[pPlayer.currentWeapon]);
                pTEffect.setShade(pTSprite.getShade());
                pTEffect.setXrepeat(32);
                pTEffect.setYrepeat(32);
                break;
            }
            case 13: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setShade(26);
                pTEffect.setPal(0);
                pTEffect.setYrepeat(64);
                pTEffect.setPicnum(2089);
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setXrepeat(pTEffect.getYrepeat());
                break;
            }
            case 14: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setShade(-128);
                pTEffect.setPal(0);
                pTEffect.setYrepeat(64);
                pTEffect.setPicnum(2605);
                pTEffect.setXrepeat(pTEffect.getYrepeat());
                return pTEffect;
            }
            case 15: {
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setZ(pTSprite.getZ());
                pTEffect.setShade(-128);
                pTEffect.setCstat(pTEffect.getCstat() | 2);
                pTEffect.setXrepeat(pTSprite.getXrepeat());
                pTEffect.setPicnum(2135);
                pTEffect.setYrepeat(pTSprite.getYrepeat());
                break;
            }
            case 16: 
            case 17: {
                Gameutils.GetSpriteExtents(pTSprite);
                TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                pTEffect.setShade(-128);
                pTEffect.setPal(0);
                pTEffect.setZ(Gameutils.extents_zTop);
                if (nViewEffect == 16) {
                    pTEffect.setYrepeat(16);
                } else {
                    pTEffect.setYrepeat(64);
                }
                pTEffect.setXrepeat(pTEffect.getYrepeat());
                pTEffect.setPicnum(3558);
                return pTEffect;
            }
            case 18: {
                for (int i = 0; i < 16; ++i) {
                    TSprite pTEffect = View.viewInsertTSprite(pTSprite.getSectnum(), Short.MAX_VALUE, pTSprite);
                    int velocity = (int)((float)Pragmas.divscale(Globals.gFrameClock, 120L, 11) + View.atomEffectVelocity[i].z);
                    int dx = Pragmas.mulscale(Trig.Cos(velocity), 512L, 30);
                    int dy = Pragmas.mulscale(Trig.Sin(velocity), 512L, 30);
                    dy = (int)Trig.RotateVector((long)((long)dy), (long)0L, (int)((int)View.atomEffectVelocity[i].x)).x;
                    int dz = (int)Trig.RotateVector((long)((long)dx), (long)((long)((int)Trig.rotated.y)), (int)((int)View.atomEffectVelocity[i].y)).y;
                    dx = (int)Trig.rotated.x;
                    pTEffect.setX(pTSprite.getX() + dx);
                    pTEffect.setY(pTSprite.getY() + dy);
                    pTEffect.setZ(pTSprite.getZ() + (dz << 4));
                    pTEffect.setPicnum(1720);
                    pTEffect.setShade(-128);
                }
                break;
            }
        }
        return null;
    }

    public static void coords() {
        int y = 30;
        BloodRenderer renderer = Main.game.getRenderer();
        BitmapFont font = EngineUtils.getSmallFont();
        font.drawText((Renderer)renderer, 32, y, Gameutils.toCharArray("X= ", Integer.toString(Globals.gMe.pSprite.getX())), 1.0f, 0, 31, TextAlign.Left, Transparent.None, false);
        font.drawText((Renderer)renderer, 32, y + 7, Gameutils.toCharArray("Y= ", Integer.toString(Globals.gMe.pSprite.getY())), 1.0f, 0, 31, TextAlign.Left, Transparent.None, false);
        font.drawText((Renderer)renderer, 32, y + 14, Gameutils.toCharArray("Z= ", Integer.toString(Globals.gMe.pSprite.getZ())), 1.0f, 0, 31, TextAlign.Left, Transparent.None, false);
        font.drawText((Renderer)renderer, 32, y + 21, Gameutils.toCharArray("A= ", Integer.toString(Globals.gMe.pSprite.getAng())), 1.0f, 0, 31, TextAlign.Left, Transparent.None, false);
        font.drawText((Renderer)renderer, 32, y + 28, Gameutils.toCharArray("SECT= ", Integer.toString(Globals.gMe.pSprite.getSectnum())), 1.0f, 0, 31, TextAlign.Left, Transparent.None, false);
    }

    private static void DrawStatSprite(int nTile, int x, int y, int nShade, int nPLU, int nFlag, int nScale) {
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(x << 16, y << 16, nScale, 0, (short)nTile, nShade, nPLU, nFlag | 0xA, gViewX0, gViewY0, gViewX1, gViewY1);
    }

    static {
        yOffset = 11;
        kMapZoom = 1024;
        PaletteView = 0;
        gViewIndex = 0;
        gViewPos = 0;
        gViewMode = 3;
        deliriumTilt = 0;
        deliriumTurn = 0;
        deliriumPitch = 0;
        viewThirdDist = -1;
        viewThirdClock = 0;
        othercameradist = 1280;
        othercameraclock = 0;
    }
}

