/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.filehandlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.Pattern.SaveReader;
import ru.m210projects.Build.filehandle.StreamUtils;

public class BloodSaveHeader
extends SaveReader.SaveHeader {
    public int skill;
    public int episode;
    public int level;
    public boolean gUserEpisode;
    public String addonFileName;
    public String addonPackedIniName;

    public BloodSaveHeader() {
        this.signature = "BLUD";
        this.version = 304;
    }

    @Override
    public BloodSaveHeader readObject(InputStream is) throws IOException {
        super.readObject(is);
        this.skill = StreamUtils.readByte(is) + 1;
        this.episode = StreamUtils.readInt(is) + 1;
        this.level = StreamUtils.readInt(is) + 1;
        this.gUserEpisode = StreamUtils.readBoolean(is);
        if (this.gUserEpisode) {
            boolean isPacked = StreamUtils.readBoolean(is);
            this.addonFileName = StreamUtils.readDataString(is);
            if (isPacked) {
                this.addonPackedIniName = StreamUtils.readDataString(is);
            }
        }
        return this;
    }

    @Override
    public BloodSaveHeader writeObject(OutputStream os) throws IOException {
        super.writeObject(os);
        StreamUtils.writeByte(os, Globals.pGameInfo.nDifficulty);
        StreamUtils.writeInt(os, Globals.pGameInfo.nEpisode);
        StreamUtils.writeInt(os, Globals.pGameInfo.nLevel);
        StreamUtils.writeBoolean(os, Main.mUserFlag == Main.UserFlag.Addon);
        if (Main.mUserFlag == Main.UserFlag.Addon) {
            this.addonFileName = "";
            this.addonPackedIniName = "";
            if (LEVELS.currentEpisode != null && LEVELS.currentEpisode.iniFile != null) {
                EpisodeEntry episodeEntry = LEVELS.currentEpisode.iniFile.getEpisodeEntry();
                this.addonFileName = episodeEntry.getFileEntry().getRelativePath().toString();
                if (episodeEntry.isPackageEpisode()) {
                    this.addonPackedIniName = episodeEntry.getIniFile().getName();
                }
            }
            StreamUtils.writeBoolean(os, !this.addonPackedIniName.isEmpty());
            StreamUtils.writeDataString(os, this.addonFileName);
            if (!this.addonPackedIniName.isEmpty()) {
                StreamUtils.writeDataString(os, this.addonPackedIniName);
            }
        }
        return this;
    }
}

