/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.filehandlers.scripts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.filehandlers.UserEntry;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.rff.RffFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class BloodDef
extends DefScript {
    private final DefineIdToken rffid = new DefineIdToken();
    private final NBloodDefineIdToken nbrffid = new NBloodDefineIdToken();
    private final DefScript.TileFromTextureToken tft = new BloodTileFromTextureToken();
    public byte[] surfType = new byte[Globals.kMaxTiles];
    private final RffFile userDef;

    public BloodDef(Engine engine) {
        super(engine);
        this.addToken("definefileid", this.rffid);
        this.addToken("rffdefineid", this.nbrffid);
        this.addToken("tilefromtexture", this.tft);
        this.surfaceInit("SURFACE.DAT");
        this.userDef = new RffFile("UserDef");
    }

    public BloodDef(BloodDef src, Entry group) {
        super(src, group);
        this.addToken("definefileid", this.rffid);
        this.addToken("rffdefineid", this.nbrffid);
        this.addToken("tilefromtexture", this.tft);
        System.arraycopy(src.surfType, 0, this.surfType, 0, src.surfType.length);
        this.userDef = new RffFile("UserDef");
    }

    public void surfaceInit(String name) {
        Entry data = Main.game.getCache().getEntry(name, true);
        if (!data.exists()) {
            return;
        }
        byte[] surfs = data.getBytes();
        System.arraycopy(surfs, 0, this.surfType, 0, Math.min(surfs.length, this.surfType.length));
    }

    @Override
    public void apply() {
        int i;
        List defs;
        if (this.addonsIncludes != null && this.currentAddon != null && (defs = (List)this.addonsIncludes.get(this.currentAddon.getName())) != null) {
            for (i = 0; i < defs.size() / 2; ++i) {
                String fn = (String)defs.get(2 * i + 1);
                Entry res = Main.game.getCache().getEntry(fn, true);
                if (!res.exists()) {
                    Console.out.println("Warning: Failed including " + fn + " as module", OsdColor.RED);
                    continue;
                }
                Scriptfile included = new Scriptfile(fn, res);
                included.path = (String)defs.get(2 * i);
                this.defsparser(included);
            }
        }
        Main.game.getCache().addGroup(this.userDef, this.disposable ? CacheResourceMap.CachePriority.HIGHEST : CacheResourceMap.CachePriority.NORMAL);
        for (i = 0; i < Engine.MAXTILES; ++i) {
            long crc32;
            if (this.tiles[i] == null) continue;
            DefScript.DefTile tile = this.tiles[i];
            ArtEntry pic = this.engine.getTile(i);
            if (tile.crc32 != 0L && (crc32 = pic.getChecksum()) != tile.crc32) {
                boolean found = false;
                while (tile.next != null) {
                    tile = tile.next;
                    if (tile.crc32 != 0L && crc32 != tile.crc32) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (tile.waloff == null) continue;
            DynamicArtEntry newPic = this.engine.allocatepermanenttile(i, tile.sizx, tile.sizy);
            newPic.copyData(tile.waloff);
            int flags = pic.getFlags();
            flags &= 0x8F0000FF;
            newPic.setFlags(flags |= (tile.optional & 7) << 28);
            newPic.setOffset(tile.xoffset, tile.yoffset);
            this.texInfo.addTexture(i, 0, tile.hrp, (float)(255 - (tile.alphacut & 0xFF)) * 0.003921569f, 1.0f, 1.0f, 1.0f, 1.0f, 0);
        }
    }

    public byte GetSurfType(int nHit) {
        int nHitType = nHit & 0xE0000000;
        int nHitIndex = nHit & 0x1FFFFFFF;
        switch (nHitType) {
            case 0x40000000: {
                return this.surfType[Main.boardService.getSector(nHitIndex).getFloorpicnum()];
            }
            case 0x60000000: {
                return this.surfType[Main.boardService.getSector(nHitIndex).getCeilingpicnum()];
            }
            case -2147483648: {
                return this.surfType[Main.boardService.getWall(nHitIndex).getPicnum()];
            }
            case -1073741824: {
                return this.surfType[Main.boardService.getSprite(nHitIndex).getPicnum()];
            }
        }
        return 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.disposable) {
            Main.game.getCache().removeGroup(this.userDef);
        }
    }

    public class DefineIdToken
    implements DefScript.Token {
        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            String name = BloodDef.this.getFile(script);
            if (name == null) {
                return DefScript.BaseToken.Error;
            }
            Entry entry = Main.game.getCache().getEntry(name, false);
            if (!entry.exists() && !(entry = Main.game.getCache().getEntry(name, true)).exists()) {
                Console.out.println("DefineId error: file " + name + " not found!", OsdColor.RED);
                return DefScript.BaseToken.Error;
            }
            Integer fileId = script.getsymbol();
            if (fileId == null) {
                return DefScript.BaseToken.Error;
            }
            BloodDef.this.userDef.addEntry(new UserEntry(entry, fileId));
            return DefScript.BaseToken.Ok;
        }
    }

    public class NBloodDefineIdToken
    implements DefScript.Token {
        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            String name = BloodDef.this.getFile(script);
            if (name == null) {
                return DefScript.BaseToken.Error;
            }
            String ext = script.getstring();
            if (ext == null) {
                return DefScript.BaseToken.Error;
            }
            String filename = name + "." + ext;
            Entry entry = Main.game.getCache().getEntry(filename, false);
            if (!entry.exists() && !(entry = Main.game.getCache().getEntry(filename, true)).exists()) {
                Console.out.println("DefineId error: file " + filename + " not found!", OsdColor.RED);
                return DefScript.BaseToken.Error;
            }
            Integer fileId = script.getsymbol();
            if (fileId == null) {
                return DefScript.BaseToken.Error;
            }
            script.getstring();
            BloodDef.this.userDef.addEntry(new UserEntry(entry, fileId));
            return DefScript.BaseToken.Ok;
        }
    }

    private class BloodTileFromTextureToken
    extends DefScript.TileFromTextureToken {
        protected final Map<String, TileTextureTokens> tilefromtexturetokens = new HashMap<String, TileTextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("file", TileTextureTokens.FILE);
                this.put("name", TileTextureTokens.FILE);
                this.put("alphacut", TileTextureTokens.ALPHACUT);
                this.put("xoffset", TileTextureTokens.XOFFSET);
                this.put("xoff", TileTextureTokens.XOFFSET);
                this.put("yoffset", TileTextureTokens.YOFFSET);
                this.put("yoff", TileTextureTokens.YOFFSET);
                this.put("texture", TileTextureTokens.TEXTURE);
                this.put("ifcrc", TileTextureTokens.CRC);
                this.put("extra", TileTextureTokens.EXTRA);
                this.put("surface", TileTextureTokens.SURF);
            }
        };

        private BloodTileFromTextureToken() {
        }

        @Override
        public DefScript.BaseToken parse(Scriptfile script) {
            int ttexturetokptr = script.ltextptr;
            String fn = null;
            Integer tile = -1;
            int talphacut = 255;
            Byte xoffset = null;
            Byte yoffset = null;
            long tilecrc = 0L;
            boolean istexture = false;
            Integer extra = null;
            Integer surf = null;
            tile = script.getsymbol();
            if (tile == null) {
                return DefScript.BaseToken.Error;
            }
            int ttextureend = script.getbraces();
            if (ttextureend == -1) {
                return DefScript.BaseToken.Error;
            }
            while (script.textptr < ttextureend) {
                Object tk = BloodDef.this.gettoken(script, this.tilefromtexturetokens);
                if (tk instanceof DefScript.BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(BloodDef.this.getPtr(script, line), BloodDef.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                switch (((TileTextureTokens)((Object)tk)).ordinal()) {
                    case 6: {
                        extra = script.getsymbol();
                        break;
                    }
                    case 0: {
                        fn = BloodDef.this.getFile(script);
                        break;
                    }
                    case 1: {
                        Integer value = script.getsymbol();
                        if (value != null) {
                            talphacut = value;
                        }
                        talphacut = Gameutils.BClipRange(talphacut, 0, 255);
                        break;
                    }
                    case 2: {
                        String xoffs = script.getstring();
                        if (xoffs.equalsIgnoreCase("ART")) {
                            xoffset = BloodDef.this.engine.getTile(tile).getOffsetX();
                            break;
                        }
                        try {
                            xoffset = Byte.parseByte(xoffs);
                        }
                        catch (Exception e) {
                            Console.out.println("Xoffset value out of range. Value: \"" + xoffs + "\" was disabled.", OsdColor.RED);
                        }
                        break;
                    }
                    case 3: {
                        String yoffs = script.getstring();
                        if (yoffs.equalsIgnoreCase("ART")) {
                            yoffset = BloodDef.this.engine.getTile(tile).getOffsetY();
                            break;
                        }
                        try {
                            yoffset = Byte.parseByte(yoffs);
                        }
                        catch (Exception e) {
                            Console.out.println("Yoffset value out of range. Value: \"" + yoffs + "\" was disabled.", OsdColor.RED);
                        }
                        break;
                    }
                    case 4: {
                        istexture = true;
                        break;
                    }
                    case 7: {
                        Integer value = script.getsymbol();
                        if (value == null) break;
                        surf = Gameutils.BClipRange(value, 0, 255);
                        break;
                    }
                    case 5: {
                        tilecrc = (long)script.getsymbol().intValue() & 0xFFFFFFFFL;
                    }
                }
            }
            DefScript.DefTile dt = this.addTile(script, fn, tile, xoffset, yoffset, tilecrc, talphacut, istexture, ttexturetokptr);
            if (dt != null) {
                if (extra != null) {
                    dt.optional = extra;
                }
                if (surf != null) {
                    byte s = (byte)surf.intValue();
                    if (s >= Tile.kSurfMax) {
                        Console.out.println("Warning! surfaceType out of range: " + s + " resetting...", OsdColor.RED);
                        s = 0;
                    }
                    BloodDef.this.surfType[tile.intValue()] = s;
                }
                return DefScript.BaseToken.Ok;
            }
            return DefScript.BaseToken.Error;
        }
    }

    public static enum TileTextureTokens {
        FILE,
        ALPHACUT,
        XOFFSET,
        YOFFSET,
        TEXTURE,
        CRC,
        EXTRA,
        SURF;

    }
}

