/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture.common;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Render.DummyRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.settings.ApplicationContext;
import ru.m210projects.Build.settings.GameConfig;

public abstract class RenderChanger
implements ApplicationListener,
ApplicationContext.ApplicationChangeListener {
    protected BuildGame game;
    protected GameConfig config;
    protected boolean renderChanging = false;
    protected boolean created = false;

    public RenderChanger(BuildGame listener) {
        this.game = listener;
        this.config = this.game.pCfg;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        applicationContext.setApplicationChangeListener(this);
        applicationContext.setControllerListener(this.game.getProcessor());
        if (!this.config.getControllerName().isEmpty()) {
            this.config.getControllers();
        }
        this.config.setApplicationContext(applicationContext);
    }

    protected abstract void startApplication(Renderer.RenderType var1);

    @Override
    public void create() {
        if (this.renderChanging) {
            this.game.resume();
            this.game.initRenderer();
            this.renderChanging = false;
            return;
        }
        this.game.create();
        this.created = true;
    }

    @Override
    public void resize(int width, int height) {
        if (width == 0 && height == 0) {
            return;
        }
        this.game.resize(width, height);
    }

    @Override
    public void render() {
        Renderer renderer = this.game.getRenderer();
        this.game.render();
        renderer.nextpage();
    }

    @Override
    public void pause() {
        this.game.pause();
    }

    @Override
    public void resume() {
        this.game.resume();
    }

    @Override
    public void dispose() {
        if (this.renderChanging) {
            return;
        }
        this.game.dispose();
    }

    public BuildGame getGame() {
        return this.game;
    }

    @Override
    public void onChangeApplication(Renderer.RenderType type) {
        if (this.created) {
            this.renderChanging = true;
            this.game.setRenderer(DummyRenderer.DUMMY_RENDERER);
            Gdx.app.exit();
        }
        Thread oldThread = Thread.currentThread();
        new Thread(() -> {
            try {
                oldThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.startApplication(type);
        }).start();
    }

    public boolean isRendererChanging() {
        return this.renderChanging;
    }
}

