/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture.common.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import ru.m210projects.Build.Architecture.common.audio.Source;

public abstract class SoundManager
implements Runnable {
    public static final int FREE_SOURCE_PRIORITY = -1;
    protected final Array<Integer> sourcesToFree = new Array(false, 16, Integer.class);
    protected ManageableSource[] allSources;
    protected PriorityQueue<Integer> priorityQueue;

    protected void init(int sourceCount) {
        ManageableSource source;
        this.priorityQueue = new PriorityQueue<Integer>(sourceCount, new SourceComparator());
        ArrayList<ManageableSource> sources = new ArrayList<ManageableSource>();
        for (int i = 0; i < sourceCount && (source = this.generateSource(i)) != null; ++i) {
            sources.add(source);
        }
        this.allSources = new ManageableSource[sources.size()];
        sources.toArray(this.allSources);
        for (ManageableSource s : sources) {
            this.priorityQueue.add(s.getIndex());
        }
    }

    public Source getSource(int sourceIndex) {
        return this.allSources[sourceIndex];
    }

    protected abstract ManageableSource generateSource(int var1);

    public int getSize() {
        return this.allSources.length;
    }

    public void freeSource(int sourceIndex) {
        if (!this.isFreeSource(sourceIndex) && this.priorityQueue.remove(sourceIndex)) {
            ManageableSource source = this.allSources[sourceIndex];
            source.reset();
            this.priorityQueue.add(sourceIndex);
        }
    }

    public int element() {
        Integer index = this.priorityQueue.peek();
        if (index != null) {
            return index;
        }
        return -1;
    }

    public void setMusicSource(ManageableSource source, boolean music) {
        source.setMusicSource(music);
        if (music) {
            this.priorityQueue.remove(source.getIndex());
        } else {
            this.priorityQueue.add(source.getIndex());
        }
    }

    public synchronized int obtainSource(int priority) {
        if (this.allSources.length == 0) {
            return -1;
        }
        int sourceIndex = (Integer)this.priorityQueue.element();
        ManageableSource source = this.allSources[sourceIndex];
        if (source.getPriority() < priority) {
            this.priorityQueue.remove(sourceIndex);
            if (source.isPlaying()) {
                source.stop();
            }
            source.reset();
            source.setPriority(priority);
            this.priorityQueue.add(sourceIndex);
            return sourceIndex;
        }
        return -1;
    }

    public void stopAllSounds() {
        for (ManageableSource source : this.allSources) {
            if (source.isMusicSource()) continue;
            source.stop();
        }
    }

    public void dispose() {
        for (ManageableSource allSource : this.allSources) {
            allSource.dispose();
        }
        this.allSources = new ManageableSource[0];
        this.priorityQueue.clear();
    }

    public boolean isFreeSource(int sourceIndex) {
        if (sourceIndex < 0 || sourceIndex >= this.allSources.length) {
            return false;
        }
        ManageableSource source = this.allSources[sourceIndex];
        return source.getPriority() <= -1;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ManageableSource source : this.allSources) {
            result.append(source.getIndex()).append(" free[").append(this.isFreeSource(source.getIndex())).append("], ");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Array<Integer> array = this.sourcesToFree;
        synchronized (array) {
            for (int i = 0; i < this.sourcesToFree.size; ++i) {
                this.freeSource(((Integer[])this.sourcesToFree.items)[i]);
            }
            this.sourcesToFree.clear();
        }
    }

    public void update() {
        if (!this.sourcesToFree.isEmpty()) {
            Gdx.app.postRunnable(this);
        }
    }

    public class SourceComparator
    implements Comparator<Integer> {
        @Override
        public int compare(Integer o1, Integer o2) {
            ManageableSource s1 = SoundManager.this.allSources[o1];
            ManageableSource s2 = SoundManager.this.allSources[o2];
            return s1.getPriority() - s2.getPriority();
        }
    }

    public static interface ManageableSource
    extends Source {
        public void reset();

        public int getIndex();

        public boolean isMusicSource();

        public void setMusicSource(boolean var1);
    }
}

