/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Architecture.common.audio;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class WAVDecoder
implements SoundData.Decoder {
    @Override
    public SoundData decode(Entry entry) {
        SoundData soundData;
        block15: {
            if (entry.getSize() <= 44L) {
                Console.out.print("WAV loader error: file size is too small", OsdColor.RED);
            }
            InputStream is = entry.getInputStream();
            try {
                int length;
                String riffId = StreamUtils.readString(is, 4);
                if (!riffId.equals("RIFF")) {
                    throw new Exception("RIFF header not found");
                }
                StreamUtils.skip(is, 4);
                String format = StreamUtils.readString(is, 4);
                if (!format.equals("WAVE")) {
                    throw new Exception("Invalid wave file header");
                }
                String fmtId = StreamUtils.readString(is, 4);
                if (!fmtId.equals("fmt ")) {
                    throw new Exception("Invalid wave file header");
                }
                int pcmId = StreamUtils.readInt(is);
                if (pcmId != 16) {
                    throw new Exception("WAV files must be PCM: " + pcmId);
                }
                StreamUtils.skip(is, 2);
                short channels = StreamUtils.readShort(is);
                if (channels != 1 && channels != 2) {
                    throw new Exception("WAV files must have 1 or 2 channels: " + channels);
                }
                int rate = StreamUtils.readInt(is);
                StreamUtils.skip(is, 4);
                StreamUtils.skip(is, 2);
                short bits = StreamUtils.readShort(is);
                StreamUtils.skip(is, 8);
                byte[] data = new byte[4096];
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(4096);
                while ((length = is.read(data)) != -1) {
                    buffer.write(data, 0, length);
                }
                ByteBuffer pcmData = ByteBuffer.allocateDirect(buffer.size()).order(ByteOrder.LITTLE_ENDIAN);
                pcmData.put(buffer.toByteArray());
                pcmData.rewind();
                soundData = new SoundData(rate, channels, bits, pcmData);
                if (is == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Console.out.print("WAV loader error: " + e, OsdColor.RED);
                    return null;
                }
            }
            is.close();
        }
        return soundData;
    }
}

