/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Board;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.ClipMover;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.GetZRange;
import ru.m210projects.Build.HitScanner;
import ru.m210projects.Build.LegacyTimer;
import ru.m210projects.Build.NearScanner;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.PushMover;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.Timer;
import ru.m210projects.Build.Types.ClipInfo;
import ru.m210projects.Build.Types.DefaultPaletteLoader;
import ru.m210projects.Build.Types.DefaultPaletteManager;
import ru.m210projects.Build.Types.EngineService;
import ru.m210projects.Build.Types.HitInfo;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.NearInfo;
import ru.m210projects.Build.Types.Neartag;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.RangeZInfo;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.TileManager;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameConfig;

public class Engine {
    public static final String version = "25.011";
    public static final int CLIPMASK0 = 65537;
    public static final int CLIPMASK1 = 0x1000040;
    public static final int MAXPSKYTILES = 256;
    public static final int MAXPALOOKUPS = 256;
    public static final int MAXSTATUS = 1024;
    public static final int DETAILPAL = 255;
    public static final int GLOWPAL = 254;
    public static final int SPECULARPAL = 253;
    public static final int NORMALPAL = 252;
    public static final int RESERVEDPALS = 4;
    public static final int MAXSECTORSV8 = 4096;
    public static final int MAXWALLSV8 = 16384;
    public static final int MAXSPRITESV8 = 16384;
    public static final int MAXSECTORSV7 = 1024;
    public static final int MAXWALLSV7 = 8192;
    public static final int MAXSPRITESV7 = 4096;
    public static final int MAXSPRITESONSCREEN = 1024;
    public static final int MAXPLAYERS = 16;
    public static final short[] pow2char = new short[]{1, 2, 4, 8, 16, 32, 64, 128};
    public static final int[] pow2long = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MAX_VALUE};
    public static final int HIT_TYPE_MASK = -536870912;
    public static final int HIT_INDEX_MASK = 0x1FFFFFFF;
    public static final int HIT_SECTOR = 0x40000000;
    public static final int HIT_WALL = Integer.MIN_VALUE;
    public static final int HIT_SPRITE = -1073741824;
    public static Hitscan pHitInfo;
    public static Neartag neartag;
    @Deprecated
    public static int clipmoveboxtracenum;
    public static int hitscangoalx;
    public static int hitscangoaly;
    public static int zr_ceilz;
    public static int zr_ceilhit;
    public static int zr_florz;
    public static int zr_florhit;
    public static int clipmove_x;
    public static int clipmove_y;
    public static int clipmove_z;
    public static short clipmove_sectnum;
    public static int pushmove_x;
    public static int pushmove_y;
    public static int pushmove_z;
    public static short pushmove_sectnum;
    public static int USERTILES;
    public static int MAXTILES;
    public static int MAXSECTORS;
    public static int MAXWALLS;
    public static int MAXSPRITES;
    public static short[] pskyoff;
    public static short[] zeropskyoff;
    public static short pskybits;
    public static byte parallaxtype;
    public static int visibility;
    public static int parallaxvisibility;
    public static byte automapping;
    public static BitMap show2dsector;
    public static BitMap show2dwall;
    public static BitMap show2dsprite;
    protected static int SETSPRITEZ;
    protected final GetZRange getZRange = new GetZRange(this);
    protected final EngineService engineService = new EngineService(this);
    protected final PushMover pushMover = new PushMover(this);
    protected final BoardService boardService;
    private final HitScanner scanner = new HitScanner(this);
    private final NearScanner nearScanner = new NearScanner(this);
    protected ClipMover clipmove = new ClipMover(this);
    protected PaletteManager paletteManager;
    protected final TileManager tileManager;
    protected final BuildGame game;
    protected Timer timer;
    protected int randomseed;
    private DefScript defs;

    public Engine(BuildGame game) throws Exception {
        this.InitArrays();
        this.game = game;
        this.tileManager = this.loadTileManager();
        this.paletteManager = this.loadpalette();
        this.boardService = this.createBoardService();
        EngineUtils.init(this);
        parallaxtype = (byte)2;
        pskybits = 0;
        automapping = 0;
        visibility = 512;
        parallaxvisibility = 512;
        this.randomseed = 1;
    }

    public GameConfig getConfig() {
        return this.game.pCfg;
    }

    public void InitArrays() {
        pskyoff = new short[256];
        zeropskyoff = new short[256];
        show2dsector = new BitMap(1024);
        show2dwall = new BitMap(8192);
        show2dsprite = new BitMap(4096);
        pHitInfo = new Hitscan();
        neartag = new Neartag();
    }

    protected Tables loadtables() throws Exception {
        return new Tables(this.game.getCache().getEntry("tables.dat", true));
    }

    protected TileManager loadTileManager() {
        return new TileManager();
    }

    public void faketimerhandler() {
        BuildNet net = this.game.pNet;
        if (net == null) {
            return;
        }
        if (this.timer.getTotalClock() < net.ototalclock) {
            return;
        }
        this.game.getProcessor().update();
        if (!net.ready2send) {
            return;
        }
        net.ototalclock += this.timer.getFrameTicks();
        this.game.syncInput(net);
    }

    protected BoardService createBoardService() {
        return new BoardService();
    }

    public PaletteManager loadpalette() throws Exception {
        return new DefaultPaletteManager(this, new DefaultPaletteLoader(this.game.getCache().getEntry("palette.dat", true)));
    }

    public void uninit() {
        Mmulti.uninitmultiplayer();
    }

    public long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public int nextsectorneighborz(int sectnum, int thez, int topbottom, int direction) {
        return this.boardService.nextSectorNeighborZ(sectnum, thez, topbottom, direction);
    }

    public void nextpage(float delta) {
        this.timer.update(delta, this.game.pCfg.isVSync());
        this.faketimerhandler();
        Console.out.draw();
    }

    public int neartag(int xs, int ys, int zs, int sectnum, int ange, Neartag near, int neartagrange, int tagsearch) {
        int result = this.nearScanner.scan(xs, ys, zs, sectnum, ange, neartagrange, tagsearch);
        NearInfo info = this.nearScanner.getInfo();
        near.tagsector = (short)info.getSector();
        near.tagwall = (short)info.getWall();
        near.tagsprite = (short)info.getSprite();
        near.taghitdist = info.getDistance();
        return result;
    }

    public int lastwall(int point) {
        return this.boardService.getLastWall(point);
    }

    public void srand(int seed) {
        this.randomseed = seed;
    }

    public int getrand() {
        return this.randomseed;
    }

    public int krand() {
        this.randomseed = this.randomseed * 27584621 + 1;
        return (int)(((long)this.randomseed & 0xFFFFFFFFL) >> 16);
    }

    public int rand() {
        return (int)(Math.random() * 32767.0);
    }

    public DefScript getDefs() {
        return this.defs;
    }

    public void setDefs(DefScript defs) {
        this.defs = defs;
    }

    public void dragpoint(int pointhighlight, int dax, int day) {
        Wall wal = this.boardService.getWall(pointhighlight);
        if (wal == null) {
            return;
        }
        this.game.pInt.setwallinterpolate(pointhighlight, wal);
        wal.setX(dax);
        wal.setY(day);
        int cnt = MAXWALLS;
        int tempshort = pointhighlight;
        block0: do {
            Wall lastWall;
            Wall wal2;
            if ((wal2 = this.boardService.getWall(tempshort)) != null && wal2.getNextwall() >= 0) {
                Wall nextWall = this.boardService.getWall(wal2.getNextwall());
                if (nextWall == null) continue;
                tempshort = nextWall.getPoint2();
                wal2 = nextWall.getWall2();
                this.game.pInt.setwallinterpolate(tempshort, wal2);
                wal2.setX(dax);
                wal2.setY(day);
                continue;
            }
            tempshort = pointhighlight;
            while ((lastWall = this.boardService.getWall(this.lastwall(tempshort))) != null && lastWall.getNextwall() >= 0) {
                tempshort = lastWall.getNextwall();
                wal2 = this.boardService.getWall(tempshort);
                if (wal2 != null) {
                    this.game.pInt.setwallinterpolate(tempshort, wal2);
                    wal2.setX(dax);
                    wal2.setY(day);
                }
                if (tempshort != pointhighlight && --cnt > 0) continue;
                break block0;
            }
            break;
        } while (tempshort != pointhighlight && --cnt > 0);
    }

    public void setbrightness(int dabrightness, byte[] dapal) {
        this.paletteManager.setbrightness(dabrightness, dapal);
    }

    public boolean loadpic(Entry artFile) {
        return this.tileManager.loadpic(artFile);
    }

    public int loadpics() {
        return this.tileManager.loadpics(this.game.getCache());
    }

    @Deprecated
    public byte[] loadtile(int tilenume) {
        return this.tileManager.loadtile(tilenume);
    }

    @NotNull
    public DynamicArtEntry allocatepermanenttile(int tilenume, int xsiz, int ysiz) {
        DynamicArtEntry dynamicArtEntry = this.tileManager.allocatepermanenttile(tilenume, xsiz, ysiz);
        if (dynamicArtEntry == null) {
            Engine.$$$reportNull$$$0(0);
        }
        return dynamicArtEntry;
    }

    @NotNull
    public DynamicArtEntry allocatepermanenttile(ArtEntry artEntry) {
        DynamicArtEntry dynamicArtEntry = this.tileManager.allocatepermanenttile(artEntry);
        if (dynamicArtEntry == null) {
            Engine.$$$reportNull$$$0(1);
        }
        return dynamicArtEntry;
    }

    @NotNull
    public ArtEntry getTile(int tilenum) {
        ArtEntry artEntry = this.tileManager.getTile(tilenum);
        if (artEntry == null) {
            Engine.$$$reportNull$$$0(2);
        }
        return artEntry;
    }

    public TileManager getTileManager() {
        return this.tileManager;
    }

    public PaletteManager getPaletteManager() {
        return this.paletteManager;
    }

    public void inittimer(boolean isLegacy, int tickspersecond, int frameTicks) {
        int totalclock = 0;
        if (this.timer != null) {
            totalclock = this.timer.getTotalClock();
        }
        this.timer = isLegacy ? new LegacyTimer(tickspersecond, frameTicks) : new Timer(tickspersecond, frameTicks);
        this.timer.setTotalClock(totalclock);
    }

    public Timer getTimer() {
        return this.timer;
    }

    public int getTotalClock() {
        return this.timer.getTotalClock();
    }

    public boolean notIntersect(int xs, int ys, int zs, int vx, int vy, int vz, int x1, int y1, int x2, int y2, Variable rx, Variable ry, Variable rz) {
        return !this.engineService.rIntersect(xs, ys, zs, vx, vy, vz, x1, y1, x2, y2, rx, ry, rz);
    }

    public int clipInsideBox(int x, int y, int wallnum, int walldist) {
        return this.clipinsidebox(x, y, wallnum, walldist);
    }

    public int clipinsidebox(int x, int y, int wallnum, int walldist) {
        return this.engineService.clipInsideBox(x, y, wallnum, walldist);
    }

    public int clipInsideBoxLine(int x, int y, int x1, int y1, int x2, int y2, int walldist) {
        return this.clipinsideboxline(x, y, x1, y1, x2, y2, walldist);
    }

    public int clipinsideboxline(int x, int y, int x1, int y1, int x2, int y2, int walldist) {
        return this.engineService.clipInsideBoxLine(x, y, x1, y1, x2, y2, walldist);
    }

    public boolean cansee(int x1, int y1, int z1, int sect1, int x2, int y2, int z2, int sect2) {
        return this.engineService.canSee(x1, y1, z1, sect1, x2, y2, z2, sect2);
    }

    public boolean lIntersect(int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int x4, int y4, Variable x, Variable y, Variable z) {
        return this.engineService.lIntersect(x1, y1, z1, x2, y2, z2, x3, y3, x4, y4, x, y, z);
    }

    public int hitscan(int xs, int ys, int zs, int sectnum, int vx, int vy, int vz, Hitscan hit, int cliptype) {
        this.scanner.setGoal(hitscangoalx, hitscangoaly);
        boolean result = this.scanner.run(xs, ys, zs, sectnum, vx, vy, vz, cliptype);
        HitInfo is = this.scanner.getInfo();
        hit.set(is.x, is.y, is.z, is.sector, is.wall, is.sprite);
        return result ? 0 : -1;
    }

    public int clipmove(int x, int y, int z, int sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        int result = this.clipmove.invoke(x, y, z, sectnum, xvect, yvect, walldist, ceildist, flordist, cliptype);
        ClipInfo info = this.clipmove.getInfo();
        clipmove_x = info.getX();
        clipmove_y = info.getY();
        clipmove_z = info.getZ();
        clipmove_sectnum = (short)info.getSectnum();
        return result;
    }

    public int pushmove(int x, int y, int z, int sectnum, int walldist, int ceildist, int flordist, int cliptype) {
        int result = this.pushMover.move(x, y, z, sectnum, walldist, ceildist, flordist, cliptype);
        ClipInfo info = this.pushMover.getInfo();
        pushmove_x = info.getX();
        pushmove_y = info.getY();
        pushmove_z = info.getZ();
        pushmove_sectnum = (short)info.getSectnum();
        return result;
    }

    public void getzrange(int x, int y, int z, int sectnum, int walldist, int cliptype) {
        RangeZInfo info = this.getZRange.invoke(x, y, z, sectnum, walldist, cliptype);
        zr_ceilz = info.getCeilz();
        zr_ceilhit = info.getCeilhit();
        zr_florz = info.getFlorz();
        zr_florhit = info.getFlorhit();
    }

    public Board loadboard(Entry fil) throws WarningException {
        Board board;
        try {
            board = this.boardService.loadBoard(fil);
        }
        catch (Exception e) {
            throw new WarningException("Failed to load the map: " + fil.getName() + ".\r\n" + (e.getMessage() != null ? e.getMessage() : e.toString()));
        }
        board = this.boardService.prepareBoard(board);
        show2dsprite.clear();
        show2dsector.clear();
        show2dwall.clear();
        return board;
    }

    public BoardService getBoardService() {
        return this.boardService;
    }

    public int insertsprite(int sectnum, int statnum) {
        return this.boardService.insertsprite(sectnum, statnum);
    }

    public int deletesprite(int spritenum) {
        this.boardService.deletesprite(spritenum);
        return 0;
    }

    public int changespritesect(int spritenum, int newsectnum) {
        this.boardService.changespritesect(spritenum, newsectnum);
        return 0;
    }

    public boolean changespritestat(int spritenum, int newstatnum) {
        return this.boardService.changespritestat(spritenum, newstatnum);
    }

    public int inside(int x, int y, int sectnum) {
        return this.boardService.inside(x, y, this.boardService.getSector(sectnum)) ? 1 : 0;
    }

    public boolean setsprite(int spritenum, int newx, int newy, int newz) {
        return this.boardService.setSprite(spritenum, newx, newy, newz, SETSPRITEZ != 0);
    }

    public int sectorofwall(int theline) {
        return this.boardService.sectorOfWall(theline);
    }

    public int getceilzofslope(int sectnum, int dax, int day) {
        return this.boardService.getceilzofslope(this.boardService.getSector(sectnum), dax, day);
    }

    public int getflorzofslope(int sectnum, int dax, int day) {
        return this.boardService.getflorzofslope(this.boardService.getSector(sectnum), dax, day);
    }

    public void getzsofslope(int sectnum, int dax, int day, AtomicInteger fz, AtomicInteger cz) {
        Sector sec = this.boardService.getSector(sectnum);
        if (sec != null) {
            fz.set(sec.getFloorz());
            cz.set(sec.getCeilingz());
            this.boardService.getzsofslope(sec, dax, day, fz, cz);
        }
    }

    public void alignceilslope(int dasect, int x, int y, int z) {
        Sector sec = this.boardService.getSector(dasect);
        if (sec != null) {
            sec.alignSlope(x, y, z, true);
        }
    }

    public void alignflorslope(int dasect, int x, int y, int z) {
        Sector sec = this.boardService.getSector(dasect);
        if (sec != null) {
            sec.alignSlope(x, y, z, false);
        }
    }

    public int updatesector(int x, int y, int sectnum) {
        return this.boardService.updatesector(x, y, sectnum);
    }

    public int updatesectorz(int x, int y, int z, int sectnum) {
        return this.boardService.updatesectorz(x, y, z, sectnum);
    }

    static {
        clipmoveboxtracenum = 3;
        hitscangoalx = 0x1FFFFFFF;
        hitscangoaly = 0x1FFFFFFF;
        USERTILES = 256;
        MAXTILES = 9216 + USERTILES;
        MAXSECTORS = 1024;
        MAXWALLS = 8192;
        MAXSPRITES = 4096;
        SETSPRITEZ = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/m210projects/Build/Engine";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocatepermanenttile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

