/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Tables;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.font.BitmapFont;

public class EngineUtils {
    public static final int[] POW2LONG = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MAX_VALUE};
    private static final Point TMP_POINT = new Point();
    protected static Tables tables;
    protected static BitmapFont largeFont;
    protected static BitmapFont smallFont;

    public static Tables init(Engine engine) throws Exception {
        tables = engine.loadtables();
        largeFont = new BitmapFont(EngineUtils.tables.textfont, 128, 128, 16, 16);
        smallFont = new BitmapFont(EngineUtils.tables.smalltextfont, 128, 128, 16, 16);
        return tables;
    }

    public static Tables getTables() {
        return tables;
    }

    public static BitmapFont getLargeFont() {
        return largeFont;
    }

    public static BitmapFont getSmallFont() {
        return smallFont;
    }

    public static int qdist(long dx, long dy) {
        if ((dx = Math.abs(dx)) > (dy = Math.abs(dy))) {
            dy = 3L * dy >> 3;
        } else {
            dx = 3L * dx >> 3;
        }
        return (int)(dx + dy);
    }

    public static int sin(int k) {
        return tables.sin(k);
    }

    public static int cos(int k) {
        return tables.cos(k);
    }

    public static int getAngle(int xvect, int yvect) {
        return tables.getAngle(xvect, yvect);
    }

    public static int sqrt(int a) {
        return tables.sqrt(a);
    }

    public static int powToLong(int value) {
        return POW2LONG[value];
    }

    public static Point rotatepoint(int xpivot, int ypivot, int x, int y, int daang) {
        int dacos = EngineUtils.cos(daang + 2048);
        int dasin = EngineUtils.sin(daang + 2048);
        TMP_POINT.set(Pragmas.dmulscale(x -= xpivot, dacos, -(y -= ypivot), dasin, 14) + xpivot, Pragmas.dmulscale(y, dacos, x, dasin, 14) + ypivot);
        return TMP_POINT;
    }
}

