/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.settings.GameConfig;

public abstract class MenuControls
extends BuildMenu {
    protected BuildMenu ResetDefaultMenu;
    protected BuildMenu ResetClassicMenu;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract BuildMenu getMouseMenu(BuildGame var1);

    public abstract BuildMenu getJoystickMenu(BuildGame var1);

    public abstract BuildMenu getKeyboardMenu(BuildGame var1);

    public abstract void mResetDefault(GameConfig var1, MenuHandler var2);

    public abstract void mResetClassic(GameConfig var1, MenuHandler var2);

    public MenuControls(BuildGame app, int posy, int questionPos, int menuHeight, int separatorHeight, Font style, int pal, int questionPal) {
        super(app.pMenu);
        this.addItem(this.getTitle(app, "Controls setup"), false);
        MenuButton mMouse = new MenuButton("Mouse setup", style, 0, posy += menuHeight, 320, 1, pal, this.getMouseMenu(app), -1, null, 0);
        MenuButton mGamepad = new MenuButton("Joystick setup", style, 0, posy += menuHeight, 320, 1, pal, this.getJoystickMenu(app), -1, null, 0);
        MenuButton mKeyboard = new MenuButton("Keyboard setup", style, 0, posy += menuHeight, 320, 1, pal, this.getKeyboardMenu(app), -1, null, 0);
        posy += separatorHeight;
        this.ResetDefaultMenu = this.getResetDefaultMenu(app, style, questionPos, questionPal);
        this.ResetClassicMenu = this.getResetClassicMenu(app, style, questionPos, questionPal);
        MenuButton mKeyReset = new MenuButton("Reset Keys to default", style, 0, posy += menuHeight, 320, 1, pal, this.ResetDefaultMenu, -1, null, 0);
        MenuButton mKeyReset2 = new MenuButton("Reset Keys to classic", style, 0, posy + menuHeight, 320, 1, pal, this.ResetClassicMenu, -1, null, 0);
        this.addItem(mMouse, true);
        this.addItem(mGamepad, false);
        this.addItem(mKeyboard, false);
        this.addItem(mKeyReset, false);
        this.addItem(mKeyReset2, false);
    }

    protected BuildMenu getResetDefaultMenu(final BuildGame app, Font style, int posy, int pal) {
        BuildMenu menu = new BuildMenu(app.pMenu);
        MenuText QuitQuestion = new MenuText("Do you really want to reset keys?", style, 160, posy, 1);
        QuitQuestion.pal = pal;
        MenuVariants QuitVariants = new MenuVariants(this, app.pEngine, "[Y/N]", style, 160, posy += 2 * style.getSize()){
            final /* synthetic */ MenuControls this$0;
            {
                this.this$0 = this$0;
                super(draw, text, font, x, y);
            }

            @Override
            public void positive(MenuHandler menu) {
                this.this$0.mResetDefault(app.pCfg, menu);
            }
        };
        QuitVariants.pal = pal;
        menu.addItem(QuitQuestion, false);
        menu.addItem(QuitVariants, true);
        return menu;
    }

    protected BuildMenu getResetClassicMenu(final BuildGame app, Font style, int posy, int pal) {
        BuildMenu menu = new BuildMenu(app.pMenu);
        MenuText QuitQuestion = new MenuText("Do you really want reset to classic keys?", style, 160, posy, 1);
        QuitQuestion.pal = pal;
        MenuVariants QuitVariants = new MenuVariants(this, app.pEngine, "[Y/N]", style, 160, posy += 2 * style.getSize()){
            final /* synthetic */ MenuControls this$0;
            {
                this.this$0 = this$0;
                super(draw, text, font, x, y);
            }

            @Override
            public void positive(MenuHandler menu) {
                this.this$0.mResetClassic(app.pCfg, menu);
            }
        };
        QuitVariants.pal = pal;
        menu.addItem(QuitQuestion, false);
        menu.addItem(QuitVariants, true);
        return menu;
    }
}

