/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import com.badlogic.gdx.controllers.Controller;
import java.util.List;
import java.util.stream.IntStream;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.settings.GameConfig;

public abstract class MenuJoystick
extends BuildMenu {
    public MenuConteiner mJoyDevices;
    public MenuButton mJoyKey;
    public MenuSlider mDeadZone;
    public MenuSlider mLookSpeed;
    public MenuSlider mTurnSpeed;
    public MenuSwitch mInvert;
    public MenuJoyList mList;
    public MenuText mText;
    public MenuText mText2;
    public BuildMenu joyButtons;

    public MenuJoystick(BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, Font style, int list_len) {
        super(app.pMenu);
        this.addItem(this.getTitle(app, "Joystick setup"), false);
        final GameConfig cfg = app.pCfg;
        this.joyButtons = this.getJoyButtonsMenu(this, app, width, style, posx, posy, list_len);
        this.mJoyDevices = new MenuConteiner(this, "Device", style, posx, posy, width, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            if (item.num == 0) {
                cfg.setControllerName("");
            } else {
                String controllerName = new String(this.mJoyDevices.list[item.num]);
                Controller controller = cfg.getControllers().stream().filter(e -> e.getName().equalsIgnoreCase(controllerName)).findAny().orElse(null);
                if (controller != null && controller.isConnected()) {
                    cfg.setControllerName(controllerName);
                    return;
                }
                item.num = 0;
                cfg.setControllerName("");
                this.updateControllerList(cfg.getControllers());
            }
        }){
            final /* synthetic */ MenuJoystick this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.this$0.updateControllerList(cfg.getControllers());
                String controllerName = cfg.getControllerName();
                this.num = IntStream.range(0, this.list.length).filter(e -> new String(this.list[e]).equalsIgnoreCase(controllerName)).boxed().findAny().orElse(0);
            }
        };
        this.mJoyKey = new MenuButton("Configure buttons", style, posx, posy += separatorHeight, width, 1, 0, this.joyButtons, -1, null, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuJoystick.this.mJoyDevices.num != 0);
                super.draw(handler);
            }
        };
        posy += 5;
        this.mDeadZone = new MenuSlider(app.pSlider, "Dead zone", style, posx, posy += menuHeight, width, (int)(cfg.getJoyDeadZone() * 65536.0f), 0, 65536, 2048, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setJoyDeadZone((float)slider.value / 65536.0f);
        }, true);
        this.mDeadZone.digitalMax = 65536.0f;
        this.mLookSpeed = new MenuSlider(app.pSlider, "Look speed", style, posx, posy += menuHeight, width, (int)(cfg.getJoyLookSpeed() * 65536.0f), 0, 999424, 4096, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setJoyLookSpeed((float)slider.value / 65536.0f);
        }, true);
        this.mLookSpeed.digitalMax = 65536.0f;
        this.mTurnSpeed = new MenuSlider(app.pSlider, "Turn speed", style, posx, posy += menuHeight, width, (int)(cfg.getJoyTurnSpeed() * 65536.0f), 0, 999424, 4096, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setJoyTurnSpeed((float)slider.value / 65536.0f);
        }, true);
        this.mTurnSpeed.digitalMax = 65536.0f;
        this.mInvert = new MenuSwitch("Invert look axis", style, posx, posy + separatorHeight, width, cfg.isJoyInvert(), (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            cfg.setJoyInvert(sw.value);
        }, "Yes", "No");
        this.addItem(this.mJoyDevices, true);
        this.addItem(this.mJoyKey, false);
        this.addItem(this.mDeadZone, false);
        this.addItem(this.mLookSpeed, false);
        this.addItem(this.mTurnSpeed, false);
        this.addItem(this.mInvert, false);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public abstract String keyNames(int var1);

    private void updateControllerList(List<Controller> controllers) {
        if (!controllers.isEmpty()) {
            this.mJoyDevices.list = new char[controllers.size() + 1][];
            this.mJoyDevices.list[0] = "Disabled".toCharArray();
            for (int i = 0; i < controllers.size(); ++i) {
                this.mJoyDevices.list[i + 1] = controllers.get(i).getName().toCharArray();
            }
        } else {
            this.mJoyDevices.list = new char[][]{"No joystick devices found".toCharArray()};
        }
    }

    public BuildMenu getJoyButtonsMenu(MenuJoystick parent, BuildGame app, int width, Font style, int posx, int posy, int list_len) {
        BuildMenu menu = new BuildMenu(app.pMenu);
        menu.addItem(parent.getTitle(app, "Config. buttons"), false);
        MenuProc callback = (handler, pItem) -> {
            MenuJoyList item = (MenuJoyList)pItem;
            if (item.l_set == 0) {
                item.l_set = 1;
            }
        };
        this.mList = new MenuJoyList(app, style, posx, posy, width, list_len, callback);
        posy += this.mList.mFontOffset() * list_len;
        this.mText = new MenuText("UP/DOWN = Select action", style, 160, posy += 2 * this.mList.mFontOffset(), 1);
        this.mText2 = new MenuText("Enter = modify  Delete = clear", style, 160, posy += this.mList.mFontOffset(), 1);
        menu.addItem(this.mList, true);
        menu.addItem(this.mText, false);
        menu.addItem(this.mText2, false);
        return menu;
    }
}

